/*
 * Decompiled with CFR 0.152.
 */
package com.github.mpjct.jmpjct;

import com.github.mpjct.jmpjct.mysql.proto.Handshake;
import com.github.mpjct.jmpjct.mysql.proto.HandshakeResponse;
import com.github.mpjct.jmpjct.plugin.Base;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class Engine
implements Runnable {
    public Logger logger = Logger.getLogger((String)"Engine");
    public int port = 0;
    public Socket clientSocket = null;
    public InputStream clientIn = null;
    public OutputStream clientOut = null;
    public ArrayList<Base> plugins = new ArrayList();
    public ArrayList<byte[]> buffer = new ArrayList();
    public int offset = 0;
    public boolean running = true;
    public int expectedResultSet = 0;
    public Handshake handshake = null;
    public HandshakeResponse authReply = null;
    public String schema = "";
    public String query = "";
    public long statusFlags = 0L;
    public long sequenceId = 0L;
    public boolean bufferResultSet = true;
    public boolean packResultSet = true;
    public int mode = 0;
    public int nextMode = 0;

    public Engine(int n, Socket socket, ArrayList<Base> arrayList) throws IOException {
        this.port = n;
        this.plugins = arrayList;
        this.clientSocket = socket;
        this.clientSocket.setPerformancePreferences(0, 2, 1);
        this.clientSocket.setTcpNoDelay(true);
        this.clientSocket.setTrafficClass(16);
        this.clientSocket.setKeepAlive(true);
        this.clientIn = new BufferedInputStream(this.clientSocket.getInputStream(), 16384);
        this.clientOut = this.clientSocket.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.running) {
                switch (this.mode) {
                    case 0: {
                        this.logger.trace((Object)"MODE_INIT");
                        this.nextMode = 1;
                        for (Base base : this.plugins) {
                            base.init(this);
                        }
                        break;
                    }
                    case 1: {
                        this.logger.trace((Object)"MODE_READ_HANDSHAKE");
                        this.nextMode = 2;
                        for (Base base : this.plugins) {
                            base.read_handshake(this);
                        }
                        break;
                    }
                    case 2: {
                        this.logger.trace((Object)"MODE_SEND_HANDSHAKE");
                        this.nextMode = 3;
                        for (Base base : this.plugins) {
                            base.send_handshake(this);
                        }
                        break;
                    }
                    case 3: {
                        this.logger.trace((Object)"MODE_READ_AUTH");
                        this.nextMode = 4;
                        for (Base base : this.plugins) {
                            base.read_auth(this);
                        }
                        break;
                    }
                    case 4: {
                        this.logger.trace((Object)"MODE_SEND_AUTH");
                        this.nextMode = 5;
                        for (Base base : this.plugins) {
                            base.send_auth(this);
                        }
                        break;
                    }
                    case 5: {
                        this.logger.trace((Object)"MODE_READ_AUTH_RESULT");
                        this.nextMode = 6;
                        for (Base base : this.plugins) {
                            base.read_auth_result(this);
                        }
                        break;
                    }
                    case 6: {
                        this.logger.trace((Object)"MODE_SEND_AUTH_RESULT");
                        this.nextMode = 7;
                        for (Base base : this.plugins) {
                            base.send_auth_result(this);
                        }
                        break;
                    }
                    case 7: {
                        this.logger.trace((Object)"MODE_READ_QUERY");
                        this.nextMode = 8;
                        for (Base base : this.plugins) {
                            base.read_query(this);
                        }
                        break;
                    }
                    case 8: {
                        this.logger.trace((Object)"MODE_SEND_QUERY");
                        this.nextMode = 9;
                        for (Base base : this.plugins) {
                            base.send_query(this);
                        }
                        break;
                    }
                    case 9: {
                        this.logger.trace((Object)"MODE_READ_QUERY_RESULT");
                        this.nextMode = 10;
                        for (Base base : this.plugins) {
                            base.read_query_result(this);
                        }
                        break;
                    }
                    case 10: {
                        this.logger.trace((Object)"MODE_SEND_QUERY_RESULT");
                        this.nextMode = 7;
                        for (Base base : this.plugins) {
                            base.send_query_result(this);
                        }
                        break;
                    }
                    case 11: {
                        this.logger.trace((Object)"MODE_CLEANUP");
                        this.nextMode = 11;
                        for (Base base : this.plugins) {
                            base.cleanup(this);
                        }
                        this.halt();
                        break;
                    }
                    default: {
                        this.logger.fatal((Object)("UNKNOWN MODE " + this.mode));
                        this.halt();
                    }
                }
                this.mode = this.nextMode;
            }
            this.logger.info((Object)"Exiting thread.");
            this.clientSocket.close();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                this.clientSocket.close();
            }
            catch (IOException iOException) {}
            try {
                for (Base base : this.plugins) {
                    base.cleanup(this);
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void buffer_result_set() {
        if (!this.bufferResultSet) {
            this.bufferResultSet = true;
        }
    }

    public void halt() {
        this.logger.trace((Object)"Halting!");
        this.running = false;
    }

    public void clear_buffer() {
        this.logger.trace((Object)"Clearing Buffer.");
        this.offset = 0;
        this.buffer = new ArrayList();
    }
}

