/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmpjct.mysql.proto;

import com.github.jmpjct.mysql.proto.Packet;
import com.github.jmpjct.mysql.proto.Proto;
import java.util.ArrayList;

public class Handshake
extends Packet {
    public long protocolVersion = 10L;
    public String serverVersion = "";
    public long connectionId = 0L;
    public String challenge1 = "";
    public long capabilityFlags = 512L;
    public long characterSet = 0L;
    public long statusFlags = 0L;
    public String challenge2 = "";
    public long authPluginDataLength = 0L;
    public String authPluginName = "";

    public void setCapabilityFlag(long l) {
        this.capabilityFlags |= l;
    }

    public void removeCapabilityFlag(long l) {
        this.capabilityFlags &= l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void toggleCapabilityFlag(long l) {
        this.capabilityFlags ^= l;
    }

    public boolean hasCapabilityFlag(long l) {
        return (this.capabilityFlags & l) == l;
    }

    public void setStatusFlag(long l) {
        this.statusFlags |= l;
    }

    public void removeStatusFlag(long l) {
        this.statusFlags &= l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void toggleStatusFlag(long l) {
        this.statusFlags ^= l;
    }

    public boolean hasStatusFlag(long l) {
        return (this.statusFlags & l) == l;
    }

    @Override
    public ArrayList<byte[]> getPayload() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(Proto.build_fixed_int(1, this.protocolVersion));
        arrayList.add(Proto.build_null_str(this.serverVersion));
        arrayList.add(Proto.build_fixed_int(4, this.connectionId));
        arrayList.add(Proto.build_fixed_str(8, this.challenge1));
        arrayList.add(Proto.build_filler(1));
        arrayList.add(Proto.build_fixed_int(2, this.capabilityFlags >> 16));
        arrayList.add(Proto.build_fixed_int(1, this.characterSet));
        arrayList.add(Proto.build_fixed_int(2, this.statusFlags));
        arrayList.add(Proto.build_fixed_int(2, this.capabilityFlags & 0xFFFFL));
        if (this.hasCapabilityFlag(32768L)) {
            arrayList.add(Proto.build_fixed_int(1, this.authPluginDataLength));
        } else {
            arrayList.add(Proto.build_filler(1));
        }
        arrayList.add(Proto.build_fixed_str(10, ""));
        if (this.hasCapabilityFlag(32768L)) {
            arrayList.add(Proto.build_fixed_str(Math.max(13L, this.authPluginDataLength - 8L), this.challenge2));
        }
        if (this.hasCapabilityFlag(524288L)) {
            arrayList.add(Proto.build_null_str(this.authPluginName));
        }
        return arrayList;
    }

    public static Handshake loadFromPacket(byte[] byArray) {
        Handshake handshake = new Handshake();
        Proto proto = new Proto(byArray, 3);
        handshake.sequenceId = proto.get_fixed_int(1);
        handshake.protocolVersion = proto.get_fixed_int(1);
        handshake.serverVersion = proto.get_null_str();
        handshake.connectionId = proto.get_fixed_int(4);
        handshake.challenge1 = proto.get_fixed_str(8);
        proto.get_filler(1);
        handshake.capabilityFlags = proto.get_fixed_int(2) << 16;
        if (proto.has_remaining_data()) {
            handshake.characterSet = proto.get_fixed_int(1);
            handshake.statusFlags = proto.get_fixed_int(2);
            handshake.setCapabilityFlag(proto.get_fixed_int(2));
            if (handshake.hasCapabilityFlag(524288L)) {
                handshake.authPluginDataLength = proto.get_fixed_int(1);
            } else {
                proto.get_filler(1);
            }
            proto.get_filler(10);
            if (handshake.hasCapabilityFlag(32768L)) {
                handshake.challenge2 = proto.get_fixed_str(Math.max(13L, handshake.authPluginDataLength - 8L));
            }
            if (handshake.hasCapabilityFlag(524288L)) {
                handshake.authPluginName = proto.get_null_str();
            }
        }
        return handshake;
    }
}

