(ns org.hellodata.api.request-test
  (:require [org.hellodata.api.request :as request]
            [org.hellodata.crypto :as crypto]
            [ring.mock.request :as mock]
            [clojure.test :refer [deftest is]]))


(deftest test-accept
  (is (= {:server-port 80,
          :server-name "example.com",
          :remote-addr "localhost",
          :uri "/",
          :query-string nil,
          :scheme :http,
          :request-method :get,
          :headers {"host" "example.com", "Accept" "application/json"},
          :as :json}
         (request/accept-json (mock/request :get "http://example.com/")))))

(deftest test-sign-request
  (let [in-req  {:server-port 8083, :server-name "localhost", :remote-addr "localhost",
                 :uri "/neartimedata.php", :query-string nil, :scheme :http,
                 :request-method :post, :headers {"host" "localhost:8083",
                                                  "Content-Type" "application/json"},
                 :body "[{\"subscription_identifier\":\"a095de60-bdda-0133-1012-0d10208d311f\",\"datapoints\":[{\"sampletime_utc\":\"2016-03-03T14:28:43+0100\",\"value\":6}]}]"}]
    (is (= (assoc-in in-req [:headers "X-Auth-Sig"] "m0rKOTJUvceH4VFHzzxpDBNeVMgEYYw5Dff0VuJ9g2IzX9VoIt0nuYQJkpatlVqULXJWRM3gL/ZHUsSKO8XC8I6Zb033FfIQ9+p4sQO9tA/VDOu8nAcGK4DhdyRwM3LwzJrie6J0vpXnGaqA+nbIYjtqwdl0Nlox+4kA14PZwVDZwQAqLlhryUxZWRCNzGHuiurgxuKzhanOABwL46v8EoSjJjYBvEYLuCeTeBIGvXPe7Esyka+dUMXVOWZFxav3KoDCqkwmQR1lQHFmID0fboi0NmYX3d6EKRe2E2c2Tcc2gC7di53DYxwe5qXis2rHqm3jYFMakIOAAOklOm0taQ==")
           (request/sign in-req (crypto/path->private-key "example-key.pem"))))))



