(ns org.hellodata.crypto
  (:require [buddy.core.dsa :as dsa]
            [buddy.core.keys :as keys]
            [base64-clj.core :as base64])
  (:import [java.security Signature]))

(defn- sha1-signer
  []
  (Signature/getInstance "Sha1withRSA" "BC"))

(defn private-key
  [path]
  (keys/private-key path))

(defn sign-string
  [private-key s]
  (String. (base64/encode-bytes (dsa/sign s {:key private-key :alg sha1-signer}))))



