;; Copyright 2016 Mozilla
;;
;; Licensed under the Apache License, Version 2.0 (the "License"); you may not use
;; this file except in compliance with the License. You may obtain a copy of the
;; License at http://www.apache.org/licenses/LICENSE-2.0
;; Unless required by applicable law or agreed to in writing, software distributed
;; under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
;; CONDITIONS OF ANY KIND, either express or implied. See the License for the
;; specific language governing permissions and limitations under the License.

(ns datomish.js-sqlite
  (:require
   [datomish.sqlite :as s]
   [datomish.js-util :refer [is-node?]]
   [datomish.promise-sqlite :as promise-sqlite]))

(def open promise-sqlite/open)

(extend-protocol s/ISQLiteConnectionFactory
  string
  (<sqlite-connection [path]
    (open path))

  object ;; TODO: narrow this to the result of node-tempfile/tempfile.
  (<sqlite-connection [tempfile]
    (open (.-name tempfile))))
