(ns playground.playground
  (:require [seria.core :refer :all]
            [seria.buffers :refer :all]
            [seria.serialization :refer :all]
            [criterium.core :as crit]
            [taoensso.nippy :as nippy]
            [seria.delta :refer :all]))


(defconfig foo
           :schemas {:body    [:record {:delta {:enabled true
                                                :ignored [:id]}}
                               {:id       :int
                                :pos      :coord
                                :angle    :float
                                :fixtures [:list :fixture]}]
                     :fixture [:multi #(nil? (:coords %))
                               {true  :circle
                                false :polygon}]
                     :circle  [:record
                               {:radius :float
                                :center :coord}]
                     :polygon [:vector :coord]
                     :coord   [:tuple [:float :float]]}
           )

(get-in foo [:processors :body :differ-source])

(def data-1 {:id 10 :pos [0 0] :angle 10 :fixtures [{:radius 10 :center [0 0]}]})
(def data-2 {:id 10 :pos [0 0] :angle 12 :fixtures [{:radius 10 :center [0 0]}]})

(comment
  (defconfig any-config {:a [:vector :any]})
  (pack [1 :a 'u [3 4] 0.4] :a any-config)
  (unpack *1 any-config)

  (defconfig config-1
             {:a [:vector :b]
              :b [:record {:foo [:tuple [:int :int]]
                           :bar [:record {:qux :int}]
                           :baz [:vector :boolean]}]})
  (def data-1 [{:foo [1 2]
                :bar {:qux 3}
                :baz [true false true true false]}
               {:foo [4 5]
                :bar {:qux 6}
                :baz [true true]}])
  (pack data-1 :a config-1)
  (seq *1)
  (unpack *1 config-1)

  (defconfig config-2
             {:a [:vector {:size :short} :double]}
             :buffer-count 4)
  (def data-2 (repeatedly 1000 #(rand)))

  (crit/with-progress-reporting
    (crit/quick-bench
      (dotimes [_ 100]
        (pack data-2 :a config-2))))

  (crit/with-progress-reporting
    (crit/quick-bench
      (dotimes [_ 100]
        (nippy/freeze data-2))))

  (count (pr-str data-1))
  (count (pack data-1 :a config-1))
  (count (nippy/freeze data-1)))