(ns dead.old-config)

(comment
  (defn make-config [schemas & args]
    (let [{:keys [keywords buffer-count max-bits max-bytes]
           :or   {keywords [] buffer-count 4 max-bits 10000 max-bytes 10000}} (apply hash-map args)
          config     {:schemas     schemas
                      :wbuffers    (repeatedly buffer-count #(make-wbuffer max-bits max-bytes))
                      :schema-map  (bimap (keys schemas))
                      :keyword-map (bimap keywords)}
          processors (into {} (for [schema (keys schemas)]
                                [schema {:serializer   (eval (make-serializer schema config))
                                         :deserializer (eval (make-deserializer schema config))}]))]
      (assoc config :processors processors)))

  (defmacro defconfig [name schemas & args]
    `(let [schemas# ~schemas
           args#    (or ~args [])]
       (def ~name (apply make-config schemas# args#))))

  )
