(ns seria.dead)

(defn bits->byte [bits]
  (unchecked-byte
    (reduce (fn [value b]
              (if b
                (bit-or 1 (bit-shift-left value 1))
                (bit-shift-left value 1)))
            0
            bits)))

(defn bits->bytes [bits]
  (->> (concat bits (repeat (mod (- 8 (mod (count bits) 8)) 8)
                            false))
       (partition 8)
       (map bits->byte)
       doall))

(defn byte->bits [byte]
  (for [i (range 7 -1 -1)]
    (bit-test byte i)))




(comment
  `(~f (doall (for [_ (range (take! ~buffer ::short ~byte-position))]
                ~(deserialize-1 sub-schema config wbuffer))))

  `(into {} (doall (for [_ (range (take! ~buffer ::short ~byte-position))]
                     [~(deserialize-1 key-schema config wbuffer)
                      ~(deserialize-1 value-schema config wbuffer)])))

  `(apply str (doall (for [_ (range (take! ~buffer ::short ~byte-position))]
                       (take! ~buffer ::char ~byte-position))))

  `(apply str (doall (repeatedly (take! ~buffer ::short ~byte-position)
                                 (fn [] (take! ~buffer ::char ~byte-position))))))

(defn long->bytes [^long x]
  (for [i (range 7 -1 -1)]
    (-> x (bit-shift-right (* 8 i)) (bit-and 0xFF))))

(defn bytes->long [bs]
  (reduce (fn [l b]
            (bit-or b (bit-shift-left l 8)))
          0
          bs))