// Compiled by ClojureScript 1.7.228 {}
goog.provide('bond.james');
goog.require('cljs.core');
bond.james.local_redefinitions = cljs.core.PersistentArrayMap.EMPTY;
bond.james.call_tracker = null;
/**
 * wrap f, returning a new fn that keeping track of its call count and arguments
 */
bond.james.spy = (function bond$james$spy(f){
var calls = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
return cljs.core.with_meta.call(null,((function (calls){
return (function() { 
var G__9056__delegate = function (args){
try{var old_f = ((cljs.core.vector_QMARK_.call(null,f))?cljs.core.nth.call(null,f,cljs.core.count.call(null,cljs.core.deref.call(null,calls))):f);
var resp = cljs.core.apply.call(null,old_f,args);
cljs.core.swap_BANG_.call(null,calls,cljs.core.conj,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"args","args",1315556576),args,new cljs.core.Keyword(null,"return","return",-1891502105),resp], null));

return resp;
}catch (e9055){if((e9055 instanceof Error)){
var e = e9055;
cljs.core.swap_BANG_.call(null,calls,cljs.core.conj,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"args","args",1315556576),args,new cljs.core.Keyword(null,"throw","throw",-1044625833),e], null));

throw e;
} else {
throw e9055;

}
}};
var G__9056 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9057__i = 0, G__9057__a = new Array(arguments.length -  0);
while (G__9057__i < G__9057__a.length) {G__9057__a[G__9057__i] = arguments[G__9057__i + 0]; ++G__9057__i;}
  args = new cljs.core.IndexedSeq(G__9057__a,0);
} 
return G__9056__delegate.call(this,args);};
G__9056.cljs$lang$maxFixedArity = 0;
G__9056.cljs$lang$applyTo = (function (arglist__9058){
var args = cljs.core.seq(arglist__9058);
return G__9056__delegate(args);
});
G__9056.cljs$core$IFn$_invoke$arity$variadic = G__9056__delegate;
return G__9056;
})()
;})(calls))
,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("bond.james","calls","bond.james/calls",1931539821),calls], null));
});
/**
 * Takes one arg, a fn that has previously been spied. Returns a seq
 *   of maps, one per call. Each map contains the keys :args and :return
 *   or :throw
 */
bond.james.calls = (function bond$james$calls(f){
var G__9060 = ((cljs.core.var_QMARK_.call(null,f))?cljs.core.deref.call(null,f):f);
var G__9060__$1 = (((G__9060 == null))?null:cljs.core.meta.call(null,G__9060));
var G__9060__$2 = (((G__9060__$1 == null))?null:new cljs.core.Keyword("bond.james","calls","bond.james/calls",1931539821).cljs$core$IFn$_invoke$arity$1(G__9060__$1));
var G__9060__$3 = (((G__9060__$2 == null))?null:cljs.core.deref.call(null,G__9060__$2));
return G__9060__$3;
});
/**
 * A utility function to get a sequence of fully-qualified symbols for all the
 *   functions in a namespace.
 */
bond.james.ns__GT_fn_symbols = (function bond$james$ns__GT_fn_symbols(ns){
return cljs.core.map.call(null,(function (p1__9061_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p1__9061_SHARP_)))].join(''),[cljs.core.str(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p1__9061_SHARP_)))].join(''));
}),cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.fn_QMARK_,cljs.core.deref),cljs.core.remove.call(null,cljs.core.comp.call(null,new cljs.core.Keyword(null,"macro","macro",-867863404),cljs.core.meta),cljs.core.vals.call(null,bond.james.ns_publics.call(null,ns)))));
});
/**
 * Takes a vector of fn vars (vars that resolve to fns). Modifies the
 *   fn to track call counts, but does not change the fn's behavior
 */
bond.james.with_spy = (function bond$james$with_spy(var_args){
var args__7207__auto__ = [];
var len__7200__auto___9066 = arguments.length;
var i__7201__auto___9067 = (0);
while(true){
if((i__7201__auto___9067 < len__7200__auto___9066)){
args__7207__auto__.push((arguments[i__7201__auto___9067]));

var G__9068 = (i__7201__auto___9067 + (1));
i__7201__auto___9067 = G__9068;
continue;
} else {
}
break;
}

var argseq__7208__auto__ = ((((3) < args__7207__auto__.length))?(new cljs.core.IndexedSeq(args__7207__auto__.slice((3)),(0))):null);
return bond.james.with_spy.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7208__auto__);
});

bond.james.with_spy.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,vs,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","with-redefs","cljs.core/with-redefs",1134293954,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.vec.call(null,cljs.core.mapcat.call(null,(function (v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","spy","bond.james/spy",986451910,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","deref","cljs.core/deref",1901963335,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,v),new cljs.core.Symbol(null,"var","var",870848730,null))))))))))], null);
}),vs))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),body)))))));
});

bond.james.with_spy.cljs$lang$maxFixedArity = (3);

bond.james.with_spy.cljs$lang$applyTo = (function (seq9062){
var G__9063 = cljs.core.first.call(null,seq9062);
var seq9062__$1 = cljs.core.next.call(null,seq9062);
var G__9064 = cljs.core.first.call(null,seq9062__$1);
var seq9062__$2 = cljs.core.next.call(null,seq9062__$1);
var G__9065 = cljs.core.first.call(null,seq9062__$2);
var seq9062__$3 = cljs.core.next.call(null,seq9062__$2);
return bond.james.with_spy.cljs$core$IFn$_invoke$arity$variadic(G__9063,G__9064,G__9065,seq9062__$3);
});

bond.james.with_spy.cljs$lang$macro = true;
/**
 * Like with-spy but takes a vector of namespaces. Spies on every function in
 *   the namespace.
 */
bond.james.with_spy_ns = (function bond$james$with_spy_ns(var_args){
var args__7207__auto__ = [];
var len__7200__auto___9073 = arguments.length;
var i__7201__auto___9074 = (0);
while(true){
if((i__7201__auto___9074 < len__7200__auto___9073)){
args__7207__auto__.push((arguments[i__7201__auto___9074]));

var G__9075 = (i__7201__auto___9074 + (1));
i__7201__auto___9074 = G__9075;
continue;
} else {
}
break;
}

var argseq__7208__auto__ = ((((3) < args__7207__auto__.length))?(new cljs.core.IndexedSeq(args__7207__auto__.slice((3)),(0))):null);
return bond.james.with_spy_ns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7208__auto__);
});

bond.james.with_spy_ns.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,namespaces,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","with-spy","bond.james/with-spy",178287243,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.mapcat.call(null,bond.james.ns__GT_fn_symbols,namespaces)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),body)))))));
});

bond.james.with_spy_ns.cljs$lang$maxFixedArity = (3);

bond.james.with_spy_ns.cljs$lang$applyTo = (function (seq9069){
var G__9070 = cljs.core.first.call(null,seq9069);
var seq9069__$1 = cljs.core.next.call(null,seq9069);
var G__9071 = cljs.core.first.call(null,seq9069__$1);
var seq9069__$2 = cljs.core.next.call(null,seq9069__$1);
var G__9072 = cljs.core.first.call(null,seq9069__$2);
var seq9069__$3 = cljs.core.next.call(null,seq9069__$2);
return bond.james.with_spy_ns.cljs$core$IFn$_invoke$arity$variadic(G__9070,G__9071,G__9072,seq9069__$3);
});

bond.james.with_spy_ns.cljs$lang$macro = true;
/**
 * Takes a vector of fn vars and/or [fn replacement] vectors.
 * 
 *   Replaces each fn with it's replacement. If a replacement is not specified for
 *   a fn it's replaced with one that takes any number of args and returns nil.
 *   Also spies the stubbed-fn
 */
bond.james.with_stub = (function bond$james$with_stub(var_args){
var args__7207__auto__ = [];
var len__7200__auto___9080 = arguments.length;
var i__7201__auto___9081 = (0);
while(true){
if((i__7201__auto___9081 < len__7200__auto___9080)){
args__7207__auto__.push((arguments[i__7201__auto___9081]));

var G__9082 = (i__7201__auto___9081 + (1));
i__7201__auto___9081 = G__9082;
continue;
} else {
}
break;
}

var argseq__7208__auto__ = ((((3) < args__7207__auto__.length))?(new cljs.core.IndexedSeq(args__7207__auto__.slice((3)),(0))):null);
return bond.james.with_stub.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7208__auto__);
});

bond.james.with_stub.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,vs,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","with-redefs","cljs.core/with-redefs",1134293954,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.vec.call(null,cljs.core.mapcat.call(null,(function (v){
if(cljs.core.vector_QMARK_.call(null,v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,v),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","spy","bond.james/spy",986451910,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.second.call(null,v)))))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","spy","bond.james/spy",986451910,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","constantly","cljs.core/constantly",119002258,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))))))))], null);
}
}),vs))),body)));
});

bond.james.with_stub.cljs$lang$maxFixedArity = (3);

bond.james.with_stub.cljs$lang$applyTo = (function (seq9076){
var G__9077 = cljs.core.first.call(null,seq9076);
var seq9076__$1 = cljs.core.next.call(null,seq9076);
var G__9078 = cljs.core.first.call(null,seq9076__$1);
var seq9076__$2 = cljs.core.next.call(null,seq9076__$1);
var G__9079 = cljs.core.first.call(null,seq9076__$2);
var seq9076__$3 = cljs.core.next.call(null,seq9076__$2);
return bond.james.with_stub.cljs$core$IFn$_invoke$arity$variadic(G__9077,G__9078,G__9079,seq9076__$3);
});

bond.james.with_stub.cljs$lang$macro = true;
bond.james.arglist_match_QMARK_ = (function bond$james$arglist_match_QMARK_(arg_count,arglist){
var vec__9084 = cljs.core.split_with.call(null,cljs.core.complement.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"&","&",-2144855648,null),null], null), null)),arglist);
var regular_args = cljs.core.nth.call(null,vec__9084,(0),null);
var var_args = cljs.core.nth.call(null,vec__9084,(1),null);
if(cljs.core.empty_QMARK_.call(null,var_args)){
return cljs.core._EQ_.call(null,arg_count,cljs.core.count.call(null,regular_args));
} else {
return (arg_count >= cljs.core.count.call(null,regular_args));
}
});
bond.james.args_match_QMARK_ = (function bond$james$args_match_QMARK_(arg_count,arglists){
return cljs.core.some.call(null,cljs.core.partial.call(null,bond.james.arglist_match_QMARK_,arg_count),arglists);
});
bond.james.stub_BANG_ = (function bond$james$stub_BANG_(v,replacement){
if(cljs.core.empty_QMARK_.call(null,new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v)))){
throw (new Error("stub!/with-stub! may only be used on functions which include :arglists in their metadata. Use stub/with-stub instead."));
} else {
}

var f = bond.james.spy.call(null,replacement);
return cljs.core.with_meta.call(null,((function (f){
return (function() { 
var G__9085__delegate = function (args){
if(cljs.core.truth_(bond.james.args_match_QMARK_.call(null,cljs.core.count.call(null,args),new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v))))){
return cljs.core.apply.call(null,f,args);
} else {
throw (new Error(cljs.core.count.call(null,args),[cljs.core.str(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v))),cljs.core.str("/"),cljs.core.str(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v)))].join('')));
}
};
var G__9085 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9086__i = 0, G__9086__a = new Array(arguments.length -  0);
while (G__9086__i < G__9086__a.length) {G__9086__a[G__9086__i] = arguments[G__9086__i + 0]; ++G__9086__i;}
  args = new cljs.core.IndexedSeq(G__9086__a,0);
} 
return G__9085__delegate.call(this,args);};
G__9085.cljs$lang$maxFixedArity = 0;
G__9085.cljs$lang$applyTo = (function (arglist__9087){
var args = cljs.core.seq(arglist__9087);
return G__9085__delegate(args);
});
G__9085.cljs$core$IFn$_invoke$arity$variadic = G__9085__delegate;
return G__9085;
})()
;})(f))
,cljs.core.meta.call(null,f));
});
/**
 * Like with-stub, but throws an exception upon arity mismatch.
 */
bond.james.with_stub_BANG_ = (function bond$james$with_stub_BANG_(var_args){
var args__7207__auto__ = [];
var len__7200__auto___9092 = arguments.length;
var i__7201__auto___9093 = (0);
while(true){
if((i__7201__auto___9093 < len__7200__auto___9092)){
args__7207__auto__.push((arguments[i__7201__auto___9093]));

var G__9094 = (i__7201__auto___9093 + (1));
i__7201__auto___9093 = G__9094;
continue;
} else {
}
break;
}

var argseq__7208__auto__ = ((((3) < args__7207__auto__.length))?(new cljs.core.IndexedSeq(args__7207__auto__.slice((3)),(0))):null);
return bond.james.with_stub_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7208__auto__);
});

bond.james.with_stub_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,vs,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","with-redefs","cljs.core/with-redefs",1134293954,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.vec.call(null,cljs.core.mapcat.call(null,(function (v){
if(cljs.core.vector_QMARK_.call(null,v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,v),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","stub!","bond.james/stub!",1433821013,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.first.call(null,v)))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.second.call(null,v)))))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","stub!","bond.james/stub!",1433821013,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,v))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","constantly","cljs.core/constantly",119002258,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))))))))], null);
}
}),vs))),body)));
});

bond.james.with_stub_BANG_.cljs$lang$maxFixedArity = (3);

bond.james.with_stub_BANG_.cljs$lang$applyTo = (function (seq9088){
var G__9089 = cljs.core.first.call(null,seq9088);
var seq9088__$1 = cljs.core.next.call(null,seq9088);
var G__9090 = cljs.core.first.call(null,seq9088__$1);
var seq9088__$2 = cljs.core.next.call(null,seq9088__$1);
var G__9091 = cljs.core.first.call(null,seq9088__$2);
var seq9088__$3 = cljs.core.next.call(null,seq9088__$2);
return bond.james.with_stub_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__9089,G__9090,G__9091,seq9088__$3);
});

bond.james.with_stub_BANG_.cljs$lang$macro = true;
/**
 * Takes a vector of namespaces and/or [namespace replacement] vectors.
 * 
 *   Replaces every fn in each namespace with its replacement. If a replacement is
 *   not specified for a namespace every fn in that namespace is replaced with
 *   (constantly nil). All replaced functions are also spied.
 */
bond.james.with_stub_ns = (function bond$james$with_stub_ns(var_args){
var args__7207__auto__ = [];
var len__7200__auto___9100 = arguments.length;
var i__7201__auto___9101 = (0);
while(true){
if((i__7201__auto___9101 < len__7200__auto___9100)){
args__7207__auto__.push((arguments[i__7201__auto___9101]));

var G__9102 = (i__7201__auto___9101 + (1));
i__7201__auto___9101 = G__9102;
continue;
} else {
}
break;
}

var argseq__7208__auto__ = ((((3) < args__7207__auto__.length))?(new cljs.core.IndexedSeq(args__7207__auto__.slice((3)),(0))):null);
return bond.james.with_stub_ns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7208__auto__);
});

bond.james.with_stub_ns.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,namespaces,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","with-stub","bond.james/with-stub",-1647195450,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.mapcat.call(null,(function (n){
if(cljs.core.vector_QMARK_.call(null,n)){
return cljs.core.map.call(null,(function (p1__9095_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__9095_SHARP_,cljs.core.second.call(null,n)], null));
}),bond.james.ns__GT_fn_symbols.call(null,cljs.core.first.call(null,n)));
} else {
return bond.james.ns__GT_fn_symbols.call(null,n);
}
}),namespaces)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),body)))))));
});

bond.james.with_stub_ns.cljs$lang$maxFixedArity = (3);

bond.james.with_stub_ns.cljs$lang$applyTo = (function (seq9096){
var G__9097 = cljs.core.first.call(null,seq9096);
var seq9096__$1 = cljs.core.next.call(null,seq9096);
var G__9098 = cljs.core.first.call(null,seq9096__$1);
var seq9096__$2 = cljs.core.next.call(null,seq9096__$1);
var G__9099 = cljs.core.first.call(null,seq9096__$2);
var seq9096__$3 = cljs.core.next.call(null,seq9096__$2);
return bond.james.with_stub_ns.cljs$core$IFn$_invoke$arity$variadic(G__9097,G__9098,G__9099,seq9096__$3);
});

bond.james.with_stub_ns.cljs$lang$macro = true;
bond.james.current__GT_original_definition = (function bond$james$current__GT_original_definition(v){
if(cljs.core.var_QMARK_.call(null,v)){
return cljs.core.get.call(null,cljs.core.meta.call(null,v),new cljs.core.Keyword(null,"original","original",-445386197));
} else {
return null;
}
});
bond.james.redef_binding__GT_originals = (function bond$james$redef_binding__GT_originals(x){
if(cljs.core.vector_QMARK_.call(null,x)){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","current->original-definition","bond.james/current->original-definition",1426378621,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.first.call(null,x)))))))));
} else {
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","current->original-definition","bond.james/current->original-definition",1426378621,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,x))))))));
}
});
bond.james.redefiniton_fn = (function bond$james$redefiniton_fn(a_var){
return (function() { 
var G__9105__delegate = function (args){
var original_f = bond.james.current__GT_original_definition.call(null,a_var);
var current_f = cljs.core.get.call(null,bond.james.local_redefinitions,a_var,original_f);
try{var result = cljs.core.apply.call(null,current_f,args);
if(cljs.core.truth_((function (){var and__6130__auto__ = bond.james.thread_bound_QMARK_.call(null,new cljs.core.Var(function(){return bond.james.call_tracker;},new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"dynamic","dynamic",704819571),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"bond.james","bond.james",1031585260,null),new cljs.core.Symbol(null,"call-tracker","call-tracker",28918148,null),"src/bond/james.cljc",28,1,true,4,4,cljs.core.List.EMPTY,null,(cljs.core.truth_(bond.james.call_tracker)?bond.james.call_tracker.cljs$lang$test:null)])));
if(cljs.core.truth_(and__6130__auto__)){
return cljs.core.vector_QMARK_.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,bond.james.call_tracker),original_f));
} else {
return and__6130__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,bond.james.call_tracker,cljs.core.update,original_f,cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"args","args",1315556576),args,new cljs.core.Keyword(null,"return","return",-1891502105),result], null));
} else {
}

return result;
}catch (e9104){if((e9104 instanceof Error)){
var e = e9104;
if(cljs.core.truth_((function (){var and__6130__auto__ = bond.james.thread_bound_QMARK_.call(null,new cljs.core.Var(function(){return bond.james.call_tracker;},new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"dynamic","dynamic",704819571),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"bond.james","bond.james",1031585260,null),new cljs.core.Symbol(null,"call-tracker","call-tracker",28918148,null),"src/bond/james.cljc",28,1,true,4,4,cljs.core.List.EMPTY,null,(cljs.core.truth_(bond.james.call_tracker)?bond.james.call_tracker.cljs$lang$test:null)])));
if(cljs.core.truth_(and__6130__auto__)){
return cljs.core.vector_QMARK_.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,bond.james.call_tracker),original_f));
} else {
return and__6130__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,bond.james.call_tracker,cljs.core.update,original_f,cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"args","args",1315556576),args,new cljs.core.Keyword(null,"throw","throw",-1044625833),e], null));
} else {
}

throw e;
} else {
throw e9104;

}
}};
var G__9105 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9106__i = 0, G__9106__a = new Array(arguments.length -  0);
while (G__9106__i < G__9106__a.length) {G__9106__a[G__9106__i] = arguments[G__9106__i + 0]; ++G__9106__i;}
  args = new cljs.core.IndexedSeq(G__9106__a,0);
} 
return G__9105__delegate.call(this,args);};
G__9105.cljs$lang$maxFixedArity = 0;
G__9105.cljs$lang$applyTo = (function (arglist__9107){
var args = cljs.core.seq(arglist__9107);
return G__9105__delegate(args);
});
G__9105.cljs$core$IFn$_invoke$arity$variadic = G__9105__delegate;
return G__9105;
})()
;
});
bond.james.dynamic_redefs = (function bond$james$dynamic_redefs(vars,func){
var un_redefs_9117 = cljs.core.remove.call(null,(function (p1__9108_SHARP_){
return new cljs.core.Keyword(null,"already-bound?","already-bound?",175091618).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,p1__9108_SHARP_));
}),vars);
var seq__9113_9118 = cljs.core.seq.call(null,un_redefs_9117);
var chunk__9114_9119 = null;
var count__9115_9120 = (0);
var i__9116_9121 = (0);
while(true){
if((i__9116_9121 < count__9115_9120)){
var a_var_9122 = cljs.core._nth.call(null,chunk__9114_9119,i__9116_9121);
bond.james.locking.call(null,a_var_9122,(cljs.core.truth_(new cljs.core.Keyword(null,"already-bound?","already-bound?",175091618).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,a_var_9122)))?null:(function (){var old_val = a_var_9122.getRawRoot();
var metadata = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"already-bound?","already-bound?",175091618),true,new cljs.core.Keyword(null,"original","original",-445386197),old_val], null);
a_var_9122.bindRoot(cljs.core.with_meta.call(null,bond.james.redefiniton_fn.call(null,a_var_9122),metadata));

return cljs.core.alter_meta_BANG_.call(null,a_var_9122,((function (seq__9113_9118,chunk__9114_9119,count__9115_9120,i__9116_9121,old_val,metadata,a_var_9122,un_redefs_9117){
return (function (m){
return cljs.core.merge.call(null,m,metadata);
});})(seq__9113_9118,chunk__9114_9119,count__9115_9120,i__9116_9121,old_val,metadata,a_var_9122,un_redefs_9117))
);
})()));

var G__9123 = seq__9113_9118;
var G__9124 = chunk__9114_9119;
var G__9125 = count__9115_9120;
var G__9126 = (i__9116_9121 + (1));
seq__9113_9118 = G__9123;
chunk__9114_9119 = G__9124;
count__9115_9120 = G__9125;
i__9116_9121 = G__9126;
continue;
} else {
var temp__4425__auto___9127 = cljs.core.seq.call(null,seq__9113_9118);
if(temp__4425__auto___9127){
var seq__9113_9128__$1 = temp__4425__auto___9127;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__9113_9128__$1)){
var c__6945__auto___9129 = cljs.core.chunk_first.call(null,seq__9113_9128__$1);
var G__9130 = cljs.core.chunk_rest.call(null,seq__9113_9128__$1);
var G__9131 = c__6945__auto___9129;
var G__9132 = cljs.core.count.call(null,c__6945__auto___9129);
var G__9133 = (0);
seq__9113_9118 = G__9130;
chunk__9114_9119 = G__9131;
count__9115_9120 = G__9132;
i__9116_9121 = G__9133;
continue;
} else {
var a_var_9134 = cljs.core.first.call(null,seq__9113_9128__$1);
bond.james.locking.call(null,a_var_9134,(cljs.core.truth_(new cljs.core.Keyword(null,"already-bound?","already-bound?",175091618).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,a_var_9134)))?null:(function (){var old_val = a_var_9134.getRawRoot();
var metadata = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"already-bound?","already-bound?",175091618),true,new cljs.core.Keyword(null,"original","original",-445386197),old_val], null);
a_var_9134.bindRoot(cljs.core.with_meta.call(null,bond.james.redefiniton_fn.call(null,a_var_9134),metadata));

return cljs.core.alter_meta_BANG_.call(null,a_var_9134,((function (seq__9113_9118,chunk__9114_9119,count__9115_9120,i__9116_9121,old_val,metadata,a_var_9134,seq__9113_9128__$1,temp__4425__auto___9127,un_redefs_9117){
return (function (m){
return cljs.core.merge.call(null,m,metadata);
});})(seq__9113_9118,chunk__9114_9119,count__9115_9120,i__9116_9121,old_val,metadata,a_var_9134,seq__9113_9128__$1,temp__4425__auto___9127,un_redefs_9117))
);
})()));

var G__9135 = cljs.core.next.call(null,seq__9113_9128__$1);
var G__9136 = null;
var G__9137 = (0);
var G__9138 = (0);
seq__9113_9118 = G__9135;
chunk__9114_9119 = G__9136;
count__9115_9120 = G__9137;
i__9116_9121 = G__9138;
continue;
}
} else {
}
}
break;
}

return func.call(null);
});
bond.james.xs__GT_map = (function bond$james$xs__GT_map(xs){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (acc,p__9141){
var vec__9142 = p__9141;
var k = cljs.core.nth.call(null,vec__9142,(0),null);
var v = cljs.core.nth.call(null,vec__9142,(1),null);
return cljs.core.assoc_BANG_.call(null,acc,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,k)))),v);
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),cljs.core.partition.call(null,(2),xs)));
});
bond.james.with_dynamic_redefs = (function bond$james$with_dynamic_redefs(var_args){
var args__7207__auto__ = [];
var len__7200__auto___9148 = arguments.length;
var i__7201__auto___9149 = (0);
while(true){
if((i__7201__auto___9149 < len__7200__auto___9148)){
args__7207__auto__.push((arguments[i__7201__auto___9149]));

var G__9150 = (i__7201__auto___9149 + (1));
i__7201__auto___9149 = G__9150;
continue;
} else {
}
break;
}

var argseq__7208__auto__ = ((((3) < args__7207__auto__.length))?(new cljs.core.IndexedSeq(args__7207__auto__.slice((3)),(0))):null);
return bond.james.with_dynamic_redefs.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7208__auto__);
});

bond.james.with_dynamic_redefs.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,bindings,body){
var map_bindings = bond.james.xs__GT_map.call(null,bindings);
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"old-rebindings__9143__auto__","old-rebindings__9143__auto__",83501183,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","local-redefinitions","bond.james/local-redefinitions",-193496131,null))))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","binding","cljs.core/binding",2050379843,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","local-redefinitions","bond.james/local-redefinitions",-193496131,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","merge","cljs.core/merge",-822184067,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"old-rebindings__9143__auto__","old-rebindings__9143__auto__",83501183,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,map_bindings)))))))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","dynamic-redefs","bond.james/dynamic-redefs",-128665661,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.vec.call(null,cljs.core.keys.call(null,map_bindings))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null))))),body)))))))))))))));
});

bond.james.with_dynamic_redefs.cljs$lang$maxFixedArity = (3);

bond.james.with_dynamic_redefs.cljs$lang$applyTo = (function (seq9144){
var G__9145 = cljs.core.first.call(null,seq9144);
var seq9144__$1 = cljs.core.next.call(null,seq9144);
var G__9146 = cljs.core.first.call(null,seq9144__$1);
var seq9144__$2 = cljs.core.next.call(null,seq9144__$1);
var G__9147 = cljs.core.first.call(null,seq9144__$2);
var seq9144__$3 = cljs.core.next.call(null,seq9144__$2);
return bond.james.with_dynamic_redefs.cljs$core$IFn$_invoke$arity$variadic(G__9145,G__9146,G__9147,seq9144__$3);
});

bond.james.with_dynamic_redefs.cljs$lang$macro = true;
/**
 * Same as spy, but does it on the current clojure thread
 */
bond.james.local_spy = (function bond$james$local_spy(v,f){
var number_of_calls = cljs.core.atom.call(null,(0));
return ((function (number_of_calls){
return (function() { 
var G__9151__delegate = function (args){
var spied_f = (((f == null))?bond.james.current__GT_original_definition.call(null,v):((cljs.core.vector_QMARK_.call(null,f))?cljs.core.nth.call(null,f,cljs.core.deref.call(null,number_of_calls)):f
));
try{return cljs.core.apply.call(null,spied_f,args);
}finally {cljs.core.swap_BANG_.call(null,number_of_calls,cljs.core.inc);
}};
var G__9151 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9152__i = 0, G__9152__a = new Array(arguments.length -  0);
while (G__9152__i < G__9152__a.length) {G__9152__a[G__9152__i] = arguments[G__9152__i + 0]; ++G__9152__i;}
  args = new cljs.core.IndexedSeq(G__9152__a,0);
} 
return G__9151__delegate.call(this,args);};
G__9151.cljs$lang$maxFixedArity = 0;
G__9151.cljs$lang$applyTo = (function (arglist__9153){
var args = cljs.core.seq(arglist__9153);
return G__9151__delegate(args);
});
G__9151.cljs$core$IFn$_invoke$arity$variadic = G__9151__delegate;
return G__9151;
})()
;
;})(number_of_calls))
});
/**
 * Same as calls, but for those symbols which were locally spied or
 *   stubbed.
 */
bond.james.local_calls = (function bond$james$local_calls(f){
var me = ((cljs.core.var_QMARK_.call(null,f))?cljs.core.deref.call(null,f):f);
if(cljs.core.truth_(bond.james.thread_bound_QMARK_.call(null,new cljs.core.Var(function(){return bond.james.call_tracker;},new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"dynamic","dynamic",704819571),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"bond.james","bond.james",1031585260,null),new cljs.core.Symbol(null,"call-tracker","call-tracker",28918148,null),"src/bond/james.cljc",28,1,true,4,4,cljs.core.List.EMPTY,null,(cljs.core.truth_(bond.james.call_tracker)?bond.james.call_tracker.cljs$lang$test:null)]))))){
return cljs.core.get.call(null,cljs.core.deref.call(null,bond.james.call_tracker),new cljs.core.Keyword(null,"original","original",-445386197).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,me)),cljs.core.PersistentVector.EMPTY);
} else {
return cljs.core.PersistentVector.EMPTY;
}
});
/**
 * Same as with-spy but spies only on the current clojure thread.
 */
bond.james.with_local_spy = (function bond$james$with_local_spy(var_args){
var args__7207__auto__ = [];
var len__7200__auto___9159 = arguments.length;
var i__7201__auto___9160 = (0);
while(true){
if((i__7201__auto___9160 < len__7200__auto___9159)){
args__7207__auto__.push((arguments[i__7201__auto___9160]));

var G__9161 = (i__7201__auto___9160 + (1));
i__7201__auto___9160 = G__9161;
continue;
} else {
}
break;
}

var argseq__7208__auto__ = ((((3) < args__7207__auto__.length))?(new cljs.core.IndexedSeq(args__7207__auto__.slice((3)),(0))):null);
return bond.james.with_local_spy.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7208__auto__);
});

bond.james.with_local_spy.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,vs,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"current-call-tracker__9154__auto__","current-call-tracker__9154__auto__",1983133676,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","when","cljs.core/when",120293186,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","thread-bound?","bond.james/thread-bound?",-390113460,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null)))))))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","deref","cljs.core/deref",1901963335,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null))))))))))))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","with-dynamic-redefs","bond.james/with-dynamic-redefs",-283272707,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.vec.call(null,cljs.core.mapcat.call(null,(function (v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","local-spy","bond.james/local-spy",2140329230,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,v),new cljs.core.Symbol(null,"var","var",870848730,null))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","local-redefinitions","bond.james/local-redefinitions",-193496131,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,v),new cljs.core.Symbol(null,"var","var",870848730,null))))))))))], null);
}),vs))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","binding","cljs.core/binding",2050379843,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"current-call-tracker__9154__auto__","current-call-tracker__9154__auto__",1983133676,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","swap!","cljs.core/swap!",-2144679919,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","merge","cljs.core/merge",-822184067,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.zipmap.call(null,cljs.core.map.call(null,bond.james.redef_binding__GT_originals,vs),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY))))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null)))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","atom","cljs.core/atom",1943839529,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.zipmap.call(null,cljs.core.map.call(null,bond.james.redef_binding__GT_originals,vs),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY)))))))))))))))),body)))))))))));
});

bond.james.with_local_spy.cljs$lang$maxFixedArity = (3);

bond.james.with_local_spy.cljs$lang$applyTo = (function (seq9155){
var G__9156 = cljs.core.first.call(null,seq9155);
var seq9155__$1 = cljs.core.next.call(null,seq9155);
var G__9157 = cljs.core.first.call(null,seq9155__$1);
var seq9155__$2 = cljs.core.next.call(null,seq9155__$1);
var G__9158 = cljs.core.first.call(null,seq9155__$2);
var seq9155__$3 = cljs.core.next.call(null,seq9155__$2);
return bond.james.with_local_spy.cljs$core$IFn$_invoke$arity$variadic(G__9156,G__9157,G__9158,seq9155__$3);
});

bond.james.with_local_spy.cljs$lang$macro = true;
/**
 * Same as with-spy but does it on the current clojure thread.
 */
bond.james.with_local_spy_ns = (function bond$james$with_local_spy_ns(var_args){
var args__7207__auto__ = [];
var len__7200__auto___9166 = arguments.length;
var i__7201__auto___9167 = (0);
while(true){
if((i__7201__auto___9167 < len__7200__auto___9166)){
args__7207__auto__.push((arguments[i__7201__auto___9167]));

var G__9168 = (i__7201__auto___9167 + (1));
i__7201__auto___9167 = G__9168;
continue;
} else {
}
break;
}

var argseq__7208__auto__ = ((((3) < args__7207__auto__.length))?(new cljs.core.IndexedSeq(args__7207__auto__.slice((3)),(0))):null);
return bond.james.with_local_spy_ns.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7208__auto__);
});

bond.james.with_local_spy_ns.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,namespaces,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","with-local-spy","bond.james/with-local-spy",-1996492859,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.mapcat.call(null,bond.james.ns__GT_fn_symbols,namespaces)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),body)))))));
});

bond.james.with_local_spy_ns.cljs$lang$maxFixedArity = (3);

bond.james.with_local_spy_ns.cljs$lang$applyTo = (function (seq9162){
var G__9163 = cljs.core.first.call(null,seq9162);
var seq9162__$1 = cljs.core.next.call(null,seq9162);
var G__9164 = cljs.core.first.call(null,seq9162__$1);
var seq9162__$2 = cljs.core.next.call(null,seq9162__$1);
var G__9165 = cljs.core.first.call(null,seq9162__$2);
var seq9162__$3 = cljs.core.next.call(null,seq9162__$2);
return bond.james.with_local_spy_ns.cljs$core$IFn$_invoke$arity$variadic(G__9163,G__9164,G__9165,seq9162__$3);
});

bond.james.with_local_spy_ns.cljs$lang$macro = true;
/**
 * Same as with-stub but only stubs it on the local clojure thread.
 */
bond.james.with_local_stub = (function bond$james$with_local_stub(var_args){
var args__7207__auto__ = [];
var len__7200__auto___9174 = arguments.length;
var i__7201__auto___9175 = (0);
while(true){
if((i__7201__auto___9175 < len__7200__auto___9174)){
args__7207__auto__.push((arguments[i__7201__auto___9175]));

var G__9176 = (i__7201__auto___9175 + (1));
i__7201__auto___9175 = G__9176;
continue;
} else {
}
break;
}

var argseq__7208__auto__ = ((((3) < args__7207__auto__.length))?(new cljs.core.IndexedSeq(args__7207__auto__.slice((3)),(0))):null);
return bond.james.with_local_stub.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7208__auto__);
});

bond.james.with_local_stub.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,vs,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"current-call-tracker__9169__auto__","current-call-tracker__9169__auto__",599798648,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","when","cljs.core/when",120293186,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","thread-bound?","bond.james/thread-bound?",-390113460,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null)))))))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","deref","cljs.core/deref",1901963335,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null))))))))))))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","with-dynamic-redefs","bond.james/with-dynamic-redefs",-283272707,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.vec.call(null,cljs.core.mapcat.call(null,(function (v){
if(cljs.core.vector_QMARK_.call(null,v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,v),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","local-spy","bond.james/local-spy",2140329230,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.first.call(null,v)),new cljs.core.Symbol(null,"var","var",870848730,null))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.second.call(null,v)))))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","local-spy","bond.james/local-spy",2140329230,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core._conj.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,v),new cljs.core.Symbol(null,"var","var",870848730,null))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","constantly","cljs.core/constantly",119002258,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))))))))], null);
}
}),vs))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","binding","cljs.core/binding",2050379843,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"current-call-tracker__9169__auto__","current-call-tracker__9169__auto__",599798648,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","swap!","cljs.core/swap!",-2144679919,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","merge","cljs.core/merge",-822184067,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.zipmap.call(null,cljs.core.map.call(null,bond.james.redef_binding__GT_originals,vs),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY))))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null)))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","atom","cljs.core/atom",1943839529,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.zipmap.call(null,cljs.core.map.call(null,bond.james.redef_binding__GT_originals,vs),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY)))))))))))))))),body)))))))))));
});

bond.james.with_local_stub.cljs$lang$maxFixedArity = (3);

bond.james.with_local_stub.cljs$lang$applyTo = (function (seq9170){
var G__9171 = cljs.core.first.call(null,seq9170);
var seq9170__$1 = cljs.core.next.call(null,seq9170);
var G__9172 = cljs.core.first.call(null,seq9170__$1);
var seq9170__$2 = cljs.core.next.call(null,seq9170__$1);
var G__9173 = cljs.core.first.call(null,seq9170__$2);
var seq9170__$3 = cljs.core.next.call(null,seq9170__$2);
return bond.james.with_local_stub.cljs$core$IFn$_invoke$arity$variadic(G__9171,G__9172,G__9173,seq9170__$3);
});

bond.james.with_local_stub.cljs$lang$macro = true;
bond.james.local_stub_BANG_ = (function bond$james$local_stub_BANG_(v,replacement){
if(cljs.core.empty_QMARK_.call(null,new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v)))){
throw (new Error("stub!/with-stub! may only be used on functions which include :arglists in their metadata. Use stub/with-stub instead."));
} else {
}

var f = bond.james.local_spy.call(null,v,replacement);
return cljs.core.with_meta.call(null,((function (f){
return (function() { 
var G__9177__delegate = function (args){
if(cljs.core.truth_(bond.james.args_match_QMARK_.call(null,cljs.core.count.call(null,args),new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v))))){
return cljs.core.apply.call(null,f,args);
} else {
throw (new Error(cljs.core.count.call(null,args),[cljs.core.str(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v))),cljs.core.str("/"),cljs.core.str(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,v)))].join('')));
}
};
var G__9177 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9178__i = 0, G__9178__a = new Array(arguments.length -  0);
while (G__9178__i < G__9178__a.length) {G__9178__a[G__9178__i] = arguments[G__9178__i + 0]; ++G__9178__i;}
  args = new cljs.core.IndexedSeq(G__9178__a,0);
} 
return G__9177__delegate.call(this,args);};
G__9177.cljs$lang$maxFixedArity = 0;
G__9177.cljs$lang$applyTo = (function (arglist__9179){
var args = cljs.core.seq(arglist__9179);
return G__9177__delegate(args);
});
G__9177.cljs$core$IFn$_invoke$arity$variadic = G__9177__delegate;
return G__9177;
})()
;})(f))
,cljs.core.meta.call(null,f));
});
/**
 * Like with-stub!, but only works for thread-locally
 */
bond.james.with_local_stub_BANG_ = (function bond$james$with_local_stub_BANG_(var_args){
var args__7207__auto__ = [];
var len__7200__auto___9185 = arguments.length;
var i__7201__auto___9186 = (0);
while(true){
if((i__7201__auto___9186 < len__7200__auto___9185)){
args__7207__auto__.push((arguments[i__7201__auto___9186]));

var G__9187 = (i__7201__auto___9186 + (1));
i__7201__auto___9186 = G__9187;
continue;
} else {
}
break;
}

var argseq__7208__auto__ = ((((3) < args__7207__auto__.length))?(new cljs.core.IndexedSeq(args__7207__auto__.slice((3)),(0))):null);
return bond.james.with_local_stub_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7208__auto__);
});

bond.james.with_local_stub_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,vs,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"current-call-tracker__9180__auto__","current-call-tracker__9180__auto__",-1589913586,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","when","cljs.core/when",120293186,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","thread-bound?","bond.james/thread-bound?",-390113460,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null)))))))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","deref","cljs.core/deref",1901963335,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null))))))))))))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","with-dynamic-redefs","bond.james/with-dynamic-redefs",-283272707,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.vec.call(null,cljs.core.mapcat.call(null,(function (v){
if(cljs.core.vector_QMARK_.call(null,v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,v),cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","local-stub!","bond.james/local-stub!",1212235669,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.first.call(null,v)))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.second.call(null,v)))))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","local-stub!","bond.james/local-stub!",1212235669,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"var","var",870848730,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,v))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","constantly","cljs.core/constantly",119002258,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,null))))))))], null);
}
}),vs))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","binding","cljs.core/binding",2050379843,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"current-call-tracker__9180__auto__","current-call-tracker__9180__auto__",-1589913586,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","swap!","cljs.core/swap!",-2144679919,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","merge","cljs.core/merge",-822184067,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.zipmap.call(null,cljs.core.map.call(null,bond.james.redef_binding__GT_originals,vs),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY))))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("bond.james","call-tracker","bond.james/call-tracker",-1866660051,null)))))),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","atom","cljs.core/atom",1943839529,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,cljs.core.zipmap.call(null,cljs.core.map.call(null,bond.james.redef_binding__GT_originals,vs),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY)))))))))))))))),body)))))))))));
});

bond.james.with_local_stub_BANG_.cljs$lang$maxFixedArity = (3);

bond.james.with_local_stub_BANG_.cljs$lang$applyTo = (function (seq9181){
var G__9182 = cljs.core.first.call(null,seq9181);
var seq9181__$1 = cljs.core.next.call(null,seq9181);
var G__9183 = cljs.core.first.call(null,seq9181__$1);
var seq9181__$2 = cljs.core.next.call(null,seq9181__$1);
var G__9184 = cljs.core.first.call(null,seq9181__$2);
var seq9181__$3 = cljs.core.next.call(null,seq9181__$2);
return bond.james.with_local_stub_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__9182,G__9183,G__9184,seq9181__$3);
});

bond.james.with_local_stub_BANG_.cljs$lang$macro = true;
