(ns inspect.core
  (:require clojure.tools.logging
            clojure.pprint))

(defmacro inspect
  "prints the expression '<name> is <value>', and returns the value. This is a
  valuable debugging tool."
  [value]
  `(do
     (let [value# (quote ~value)
           result# ~value]
       (print (str value#
                   " is "
                   (with-out-str (clojure.pprint/pprint result#))
                   "\n"))
       ;; flushing would be provided by println, but println causes
       ;; near-simultaneous inspects to be interspersed
       (when *flush-on-newline*
         (flush))
       (clojure.tools.logging/infof "%s is %s" value# result#)
       result#)))
