# inspect

[![CircleCI](https://circleci.com/gh/Motiva-AI/inspect.svg?style=svg)](https://circleci.com/gh/Motiva-AI/inspect)

A macro for dumping values to stdout and logs. Can be used inline.

## Usage

```clojure
(let [path (inspect (System/getenv "CLOJURE_HOME"))]
  (clojure.string/split path #"/"))
```

Output when executed via REPL:

```
(System/getenv "CLOJURE_HOME") is "/usr/share/clojure"

Jul 03, 2018 2:20:59 PM clojure.tools.logging$eval579$fn__582 invoke
INFO: (System/getenv "CLOJURE_HOME") is /usr/share/clojure
=> ["" "usr" "share" "clojure"]
```

Inline example:

```clojure
(-> (System/getenv "CLOJURE_HOME")
    (inspect)
    (clojure.string/split #"/"))
```

giving the same result as above.

## License

The MIT License (MIT)

Copyright © 2018 Motiva AI

