# clj-sqs-extended

[![CircleCI](https://circleci.com/gh/Motiva-AI/clj-sqs-extended/tree/master.svg?style=svg)](https://circleci.com/gh/Motiva-AI/clj-sqs-extended/tree/master) [![Clojars Project](https://img.shields.io/clojars/v/motiva/clj-sqs-extended.svg)](https://clojars.org/motiva/clj-sqs-extended)

This library is a clojure wrapper for the [Amazon SQS Extended Client Library for Java](https://github.com/awslabs/amazon-sqs-java-extended-client-lib).

## Example

Spin up some services via Docker on your localhost to try the following:

```
$ make devel
```

```clj
(require '[clj-sqs-extended.core :as sqs-ext]
         '[clj-sqs-extended.aws.sqs :as sqs])

(def client
  (sqs-ext/sqs-ext-client
    {:access-key     "default"
     :secret-key     "default"
     :s3-endpoint    "http://localhost:4566"
     :s3-bucket-name "example-bucket"
     :sqs-endpoint   "http://localhost:4566"
     :region         "us-east-2"}))

(def queue-url (sqs/create-standard-queue! client "my-test-queue"))
; "http://localstack:4566/000000000000/my-test-queue"

(sqs-ext/send-message client queue-url "hello world!")
; "61b077d1-63f9-cd52-b2eb-1078d66ed1a4"

(sqs/receive-messages client queue-url)
; ({:body "hello world!"
;   :format :transit
;   :messageId "61b077d1-63f9-cd52-b2eb-1078d66ed1a4"
;   :receiptHandle "myztiahpogtvdzmjnjqdgezxppupfabbwqckgymjsqyxsclfbajceqrmeuheuqcyuupppmqtryibpkuuoedhrqicnqtkcrsajycnlorutgtgzwykwoqkbkocrpmwedcnafhqetnejdfkwwkcmkrohkldahtzpiavhvyohpccrgssklvoyosricawi"})
```

## Development

### Requirements

- [circleci-cli-tool](https://circleci.com/docs/2.0/local-cli/)

### Testing

Tests are run inside a CircleCI Docker container on localhost.

```
$ make test
```
