(ns morri.meth450k.common.db-utils
  (:require [clojure.java.jdbc :as jdbc]
            [java-jdbc.ddl :as ddl]
            [clojure.string :as string]
            [honeysql.core :as sql]
            [honeysql.helpers :refer :all]
            [morri.meth450k.common.utils :refer [tprn]])
  (:import (com.mchange.v2.c3p0 ComboPooledDataSource)))

(defn sqlite-db [sqlite-file]
  {:classname   "org.sqlite.JDBC"
   :subprotocol "sqlite"
   :subname     sqlite-file})
;tested

(defn mysql-db [db]
  {:subprotocol "mysql"
   :subname (str "//127.0.0.1:3306/" db)})

(defn make-delayed-db-pool
  [spec]
  (let [cpds (doto (ComboPooledDataSource.)
               (.setDriverClass (:classname spec))
               (.setJdbcUrl (str "jdbc:" (:subprotocol spec) ":" (:subname spec)))
               ;; (.setMaxPoolSize 100)
               ;; (.setMinPoolSize 20)
               ;; (.setNumHelperThreads 6)
               ;; (.setInitialPoolSize 50)
               ;; (.setMaxStatements 200)
               ;; (.setUser (:user spec))
               ;; (.setPassword (:password spec))
               ;; ;; expire excess connections after 30 minutes of inactivity:
               ;; (.setMaxIdleTimeExcessConnections (* 30 60))
               ;; ;; expire connections after 3 hours of inactivity:
               ;; (.setMaxIdleTime (* 3 60 60)))
               )]
    (delay {:datasource cpds})))

(defmacro try-catch-all [expr]
  `(try ~expr
        (catch Exception e# (println "Caught Exception: " (.getMessage e#)))))

(defn try-drop-table [db table]
  (try-catch-all (jdbc/db-do-commands db (tprn (ddl/drop-table table)))))

(defn try-drop-index [db index]
  (try-catch-all (jdbc/db-do-commands db (tprn (ddl/drop-index index)))))

(defn make-index-name [cols]
  (str (string/join \_ (map name cols))
       "_idx"))

(defn try-create-index
  ([db table-name cols] (try-create-index db table-name cols (make-index-name cols)))
  ([db table-name cols index-name]
     (do
       (try-catch-all
        (jdbc/db-do-commands db (tprn (ddl/create-index
                                       index-name
                                       table-name
                                       cols))))
       index-name)))

(defn count-rows-sql [table]
  (sql/format (-> (select [(sql/call :count :*) :count])
                  (from table))))

(defn count-rows [db table]
  (:count (first (jdbc/query db (count-rows-sql table)))))
