(ns morri.meth450k.common.illumina450k-db
  (:require [clojure.java.jdbc :as jdbc]
            [morri.meth450k.common.utils :as utils]
            [morri.meth450k.common.db-utils :as db-utils]
            [honeysql.core :as sql]
            [honeysql.helpers :refer :all]))

(def illumina450k-db-spec (db-utils/mysql-db "illumina450k"))

;; using a delay so that the c3p0 pool is not initailized when compiling
(def i450k-DB (db-utils/make-delayed-db-pool illumina450k-db-spec))

(defn i450k-query [sql-query]
  (jdbc/query @i450k-DB sql-query :identifiers identity))

(def i450k-table :illumina450k)

(defn i450k-count []
  (db-utils/count-rows @i450k-DB i450k-table))

(defn last-cpg [{:keys [chr tss strand]}]
  (let [chr (utils/strip-chr chr)
        gt-or-lt (case strand
                   "+" :<
                   "-" :>)
        asc-or-desc (case strand
                      "+" :desc
                      "-" :asc)
        query (-> (select :name :mapinfo)
                  (from i450k-table)
                  (where [:and
                          [:like :name "cg%"]
                          [:= :chr (sql/param :chr)]
                          [gt-or-lt :mapinfo (sql/param :tss)]])
                  (order-by [:mapinfo asc-or-desc])
                  (limit 1)
                  (sql/format {:chr chr :tss tss}))]
    (if-let [result (first (i450k-query query))]
      [(:name result)
       (utils/dist-rel-to-tss strand tss (:mapinfo result))]
      [nil nil])))
