(ns morri.lib.incanter
  (:require [clojure.string :as str]
            [clostache.parser :as stache]
            [incanter.core :refer :all]
            [incanter.stats :as stats]
            [morri.lib.binning :as bin]
            [clatrix.core :as matrix]))

(defn map-add-col [new-col-or-cols f old-col-or-cols a-dataset]
  (let [new-colv (if (coll? new-col-or-cols)
                   new-col-or-cols
                   [new-col-or-cols])]
    (conj-cols a-dataset
               (dataset new-colv
                        ($map f old-col-or-cols a-dataset)))))

(defn transform-column [col-name f data]
  (let [new-col-names (sort-by #(= % col-name) (col-names data))
        new-dataset (conj-cols
                      (sel data :except-cols col-name)
                      (map f ($ col-name data)))]
    ($ (col-names data) (col-names new-dataset new-col-names))))

(defn my-replace-column [col-name new-col-data data]
  (let [new-col-names (sort-by #(= % col-name) (col-names data))
        new-dataset (conj-cols
                     (sel data :except-cols col-name)
                     new-col-data)]
    ($ (col-names data) (col-names new-dataset new-col-names))))

(defn col->int [col-name data]
  (transform-column col-name int data))

;; Need to add some tests for the latex output, esp the escaping.

(defn add-slash [s tok]
  (str/replace s tok (str "\\" tok)))

(defn escape-latex [i]
  (let [s (str i)]
    (-> s
        (str/replace #"\\|\{|\}" {"\\" "\\textbackslash{}"
                                  "{" "\\{"
                                  "}" "\\}"}); need to do these together
        (add-slash "#")
        (add-slash "$")
        (add-slash "%")
        (add-slash "&")
        (add-slash "_")
        (str/replace "^" "\\textasciicircum{}")
        (str/replace "~" "\\textasciitilde{}")
        (str/replace ">" "\\textgreater{}")
        (str/replace "<" "\\testless{}"))))

(defn latex-table-row [data]
  (str/join " & " (map escape-latex data)))

(defn save-latex [d-set file-name]
  (let [render-map {:col-spec (apply str (repeat (ncol d-set) "l"))
                    :header-row (latex-table-row (col-names d-set))
                    :data-rows (map latex-table-row (to-list d-set))}
        rendered (stache/render-resource "dataset-to-latex.tex" render-map)]
    (spit file-name rendered)))

;; (defn smooth-density-2d [x-data y-data]
;;   (let [bin-opts {:binning-type :range-n-bins-binning
;;                   :start 0 :stop 10}
;;         x-bin-width 1.0
;;         y-bin-width 1.0
;;         bin-fn (bin/which-bin-id-2d x-bin-width y-bin-width)
;;         binned-data (map bin-fn x-data y-data)
;;         freqs (frequencies binned-data)]
;;     freqs))


;; ;; freqs is {[x-bin-center y-bin-center] count, ...}
;; ;; Now maybe we should populate a matrix

;; (def x (stats/sample-poisson 1000 :lambda 5))
;; (def y (stats/sample-poisson 1000 :lambda 5))

;; (def f (smooth-density-2d x y))
;; (prn f)
