(ns {{name}}.core
  (:require [{{name}}.database :as database]
            [compojure.core :as compojure]
            [compojure.handler :as handler]
            [environ.core :as environ]            
            [{{name}}.routes :as routes]
            [org.httpkit.server :as http-kit]
            [ring.middleware.reload :as reload]
            [ring.middleware.stacktrace :as stacktrace]
            [{{name}}.utils :as utils]))

(def app
  (-> (handler/api routes/secured-routes)
      (utils/wrap-if (= "development" (environ/env :environment))
                     (stacktrace/wrap-stacktrace)
                     (reload/wrap-reload :all))))

(defn -main []
  (println "Connecting to database")
  (database/setup-db)
  (println "Starting http-kit")
  (defonce web-server (http-kit/run-server #'app {:port (Integer. (:port (environ/env :{{name}}))) :join? false})))