(ns leiningen.new.monolith
  (:use [leiningen.new.templates :only [renderer name-to-path ->files]]))

(def render (renderer "monolith"))

(defn monolith
  "FIXME: write documentation"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (->files data
             [".gitignore" (render "gitignore")]
             ["project.clj" (render "project.clj" data)]
             ["src/{{sanitized}}/authentication.clj" (render "authentication.clj" data)]
             ["src/{{sanitized}}/core.clj" (render "core.clj" data)]
             ["src/{{sanitized}}/database.clj" (render "database.clj" data)]
             ["src/{{sanitized}}/home.clj" (render "home.clj" data)]
             ["src/{{sanitized}}/models.clj" (render "models.clj" data)]
             ["src/{{sanitized}}/routes.clj" (render "routes.clj" data)]
             ["src/{{sanitized}}/utils.clj" (render "utils.clj" data)]
             ["src/{{sanitized}}/layouts.clj" (render "layouts.clj" data)]
             "test/{{sanitized}}/test"
             "resources/public"
)))
