(ns {{name}}.database
  (:require [environ.core :as environ]
            [korma.db :as korma-db])
  (:import com.googlecode.flyway.core.Flyway))

(def db-settings {:classname "org.postgresql.Driver"
                  :subprotocol "postgresql"
                  :subname (:database-subname (environ/env :{{name}}))
                  :user (:database-username (environ/env :{{name}})) 
                  :password (:database-password (environ/env :{{name}}))})

(defn setup-db []
  (korma-db/defdb db db-settings))

(defn- get-database-url []
  (str "jdbc:postgresql://localhost/" (:database-subname (environ/env :{{name}}))))

(defn run-migrations []
  (let [flyway (Flyway.)]
    (doto flyway
      (.setDataSource (get-database-url)
                      (:database-username (environ/env :{{name}}))
                      (:database-password (environ/env :{{name}})))
      (.migrate))))

