(ns {{name}}.models
  (:require [cemerick.friend.credentials :as creds]
            [korma.core :as korma]))

                                        ;Users
(korma/defentity users
  (korma/entity-fields :id :email :password))

(defn find-user-by-email [email]
  (korma/select users (korma/where {:email email})))

(defn create-user [email password]
  (korma/insert users
          (korma/values {:email email
                              :password (creds/hash-bcrypt password)})))