/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.CharBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.UUID;
import org.monetdb.jdbc.MonetBlob;
import org.monetdb.jdbc.MonetClob;
import org.monetdb.jdbc.MonetConnection;
import org.monetdb.jdbc.MonetDriver;
import org.monetdb.jdbc.MonetResultSet;
import org.monetdb.jdbc.MonetStatement;
import org.monetdb.jdbc.MonetWrapper;
import org.monetdb.jdbc.types.INET;

public class MonetPreparedStatement
extends MonetStatement
implements PreparedStatement,
AutoCloseable {
    private final String[] monetdbType;
    private final int[] javaType;
    private final int[] digits;
    private final int[] scale;
    private final String[] schema;
    private final String[] table;
    private final String[] column;
    private final int id;
    private final int size;
    private final int rscolcnt;
    private final String[] values;
    private SimpleDateFormat mTimestampZ;
    private SimpleDateFormat mTimestamp;
    private SimpleDateFormat mTimeZ;
    private SimpleDateFormat mTime;
    private SimpleDateFormat mDate;
    static final String HEXES = "0123456789ABCDEF";

    MonetPreparedStatement(MonetConnection monetConnection, int n, int n2, int n3, String string) throws SQLException, IllegalArgumentException {
        super(monetConnection, n, n2, n3);
        if (!super.execute("PREPARE " + string)) {
            throw new SQLException("Unexpected server response", "M0M10");
        }
        this.id = ((MonetConnection.ResultSetResponse)this.header).id;
        this.size = (int)((MonetConnection.ResultSetResponse)this.header).tuplecount;
        this.rscolcnt = ((MonetConnection.ResultSetResponse)this.header).columncount;
        this.monetdbType = new String[this.size];
        this.javaType = new int[this.size];
        this.digits = new int[this.size];
        this.scale = new int[this.size];
        this.schema = new String[this.size];
        this.table = new String[this.size];
        this.column = new String[this.size];
        this.values = new String[this.size];
        ResultSet resultSet = super.getResultSet();
        if (resultSet != null) {
            int n4 = resultSet.findColumn("type");
            int n5 = resultSet.findColumn("digits");
            int n6 = resultSet.findColumn("scale");
            int n7 = resultSet.findColumn("schema");
            int n8 = resultSet.findColumn("table");
            int n9 = resultSet.findColumn("column");
            int n10 = 0;
            while (resultSet.next()) {
                this.monetdbType[n10] = resultSet.getString(n4);
                this.javaType[n10] = MonetDriver.getJdbcSQLType(this.monetdbType[n10]);
                if (this.javaType[n10] == 2005) {
                    if (monetConnection.mapClobAsVarChar()) {
                        this.javaType[n10] = 12;
                    }
                } else if (this.javaType[n10] == 2004 && monetConnection.mapBlobAsVarBinary()) {
                    this.javaType[n10] = -3;
                }
                this.digits[n10] = resultSet.getInt(n5);
                this.scale[n10] = resultSet.getInt(n6);
                if (this.rscolcnt != 3) {
                    this.schema[n10] = resultSet.getString(n7);
                    this.table[n10] = resultSet.getString(n8);
                    this.column[n10] = resultSet.getString(n9);
                }
                ++n10;
            }
            resultSet.close();
        }
        this.poolable = true;
    }

    @Override
    public void addBatch() throws SQLException {
        super.addBatch(this.transform());
    }

    @Override
    public void addBatch(String string) throws SQLException {
        throw new SQLException("This method is not available in a PreparedStatement!", "M1M05");
    }

    @Override
    public void clearParameters() {
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = null;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        return super.execute(this.transform());
    }

    @Override
    public boolean execute(String string) throws SQLException {
        throw new SQLException("This method is not available in a PreparedStatement!", "M1M05");
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (!this.execute()) {
            throw new SQLException("Query did not produce a result set", "M1M19");
        }
        return this.getResultSet();
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        throw new SQLException("This method is not available in a PreparedStatement!", "M1M05");
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.execute()) {
            throw new SQLException("Query produced a result set", "M1M17");
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        throw new SQLException("This method is not available in a PreparedStatement!", "M1M05");
    }

    private final int getColumnIdx(int n) throws SQLException {
        int n2 = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.column[i] == null || ++n2 != n) continue;
            return i;
        }
        throw new SQLException("No such column with index: " + n, "M1M05");
    }

    private final int getParamIdx(int n) throws SQLException {
        int n2 = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.column[i] != null || ++n2 != n) continue;
            return i;
        }
        throw new SQLException("No such parameter with index: " + n, "M1M05");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.rscolcnt == 3) {
            return null;
        }
        return new rsmdw(){

            @Override
            public int getColumnCount() {
                int n = 0;
                for (int i = 0; i < MonetPreparedStatement.this.size; ++i) {
                    if (MonetPreparedStatement.this.column[i] == null) continue;
                    ++n;
                }
                return n;
            }

            @Override
            public boolean isAutoIncrement(int n) throws SQLException {
                return false;
            }

            @Override
            public boolean isCaseSensitive(int n) throws SQLException {
                switch (this.getColumnType(n)) {
                    case -1: 
                    case 1: 
                    case 2005: {
                        return true;
                    }
                    case 12: {
                        String string = this.getColumnTypeName(n);
                        return string == null || !"inet".equals(string) && !"uuid".equals(string);
                    }
                }
                return false;
            }

            @Override
            public boolean isSearchable(int n) {
                return true;
            }

            @Override
            public boolean isCurrency(int n) {
                return false;
            }

            @Override
            public boolean isSigned(int n) throws SQLException {
                switch (this.getColumnType(n)) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                    case -5: {
                        String string = this.getColumnTypeName(n);
                        return string == null || !"oid".equals(string) && !"ptr".equals(string);
                    }
                }
                return false;
            }

            @Override
            public int getColumnDisplaySize(int n) throws SQLException {
                try {
                    return MonetPreparedStatement.this.digits[MonetPreparedStatement.this.getColumnIdx(n)];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public String getSchemaName(int n) throws SQLException {
                try {
                    return MonetPreparedStatement.this.schema[MonetPreparedStatement.this.getColumnIdx(n)];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public String getTableName(int n) throws SQLException {
                try {
                    return MonetPreparedStatement.this.table[MonetPreparedStatement.this.getColumnIdx(n)];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public int getPrecision(int n) throws SQLException {
                try {
                    return MonetPreparedStatement.this.digits[MonetPreparedStatement.this.getColumnIdx(n)];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public int getScale(int n) throws SQLException {
                try {
                    return MonetPreparedStatement.this.scale[MonetPreparedStatement.this.getColumnIdx(n)];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public int isNullable(int n) throws SQLException {
                return 2;
            }

            @Override
            public String getCatalogName(int n) throws SQLException {
                return null;
            }

            @Override
            public boolean isReadOnly(int n) {
                return true;
            }

            @Override
            public boolean isWritable(int n) {
                return false;
            }

            @Override
            public boolean isDefinitelyWritable(int n) {
                return false;
            }

            @Override
            public String getColumnClassName(int n) throws SQLException {
                String string = this.getColumnTypeName(n);
                Map<String, Class<?>> map = MonetPreparedStatement.this.getConnection().getTypeMap();
                Class<?> clazz = map.containsKey(string) ? map.get(string) : MonetResultSet.getClassForType(this.getColumnType(n));
                return clazz.getName();
            }

            @Override
            public String getColumnLabel(int n) throws SQLException {
                return this.getColumnName(n);
            }

            @Override
            public String getColumnName(int n) throws SQLException {
                try {
                    return MonetPreparedStatement.this.column[MonetPreparedStatement.this.getColumnIdx(n)];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public int getColumnType(int n) throws SQLException {
                try {
                    return MonetPreparedStatement.this.javaType[MonetPreparedStatement.this.getColumnIdx(n)];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public String getColumnTypeName(int n) throws SQLException {
                try {
                    return MonetPreparedStatement.this.monetdbType[MonetPreparedStatement.this.getColumnIdx(n)];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }
        };
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new pmdw(){

            @Override
            public int getParameterCount() throws SQLException {
                int n = 0;
                for (int i = 0; i < MonetPreparedStatement.this.size; ++i) {
                    if (MonetPreparedStatement.this.column[i] != null) continue;
                    ++n;
                }
                return n;
            }

            @Override
            public int isNullable(int n) throws SQLException {
                return 2;
            }

            @Override
            public boolean isSigned(int n) throws SQLException {
                switch (this.getParameterType(n)) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                    case -5: {
                        String string = this.getParameterTypeName(n);
                        return string == null || !"oid".equals(string) && !"ptr".equals(string);
                    }
                }
                return false;
            }

            @Override
            public int getPrecision(int n) throws SQLException {
                try {
                    return MonetPreparedStatement.this.digits[MonetPreparedStatement.this.getParamIdx(n)];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetPreparedStatement.newSQLInvalidParameterIndexException(n);
                }
            }

            @Override
            public int getScale(int n) throws SQLException {
                try {
                    return MonetPreparedStatement.this.scale[MonetPreparedStatement.this.getParamIdx(n)];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetPreparedStatement.newSQLInvalidParameterIndexException(n);
                }
            }

            @Override
            public int getParameterType(int n) throws SQLException {
                try {
                    return MonetPreparedStatement.this.javaType[MonetPreparedStatement.this.getParamIdx(n)];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetPreparedStatement.newSQLInvalidParameterIndexException(n);
                }
            }

            @Override
            public String getParameterTypeName(int n) throws SQLException {
                try {
                    return MonetPreparedStatement.this.monetdbType[MonetPreparedStatement.this.getParamIdx(n)];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetPreparedStatement.newSQLInvalidParameterIndexException(n);
                }
            }

            @Override
            public String getParameterClassName(int n) throws SQLException {
                String string = this.getParameterTypeName(n);
                Map<String, Class<?>> map = MonetPreparedStatement.this.getConnection().getTypeMap();
                Class<?> clazz = map.containsKey(string) ? map.get(string) : MonetResultSet.getClassForType(this.getParameterType(n));
                return clazz.getName();
            }

            @Override
            public int getParameterMode(int n) throws SQLException {
                return 1;
            }
        };
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setArray");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        int n2 = this.getParamIdx(n);
        if ((bigDecimal = bigDecimal.setScale(this.scale[n2], RoundingMode.HALF_UP)).precision() > this.digits[n2]) {
            throw new SQLDataException("DECIMAL value exceeds allowed digits/scale: " + bigDecimal.toPlainString() + " (" + this.digits[n2] + "/" + this.scale[n2] + ")", "22003");
        }
        String string = bigDecimal.toPlainString();
        int n3 = string.indexOf(46);
        if (n3 >= 0) {
            string = string.substring(0, Math.min(string.length(), n3 + 1 + this.scale[n2]));
        }
        while (string.startsWith("0") && string.length() > 1) {
            string = string.substring(1);
        }
        this.setValue(n, string);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setBinaryStream");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setBinaryStream");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setBinaryStream");
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.setValue(n, Boolean.toString(bl));
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.setValue(n, Byte.toString(by));
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull(n, -1);
            return;
        }
        int n2 = byArray.length;
        StringBuilder stringBuilder = new StringBuilder(8 + n2 * 2);
        stringBuilder.append("blob '");
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(HEXES.charAt((byArray[i] & 0xF0) >> 4)).append(HEXES.charAt(byArray[i] & 0xF));
        }
        stringBuilder.append("'");
        this.setValue(n, stringBuilder.toString());
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.setClob(n, reader, n2);
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.setClob(n, reader);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.setClob(n, reader, l);
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        if (clob == null) {
            this.setNull(n, -1);
            return;
        }
        this.setString(n, clob.getSubString(1L, (int)clob.length()));
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        if (reader == null) {
            this.setNull(n, -1);
            return;
        }
        char[] cArray = new char[8192];
        StringBuilder stringBuilder = new StringBuilder(262144);
        try {
            int n2;
            while ((n2 = reader.read(cArray, 0, 8192)) > 0) {
                stringBuilder.append(cArray, 0, n2);
            }
            this.setString(n, stringBuilder.toString());
        }
        catch (IOException iOException) {
            throw new SQLException("failed to read from stream: " + iOException.getMessage(), "M1M25");
        }
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        if (reader == null) {
            this.setNull(n, -1);
            return;
        }
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw new SQLException("Invalid length value: " + l, "M1M05");
        }
        CharBuffer charBuffer = CharBuffer.allocate((int)l);
        try {
            reader.read(charBuffer);
            charBuffer.rewind();
            this.setString(n, charBuffer.toString());
        }
        catch (IOException iOException) {
            throw new SQLException("failed to read from stream: " + iOException.getMessage(), "M1M25");
        }
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            this.setNull(n, -1);
            return;
        }
        if (calendar == null) {
            this.setValue(n, "date '" + date.toString() + "'");
        } else {
            if (this.mDate == null) {
                this.mDate = new SimpleDateFormat("yyyy-MM-dd");
            }
            this.mDate.setTimeZone(calendar.getTimeZone());
            this.setValue(n, "date '" + this.mDate.format(date) + "'");
        }
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.setValue(n, Double.toString(d));
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.setValue(n, Float.toString(f));
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.setValue(n, Integer.toString(n2));
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.setValue(n, Long.toString(l));
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.setCharacterStream(n, reader);
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, l);
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.setString(n, string);
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.setValue(n, "NULL");
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.setObject(n, object, this.javaType[this.getParamIdx(n)], 0);
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (object == null) {
            this.setNull(n, -1);
            return;
        }
        if (object instanceof String) {
            this.setString(n, (String)object);
            return;
        }
        if (object instanceof BigDecimal || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double) {
            Number number = (Number)object;
            switch (n2) {
                case -6: {
                    this.setByte(n, number.byteValue());
                    return;
                }
                case 5: {
                    this.setShort(n, number.shortValue());
                    return;
                }
                case 4: {
                    this.setInt(n, number.intValue());
                    return;
                }
                case -5: {
                    if (object instanceof BigDecimal) {
                        BigDecimal bigDecimal = (BigDecimal)object;
                        this.setLong(n, bigDecimal.setScale(n3, RoundingMode.HALF_UP).longValue());
                        return;
                    }
                    this.setLong(n, number.longValue());
                    return;
                }
                case 7: {
                    this.setFloat(n, number.floatValue());
                    return;
                }
                case 6: 
                case 8: {
                    this.setDouble(n, number.doubleValue());
                    return;
                }
                case 2: 
                case 3: {
                    if (object instanceof BigDecimal) {
                        this.setBigDecimal(n, (BigDecimal)object);
                        return;
                    }
                    this.setBigDecimal(n, new BigDecimal(number.doubleValue()));
                    return;
                }
                case 16: {
                    if (number.doubleValue() != 0.0) {
                        this.setBoolean(n, true);
                        return;
                    }
                    this.setBoolean(n, false);
                    return;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    this.setString(n, object.toString());
                    return;
                }
                default: {
                    throw new SQLException("Conversion not allowed", "M1M05");
                }
            }
        }
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            switch (n2) {
                case -6: {
                    this.setByte(n, (byte)(bl ? 1 : 0));
                    return;
                }
                case 5: {
                    this.setShort(n, (short)(bl ? 1 : 0));
                    return;
                }
                case 4: {
                    this.setInt(n, bl ? 1 : 0);
                    return;
                }
                case -5: {
                    this.setLong(n, bl ? 1 : 0);
                    return;
                }
                case 7: {
                    this.setFloat(n, (float)(bl ? 1.0 : 0.0));
                    return;
                }
                case 6: 
                case 8: {
                    this.setDouble(n, bl ? 1.0 : 0.0);
                    return;
                }
                case 2: 
                case 3: {
                    BigDecimal bigDecimal;
                    try {
                        bigDecimal = new BigDecimal(bl ? 1.0 : 0.0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SQLException("Internal error: unable to create template BigDecimal: " + numberFormatException.getMessage(), "M0M03");
                    }
                    this.setBigDecimal(n, bigDecimal);
                    return;
                }
                case 16: {
                    this.setBoolean(n, bl);
                    return;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    this.setString(n, object.toString());
                    return;
                }
                default: {
                    throw new SQLException("Conversion not allowed", "M1M05");
                }
            }
        }
        if (object instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)object;
            switch (n2) {
                case -5: {
                    this.setLong(n, bigInteger.longValue());
                    return;
                }
                case 2: 
                case 3: {
                    BigDecimal bigDecimal;
                    try {
                        bigDecimal = new BigDecimal(bigInteger);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SQLException("Internal error: unable to create template BigDecimal: " + numberFormatException.getMessage(), "M0M03");
                    }
                    this.setBigDecimal(n, bigDecimal);
                    return;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    this.setString(n, object.toString());
                    return;
                }
                default: {
                    throw new SQLException("Conversion not allowed", "M1M05");
                }
            }
        }
        if (object instanceof byte[]) {
            switch (n2) {
                case -4: 
                case -3: 
                case -2: {
                    this.setBytes(n, (byte[])object);
                    return;
                }
                default: {
                    throw new SQLException("Conversion not allowed", "M1M05");
                }
            }
        }
        if (object instanceof Date || object instanceof Timestamp || object instanceof Time || object instanceof Calendar || object instanceof java.util.Date) {
            switch (n2) {
                case 91: {
                    if (object instanceof Date) {
                        this.setDate(n, (Date)object);
                        return;
                    } else if (object instanceof Timestamp) {
                        this.setDate(n, new Date(((Timestamp)object).getTime()));
                        return;
                    } else if (object instanceof java.util.Date) {
                        this.setDate(n, new Date(((java.util.Date)object).getTime()));
                        return;
                    } else {
                        if (!(object instanceof Calendar)) throw new SQLException("Conversion not allowed", "M1M05");
                        this.setDate(n, new Date(((Calendar)object).getTimeInMillis()));
                    }
                    return;
                }
                case 92: 
                case 2013: {
                    if (object instanceof Time) {
                        this.setTime(n, (Time)object);
                        return;
                    } else if (object instanceof Timestamp) {
                        this.setTime(n, new Time(((Timestamp)object).getTime()));
                        return;
                    } else if (object instanceof java.util.Date) {
                        this.setTime(n, new Time(((java.util.Date)object).getTime()));
                        return;
                    } else {
                        if (!(object instanceof Calendar)) throw new SQLException("Conversion not allowed", "M1M05");
                        this.setTime(n, new Time(((Calendar)object).getTimeInMillis()));
                    }
                    return;
                }
                case 93: 
                case 2014: {
                    if (object instanceof Timestamp) {
                        this.setTimestamp(n, (Timestamp)object);
                        return;
                    } else if (object instanceof Date) {
                        this.setTimestamp(n, new Timestamp(((Date)object).getTime()));
                        return;
                    } else if (object instanceof java.util.Date) {
                        this.setTimestamp(n, new Timestamp(((java.util.Date)object).getTime()));
                        return;
                    } else {
                        if (!(object instanceof Calendar)) throw new SQLException("Conversion not allowed", "M1M05");
                        this.setTimestamp(n, new Timestamp(((Calendar)object).getTimeInMillis()));
                    }
                    return;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    this.setString(n, object.toString());
                    return;
                }
                default: {
                    throw new SQLException("Conversion not allowed", "M1M05");
                }
            }
        }
        if (object instanceof Array) {
            this.setArray(n, (Array)object);
            return;
        } else if (object instanceof MonetBlob || object instanceof Blob) {
            this.setBlob(n, (Blob)object);
            return;
        } else if (object instanceof MonetClob || object instanceof Clob) {
            this.setClob(n, (Clob)object);
            return;
        } else {
            if (object instanceof Struct) {
                throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setObject() with object of type Struct");
            }
            if (object instanceof Ref) {
                this.setRef(n, (Ref)object);
                return;
            } else if (object instanceof URL) {
                this.setURL(n, (URL)object);
                return;
            } else if (object instanceof UUID) {
                this.setString(n, object.toString());
                return;
            } else if (object instanceof RowId) {
                this.setRowId(n, (RowId)object);
                return;
            } else if (object instanceof NClob) {
                this.setNClob(n, (NClob)object);
                return;
            } else if (object instanceof SQLXML) {
                this.setSQLXML(n, (SQLXML)object);
                return;
            } else {
                if (!(object instanceof SQLData)) throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setObject() with object of type Class " + object.getClass().getName());
                SQLData sQLData = (SQLData)object;
                final int n4 = n;
                final String string = sQLData.getSQLTypeName();
                SQLOutput sQLOutput = new SQLOutput(){

                    @Override
                    public void writeString(String string2) throws SQLException {
                        MonetPreparedStatement.this.setValue(n4, string + " " + MonetWrapper.sq(string2));
                    }

                    @Override
                    public void writeBoolean(boolean bl) throws SQLException {
                        MonetPreparedStatement.this.setBoolean(n4, bl);
                    }

                    @Override
                    public void writeByte(byte by) throws SQLException {
                        MonetPreparedStatement.this.setByte(n4, by);
                    }

                    @Override
                    public void writeShort(short s) throws SQLException {
                        MonetPreparedStatement.this.setShort(n4, s);
                    }

                    @Override
                    public void writeInt(int n) throws SQLException {
                        MonetPreparedStatement.this.setInt(n4, n);
                    }

                    @Override
                    public void writeLong(long l) throws SQLException {
                        MonetPreparedStatement.this.setLong(n4, l);
                    }

                    @Override
                    public void writeFloat(float f) throws SQLException {
                        MonetPreparedStatement.this.setFloat(n4, f);
                    }

                    @Override
                    public void writeDouble(double d) throws SQLException {
                        MonetPreparedStatement.this.setDouble(n4, d);
                    }

                    @Override
                    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
                        MonetPreparedStatement.this.setBigDecimal(n4, bigDecimal);
                    }

                    @Override
                    public void writeBytes(byte[] byArray) throws SQLException {
                        MonetPreparedStatement.this.setBytes(n4, byArray);
                    }

                    @Override
                    public void writeDate(Date date) throws SQLException {
                        MonetPreparedStatement.this.setDate(n4, date);
                    }

                    @Override
                    public void writeTime(Time time) throws SQLException {
                        MonetPreparedStatement.this.setTime(n4, time);
                    }

                    @Override
                    public void writeTimestamp(Timestamp timestamp) throws SQLException {
                        MonetPreparedStatement.this.setTimestamp(n4, timestamp);
                    }

                    @Override
                    public void writeCharacterStream(Reader reader) throws SQLException {
                        MonetPreparedStatement.this.setCharacterStream(n4, reader);
                    }

                    @Override
                    public void writeAsciiStream(InputStream inputStream) throws SQLException {
                        MonetPreparedStatement.this.setAsciiStream(n4, inputStream);
                    }

                    @Override
                    public void writeBinaryStream(InputStream inputStream) throws SQLException {
                        MonetPreparedStatement.this.setBinaryStream(n4, inputStream);
                    }

                    @Override
                    public void writeObject(SQLData sQLData) throws SQLException {
                        MonetPreparedStatement.this.setObject(n4, sQLData);
                    }

                    @Override
                    public void writeRef(Ref ref) throws SQLException {
                        MonetPreparedStatement.this.setRef(n4, ref);
                    }

                    @Override
                    public void writeBlob(Blob blob) throws SQLException {
                        MonetPreparedStatement.this.setBlob(n4, blob);
                    }

                    @Override
                    public void writeClob(Clob clob) throws SQLException {
                        MonetPreparedStatement.this.setClob(n4, clob);
                    }

                    @Override
                    public void writeStruct(Struct struct) throws SQLException {
                        MonetPreparedStatement.this.setObject(n4, struct);
                    }

                    @Override
                    public void writeArray(Array array) throws SQLException {
                        MonetPreparedStatement.this.setArray(n4, array);
                    }

                    @Override
                    public void writeURL(URL uRL) throws SQLException {
                        MonetPreparedStatement.this.setURL(n4, uRL);
                    }

                    @Override
                    public void writeNString(String string2) throws SQLException {
                        MonetPreparedStatement.this.setNString(n4, string2);
                    }

                    @Override
                    public void writeNClob(NClob nClob) throws SQLException {
                        MonetPreparedStatement.this.setNClob(n4, nClob);
                    }

                    @Override
                    public void writeRowId(RowId rowId) throws SQLException {
                        MonetPreparedStatement.this.setRowId(n4, rowId);
                    }

                    @Override
                    public void writeSQLXML(SQLXML sQLXML) throws SQLException {
                        MonetPreparedStatement.this.setSQLXML(n4, sQLXML);
                    }
                };
                sQLData.writeSQL(sQLOutput);
            }
        }
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setRef");
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setRowId");
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.setValue(n, Short.toString(s));
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        if (string == null) {
            this.setNull(n, -1);
            return;
        }
        int n2 = this.getParamIdx(n);
        int n3 = this.javaType[n2];
        String string2 = this.monetdbType[n2];
        switch (n3) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                String string3 = null;
                switch (string2) {
                    case "inet": {
                        try {
                            INET iNET = new INET();
                            iNET.fromString(string);
                        }
                        catch (SQLException sQLException) {
                            throw new SQLDataException("Conversion of string: " + string + " to parameter data type " + string2 + " failed. " + sQLException.getMessage(), "22M29");
                        }
                        string3 = "inet ";
                        break;
                    }
                    case "json": {
                        String string4 = null;
                        if (string.isEmpty()) {
                            string4 = "It may not be empty";
                        } else {
                            int n4 = 0;
                            int n5 = string.length() - 1;
                            char c = string.charAt(n4);
                            while ((c == ' ' || c == '\t' || c == '\n' || c == '\r') && n4 < n5) {
                                c = string.charAt(++n4);
                            }
                            char c2 = string.charAt(n5);
                            while ((c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r') && n4 < n5) {
                                c2 = string.charAt(--n5);
                            }
                            if (n5 - n4 <= 0) {
                                string4 = "It may not be empty";
                            } else {
                                switch (c) {
                                    case '{': {
                                        if (c2 == '}') break;
                                        string4 = "It does not end with }";
                                        break;
                                    }
                                    case '[': {
                                        if (c2 == ']') break;
                                        string4 = "It does not end with ]";
                                        break;
                                    }
                                    case '\"': {
                                        if (c2 == '\"') break;
                                        string4 = "It does not end with \"";
                                        break;
                                    }
                                    case 'n': {
                                        if (c2 == 'l' && n5 - n4 == 3 && "null".equals(string.trim())) break;
                                        string4 = "It does not match: null";
                                        break;
                                    }
                                    case 'f': {
                                        if (c2 == 'e' && n5 - n4 == 4 && "false".equals(string.trim())) break;
                                        string4 = "It does not match: false";
                                        break;
                                    }
                                    case 't': {
                                        if (c2 == 'e' && n5 - n4 == 3 && "true".equals(string.trim())) break;
                                        string4 = "It does not match: true";
                                        break;
                                    }
                                    case '+': 
                                    case '-': 
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        if (n4 < n5) {
                                            ++n4;
                                        }
                                        c = string.charAt(n4);
                                        while (c >= '0' && c <= '9' && n4 < n5) {
                                            c = string.charAt(++n4);
                                        }
                                        if (c == '.' && n4 < n5) {
                                            c = string.charAt(++n4);
                                            while (c >= '0' && c <= '9' && n4 < n5) {
                                                c = string.charAt(++n4);
                                            }
                                        }
                                        if ((c == 'E' || c == 'e') && n4 < n5) {
                                            if (((c = string.charAt(++n4)) == '+' || c == '-') && n4 < n5) {
                                                c = string.charAt(++n4);
                                            }
                                            while (c >= '0' && c <= '9' && n4 < n5) {
                                                c = string.charAt(++n4);
                                            }
                                        }
                                        if (n4 == n5) break;
                                        string4 = "It does not represent a valid number";
                                        break;
                                    }
                                    default: {
                                        string4 = "Invalid first character: " + c;
                                    }
                                }
                            }
                        }
                        if (string4 != null) {
                            throw new SQLDataException("Invalid json string. " + string4, "22M32");
                        }
                        string3 = "json ";
                        break;
                    }
                    case "url": {
                        try {
                            URL uRL = new URL(string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new SQLDataException("Conversion of string: " + string + " to parameter data type " + string2 + " failed. " + malformedURLException.getMessage(), "22M30");
                        }
                        string3 = "url ";
                        break;
                    }
                    case "uuid": {
                        try {
                            UUID uUID = UUID.fromString(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new SQLDataException("Conversion of string: " + string + " to parameter data type " + string2 + " failed. " + illegalArgumentException.getMessage(), "22M31");
                        }
                        string3 = "uuid ";
                    }
                }
                if (string3 != null) {
                    this.setValue(n, string3 + MonetWrapper.sq(string));
                    break;
                }
                this.setValue(n, MonetWrapper.sq(string));
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                try {
                    if (n3 == 4 || n3 == 5 || n3 == -6) {
                        int n6 = Integer.parseInt(string);
                    } else if (n3 == -5) {
                        long l = Long.parseLong(string);
                    } else if (n3 == 7 || n3 == 8 || n3 == 6) {
                        double d = Double.parseDouble(string);
                    } else if (n3 == 3 || n3 == 2) {
                        BigDecimal bigDecimal = new BigDecimal(string);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLDataException("Conversion of string: " + string + " to parameter data type " + string2 + " failed. " + numberFormatException.getMessage(), "22003");
                }
                this.setValue(n, string);
                break;
            }
            case 16: {
                if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("true") || string.equals("0") || string.equals("1")) {
                    this.setValue(n, string);
                    break;
                }
                throw new SQLDataException("Conversion of string: " + string + " to parameter data type " + string2 + " failed", "22000");
            }
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                try {
                    if (n3 == 91) {
                        Date date = Date.valueOf(string);
                    } else if (n3 == 92 || n3 == 2013) {
                        Time time = Time.valueOf(string);
                    } else if (n3 == 93 || n3 == 2014) {
                        Timestamp timestamp = Timestamp.valueOf(string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new SQLDataException("Conversion of string: " + string + " to parameter data type " + string2 + " failed. " + illegalArgumentException.getMessage(), "22007");
                }
                this.setValue(n, string2 + " '" + string + "'");
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                int n7 = string.length();
                for (int i = 0; i < n7; ++i) {
                    char c = string.charAt(i);
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
                    throw new SQLDataException("Invalid string for parameter data type " + string2 + ". The string may contain only hex chars", "22M28");
                }
                this.setValue(n, "blob '" + string + "'");
                break;
            }
            default: {
                throw new SQLException("Conversion of string to parameter data type " + string2 + " is not (yet) supported", "M1M05");
            }
        }
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setSQLXML");
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        boolean bl;
        if (time == null) {
            this.setNull(n, -1);
            return;
        }
        String string = this.monetdbType[this.getParamIdx(n)];
        boolean bl2 = bl = "timetz".equals(string) || "timestamptz".equals(string);
        if (bl) {
            if (this.mTimeZ == null) {
                this.mTimeZ = new SimpleDateFormat("HH:mm:ss.SSSZ");
            }
            String string2 = this.mTimeZ.format(time);
            this.setValue(n, "timetz '" + string2.substring(0, 15) + ":" + string2.substring(15) + "'");
        } else if (calendar == null) {
            this.setValue(n, "time '" + time.toString() + "'");
        } else {
            if (this.mTime == null) {
                this.mTime = new SimpleDateFormat("HH:mm:ss.SSS");
            }
            this.mTime.setTimeZone(calendar.getTimeZone());
            this.setValue(n, "time '" + this.mTime.format(time) + "'");
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        boolean bl;
        if (timestamp == null) {
            this.setNull(n, -1);
            return;
        }
        String string = this.monetdbType[this.getParamIdx(n)];
        boolean bl2 = bl = "timestamptz".equals(string) || "timetz".equals(string);
        if (bl) {
            if (this.mTimestampZ == null) {
                this.mTimestampZ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
            }
            String string2 = this.mTimestampZ.format(timestamp);
            this.setValue(n, "timestamptz '" + string2.substring(0, 26) + ":" + string2.substring(26) + "'");
        } else if (calendar == null) {
            this.setValue(n, "timestamp '" + timestamp.toString() + "'");
        } else {
            if (this.mTimestamp == null) {
                this.mTimestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            }
            this.mTimestamp.setTimeZone(calendar.getTimeZone());
            this.setValue(n, "timestamp '" + this.mTimestamp.format(timestamp) + "'");
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setUnicodeStream");
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        if (uRL == null) {
            this.setNull(n, -1);
            return;
        }
        this.setValue(n, "url " + MonetWrapper.sq(uRL.toString()));
    }

    @Override
    public void close() {
        try {
            if (!this.closed && this.id != -1) {
                this.connection.sendControlCommand("release " + this.id);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.close();
    }

    @Deprecated
    protected void finalize() {
        this.close();
    }

    @Override
    public void setObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setObject");
    }

    @Override
    public void setObject(int n, Object object, SQLType sQLType) throws SQLException {
        throw MonetPreparedStatement.newSQLFeatureNotSupportedException("setObject");
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        if (this.execute()) {
            throw new SQLException("Query produced a result set", "M1M17");
        }
        return this.getLargeUpdateCount();
    }

    private final void setValue(int n, String string) throws SQLException {
        this.values[this.getParamIdx((int)n)] = string == null ? "NULL" : string;
    }

    private final String transform() throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(8 + 12 * this.size);
        stringBuilder.append("exec ").append(this.id).append('(');
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.column[i] != null) continue;
            if (++n > 1) {
                stringBuilder.append(',');
            }
            if (this.values[i] == null) {
                throw new SQLException("Cannot execute, parameter " + n + " is missing.", "M1M05");
            }
            stringBuilder.append(this.values[i]);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static final SQLDataException newSQLInvalidParameterIndexException(int n) {
        return new SQLDataException("Invalid Parameter Index number: " + n, "22010");
    }

    private abstract class pmdw
    extends MonetWrapper
    implements ParameterMetaData {
        private pmdw() {
        }
    }

    private abstract class rsmdw
    extends MonetWrapper
    implements ResultSetMetaData {
        private rsmdw() {
        }
    }
}

