/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import nl.cwi.monetdb.jdbc.MonetBlob;
import nl.cwi.monetdb.jdbc.MonetClob;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.jdbc.MonetDriver;
import nl.cwi.monetdb.jdbc.MonetStatement;
import nl.cwi.monetdb.jdbc.MonetWrapper;
import nl.cwi.monetdb.mcl.parser.MCLParseException;
import nl.cwi.monetdb.mcl.parser.TupleLineParser;

public class MonetResultSet
extends MonetWrapper
implements ResultSet {
    private int lastColumnRead = -1;
    final TupleLineParser tlp;
    int curRow = 0;
    private final MonetConnection.ResultSetResponse header;
    private final String[] columns;
    private final String[] types;
    private final String tableID;
    final int tupleCount;
    private final Statement statement;
    private int type = 1003;
    private int concurrency = 1007;
    private SQLWarning warnings;
    private SimpleDateFormat ts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat t = new SimpleDateFormat("HH:mm:ss");
    private SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd");

    MonetResultSet(Statement statement, MonetConnection.ResultSetResponse header) throws SQLException {
        this.statement = statement;
        this.header = header;
        this.type = header.getRSType();
        this.concurrency = header.getRSConcur();
        this.columns = header.getNames();
        this.types = header.getTypes();
        this.tableID = "" + header.id;
        this.tupleCount = header.tuplecount;
        this.tlp = new TupleLineParser(this.columns.length);
    }

    MonetResultSet(String[] columns, String[] types, int results) throws IllegalArgumentException {
        if (columns == null || types == null) {
            throw new IllegalArgumentException("One of the given arguments is null!");
        }
        if (columns.length != types.length) {
            throw new IllegalArgumentException("Given arguments are not the same size!");
        }
        if (results < 0) {
            throw new IllegalArgumentException("Negative rowcount not allowed!");
        }
        this.header = null;
        this.tableID = null;
        this.statement = null;
        this.columns = columns;
        this.types = types;
        this.tupleCount = results;
        this.tlp = new TupleLineParser(columns.length);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (row != this.curRow + 1 && this.type == 1003) {
            throw new SQLException("(Absolute) positioning not allowed on forward  only result sets!", "M1M05");
        }
        if (this.header.isClosed()) {
            throw new SQLException("ResultSet is closed!", "M1M20");
        }
        if (row < 0) {
            row = this.tupleCount + row + 1;
        }
        if (row < 0) {
            row = 0;
        } else if (row > this.tupleCount + 1) {
            row = this.tupleCount + 1;
        }
        String tmpLine = this.header.getLine(row - 1);
        this.curRow = row;
        if (tmpLine == null) {
            return false;
        }
        try {
            this.tlp.parse(tmpLine);
        }
        catch (MCLParseException e) {
            throw new SQLException(e.getMessage(), "M0M10");
        }
        this.lastColumnRead = -1;
        return true;
    }

    @Override
    public void afterLast() throws SQLException {
        this.absolute(this.tupleCount + 1);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public void close() {
        if (!this.header.isClosed()) {
            this.header.close();
        }
        if (this.statement instanceof MonetStatement) {
            ((MonetStatement)this.statement).closeIfCompletion();
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].equalsIgnoreCase(columnName)) continue;
            return i + 1;
        }
        throw new SQLException("No such column name: " + columnName, "M1M05");
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method getArray not implemented yet, sorry!", "0A000");
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method getArray not implemented yet, sorry!", "0A000");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method getAsciiStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method getAsciiStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method getUnicodeStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method getUnicodeStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        switch (this.getJavaType(this.types[columnIndex - 1])) {
            case 2004: {
                Blob blob = this.getBlob(columnIndex);
                if (blob == null) {
                    return null;
                }
                return blob.getBinaryStream();
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] bte = this.getBytes(columnIndex);
                if (bte == null) {
                    return null;
                }
                return new ByteArrayInputStream(bte);
            }
        }
        throw new SQLException("Cannot operate on " + this.types[columnIndex - 1] + " type", "M1M05");
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String tmp = this.getString(columnIndex);
        if (tmp == null) {
            return null;
        }
        return new StringReader(tmp);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNCharacterStream() not supported", "0A000");
    }

    @Override
    public Reader getNCharacterStream(String columnName) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnName));
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        String tmp = this.getString(i);
        if (tmp == null) {
            return null;
        }
        return MonetBlob.create(tmp);
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        String tmp = this.getString(i);
        if (tmp == null) {
            return null;
        }
        return new MonetClob(tmp);
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNClob() not supported", "0A000");
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    @Override
    public NClob getNClob(String colName) throws SQLException {
        return this.getNClob(this.findColumn(colName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String decimal = this.getString(columnIndex);
        if (decimal == null) {
            return null;
        }
        try {
            return new BigDecimal(decimal);
        }
        catch (NumberFormatException e) {
            return BigDecimal.ZERO;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal bd;
        String decimal = this.getString(columnIndex);
        if (decimal == null) {
            return null;
        }
        try {
            bd = new BigDecimal(decimal);
        }
        catch (NumberFormatException e) {
            bd = BigDecimal.ZERO;
        }
        return bd.setScale(scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        int dataType = this.getJavaType(this.types[columnIndex - 1]);
        if (dataType == -6 || dataType == 5 || dataType == 4 || dataType == -5) {
            return this.getLong(columnIndex) != 0L;
        }
        if (dataType == 7 || dataType == 6 || dataType == 8) {
            return this.getDouble(columnIndex) != 0.0;
        }
        if (dataType == 3 || dataType == 2) {
            return this.getBigDecimal(columnIndex).compareTo(new BigDecimal(0.0)) != 0;
        }
        if (dataType == -7 || dataType == 16 || dataType == 1 || dataType == 12 || dataType == -1) {
            return Boolean.valueOf(this.getString(columnIndex));
        }
        throw new SQLException("Conversion from " + this.types[columnIndex - 1] + " to boolean type not supported", "M1M05");
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        String bytes = this.getString(columnIndex);
        if (bytes == null || bytes.length() == 0) {
            return 0;
        }
        return bytes.getBytes()[0];
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        switch (this.getJavaType(this.types[columnIndex - 1])) {
            case -4: 
            case -3: 
            case -2: {
                break;
            }
            default: {
                throw new SQLException("Cannot operate on " + this.types[columnIndex - 1] + " type", "M1M05");
            }
        }
        String tmp = this.getString(columnIndex);
        if (tmp == null) {
            return null;
        }
        int len = tmp.length() / 2;
        byte[] buf = new byte[len];
        for (int j = 0; j < len; ++j) {
            buf[j] = (byte)Integer.parseInt(tmp.substring(2 * j, 2 * j + 2), 16);
        }
        return buf;
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public int getConcurrency() {
        return this.concurrency;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("Positioned updates not supported for this cursor (" + this.tableID + ")", "0AM21");
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        double ret = 0.0;
        String dbl = this.getString(columnIndex);
        if (dbl != null) {
            try {
                ret = Double.parseDouble(dbl);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getStatement().getConnection().getHoldability();
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.header.getCacheSize();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        float ret = 0.0f;
        String flt = this.getString(columnIndex);
        if (flt != null) {
            try {
                ret = Float.parseFloat(flt);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        int ret = 0;
        try {
            ret = Integer.parseInt(this.getString(columnIndex));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        long ret = 0L;
        try {
            ret = Long.parseLong(this.getString(columnIndex));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return new rsmdw(){
            private DatabaseMetaData dbmd = null;
            private ResultSet[] colrs = new ResultSet[MonetResultSet.access$100(MonetResultSet.this).length];

            @Override
            public int getColumnCount() {
                return MonetResultSet.this.columns.length;
            }

            @Override
            public boolean isAutoIncrement(int column) throws SQLException {
                return "oid".equals(this.getColumnTypeName(column));
            }

            @Override
            public boolean isCaseSensitive(int column) {
                return false;
            }

            @Override
            public boolean isSearchable(int column) {
                return true;
            }

            @Override
            public boolean isCurrency(int column) {
                return false;
            }

            @Override
            public boolean isSigned(int column) throws SQLException {
                switch (this.getColumnType(column)) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public int getColumnDisplaySize(int column) throws SQLException {
                int ret;
                try {
                    ret = MonetResultSet.this.header.getColumnLengths()[column - 1];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException("No such column " + column, "M1M05");
                }
                return ret;
            }

            @Override
            public String getSchemaName(int column) throws SQLException {
                String schema = "";
                try {
                    schema = MonetResultSet.this.header.getTableNames()[column - 1];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException("No such column " + column, "M1M05");
                }
                if (schema == null) {
                    throw new AssertionError((Object)"table_name header is empty!");
                }
                int dot = schema.indexOf(".");
                if (dot == -1) {
                    throw new AssertionError((Object)("table_name is not fully qualified! (" + schema + ")"));
                }
                return schema.substring(0, dot);
            }

            @Override
            public String getTableName(int column) throws SQLException {
                String table = "";
                try {
                    table = MonetResultSet.this.header.getTableNames()[column - 1];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException("No such column " + column, "M1M05");
                }
                if (table == null) {
                    throw new AssertionError((Object)"table_name header is empty!");
                }
                int dot = table.indexOf(".");
                if (dot == -1) {
                    throw new AssertionError((Object)("table_name is not fully qualified! (" + table + ")"));
                }
                return table.substring(dot + 1);
            }

            @Override
            public int getPrecision(int column) throws SQLException {
                int precision = 0;
                ResultSet col = this.getColumnResultSet(column);
                if (col.next()) {
                    precision = col.getInt("COLUMN_SIZE");
                }
                return precision;
            }

            @Override
            public int getScale(int column) throws SQLException {
                int scale = 0;
                ResultSet col = this.getColumnResultSet(column);
                if (col.next()) {
                    scale = col.getInt("DECIMAL_DIGITS");
                }
                return scale;
            }

            @Override
            public int isNullable(int column) throws SQLException {
                int ret = 2;
                ResultSet col = this.getColumnResultSet(column);
                if (col.next()) {
                    ret = col.getInt("NULLABLE");
                }
                return ret;
            }

            @Override
            public String getCatalogName(int column) throws SQLException {
                if (this.getTableName(column) != "") {
                    return MonetResultSet.this.getStatement().getConnection().getCatalog();
                }
                return "";
            }

            @Override
            public boolean isReadOnly(int column) {
                return true;
            }

            @Override
            public boolean isWritable(int column) {
                return false;
            }

            @Override
            public boolean isDefinitelyWritable(int column) {
                return false;
            }

            @Override
            public String getColumnClassName(int column) throws SQLException {
                try {
                    return MonetResultSet.getClassForType(MonetResultSet.this.getJavaType(MonetResultSet.this.types[column - 1])).getName();
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException("No such column " + column, "M1M05");
                }
            }

            @Override
            public String getColumnLabel(int column) throws SQLException {
                return this.getColumnName(column);
            }

            @Override
            public String getColumnName(int column) throws SQLException {
                try {
                    return MonetResultSet.this.columns[column - 1];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException("No such column " + column, "M1M05");
                }
            }

            @Override
            public int getColumnType(int column) throws SQLException {
                String type = this.getColumnTypeName(column);
                return MonetResultSet.this.getJavaType(type);
            }

            @Override
            public String getColumnTypeName(int column) throws SQLException {
                try {
                    return MonetResultSet.this.types[column - 1];
                }
                catch (IndexOutOfBoundsException e) {
                    throw new SQLException("No such column " + column, "M1M05");
                }
            }

            private ResultSet getColumnResultSet(int column) throws SQLException {
                if (column > MonetResultSet.this.columns.length || column <= 0) {
                    throw new SQLException("No such column " + column, "M1M05");
                }
                if (this.colrs[column - 1] == null) {
                    ResultSet col;
                    if (this.dbmd == null) {
                        this.dbmd = MonetResultSet.this.getStatement().getConnection().getMetaData();
                    }
                    this.colrs[column - 1] = col = this.dbmd.getColumns(null, this.getSchemaName(column), this.getTableName(column), this.getColumnName(column));
                }
                this.colrs[column - 1].beforeFirst();
                return this.colrs[column - 1];
            }
        };
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, this.getStatement().getConnection().getTypeMap());
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        if (this.tlp.values[i - 1] == null) {
            this.lastColumnRead = i - 1;
            return null;
        }
        Class<?> type = map.containsKey(this.types[i - 1]) ? map.get(this.types[i - 1]) : MonetResultSet.getClassForType(this.getJavaType(this.types[i - 1]));
        if (type == String.class) {
            return this.getString(i);
        }
        if (type == BigDecimal.class) {
            return this.getBigDecimal(i);
        }
        if (type == Boolean.class) {
            return this.getBoolean(i);
        }
        if (type == Integer.class) {
            return this.getInt(i);
        }
        if (type == Long.class) {
            return this.getLong(i);
        }
        if (type == Float.class) {
            return Float.valueOf(this.getFloat(i));
        }
        if (type == Double.class) {
            return this.getDouble(i);
        }
        if (type == byte[].class) {
            return this.getBytes(i);
        }
        if (type == Date.class) {
            return this.getDate(i);
        }
        if (type == Time.class) {
            return this.getTime(i);
        }
        if (type == Timestamp.class) {
            return this.getTimestamp(i);
        }
        if (type == Clob.class) {
            return this.getClob(i);
        }
        if (type == Blob.class) {
            return this.getBlob(i);
        }
        return this.getString(i);
    }

    @Override
    public <T> T getObject(int i, Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLException("type is null", "M1M05");
        }
        throw new SQLFeatureNotSupportedException("cannot return a Java generic type based on static types from getXXX methods", "0AM34");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    static Class<?> getClassForType(int type) {
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case -7: 
            case 16: {
                return Boolean.class;
            }
            case -6: 
            case 4: 
            case 5: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 7: {
                return Float.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case -4: 
            case -3: 
            case -2: {
                return byte[].class;
            }
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 2005: {
                return Clob.class;
            }
            case 2004: {
                return Blob.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(columnName, this.getStatement().getConnection().getTypeMap());
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(colName), map);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new SQLException("Method getRef not implemented yet, sorry!", "0A000");
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw new SQLException("Method getRef not implemented yet, sorry!", "0A000");
    }

    @Override
    public int getRow() {
        return this.curRow;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRowId() not supported", "0A000");
    }

    @Override
    public RowId getRowId(String columnName) throws SQLException {
        return this.getRowId(this.findColumn(columnName));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        short ret = 0;
        try {
            ret = Short.parseShort(this.getString(columnIndex));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try {
            String ret = this.tlp.values[columnIndex - 1];
            this.lastColumnRead = columnIndex - 1;
            return ret;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("No such column " + columnIndex, "M1M05");
        }
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNString not supported", "0A000");
    }

    @Override
    public String getNString(String columnName) throws SQLException {
        return this.getNString(this.findColumn(columnName));
    }

    @Override
    public SQLXML getSQLXML(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException("getSQLXML() not supported", "0A000");
    }

    @Override
    public SQLXML getSQLXML(String colName) throws SQLException {
        return this.getSQLXML(this.findColumn(colName));
    }

    private int getJavaDate(Calendar cal, int col, int type) throws SQLException {
        char[] monDate;
        int pos;
        boolean hasTimeZone;
        if (cal == null) {
            throw new IllegalArgumentException("No Calendar object given!");
        }
        if (col <= 0) {
            throw new IllegalArgumentException("No valid column number given!");
        }
        String monetDate = this.getString(col);
        if (monetDate == null) {
            return -1;
        }
        int nanos = 0;
        TimeZone ptz = cal.getTimeZone();
        int dataType = this.getJavaType(this.types[col - 1]);
        if (dataType == 1 || dataType == 12 || dataType == -1) {
            dataType = type;
        }
        if (hasTimeZone = this.types[col - 1].endsWith("tz")) {
            ptz = TimeZone.getTimeZone("GMT" + monetDate.substring(monetDate.length() - 6, monetDate.length()));
        }
        this.ts.setTimeZone(ptz);
        this.t.setTimeZone(ptz);
        this.d.setTimeZone(ptz);
        java.util.Date pdate = null;
        ParsePosition ppos = new ParsePosition(0);
        switch (dataType) {
            default: {
                this.addWarning("unsupported data type", "01M03");
                cal.clear();
                nanos = 0;
                return nanos;
            }
            case 91: {
                pdate = this.d.parse(monetDate, ppos);
                break;
            }
            case 92: {
                pdate = this.t.parse(monetDate, ppos);
                break;
            }
            case 93: {
                pdate = this.ts.parse(monetDate, ppos);
            }
        }
        if (pdate == null) {
            int epos = ppos.getErrorIndex();
            if (epos == -1) {
                this.addWarning("parsing '" + monetDate + "' failed", "01M10");
            } else if (epos < monetDate.length()) {
                this.addWarning("parsing failed, found: '" + monetDate.charAt(epos) + "'" + " in: \"" + monetDate + "\"" + " at pos: " + ppos.getErrorIndex(), "01M10");
            } else {
                this.addWarning("parsing failed, expected more data after '" + monetDate + "'", "01M10");
            }
            cal.clear();
            nanos = 0;
            return nanos;
        }
        cal.setTime(pdate);
        if ((dataType == 92 || dataType == 93) && (pos = ppos.getIndex()) < (monDate = monetDate.toCharArray()).length && monDate[pos] == '.') {
            ++pos;
            try {
                nanos = MonetResultSet.getIntrinsicValue(monDate[pos], pos++);
                int ctr = 1;
                while (pos < monDate.length && monDate[pos] >= '0' && monDate[pos] <= '9') {
                    if (ctr < 9) {
                        nanos *= 10;
                        nanos += MonetResultSet.getIntrinsicValue(monDate[pos], pos);
                    }
                    if (ctr == 2) {
                        cal.set(14, nanos);
                    }
                    ++pos;
                    ++ctr;
                }
                while (ctr++ < 9) {
                    nanos *= 10;
                }
            }
            catch (MCLParseException e) {
                this.addWarning(e.getMessage() + " found: '" + monDate[e.getErrorOffset()] + "'" + " in: \"" + monetDate + "\"" + " at pos: " + e.getErrorOffset(), "01M10");
                cal.clear();
                nanos = 0;
            }
        }
        return nanos;
    }

    private static final int getIntrinsicValue(char c, int pos) throws MCLParseException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new MCLParseException("Expected a digit", pos);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, Calendar.getInstance());
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        int ret = this.getJavaDate(cal, columnIndex, 91);
        return ret == -1 ? null : new Date(cal.getTimeInMillis());
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(columnName, Calendar.getInstance());
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, Calendar.getInstance());
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        int ret = this.getJavaDate(cal, columnIndex, 92);
        return ret == -1 ? null : new Time(cal.getTimeInMillis());
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(columnName, Calendar.getInstance());
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, Calendar.getInstance());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        int nanos = this.getJavaDate(cal, columnIndex, 93);
        if (nanos == -1) {
            return null;
        }
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        ts.setNanos(nanos);
        return ts;
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(columnName, Calendar.getInstance());
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        String url = this.getString(columnIndex);
        if (url == null) {
            return null;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new SQLException(e.getMessage(), "M1M05");
        }
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.header.isClosed()) {
            throw new SQLException("Cannot call on closed ResultSet", "M1M20");
        }
        return this.warnings;
    }

    @Override
    public boolean isAfterLast() {
        return this.curRow == this.tupleCount + 1;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.curRow == 0;
    }

    @Override
    public boolean isClosed() {
        return this.header.isClosed();
    }

    @Override
    public boolean isFirst() {
        return this.curRow == 1;
    }

    @Override
    public boolean isLast() {
        return this.curRow == this.tupleCount;
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    @Override
    public boolean next() throws SQLException {
        return this.relative(1);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.relative(-1);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this.absolute(this.curRow + rows);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method cancelRowUpdates not implemented yet, sorry!", "0A000");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method deleteRow not implemented yet, sorry!", "0A000");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method insertRow not implemented yet, sorry!", "0A000");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method moveToCurrentRow not implemented yet, sorry!", "0A000");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method moveToInsertRow not implemented yet, sorry!", "0A000");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method refreshRow not implemented yet, sorry!", "0A000");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method rowDeleted not implemented yet, sorry!", "0A000");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method rowInserted not implemented yet, sorry!", "0A000");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method rowUpdated not implemented yet, sorry!", "0A000");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method setFetchDirection not implemented yet, sorry!", "0A000");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method setFetchSize not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateArray not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateArray not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream xh) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateAsciiStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateAsciiStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateAsciiStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateAsciiStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateAsciiStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateAsciiStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBigDecimal not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBigDecimal not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBinaryStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBinaryStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBinaryStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBinaryStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBinaryStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBinaryStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBlob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream s) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBlob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream s, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBlob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBlob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBlob(String columnName, InputStream s) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBlob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBlob(String columnName, InputStream s, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBlob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBoolean not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBoolean not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateByte not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateByte not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBytes not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateBytes not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateCharacterStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateCharacterStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateCharacterStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateCharacterStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateCharacterStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateCharacterStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateNCharacterStream not implemented yet, sorry!", "0A000");
    }

    public void updateNCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateNCharacterStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateNCharacterStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateNCharacterStream not implemented yet, sorry!", "0A000");
    }

    public void updateNCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateNCharacterStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateNCharacterStream not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateClob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateClob(int columnIndex, Reader r) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateClob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateClob(int columnIndex, Reader r, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateClob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateClob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateClob(String columnName, Reader r) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateClob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateClob(String columnName, Reader r, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateClob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateNClob(int columnIndex, NClob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateNClob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateNClob(int columnIndex, Reader r) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateNClob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateNClob(int columnIndex, Reader r, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateNClob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateNClob(String columnName, NClob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateNClob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateNClob(String columnName, Reader r) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateNClob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateNClob(String columnName, Reader r, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateNClob not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateDate not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateDate not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateDouble not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateDouble not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateFloat not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateFloat not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateInt not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateInt not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateLong not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateLong not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateNull not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateNull not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateObject not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateObject not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateObject not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateObject not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateRef not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateRef not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateRow not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateRowId not implemented yet, sorry", "0A000");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateRowId not implemented yet, sorry", "0A000");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateShort not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateShort not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateString not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateString not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateNString(int columnIndex, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateNString not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateNString(String columnName, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateNString not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateSQLXML not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateSQLXML not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateTime not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateTime not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateTimestamp not implemented yet, sorry!", "0A000");
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method updateTimestamp not implemented yet, sorry!", "0A000");
    }

    @Override
    public boolean wasNull() {
        return this.lastColumnRead != -1 ? this.tlp.values[this.lastColumnRead] == null : false;
    }

    private void addWarning(String reason, String sqlstate) {
        if (this.warnings == null) {
            this.warnings = new SQLWarning(reason, sqlstate);
        } else {
            this.warnings.setNextWarning(new SQLWarning(reason, sqlstate));
        }
    }

    private int getJavaType(String sqltype) throws SQLException {
        int type = MonetDriver.getJavaType(sqltype);
        if (this.statement != null && ((MonetConnection)this.statement.getConnection()).getBlobAsBinary() && type == 2004) {
            type = -2;
        }
        return type;
    }

    private abstract class rsmdw
    extends MonetWrapper
    implements ResultSetMetaData {
        private rsmdw() {
        }
    }
}

