/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import nl.cwi.monetdb.mcl.MCLException;
import nl.cwi.monetdb.mcl.io.BufferedMCLReader;
import nl.cwi.monetdb.mcl.io.BufferedMCLWriter;
import nl.cwi.monetdb.mcl.parser.MCLParseException;

public final class MapiSocket {
    private Socket con = null;
    private int soTimeout = 0;
    private InputStream fromMonet;
    private OutputStream toMonet;
    private BufferedMCLReader reader;
    private BufferedMCLWriter writer;
    private int version;
    private String database = null;
    private String language = "sql";
    private String hash = null;
    private boolean followRedirects = true;
    private int ttl = 10;
    private boolean debug = false;
    private Writer log;
    public static final int BLOCK = 8190;
    private byte[] blklen = new byte[2];

    public void setDatabase(String db) {
        this.database = db;
    }

    public void setLanguage(String lang) {
        this.language = lang;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setFollowRedirects(boolean r) {
        this.followRedirects = r;
    }

    public void setTTL(int t) {
        this.ttl = t;
    }

    public void setSoTimeout(int s) throws SocketException {
        if (s < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.soTimeout = s;
        if (this.con != null) {
            this.con.setSoTimeout(s);
        }
    }

    public int getSoTimeout() throws SocketException {
        if (this.con != null) {
            this.soTimeout = this.con.getSoTimeout();
        }
        return this.soTimeout;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public List<String> connect(String host, int port, String user, String pass) throws IOException, MCLParseException, MCLException {
        return this.connect(host, port, user, pass, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> connect(String host, int port, String user, String pass, boolean makeConnection) throws IOException, MCLParseException, MCLException {
        String tmp;
        int lineType;
        if (this.ttl-- <= 0) {
            throw new MCLException("Maximum number of redirects reached, aborting connection attempt. Sorry.");
        }
        if (makeConnection) {
            this.con = new Socket(host, port);
            this.con.setSoTimeout(this.soTimeout);
            this.con.setTcpNoDelay(true);
            this.fromMonet = new BlockInputStream(this.con.getInputStream());
            this.toMonet = new BlockOutputStream(this.con.getOutputStream());
            try {
                this.reader = new BufferedMCLReader(this.fromMonet, "UTF-8");
                this.writer = new BufferedMCLWriter(this.toMonet, "UTF-8");
                this.writer.registerReader(this.reader);
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e.toString());
            }
        }
        String c = this.reader.readLine();
        this.reader.waitForPrompt();
        this.writer.writeLine(this.getChallengeResponse(c, user, pass, this.language, this.database, this.hash));
        ArrayList<String> redirects = new ArrayList<String>();
        ArrayList<String> warns = new ArrayList<String>();
        String err = "";
        do {
            if ((tmp = this.reader.readLine()) == null) {
                throw new IOException("Read from " + this.con.getInetAddress().getHostName() + ":" + this.con.getPort() + ": End of stream reached");
            }
            lineType = this.reader.getLineType();
            if (lineType == 33) {
                err = err + "\n" + tmp.substring(7);
                continue;
            }
            if (lineType == 35) {
                warns.add(tmp.substring(1));
                continue;
            }
            if (lineType != 94) continue;
            redirects.add(tmp.substring(1));
        } while (lineType != 46);
        if (err.length() > 0) {
            this.close();
            throw new MCLException(err.trim());
        }
        if (redirects.isEmpty()) return warns;
        if (this.followRedirects) {
            URI u;
            String suri = ((String)redirects.get(0)).toString();
            if (!suri.startsWith("mapi:")) {
                throw new MCLException("unsupported redirect: " + suri);
            }
            try {
                u = new URI(suri.substring(5));
            }
            catch (URISyntaxException e) {
                throw new MCLParseException(e.toString());
            }
            tmp = u.getQuery();
            if (tmp != null) {
                String[] args = tmp.split("&");
                for (int i = 0; i < args.length; ++i) {
                    int pos = args[i].indexOf("=");
                    if (pos > 0) {
                        tmp = args[i].substring(0, pos);
                        if (tmp.equals("database")) {
                            tmp = args[i].substring(pos + 1);
                            if (tmp.equals(this.database)) continue;
                            warns.add("redirect points to different database: " + tmp);
                            this.setDatabase(tmp);
                            continue;
                        }
                        if (tmp.equals("language")) {
                            tmp = args[i].substring(pos + 1);
                            warns.add("redirect specifies use of different language: " + tmp);
                            this.setLanguage(tmp);
                            continue;
                        }
                        if (tmp.equals("user")) {
                            tmp = args[i].substring(pos + 1);
                            if (tmp.equals(user)) continue;
                            warns.add("ignoring different username '" + tmp + "' set by redirect, what are the security implications?");
                            continue;
                        }
                        if (tmp.equals("password")) {
                            warns.add("ignoring different password set by redirect, what are the security implications?");
                            continue;
                        }
                        warns.add("ignoring unknown argument '" + tmp + "' from redirect");
                        continue;
                    }
                    warns.add("ignoring illegal argument from redirect: " + args[i]);
                }
            }
            if (u.getScheme().equals("monetdb")) {
                if (this.debug) {
                    this.debug = false;
                    this.close();
                    this.debug = true;
                } else {
                    this.close();
                }
                tmp = u.getPath();
                if (tmp != null && tmp.length() != 0 && !(tmp = tmp.substring(1).trim()).isEmpty() && !tmp.equals(this.database)) {
                    warns.add("redirect points to different database: " + tmp);
                    this.setDatabase(tmp);
                }
                int p = u.getPort();
                warns.addAll(this.connect(u.getHost(), p == -1 ? port : p, user, pass, true));
                warns.add("Redirect by " + host + ":" + port + " to " + suri);
                return warns;
            } else {
                if (!u.getScheme().equals("merovingian")) throw new MCLException("unsupported scheme in redirect: " + suri);
                warns.addAll(this.connect(host, port, user, pass, false));
            }
            return warns;
        }
        StringBuilder msg = new StringBuilder("The server sent a redirect for this connection:");
        for (String it : redirects) {
            msg.append(" [" + it + "]");
        }
        throw new MCLException(msg.toString());
    }

    private String getChallengeResponse(String chalstr, String username, String password, String language, String database, String hash) throws MCLParseException, MCLException, IOException {
        String pwhash;
        String algo;
        String[] chaltok = chalstr.split(":");
        if (chaltok.length <= 4) {
            throw new MCLParseException("Server challenge string unusable!  Challenge contains too few tokens: " + chalstr);
        }
        String challenge = chaltok[0];
        String servert = chaltok[1];
        try {
            this.version = Integer.parseInt(chaltok[2].trim());
        }
        catch (NumberFormatException e) {
            throw new MCLParseException("Protocol version unparseable: " + chaltok[3]);
        }
        switch (this.version) {
            default: {
                throw new MCLException("Unsupported protocol version: " + this.version);
            }
            case 9: 
        }
        if (chaltok[5].equals("SHA512")) {
            algo = "SHA-512";
        } else if (chaltok[5].equals("SHA384")) {
            algo = "SHA-384";
        } else if (chaltok[5].equals("SHA256")) {
            algo = "SHA-256";
        } else if (chaltok[5].equals("SHA1")) {
            algo = "SHA-1";
        } else if (chaltok[5].equals("MD5")) {
            algo = "MD5";
        } else {
            throw new MCLException("Unsupported password hash: " + chaltok[5]);
        }
        try {
            MessageDigest md = MessageDigest.getInstance(algo);
            md.update(password.getBytes("UTF-8"));
            byte[] digest = md.digest();
            password = MapiSocket.toHex(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)("internal error: " + e.toString()));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)("internal error: " + e.toString()));
        }
        String hashes = hash == null ? chaltok[3] : hash;
        HashSet<String> hashesSet = new HashSet<String>(Arrays.asList(hashes.toUpperCase().split("[, ]")));
        if (servert.equals("merovingian") && !language.equals("control")) {
            username = "merovingian";
            password = "merovingian";
        }
        algo = null;
        if (hashesSet.contains("SHA512")) {
            algo = "SHA-512";
            pwhash = "{SHA512}";
        } else if (hashesSet.contains("SHA384")) {
            algo = "SHA-384";
            pwhash = "{SHA384}";
        } else if (hashesSet.contains("SHA256")) {
            algo = "SHA-256";
            pwhash = "{SHA256}";
        } else if (hashesSet.contains("SHA1")) {
            algo = "SHA-1";
            pwhash = "{SHA1}";
        } else if (hashesSet.contains("MD5")) {
            algo = "MD5";
            pwhash = "{MD5}";
        } else {
            throw new MCLException("no supported password hashes in " + hashes);
        }
        if (algo != null) {
            try {
                MessageDigest md = MessageDigest.getInstance(algo);
                md.update(password.getBytes("UTF-8"));
                md.update(challenge.getBytes("UTF-8"));
                byte[] digest = md.digest();
                pwhash = pwhash + MapiSocket.toHex(digest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)("internal error: " + e.toString()));
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)("internal error: " + e.toString()));
            }
        }
        if (!chaltok[4].equals("BIG") && !chaltok[4].equals("LIT")) {
            throw new MCLParseException("Invalid byte-order: " + chaltok[5]);
        }
        String response = "BIG:";
        response = response + username + ":" + pwhash + ":" + language;
        response = response + ":" + (database == null ? "" : database) + ":";
        return response;
    }

    private static char hexChar(int n) {
        return n > 9 ? (char)(97 + (n - 10)) : (char)(48 + n);
    }

    private static String toHex(byte[] digest) {
        char[] result = new char[digest.length * 2];
        int pos = 0;
        for (int i = 0; i < digest.length; ++i) {
            result[pos++] = MapiSocket.hexChar((digest[i] & 0xF0) >> 4);
            result[pos++] = MapiSocket.hexChar(digest[i] & 0xF);
        }
        return new String(result);
    }

    public InputStream getInputStream() {
        return this.fromMonet;
    }

    public OutputStream getOutputStream() {
        return this.toMonet;
    }

    public BufferedMCLReader getReader() {
        return this.reader;
    }

    public BufferedMCLWriter getWriter() {
        return this.writer;
    }

    public int getProtocolVersion() {
        return this.version;
    }

    public void debug(String filename) throws IOException {
        this.debug(new FileWriter(filename));
    }

    public void debug(PrintStream out) throws IOException {
        this.debug(new PrintWriter(out));
    }

    public void debug(Writer out) throws IOException {
        this.log = out;
        this.debug = true;
    }

    public synchronized void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.reader != null) {
            try {
                this.reader.close();
                this.reader = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.toMonet != null) {
            try {
                this.toMonet.close();
                this.toMonet = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.fromMonet != null) {
            try {
                this.fromMonet.close();
                this.fromMonet = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.con != null) {
            try {
                this.con.close();
                this.con = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.debug && this.log != null && this.log instanceof FileWriter) {
            try {
                this.log.close();
                this.log = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private void logTx(String message) throws IOException {
        this.log.write("TX " + System.currentTimeMillis() + ": " + message + "\n");
    }

    private void logTd(String message) throws IOException {
        this.log.write("TD " + System.currentTimeMillis() + ": " + message + "\n");
    }

    private void logRx(String message) throws IOException {
        this.log.write("RX " + System.currentTimeMillis() + ": " + message + "\n");
        this.log.flush();
    }

    private void logRd(String message) throws IOException {
        this.log.write("RD " + System.currentTimeMillis() + ": " + message + "\n");
        this.log.flush();
    }

    class BlockInputStream
    extends FilterInputStream {
        private int readPos;
        private int blockLen;
        private byte[] block;

        public BlockInputStream(InputStream in) {
            super(new BufferedInputStream(in));
            this.readPos = 0;
            this.blockLen = 0;
            this.block = new byte[8193];
        }

        @Override
        public int available() {
            return this.blockLen - this.readPos;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void mark(int readlimit) {
            throw new AssertionError((Object)"Not implemented!");
        }

        @Override
        public void reset() {
            throw new AssertionError((Object)"Not implemented!");
        }

        private boolean _read(byte[] b, int len) throws IOException {
            int off = 0;
            while (len > 0) {
                int s = this.in.read(b, off, len);
                if (s == -1) {
                    if (off > 0) {
                        if (MapiSocket.this.debug) {
                            MapiSocket.this.logRd("the following incomplete block was received:");
                            MapiSocket.this.logRx(new String(b, 0, off, "UTF-8"));
                        }
                        throw new IOException("Read from " + MapiSocket.this.con.getInetAddress().getHostName() + ":" + MapiSocket.this.con.getPort() + ": Incomplete block read from stream");
                    }
                    if (MapiSocket.this.debug) {
                        MapiSocket.this.logRd("server closed the connection (EOF)");
                    }
                    return false;
                }
                len -= s;
                off += s;
            }
            return true;
        }

        private int readBlock() throws IOException {
            if (!this._read(MapiSocket.this.blklen, 2)) {
                return -1;
            }
            this.blockLen = (short)((MapiSocket.this.blklen[0] & 0xFF) >> 1 | (MapiSocket.this.blklen[1] & 0xFF) << 7);
            this.readPos = 0;
            if (MapiSocket.this.debug) {
                if ((MapiSocket.this.blklen[0] & 1) == 1) {
                    MapiSocket.this.logRd("read final block: " + this.blockLen + " bytes");
                } else {
                    MapiSocket.this.logRd("read new block: " + this.blockLen + " bytes");
                }
            }
            if (this.blockLen > this.block.length) {
                throw new AssertionError((Object)("Server sent a block larger than BLOCKsize: " + this.blockLen + " > " + this.block.length));
            }
            if (!this._read(this.block, this.blockLen)) {
                return -1;
            }
            if (MapiSocket.this.debug) {
                MapiSocket.this.logRx(new String(this.block, 0, this.blockLen, "UTF-8"));
            }
            if ((MapiSocket.this.blklen[0] & 1) == 1) {
                if (this.blockLen > 0 && this.block[this.blockLen - 1] != 10) {
                    this.block[this.blockLen++] = 10;
                }
                this.block[this.blockLen++] = 46;
                this.block[this.blockLen++] = 10;
                if (MapiSocket.this.debug) {
                    MapiSocket.this.logRd("inserting prompt");
                }
            }
            return this.blockLen;
        }

        @Override
        public int read() throws IOException {
            if (this.available() == 0 && this.readBlock() == -1) {
                return -1;
            }
            if (MapiSocket.this.debug) {
                MapiSocket.this.logRx(new String(this.block, this.readPos, 1, "UTF-8"));
            }
            return this.block[this.readPos++];
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int size;
            int t;
            for (size = 0; size < len; size += t) {
                t = this.available();
                if (t == 0) {
                    if (size != 0) break;
                    if (this.readBlock() == -1) {
                        if (size != 0) break;
                        size = -1;
                        break;
                    }
                    t = this.available();
                }
                if (len > t) {
                    System.arraycopy(this.block, this.readPos, b, off, t);
                    off += t;
                    len -= t;
                    this.readPos += t;
                    continue;
                }
                System.arraycopy(this.block, this.readPos, b, off, len);
                this.readPos += len;
                size += len;
                break;
            }
            return size;
        }

        @Override
        public long skip(long n) throws IOException {
            long skip = n;
            int t = 0;
            while (skip > 0L) {
                t = this.available();
                if (skip > (long)t) {
                    skip -= (long)t;
                    this.readPos += t;
                    this.readBlock();
                    continue;
                }
                this.readPos = (int)((long)this.readPos + skip);
                break;
            }
            return n;
        }
    }

    class BlockOutputStream
    extends FilterOutputStream {
        private int writePos;
        private byte[] block;
        private int blocksize;

        public BlockOutputStream(OutputStream out) {
            super(new BufferedOutputStream(out));
            this.writePos = 0;
            this.block = new byte[8190];
            this.blocksize = 0;
        }

        @Override
        public void flush() throws IOException {
            this.writeBlock(true);
            this.out.flush();
            if (MapiSocket.this.debug) {
                MapiSocket.this.log.flush();
            }
        }

        public void writeBlock(boolean last) throws IOException {
            if (last) {
                this.blocksize = (short)this.writePos;
                ((MapiSocket)MapiSocket.this).blklen[0] = (byte)(this.blocksize << 1 & 0xFF | 1);
                ((MapiSocket)MapiSocket.this).blklen[1] = (byte)(this.blocksize >> 7);
            } else {
                this.blocksize = 8190;
                ((MapiSocket)MapiSocket.this).blklen[0] = (byte)(this.blocksize << 1 & 0xFF);
                ((MapiSocket)MapiSocket.this).blklen[1] = (byte)(this.blocksize >> 7);
            }
            this.out.write(MapiSocket.this.blklen);
            this.out.write(this.block, 0, this.writePos);
            if (MapiSocket.this.debug) {
                if (last) {
                    MapiSocket.this.logTd("write final block: " + this.writePos + " bytes");
                } else {
                    MapiSocket.this.logTd("write block: " + this.writePos + " bytes");
                }
                MapiSocket.this.logTx(new String(this.block, 0, this.writePos, "UTF-8"));
            }
            this.writePos = 0;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.writePos == 8190) {
                this.writeBlock(false);
            }
            this.block[this.writePos++] = (byte)b;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int t = 0;
            while (len > 0) {
                t = 8190 - this.writePos;
                if (len > t) {
                    System.arraycopy(b, off, this.block, this.writePos, t);
                    off += t;
                    len -= t;
                    this.writePos += t;
                    this.writeBlock(false);
                    continue;
                }
                System.arraycopy(b, off, this.block, this.writePos, len);
                this.writePos += len;
                break;
            }
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

