/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc.types;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;

public class INET
implements SQLData {
    private String inet;

    public String getSQLTypeName() {
        return "inet";
    }

    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        if (typeName.compareTo("inet") != 0) {
            throw new SQLException("can only use this class with 'inet' type", "M1M05");
        }
        this.inet = stream.readString();
    }

    public void writeSQL(SQLOutput stream) throws SQLException {
        stream.writeString(this.inet);
    }

    public String toString() {
        return this.inet;
    }

    public void fromString(String newinet) throws Exception {
        String[] quads;
        if (newinet == null) {
            this.inet = newinet;
            return;
        }
        int slash = newinet.indexOf(47);
        String tinet = newinet;
        if (slash != -1) {
            int netmask;
            try {
                netmask = Integer.parseInt(newinet.substring(slash + 1));
            }
            catch (NumberFormatException nfe) {
                throw new Exception("cannot parse netmask bits: " + newinet.substring(slash + 1));
            }
            if (netmask <= 0 || netmask > 32) {
                throw new Exception("netmask must be >0 and <32");
            }
            tinet = newinet.substring(0, slash);
        }
        if ((quads = tinet.split("\\.")).length != 4) {
            throw new Exception("expected dotted quad (xxx.xxx.xxx.xxx)");
        }
        for (int i = 0; i < 4; ++i) {
            int quadv;
            try {
                quadv = Integer.parseInt(quads[i]);
            }
            catch (NumberFormatException nfe) {
                throw new Exception("cannot parse number: " + quads[i]);
            }
            if (quadv >= 0 && quadv <= 255) continue;
            throw new Exception("value must be between 0 and 255: " + quads[i]);
        }
        this.inet = newinet;
    }

    public String getAddress() {
        if (this.inet == null) {
            return null;
        }
        int slash = this.inet.indexOf(47);
        if (slash != -1) {
            return this.inet.substring(0, slash);
        }
        return this.inet;
    }

    public void setAddress(String newinet) throws Exception {
        if (newinet == null) {
            this.inet = newinet;
            return;
        }
        if (newinet.indexOf(47) != -1) {
            throw new Exception("IPv4 address cannot contain '/' (use fromString() instead)");
        }
        this.fromString(newinet);
    }

    public int getNetmaskBits() throws SQLException {
        if (this.inet == null) {
            return 0;
        }
        int slash = this.inet.indexOf(47);
        if (slash == -1) {
            return 32;
        }
        try {
            return Integer.parseInt(this.inet.substring(slash + 1));
        }
        catch (NumberFormatException nfe) {
            throw new SQLException("cannot parse netmask bits: " + this.inet.substring(slash + 1), "M0M27");
        }
    }

    public void setNetmaskBits(int bits) throws Exception {
        int slash;
        String newinet = this.inet;
        newinet = newinet == null ? "0.0.0.0/" + bits : ((slash = newinet.indexOf(47)) != -1 ? newinet.substring(0, slash + 1) + bits : newinet + "/" + bits);
        this.fromString(newinet);
    }

    public InetAddress getInetAddress() throws SQLException {
        if (this.inet == null) {
            return null;
        }
        try {
            return InetAddress.getByName(this.getAddress());
        }
        catch (UnknownHostException uhe) {
            throw new SQLException("could not resolve IP address", "M0M27");
        }
    }

    public void setInetAddress(InetAddress iaddr) throws Exception {
        if (!(iaddr instanceof Inet4Address)) {
            throw new Exception("only IPv4 are supported currently");
        }
        this.fromString(iaddr.getHostAddress());
    }
}

