/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class MonetClob
implements Clob {
    private StringBuilder buf;

    protected MonetClob(String in) {
        this.buf = new StringBuilder(in);
    }

    public void free() {
        this.buf = null;
    }

    public InputStream getAsciiStream() throws SQLException {
        throw new SQLFeatureNotSupportedException("Operation getAsciiStream() currently not supported", "0A000");
    }

    public Reader getCharacterStream() throws SQLException {
        throw new SQLFeatureNotSupportedException("Operation getCharacterStream() currently not supported", "0A000");
    }

    public Reader getCharacterStream(long pos, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Operation getCharacterStream(long, long) currently not supported", "0A000");
    }

    public String getSubString(long pos, int length) throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This Clob has been freed", "M1M20");
        }
        try {
            return this.buf.substring((int)(pos - 1L), (int)(pos - 1L + (long)length));
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public long length() throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This Clob has been freed", "M1M20");
        }
        return this.buf.length();
    }

    public long position(Clob searchstr, long start) throws SQLException {
        return this.position(searchstr.getSubString(1L, (int)searchstr.length()), start);
    }

    public long position(String searchstr, long start) throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This Clob has been freed", "M1M20");
        }
        return this.buf.indexOf(searchstr, (int)(start - 1L));
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This Clob has been freed", "M1M20");
        }
        throw new SQLException("Operation setAsciiStream(long pos) currently not supported", "0A000");
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This Clob has been freed", "M1M20");
        }
        throw new SQLException("Operation setCharacterStream(long pos) currently not supported", "0A000");
    }

    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 1, str.length());
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This Clob has been freed", "M1M20");
        }
        int buflen = this.buf.length();
        int retlen = Math.min(buflen, (int)(pos - 1L + (long)len));
        if (retlen > 0) {
            this.buf.replace((int)(pos - 1L), (int)(pos + (long)retlen), str.substring(offset - 1, offset + len));
            return retlen;
        }
        return 0;
    }

    public void truncate(long len) throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This Clob has been freed", "M1M20");
        }
    }

    public String toString() {
        if (this.buf == null) {
            return "<a freed MonetClob instance>";
        }
        return this.buf.toString();
    }
}

