/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.jdbc.MonetResultSet;
import nl.cwi.monetdb.jdbc.MonetVirtualResultSet;
import nl.cwi.monetdb.jdbc.MonetWrapper;

public class MonetStatement
extends MonetWrapper
implements Statement {
    static final int DEF_MAXROWS = 0;
    private MonetConnection connection;
    private MonetConnection.ResponseList lastResponseList;
    MonetConnection.Response header;
    private SQLWarning warnings;
    protected boolean closed;
    protected boolean poolable;
    private int fetchSize = 0;
    private int maxRows = 0;
    private int fetchDirection = 1000;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private List batch;

    MonetStatement(MonetConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException, IllegalArgumentException {
        if (connection == null) {
            throw new IllegalArgumentException("No Connection given!");
        }
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        if (resultSetConcurrency != 1007) {
            this.addWarning("No concurrency mode other then read only is supported, continuing with concurrency level READ_ONLY");
            resultSetConcurrency = 1007;
        }
        if (resultSetType == 1005) {
            this.addWarning("Change sensitive scrolling ResultSet objects are not supported, continuing with a change non-sensitive scrollable cursor.");
            resultSetType = 1004;
        }
        if (resultSetHoldability != 1) {
            this.addWarning("Close cursors at commit not supported, continuing with holdability to hold open cursors over commit.");
        }
        this.closed = false;
        this.poolable = false;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.batch == null) {
            this.batch = new ArrayList(1000);
        }
        this.batch.add(sql);
    }

    @Override
    public void clearBatch() {
        this.batch = null;
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        if (this.batch == null) {
            return new int[0];
        }
        int[] counts = new int[this.batch.size()];
        int offset = 0;
        boolean first = true;
        boolean error = false;
        BatchUpdateException e = new BatchUpdateException("Error(s) occurred while executing the batch, see next SQLExceptions for details", counts);
        StringBuffer tmpBatch = new StringBuffer(8190);
        String sep = this.connection.queryTempl[2];
        for (int i = 0; i < this.batch.size(); ++i) {
            String tmp = this.batch.get(i).toString();
            if (sep.length() + tmp.length() > 8190) {
                if (!first) {
                    tmpBatch.append(sep);
                }
                tmpBatch.append(tmp);
                error |= this.internalBatch(tmpBatch.toString(), counts, offset, i, e);
                offset = i;
                tmpBatch.delete(0, tmpBatch.length());
                first = true;
                continue;
            }
            if (tmpBatch.length() + sep.length() + tmp.length() >= 8190) {
                error |= this.internalBatch(tmpBatch.toString(), counts, offset, i, e);
                offset = i;
                tmpBatch.delete(0, tmpBatch.length());
                first = true;
            }
            if (!first) {
                tmpBatch.append(sep);
            }
            first = false;
            tmpBatch.append(tmp);
        }
        if (error |= this.internalBatch(tmpBatch.toString(), counts, offset, counts.length, e)) {
            throw e;
        }
        return counts;
    }

    private boolean internalBatch(String batch, int[] counts, int offset, int max, BatchUpdateException e) throws BatchUpdateException {
        try {
            boolean type = this.internalExecute(batch);
            int count = -1;
            if (!type) {
                count = this.getUpdateCount();
            }
            do {
                if (offset >= max) {
                    throw new SQLException("Overflow: don't use multi statements when batching (" + max + ")");
                }
                if (type) {
                    e.setNextException(new SQLException("Batch query produced a ResultSet! Ignoring and setting update count to value -3"));
                    counts[offset] = -3;
                } else if (count >= 0) {
                    counts[offset] = count;
                }
                ++offset;
            } while ((type = this.getMoreResults()) || (count = this.getUpdateCount()) != -1);
        }
        catch (SQLException ex) {
            e.setNextException(ex);
            while (offset < max) {
                counts[offset] = -3;
                ++offset;
            }
            return true;
        }
        return false;
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLException("Query cancelling is currently not supported by the DBMS.");
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public void close() {
        if (this.lastResponseList != null) {
            this.lastResponseList.close();
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isPoolable() {
        return this.poolable;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.internalExecute(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw new SQLException("Invalid argument, expected RETURN_GENERATED_KEYS or NO_GENERATED_KEYS");
        }
        return this.internalExecute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexed) throws SQLException {
        this.addWarning("execute: generated keys for fixed set of columns not supported");
        return this.execute(sql, 1);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.addWarning("execute: generated keys for fixed set of columns not supported");
        return this.execute(sql, 1);
    }

    private boolean internalExecute(String sql) throws SQLException {
        if (this.lastResponseList != null) {
            this.lastResponseList.close();
            this.lastResponseList = null;
        }
        MonetConnection monetConnection = this.connection;
        monetConnection.getClass();
        this.lastResponseList = monetConnection.new MonetConnection.ResponseList(this.fetchSize, this.maxRows, this.resultSetType, this.resultSetConcurrency);
        this.lastResponseList.processQuery(sql);
        return this.getMoreResults();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw new SQLException("Query did not produce a result set");
        }
        return this.getResultSet();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.execute(sql)) {
            throw new SQLException("Query produced a result set");
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw new SQLException("Invalid argument, expected RETURN_GENERATED_KEYS or NO_GENERATED_KEYS");
        }
        if (this.execute(sql)) {
            throw new SQLException("Query produced a result set");
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.addWarning("executeUpdate: generated keys for fixed set of columns not supported");
        return this.executeUpdate(sql, 1);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.addWarning("executeUpdate: generated keys for fixed set of columns not supported");
        return this.executeUpdate(sql, 1);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        String[][] results;
        String[] columns = new String[1];
        String[] types = new String[1];
        columns[0] = "GENERATED_KEY";
        types[0] = "varchar";
        if (this.header instanceof MonetConnection.UpdateResponse) {
            String lastid = ((MonetConnection.UpdateResponse)this.header).lastid;
            if (lastid.equals("-1")) {
                results = new String[0][1];
            } else {
                results = new String[1][1];
                results[0][0] = lastid;
            }
        } else {
            results = new String[0][1];
        }
        try {
            return new MonetVirtualResultSet(columns, types, results);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Internal driver error: " + e.getMessage());
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.lastResponseList == null) {
            this.header = null;
            return false;
        }
        if (current == 1) {
            this.lastResponseList.closeCurrentResponse();
        } else if (current == 3) {
            this.lastResponseList.closeCurOldResponses();
        }
        this.header = this.lastResponseList.getNextResponse();
        return this.header instanceof MonetConnection.ResultSetResponse;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.header instanceof MonetConnection.ResultSetResponse) {
            return new MonetResultSet(this, (MonetConnection.ResultSetResponse)this.header);
        }
        return null;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int ret = -1;
        if (this.header instanceof MonetConnection.UpdateResponse) {
            ret = ((MonetConnection.UpdateResponse)this.header).count;
        } else if (this.header instanceof MonetConnection.SchemaResponse) {
            ret = ((MonetConnection.SchemaResponse)this.header).state;
        }
        return ret;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot call on closed Statement");
        }
        return this.warnings;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.addWarning("setCursorName: positioned updates/deletes not supported");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (enable) {
            this.addWarning("setEscapeProcessing: JDBC escape syntax is not supported by this driver");
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new SQLException("Illegal direction: " + direction);
        }
        this.fetchDirection = direction;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 || this.getMaxRows() != 0 && rows > this.getMaxRows()) {
            throw new SQLException("Illegal fetch size value: " + rows);
        }
        this.fetchSize = rows;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("Illegal max value: " + max);
        }
        if (max > 0) {
            this.addWarning("setMaxFieldSize: field size limitation not supported");
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("Illegal max value: " + max);
        }
        this.maxRows = max;
    }

    @Override
    public void setPoolable(boolean poolable) {
        this.poolable = poolable;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new SQLException("Illegal timeout value: " + seconds);
        }
        if (seconds > 0) {
            this.addWarning("setQueryTimeout: query time outs not supported");
        }
    }

    private void addWarning(String reason) {
        if (this.warnings == null) {
            this.warnings = new SQLWarning(reason);
        } else {
            this.warnings.setNextWarning(new SQLWarning(reason));
        }
    }
}

