/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.CharBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.jdbc.MonetDriver;
import nl.cwi.monetdb.jdbc.MonetResultSet;
import nl.cwi.monetdb.jdbc.MonetStatement;
import nl.cwi.monetdb.jdbc.MonetWrapper;

public class MonetPreparedStatement
extends MonetStatement
implements PreparedStatement {
    private final String[] monetdbType;
    private final int[] javaType;
    private final int[] digits;
    private final int[] scale;
    private final int id;
    private final int size;
    private final String[] values;
    private final StringBuffer buf;
    private final MonetConnection connection;
    final SimpleDateFormat mTimestampZ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
    final SimpleDateFormat mTimestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    final SimpleDateFormat mTimeZ = new SimpleDateFormat("HH:mm:ss.SSSZ");
    final SimpleDateFormat mTime = new SimpleDateFormat("HH:mm:ss.SSS");
    final SimpleDateFormat mDate = new SimpleDateFormat("yyyy-MM-dd");
    static final String HEXES = "0123456789ABCDEF";

    MonetPreparedStatement(MonetConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String prepareQuery) throws SQLException, IllegalArgumentException {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (!super.execute("PREPARE " + prepareQuery)) {
            throw new SQLException("Unexpected server response");
        }
        this.id = ((MonetConnection.ResultSetResponse)this.header).id;
        this.size = ((MonetConnection.ResultSetResponse)this.header).tuplecount;
        this.monetdbType = new String[this.size];
        this.javaType = new int[this.size];
        this.digits = new int[this.size];
        this.scale = new int[this.size];
        this.values = new String[this.size];
        this.buf = new StringBuffer(6 + 12 * this.size);
        this.connection = connection;
        ResultSet rs = super.getResultSet();
        int i = 0;
        while (rs.next()) {
            this.monetdbType[i] = rs.getString("type");
            this.javaType[i] = MonetDriver.getJavaType(this.monetdbType[i]);
            this.digits[i] = rs.getInt("digits");
            this.scale[i] = rs.getInt("scale");
            ++i;
        }
        rs.close();
        this.poolable = true;
    }

    MonetPreparedStatement(MonetConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.monetdbType = null;
        this.javaType = null;
        this.digits = null;
        this.scale = null;
        this.values = null;
        this.buf = null;
        this.id = -1;
        this.size = -1;
        this.connection = connection;
    }

    @Override
    public void addBatch() throws SQLException {
        super.addBatch(this.transform());
    }

    @Override
    public void addBatch(String q) throws SQLException {
        throw new SQLException("This method is not available in a PreparedStatement!");
    }

    @Override
    public void clearParameters() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        return super.execute(this.transform());
    }

    @Override
    public boolean execute(String q) throws SQLException {
        throw new SQLException("This method is not available in a PreparedStatement!");
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (!this.execute()) {
            throw new SQLException("Query did not produce a result set");
        }
        return this.getResultSet();
    }

    @Override
    public ResultSet executeQuery(String q) throws SQLException {
        throw new SQLException("This method is not available in a PreparedStatement!");
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.execute()) {
            throw new SQLException("Query produced a result set");
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String q) throws SQLException {
        throw new SQLException("This method is not available in a PreparedStatement!");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new pmdw(){

            @Override
            public int getParameterCount() throws SQLException {
                return MonetPreparedStatement.this.size;
            }

            @Override
            public int isNullable(int param) throws SQLException {
                return 2;
            }

            @Override
            public boolean isSigned(int param) throws SQLException {
                if (param < 1 || param > MonetPreparedStatement.this.size) {
                    throw new SQLException("No such parameter with index: " + param);
                }
                switch (MonetPreparedStatement.this.javaType[param - 1]) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public int getPrecision(int param) throws SQLException {
                if (param < 1 || param > MonetPreparedStatement.this.size) {
                    throw new SQLException("No such parameter with index: " + param);
                }
                return MonetPreparedStatement.this.digits[param - 1];
            }

            @Override
            public int getScale(int param) throws SQLException {
                if (param < 1 || param > MonetPreparedStatement.this.size) {
                    throw new SQLException("No such parameter with index: " + param);
                }
                return MonetPreparedStatement.this.scale[param - 1];
            }

            @Override
            public int getParameterType(int param) throws SQLException {
                if (param < 1 || param > MonetPreparedStatement.this.size) {
                    throw new SQLException("No such parameter with index: " + param);
                }
                return MonetPreparedStatement.this.javaType[param - 1];
            }

            @Override
            public String getParameterTypeName(int param) throws SQLException {
                if (param < 1 || param > MonetPreparedStatement.this.size) {
                    throw new SQLException("No such parameter with index: " + param);
                }
                return MonetPreparedStatement.this.monetdbType[param - 1];
            }

            @Override
            public String getParameterClassName(int param) throws SQLException {
                if (param < 1 || param > MonetPreparedStatement.this.size) {
                    throw new SQLException("No such parameter with index: " + param);
                }
                return MonetResultSet.getClassForType(MonetPreparedStatement.this.javaType[param - 1]).getName();
            }

            @Override
            public int getParameterMode(int param) throws SQLException {
                return 0;
            }
        };
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        throw new SQLException("Operation setArray(int i, Array x) currently not supported!");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Operation setAsciiStream(int, InputStream x) currently not supported!");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Operation setAsciiStream(int parameterIndex, InputStream x, long length) currently not supported!");
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setValue(parameterIndex, x.toString());
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Operation setBinaryStream(int parameterIndex, InputStream x) currently not supported!");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Operation setBinaryStream(int parameterIndex, InputStream x, long length) currently not supported!");
    }

    @Override
    public void setBlob(int i, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Operation setBlob(int, InputStream) currently not supported!");
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Operation setBlob(int i, Blob x) currently not supported!");
    }

    @Override
    public void setBlob(int i, InputStream is, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Operation setBlob(int, InputStream, long) currently not supported!");
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setValue(parameterIndex, "" + x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setValue(parameterIndex, "" + x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, -1);
            return;
        }
        StringBuffer hex = new StringBuffer(x.length * 2);
        for (int i = 0; i < x.length; ++i) {
            byte b = x[i];
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        this.setValue(parameterIndex, "blob '" + hex.toString() + "'");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        CharBuffer tmp = CharBuffer.allocate(length);
        try {
            reader.read(tmp);
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        this.setString(parameterIndex, tmp.toString());
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("setCharacterStream(int, Reader) not supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (int)length);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.setString(i, x.getSubString(1L, (int)x.length()));
    }

    @Override
    public void setClob(int i, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setClob(int, Reader) not supported");
    }

    @Override
    public void setClob(int i, Reader reader, long length) throws SQLException {
        CharBuffer buf = CharBuffer.allocate((int)length);
        try {
            reader.read(buf);
        }
        catch (IOException e) {
            throw new SQLException("failed to read from stream: " + e.getMessage());
        }
        this.setString(i, buf.toString());
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (cal == null) {
            this.setValue(parameterIndex, "date '" + x.toString() + "'");
        } else {
            this.mDate.setTimeZone(cal.getTimeZone());
            this.setValue(parameterIndex, "date '" + this.mDate.format(x) + "'");
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setValue(parameterIndex, "" + x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setValue(parameterIndex, "" + x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setValue(parameterIndex, "" + x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setValue(parameterIndex, "" + x);
    }

    @Override
    public void setNCharacterStream(int i, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Operation setNCharacterStream currently not supported!");
    }

    @Override
    public void setNCharacterStream(int i, Reader value, long length) throws SQLException {
        this.setNCharacterStream(i, value);
    }

    @Override
    public void setNClob(int i, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Operation setNClob(int, Reader) currently not supported!");
    }

    @Override
    public void setNClob(int i, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Operation setNClob(int, NClob) currently not supported!");
    }

    @Override
    public void setNClob(int i, Reader r, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Operation setNClob(int, Reader, long) currently not supported!");
    }

    @Override
    public void setNString(int i, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException("Operation setNString(int i, String x) currently not supported!");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setValue(parameterIndex, "NULL");
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(paramIndex, sqlType);
    }

    @Override
    public void setObject(int index, Object x) throws SQLException {
        if (index < 1 || index > this.size) {
            throw new SQLException("No such parameter with index: " + index);
        }
        this.setObject(index, x, this.javaType[index - 1]);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        block106: {
            block110: {
                block109: {
                    block108: {
                        block107: {
                            block105: {
                                if (!(x instanceof String)) break block105;
                                switch (targetSqlType) {
                                    case -6: 
                                    case 4: 
                                    case 5: {
                                        int val;
                                        try {
                                            val = Integer.parseInt((String)x);
                                        }
                                        catch (NumberFormatException e) {
                                            val = 0;
                                        }
                                        this.setInt(parameterIndex, val);
                                        break block106;
                                    }
                                    case -5: {
                                        long val;
                                        try {
                                            val = Long.parseLong((String)x);
                                        }
                                        catch (NumberFormatException e) {
                                            val = 0L;
                                        }
                                        this.setLong(parameterIndex, val);
                                        break block106;
                                    }
                                    case 7: {
                                        float val;
                                        try {
                                            val = Float.parseFloat((String)x);
                                        }
                                        catch (NumberFormatException e) {
                                            val = 0.0f;
                                        }
                                        this.setFloat(parameterIndex, val);
                                        break block106;
                                    }
                                    case 6: 
                                    case 8: {
                                        double val;
                                        try {
                                            val = Double.parseDouble((String)x);
                                        }
                                        catch (NumberFormatException e) {
                                            val = 0.0;
                                        }
                                        this.setDouble(parameterIndex, val);
                                        break block106;
                                    }
                                    case 2: 
                                    case 3: {
                                        BigDecimal val;
                                        try {
                                            val = new BigDecimal((String)x);
                                        }
                                        catch (NumberFormatException e) {
                                            try {
                                                val = new BigDecimal(0.0);
                                            }
                                            catch (NumberFormatException ex) {
                                                throw new SQLException("Internal error: unable to create template BigDecimal: " + ex.getMessage());
                                            }
                                        }
                                        val = val.setScale(scale, 4);
                                        this.setBigDecimal(parameterIndex, val);
                                        break block106;
                                    }
                                    case -7: 
                                    case 16: {
                                        this.setBoolean(parameterIndex, Boolean.valueOf((String)x));
                                        break block106;
                                    }
                                    case -1: 
                                    case 1: 
                                    case 12: {
                                        this.setString(parameterIndex, (String)x);
                                        break block106;
                                    }
                                    case -4: 
                                    case -3: 
                                    case -2: {
                                        this.setBytes(parameterIndex, ((String)x).getBytes());
                                        break block106;
                                    }
                                    case 91: {
                                        Date val;
                                        try {
                                            val = Date.valueOf((String)x);
                                        }
                                        catch (IllegalArgumentException e) {
                                            val = new Date(0L);
                                        }
                                        this.setDate(parameterIndex, val);
                                        break block106;
                                    }
                                    case 92: {
                                        Time val;
                                        try {
                                            val = Time.valueOf((String)x);
                                        }
                                        catch (IllegalArgumentException e) {
                                            val = new Time(0L);
                                        }
                                        this.setTime(parameterIndex, val);
                                        break block106;
                                    }
                                    case 93: {
                                        Timestamp val;
                                        try {
                                            val = Timestamp.valueOf((String)x);
                                        }
                                        catch (IllegalArgumentException e) {
                                            val = new Timestamp(0L);
                                        }
                                        this.setTimestamp(parameterIndex, val);
                                        break block106;
                                    }
                                    case -16: 
                                    case -15: 
                                    case -9: {
                                        throw new SQLFeatureNotSupportedException("N CHAR types not supported");
                                    }
                                    default: {
                                        throw new SQLException("Conversion not allowed");
                                    }
                                }
                            }
                            if (!(x instanceof Number)) break block107;
                            Number num = (Number)x;
                            switch (targetSqlType) {
                                case -6: {
                                    this.setByte(parameterIndex, num.byteValue());
                                    break;
                                }
                                case 5: {
                                    this.setShort(parameterIndex, num.shortValue());
                                    break;
                                }
                                case 4: {
                                    this.setInt(parameterIndex, num.intValue());
                                    break;
                                }
                                case -5: {
                                    if (x instanceof BigDecimal) {
                                        this.setLong(parameterIndex, ((BigDecimal)x).setScale(scale, 4).longValue());
                                        break;
                                    }
                                    this.setLong(parameterIndex, num.longValue());
                                    break;
                                }
                                case 7: {
                                    this.setFloat(parameterIndex, num.floatValue());
                                    break;
                                }
                                case 6: 
                                case 8: {
                                    this.setDouble(parameterIndex, num.doubleValue());
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    BigDecimal val;
                                    if (x instanceof BigDecimal) {
                                        this.setBigDecimal(parameterIndex, (BigDecimal)x);
                                        break;
                                    }
                                    if (x instanceof BigInteger) {
                                        BigDecimal val2;
                                        try {
                                            val2 = new BigDecimal((BigInteger)x, scale);
                                        }
                                        catch (NumberFormatException e) {
                                            try {
                                                val2 = new BigDecimal(0.0);
                                            }
                                            catch (NumberFormatException ex) {
                                                throw new SQLException("Internal error: unable to create template BigDecimal: " + ex.getMessage());
                                            }
                                        }
                                        this.setBigDecimal(parameterIndex, val2);
                                        break;
                                    }
                                    try {
                                        val = new BigDecimal(num.doubleValue());
                                    }
                                    catch (NumberFormatException e) {
                                        try {
                                            val = new BigDecimal(0.0);
                                        }
                                        catch (NumberFormatException ex) {
                                            throw new SQLException("Internal error: unable to create template BigDecimal: " + ex.getMessage());
                                        }
                                    }
                                    this.setBigDecimal(parameterIndex, val);
                                    break;
                                }
                                case -7: 
                                case 16: {
                                    if (num.doubleValue() != 0.0) {
                                        this.setBoolean(parameterIndex, true);
                                        break;
                                    }
                                    this.setBoolean(parameterIndex, false);
                                    break;
                                }
                                case -1: 
                                case 1: 
                                case 12: {
                                    this.setString(parameterIndex, x.toString());
                                    break;
                                }
                                default: {
                                    throw new SQLException("Conversion not allowed");
                                }
                            }
                            break block106;
                        }
                        if (!(x instanceof Boolean)) break block108;
                        boolean val = (Boolean)x;
                        switch (targetSqlType) {
                            case -6: {
                                this.setByte(parameterIndex, (byte)(val ? 1 : 0));
                                break;
                            }
                            case 5: {
                                this.setShort(parameterIndex, (short)(val ? 1 : 0));
                                break;
                            }
                            case 4: {
                                this.setInt(parameterIndex, val ? 1 : 0);
                                break;
                            }
                            case -5: {
                                this.setLong(parameterIndex, val ? 1 : 0);
                                break;
                            }
                            case 7: {
                                this.setFloat(parameterIndex, (float)(val ? 1.0 : 0.0));
                                break;
                            }
                            case 6: 
                            case 8: {
                                this.setDouble(parameterIndex, val ? 1.0 : 0.0);
                                break;
                            }
                            case 2: 
                            case 3: {
                                BigDecimal dec;
                                try {
                                    dec = new BigDecimal(val ? 1.0 : 0.0);
                                }
                                catch (NumberFormatException e) {
                                    throw new SQLException("Internal error: unable to create template BigDecimal: " + e.getMessage());
                                }
                                this.setBigDecimal(parameterIndex, dec);
                                break;
                            }
                            case -7: 
                            case 16: {
                                this.setBoolean(parameterIndex, val);
                                break;
                            }
                            case -1: 
                            case 1: 
                            case 12: {
                                this.setString(parameterIndex, "" + val);
                                break;
                            }
                            default: {
                                throw new SQLException("Conversion not allowed");
                            }
                        }
                        break block106;
                    }
                    if (!(x instanceof byte[])) break block109;
                    switch (targetSqlType) {
                        case -4: 
                        case -3: 
                        case -2: {
                            this.setBytes(parameterIndex, (byte[])x);
                            break block106;
                        }
                        default: {
                            throw new SQLException("Conversion not allowed");
                        }
                    }
                }
                if (!(x instanceof Date) && !(x instanceof Timestamp) && !(x instanceof Time)) break block110;
                switch (targetSqlType) {
                    case -1: 
                    case 1: 
                    case 12: {
                        this.setString(parameterIndex, x.toString());
                        break block106;
                    }
                    case 91: {
                        if (x instanceof Time) {
                            throw new SQLException("Conversion not allowed");
                        }
                        if (x instanceof Date) {
                            this.setDate(parameterIndex, (Date)x);
                        } else if (x instanceof Timestamp) {
                            this.setDate(parameterIndex, new Date(((Timestamp)x).getTime()));
                        }
                        break block106;
                    }
                    case 92: {
                        if (x instanceof Time) {
                            this.setTime(parameterIndex, (Time)x);
                        } else {
                            if (x instanceof Date) {
                                throw new SQLException("Conversion not allowed");
                            }
                            if (x instanceof Timestamp) {
                                this.setTime(parameterIndex, new Time(((Timestamp)x).getTime()));
                            }
                        }
                        break block106;
                    }
                    case 93: {
                        if (x instanceof Time) {
                            throw new SQLException("Conversion not allowed");
                        }
                        if (x instanceof Date) {
                            this.setTimestamp(parameterIndex, new Timestamp(((Date)x).getTime()));
                        } else if (x instanceof Timestamp) {
                            this.setTimestamp(parameterIndex, (Timestamp)x);
                        }
                        break block106;
                    }
                    default: {
                        throw new SQLException("Conversion not allowed");
                    }
                }
            }
            if (x instanceof Array) {
                this.setArray(parameterIndex, (Array)x);
            } else if (x instanceof Blob) {
                this.setBlob(parameterIndex, (Blob)x);
            } else if (x instanceof Clob) {
                this.setClob(parameterIndex, (Clob)x);
            } else {
                if (x instanceof NClob) {
                    throw new SQLFeatureNotSupportedException("Operation setObject() with object of type NClob currently not supported!");
                }
                if (x instanceof Struct) {
                    throw new SQLFeatureNotSupportedException("Operation setObject() with object of type Struct currently not supported!");
                }
                if (x instanceof Ref) {
                    this.setRef(parameterIndex, (Ref)x);
                } else if (x instanceof RowId) {
                    this.setRowId(parameterIndex, (RowId)x);
                } else if (x instanceof URL) {
                    this.setURL(parameterIndex, (URL)x);
                } else {
                    if (x instanceof SQLData) {
                        throw new SQLFeatureNotSupportedException("Operation setObject() with object of type SQLData currently not supported!");
                    }
                    if (x instanceof SQLXML) {
                        throw new SQLFeatureNotSupportedException("Operation setObject() with object of type SQLXML currently not supported!");
                    }
                    throw new SQLFeatureNotSupportedException("Operation setObject() with object of type Class currently not supported!");
                }
            }
        }
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Operation setRef(int i, Ref x) currently not supported!");
    }

    @Override
    public void setRowId(int i, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Operation setRowId(int i, RowId x) currently not supported!");
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setValue(parameterIndex, "" + x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setValue(parameterIndex, "'" + x.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'") + "'");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setSQLXML(int, SQLXML) not supported");
    }

    @Override
    public void setTime(int index, Time x) throws SQLException {
        this.setTime(index, x, null);
    }

    @Override
    public void setTime(int index, Time x, Calendar cal) throws SQLException {
        if (index < 1 || index > this.size) {
            throw new SQLException("No such parameter with index: " + index);
        }
        boolean hasTimeZone = this.monetdbType[index - 1].endsWith("tz");
        if (hasTimeZone) {
            String RFC822 = this.mTimeZ.format(x);
            this.setValue(index, "timetz '" + RFC822.substring(0, 15) + ":" + RFC822.substring(15) + "'");
        } else if (cal == null) {
            this.setValue(index, "time '" + x.toString() + "'");
        } else {
            this.mTime.setTimeZone(cal.getTimeZone());
            this.setValue(index, "time '" + this.mTime.format(x) + "'");
        }
    }

    @Override
    public void setTimestamp(int index, Timestamp x) throws SQLException {
        this.setTimestamp(index, x, null);
    }

    @Override
    public void setTimestamp(int index, Timestamp x, Calendar cal) throws SQLException {
        if (index < 1 || index > this.size) {
            throw new SQLException("No such parameter with index: " + index);
        }
        boolean hasTimeZone = this.monetdbType[index - 1].endsWith("tz");
        if (hasTimeZone) {
            String RFC822 = this.mTimestampZ.format(x);
            this.setValue(index, "timestamptz '" + RFC822.substring(0, 26) + ":" + RFC822.substring(26) + "'");
        } else if (cal == null) {
            this.setValue(index, "timestamp '" + x.toString() + "'");
        } else {
            this.mTimestamp.setTimeZone(cal.getTimeZone());
            this.setValue(index, "timestamp '" + this.mTimestamp.format(x) + "'");
        }
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Operation setUnicodeStream(int parameterIndex, InputStream x, int length) currently not supported!");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLException("Operation setURL(int parameterIndex, URL x) currently not supported!");
    }

    @Override
    public void close() {
        try {
            if (!this.closed && this.id != -1) {
                this.connection.sendControlCommand("release " + this.id);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.close();
    }

    protected void finalize() {
        this.close();
    }

    void setValue(int index, String val) throws SQLException {
        if (index < 1 || index > this.size) {
            throw new SQLException("No such parameter with index: " + index);
        }
        this.values[index - 1] = val;
    }

    private String transform() throws SQLException {
        this.buf.delete(0, this.buf.length());
        this.buf.append("exec ");
        this.buf.append(this.id);
        this.buf.append("(");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                this.buf.append(", ");
            }
            if (this.values[i] == null) {
                throw new SQLException("Cannot execute, parameter " + (i + 1) + " is missing.");
            }
            this.buf.append(this.values[i]);
        }
        this.buf.append(")");
        return this.buf.toString();
    }

    private abstract class pmdw
    extends MonetWrapper
    implements ParameterMetaData {
        private pmdw() {
        }
    }
}

