/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.mcl.parser;

import org.monetdb.mcl.parser.MCLParseException;

public class QuotedStringParser {
    private StringBuilder builder = null;
    public int size;

    public String parse(char[] cArray, int n, int n2) throws MCLParseException {
        for (int i = n + 1; i < n2; ++i) {
            char c = cArray[i];
            if (c == '\"') {
                this.size = i + 1 - n;
                return new String(cArray, n + 1, i - n - 1);
            }
            if (c != '\\') continue;
            return this.parseEscapes(cArray, n, i, n2);
        }
        throw new MCLParseException("unterminated quoted string", n2);
    }

    private String parseEscapes(char[] cArray, int n, int n2, int n3) throws MCLParseException {
        if (this.builder != null) {
            this.builder.setLength(0);
        } else {
            this.builder = new StringBuilder(n3 - n + 16);
        }
        this.builder.append(cArray, n + 1, n2 - n - 1);
        for (int i = n2; i < n3; ++i) {
            int n4 = cArray[i];
            if (n4 == 34) {
                this.size = i + 1 - n;
                return this.builder.toString();
            }
            if (n4 == 92) {
                int n5 = i;
                if (i + 1 == n3) {
                    throw new MCLParseException("truncated escape sequence", n5);
                }
                int n6 = cArray[++i];
                switch (n6) {
                    case 34: 
                    case 92: {
                        n4 = n6;
                        break;
                    }
                    case 102: {
                        n4 = 12;
                        break;
                    }
                    case 110: {
                        n4 = 10;
                        break;
                    }
                    case 114: {
                        n4 = 13;
                        break;
                    }
                    case 116: {
                        n4 = 9;
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        int n7;
                        if (i + 3 >= n3) {
                            throw new MCLParseException("truncated escape sequence", n5);
                        }
                        int n8 = n6 - 48;
                        int n9 = cArray[++i] - 48;
                        if (n9 < 0 | n9 > 7 | (n7 = cArray[++i] - 48) < 0 | n7 > 7) {
                            throw new MCLParseException("invalid escape sequence", i);
                        }
                        n4 = (char)(64 * n8 + 8 * n9 + n7);
                        break;
                    }
                    default: {
                        throw new MCLParseException("unexpected escape sequence", n5);
                    }
                }
            }
            this.builder.append((char)n4);
        }
        throw new MCLParseException("unterminated quoted string", n3);
    }
}

