/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.mcl.parser;

import org.monetdb.mcl.parser.MCLParseException;
import org.monetdb.mcl.parser.MCLParser;
import org.monetdb.mcl.parser.QuotedStringParser;

public final class HeaderLineParser
extends MCLParser {
    public static final int NAME = 1;
    public static final int LENGTH = 2;
    public static final int TABLE = 3;
    public static final int TYPE = 4;
    public static final int TYPESIZES = 5;
    public final int[] intValues;
    private final QuotedStringParser qsparser = new QuotedStringParser();

    public HeaderLineParser(int n) {
        super(n);
        this.intValues = new int[n];
    }

    @Override
    public int parse(String string) throws MCLParseException {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        block10: for (n = n2 - 1; n >= 0; --n) {
            switch (cArray[n]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (!bl) {
                        n2 = n - 1;
                        continue block10;
                    }
                    n3 = n + 1;
                    continue block10;
                }
                case '#': {
                    bl2 = true;
                    if (n3 == 0) {
                        n3 = n + 1;
                    }
                    n = 0;
                    continue block10;
                }
                default: {
                    bl = true;
                    n3 = 0;
                }
            }
        }
        if (!bl2) {
            throw new MCLParseException("invalid header, no header name found", n3);
        }
        int n4 = 0;
        n = n3;
        switch (n2 - n3) {
            case 4: {
                if (cArray[n] == 'n' && cArray[++n] == 'a' && cArray[++n] == 'm' && cArray[++n] == 'e') {
                    this.getValues(cArray, 2, n3 - 3);
                    n4 = 1;
                    break;
                }
                if (cArray[n] != 't' || cArray[++n] != 'y' || cArray[++n] != 'p' || cArray[++n] != 'e') break;
                this.getValues(cArray, 2, n3 - 3);
                n4 = 4;
                break;
            }
            case 6: {
                if (cArray[n] != 'l' || cArray[++n] != 'e' || cArray[++n] != 'n' || cArray[++n] != 'g' || cArray[++n] != 't' || cArray[++n] != 'h') break;
                this.getIntValues(cArray, 2, n3 - 3);
                n4 = 2;
                break;
            }
            case 9: {
                if (cArray[n] != 't' || cArray[++n] != 'y' || cArray[++n] != 'p' || cArray[++n] != 'e' || cArray[++n] != 's' || cArray[++n] != 'i' || cArray[++n] != 'z' || cArray[++n] != 'e' || cArray[++n] != 's') break;
                this.getValues(cArray, 2, n3 - 3);
                n4 = 5;
                break;
            }
            case 10: {
                if (cArray[n] != 't' || cArray[++n] != 'a' || cArray[++n] != 'b' || cArray[++n] != 'l' || cArray[++n] != 'e' || cArray[++n] != '_' || cArray[++n] != 'n' || cArray[++n] != 'a' || cArray[++n] != 'm' || cArray[++n] != 'e') break;
                this.getValues(cArray, 2, n3 - 3);
                n4 = 3;
                break;
            }
            default: {
                throw new MCLParseException("unknown header: " + new String(cArray, n3, n2 - n3));
            }
        }
        this.colnr = 0;
        return n4;
    }

    private void getValues(char[] cArray, int n, int n2) throws MCLParseException {
        int n3 = 0;
        for (int i = n; i < n2; i += 2) {
            String string;
            if (cArray[i] == '\"') {
                string = this.qsparser.parse(cArray, i, n2);
                i += this.qsparser.size;
            } else {
                int n4;
                for (n4 = i; n4 < n2 && cArray[n4] != ','; ++n4) {
                }
                string = new String(cArray, i, n4 - i);
                i = n4;
            }
            if (i != n2 && (i > n2 - 2 || cArray[i] != ',' || cArray[i + 1] != '\t')) {
                throw new MCLParseException("invalid separator", i);
            }
            if (n3 >= this.values.length) {
                throw new MCLParseException("too many values", i);
            }
            this.values[n3++] = string;
        }
        if (n3 != this.values.length) {
            throw new MCLParseException("not enough values", n2);
        }
    }

    private final void getIntValues(char[] cArray, int n, int n2) throws MCLParseException {
        int n3 = 0;
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            if (cArray[i] == ',' && cArray[i + 1] == '\t') {
                if (n3 < this.intValues.length) {
                    this.intValues[n3++] = n4;
                }
                n4 = 0;
                ++i;
                continue;
            }
            if (cArray[i] >= '0' && cArray[i] <= '9') {
                n4 *= 10;
                n4 += cArray[i] - 48;
                continue;
            }
            throw new MCLParseException("expected a digit in " + new String(cArray) + " at " + i);
        }
        if (n3 < this.intValues.length) {
            this.intValues[n3] = n4;
        }
    }
}

