/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.jdbc.types;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;

public final class Inet6
implements SQLData {
    private String inet6;

    @Override
    public String getSQLTypeName() {
        return "inet6";
    }

    @Override
    public void readSQL(SQLInput sQLInput, String string) throws SQLException {
        if (!"inet6".equals(string)) {
            throw new SQLException("can only use this class with 'inet6' type", "M1M05");
        }
        this.fromString(sQLInput.readString());
    }

    @Override
    public void writeSQL(SQLOutput sQLOutput) throws SQLException {
        sQLOutput.writeString(this.inet6);
    }

    public String toString() {
        return this.inet6;
    }

    public void fromString(String string) throws SQLException {
        InetAddress inetAddress;
        if (string == null) {
            this.inet6 = null;
            return;
        }
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new SQLDataException("could not resolve IP address", "22M29");
        }
        if (!(inetAddress instanceof Inet6Address)) {
            throw new SQLDataException("IPv6 address expected", "22M29");
        }
        this.inet6 = inetAddress.toString();
    }

    public String getAddress() {
        return this.inet6;
    }

    public void setAddress(String string) throws SQLException {
        this.fromString(string);
    }

    public InetAddress getInetAddress() throws SQLException {
        if (this.inet6 == null) {
            return null;
        }
        try {
            return InetAddress.getByName(this.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            throw new SQLDataException("could not resolve IP address", "22M29");
        }
    }

    public void setInetAddress(InetAddress inetAddress) throws SQLException {
        if (!(inetAddress instanceof Inet6Address)) {
            throw new SQLDataException("IPv6 address expected", "22M29");
        }
        this.fromString(inetAddress.getHostAddress());
    }
}

