/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.jdbc;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Wrapper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MonetWrapper
implements Wrapper {
    private static final Pattern dqPattern = Pattern.compile("\"");
    private static final Pattern sqPattern = Pattern.compile("[\\\\']");

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw new SQLException("Cannot unwrap to interface: " + (clazz != null ? clazz.getName() : ""), "0A000");
    }

    static final SQLFeatureNotSupportedException newSQLFeatureNotSupportedException(String string) {
        return new SQLFeatureNotSupportedException("Method " + string + " not implemented", "0A000");
    }

    public static final String dq(String string) {
        Matcher matcher = dqPattern.matcher(string);
        String string2 = matcher.replaceAll("\"$0");
        return "\"" + string2 + "\"";
    }

    public static final String sq(String string) {
        Matcher matcher = sqPattern.matcher(string);
        String string2 = matcher.replaceAll("\\\\$0");
        return "'" + string2 + "'";
    }
}

