/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.monetdb.jdbc.MonetConnection;
import org.monetdb.jdbc.MonetDriver;
import org.monetdb.jdbc.MonetResultSet;
import org.monetdb.jdbc.MonetWrapper;

final class MonetResultSetMetaData
extends MonetWrapper
implements ResultSetMetaData {
    private final MonetConnection conn;
    private final int colCount;
    private final String[] schemas;
    private final String[] tables;
    private final String[] columns;
    private final String[] types;
    private final int[] JdbcSQLTypes;
    private final int[] lengths;
    private final int[] precisions;
    private final int[] scales;
    private final int array_size;
    private final boolean[] _is_queried;
    private final boolean[] _is_fetched;
    private final int[] _isNullable;
    private final boolean[] _isAutoincrement;
    private int nextUpperbound;

    MonetResultSetMetaData(MonetConnection monetConnection, MonetConnection.ResultSetResponse resultSetResponse) throws IllegalArgumentException {
        if (monetConnection == null) {
            throw new IllegalArgumentException("Connection may not be null!");
        }
        if (resultSetResponse == null) {
            throw new IllegalArgumentException("Header may not be null!");
        }
        this.conn = monetConnection;
        this.schemas = resultSetResponse.getSchemaNames();
        this.tables = resultSetResponse.getTableNames();
        this.columns = resultSetResponse.getNames();
        this.types = resultSetResponse.getTypes();
        this.lengths = resultSetResponse.getColumnLengths();
        this.precisions = resultSetResponse.getColumnPrecisions();
        this.scales = resultSetResponse.getColumnScales();
        if (this.schemas == null) {
            throw new IllegalArgumentException("Schemas may not be null!");
        }
        if (this.tables == null) {
            throw new IllegalArgumentException("Tables may not be null!");
        }
        if (this.columns == null) {
            throw new IllegalArgumentException("Columns may not be null!");
        }
        if (this.types == null) {
            throw new IllegalArgumentException("MonetDB Types may not be null!");
        }
        if (this.lengths == null) {
            throw new IllegalArgumentException("Lengths may not be null!");
        }
        this.colCount = this.columns.length;
        if (this.columns.length != this.tables.length || this.columns.length != this.types.length) {
            throw new IllegalArgumentException("Inconsistent Header metadata");
        }
        this.JdbcSQLTypes = new int[this.types.length];
        for (int i = 0; i < this.types.length; ++i) {
            int n = MonetDriver.getJdbcSQLType(this.types[i]);
            if (n == 2005) {
                if (monetConnection.mapClobAsVarChar()) {
                    n = 12;
                }
            } else if (n == 2004 && monetConnection.mapBlobAsVarBinary()) {
                n = -3;
            }
            this.JdbcSQLTypes[i] = n;
        }
        this.array_size = this.colCount + 1;
        this._is_queried = new boolean[this.array_size];
        this._is_fetched = new boolean[this.array_size];
        this._isNullable = new int[this.array_size];
        this._isAutoincrement = new boolean[this.array_size];
        this.nextUpperbound = this.array_size;
    }

    MonetResultSetMetaData(MonetConnection monetConnection, int n, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) throws IllegalArgumentException {
        if (monetConnection == null) {
            throw new IllegalArgumentException("Connection may not be null!");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("Schemas may not be null!");
        }
        if (stringArray2 == null) {
            throw new IllegalArgumentException("Tables may not be null!");
        }
        if (stringArray3 == null) {
            throw new IllegalArgumentException("Columns may not be null!");
        }
        if (stringArray4 == null) {
            throw new IllegalArgumentException("MonetDB Types may not be null!");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("JDBC Types may not be null!");
        }
        if (nArray2 == null) {
            throw new IllegalArgumentException("Lengths may not be null!");
        }
        if (nArray3 == null) {
            throw new IllegalArgumentException("Precisions may not be null!");
        }
        if (nArray4 == null) {
            throw new IllegalArgumentException("Scales may not be null!");
        }
        if (stringArray3.length != stringArray2.length || stringArray3.length != stringArray4.length) {
            throw new IllegalArgumentException("Inconsistent Header metadata");
        }
        this.conn = monetConnection;
        this.colCount = n;
        this.schemas = stringArray;
        this.tables = stringArray2;
        this.columns = stringArray3;
        this.lengths = nArray2;
        this.types = stringArray4;
        this.JdbcSQLTypes = nArray;
        this.precisions = nArray3;
        this.scales = nArray4;
        this.array_size = this.colCount + 1;
        this._is_queried = new boolean[this.array_size];
        this._is_fetched = new boolean[this.array_size];
        this._isNullable = new int[this.array_size];
        this._isAutoincrement = new boolean[this.array_size];
        this.nextUpperbound = this.array_size;
    }

    @Override
    public int getColumnCount() {
        return this.colCount;
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        switch (this.getColumnType(n)) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                try {
                    if (!this._is_fetched[n]) {
                        this.fetchColumnInfo(n);
                    }
                    return this._isAutoincrement[n];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }
        }
        return false;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        switch (this.getColumnType(n)) {
            case 1: 
            case 2005: {
                return true;
            }
            case 12: {
                try {
                    String string = this.types[n - 1];
                    if ("inet".equals(string) || "inet4".equals(string) || "inet6".equals(string) || "uuid".equals(string)) {
                        return false;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        this.checkColumnIndexValidity(n);
        return true;
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        this.checkColumnIndexValidity(n);
        return false;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        this.checkColumnIndexValidity(n);
        try {
            if (!this._is_fetched[n]) {
                this.fetchColumnInfo(n);
            }
            return this._isNullable[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        switch (this.getColumnType(n)) {
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 93: 
            case 2014: {
                return true;
            }
            case -5: {
                try {
                    String string = this.types[n - 1];
                    if ("oid".equals(string) || "ptr".equals(string)) {
                        return false;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkColumnIndexValidity(n);
        try {
            int n2;
            String string = this.types[n - 1];
            if (string != null && string.endsWith("_interval")) {
                n2 = -1;
                if (this.precisions != null) {
                    n2 = this.precisions[n - 1];
                }
                switch (n2) {
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 6;
                    }
                    case 3: {
                        return 6;
                    }
                    case 4: {
                        return 9;
                    }
                    case 5: {
                        return 11;
                    }
                    case 6: {
                        return 13;
                    }
                    case 7: {
                        return 15;
                    }
                    case 8: {
                        return 11;
                    }
                    case 9: {
                        return 13;
                    }
                    case 10: {
                        return 15;
                    }
                    case 11: {
                        return 13;
                    }
                    case 12: {
                        return 15;
                    }
                    case 13: {
                        return 15;
                    }
                }
                if ("sec_interval".equals(string)) {
                    return 15;
                }
                if ("day_interval".equals(string)) {
                    return 9;
                }
                if ("month_interval".equals(string)) {
                    return 6;
                }
            }
            if ((n2 = this.lengths[n - 1]) == 0) {
                if ("inet".equals(string)) {
                    return 18;
                }
                if ("inet4".equals(string)) {
                    return 15;
                }
                if ("inet6".equals(string)) {
                    return 39;
                }
            }
            return n2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        this.checkColumnIndexValidity(n);
        try {
            return this.columns[n - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        this.checkColumnIndexValidity(n);
        return null;
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        this.checkColumnIndexValidity(n);
        try {
            return this.schemas[n - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public String getTableName(int n) throws SQLException {
        this.checkColumnIndexValidity(n);
        try {
            return this.tables[n - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        this.checkColumnIndexValidity(n);
        try {
            return this.JdbcSQLTypes[n - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        this.checkColumnIndexValidity(n);
        try {
            String string = this.types[n - 1];
            if (string != null && string.endsWith("_interval")) {
                int n2 = -1;
                if (this.precisions != null) {
                    n2 = this.precisions[n - 1];
                }
                switch (n2) {
                    case 1: {
                        return "interval year";
                    }
                    case 2: {
                        return "interval year to month";
                    }
                    case 3: {
                        return "interval month";
                    }
                    case 4: {
                        return "interval day";
                    }
                    case 5: {
                        return "interval day to hour";
                    }
                    case 6: {
                        return "interval day to minute";
                    }
                    case 7: {
                        return "interval day to second";
                    }
                    case 8: {
                        return "interval hour";
                    }
                    case 9: {
                        return "interval hour to minute";
                    }
                    case 10: {
                        return "interval hour to second";
                    }
                    case 11: {
                        return "interval minute";
                    }
                    case 12: {
                        return "interval minute to second";
                    }
                    case 13: {
                        return "interval second";
                    }
                }
                if ("day_interval".equals(string)) {
                    return "interval day";
                }
                if ("month_interval".equals(string)) {
                    return "interval month";
                }
                if ("sec_interval".equals(string)) {
                    return "interval second";
                }
            }
            return string;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        switch (this.getColumnType(n)) {
            case -5: {
                return 19;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 5;
            }
            case -6: {
                return 3;
            }
            case 7: {
                return 7;
            }
            case 6: 
            case 8: {
                return 15;
            }
            case 2: 
            case 3: {
                if (this.precisions != null) {
                    try {
                        String string = this.types[n - 1];
                        if (string != null && string.endsWith("_interval")) {
                            switch (this.precisions[n - 1]) {
                                case 1: {
                                    return 4;
                                }
                                case 2: {
                                    return 6;
                                }
                                case 3: {
                                    return 6;
                                }
                                case 4: {
                                    return 9;
                                }
                                case 5: {
                                    return 11;
                                }
                                case 6: {
                                    return 13;
                                }
                                case 7: {
                                    return 15;
                                }
                                case 8: {
                                    return 11;
                                }
                                case 9: {
                                    return 13;
                                }
                                case 10: {
                                    return 15;
                                }
                                case 11: {
                                    return 13;
                                }
                                case 12: {
                                    return 15;
                                }
                                case 13: {
                                    return 15;
                                }
                            }
                            if ("sec_interval".equals(string)) {
                                return 15;
                            }
                            if ("day_interval".equals(string)) {
                                return 9;
                            }
                            if ("month_interval".equals(string)) {
                                return 6;
                            }
                        }
                        return this.precisions[n - 1];
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                    }
                }
                return 18;
            }
            case 1: 
            case 12: 
            case 2005: {
                if (this.precisions != null) {
                    try {
                        int n2 = this.precisions[n - 1];
                        if (n2 <= 0) {
                            this.precisions[n - 1] = n2 = this.getColumnDisplaySize(n);
                        }
                        return n2;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                    }
                }
                return this.getColumnDisplaySize(n);
            }
            case -3: 
            case -2: 
            case 2004: {
                if (this.precisions != null) {
                    try {
                        int n3 = this.precisions[n - 1];
                        if (n3 <= 0) {
                            this.precisions[n - 1] = n3 = this.getColumnDisplaySize(n) / 2 + 1;
                        }
                        return n3;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                    }
                }
                return this.getColumnDisplaySize(n) / 2 + 1;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 15;
            }
            case 2013: {
                return 21;
            }
            case 93: {
                return 26;
            }
            case 2014: {
                return 32;
            }
            case 16: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int getScale(int n) throws SQLException {
        switch (this.getColumnType(n)) {
            case 2: 
            case 3: {
                try {
                    String string = this.types[n - 1];
                    if ("day_interval".equals(string)) {
                        return 0;
                    }
                    if ("sec_interval".equals(string)) {
                        return 3;
                    }
                    if (this.scales != null) {
                        return this.scales[n - 1];
                    }
                    return 0;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                try {
                    if (this.scales != null) {
                        return this.scales[n - 1];
                    }
                    return 6;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }
        }
        return 0;
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        this.checkColumnIndexValidity(n);
        return true;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        this.checkColumnIndexValidity(n);
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.checkColumnIndexValidity(n);
        return false;
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        this.checkColumnIndexValidity(n);
        try {
            Map<String, Class<?>> map;
            String string = this.types[n - 1];
            Class<?> clazz = null;
            if (this.conn != null && (map = this.conn.getTypeMap()) != null && map.containsKey(string)) {
                clazz = map.get(string);
            }
            if (clazz == null) {
                clazz = MonetDriver.getClassForType(this.JdbcSQLTypes[n - 1]);
            }
            if (clazz != null) {
                return clazz.getCanonicalName();
            }
            throw new SQLException("column type mapping null: " + string, "M0M03");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    private final void checkColumnIndexValidity(int n) throws SQLDataException {
        if (n < 1 || n > this.colCount) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    private final void fetchColumnInfo(int n) throws SQLException {
        this.checkColumnIndexValidity(n);
        if (!this._is_fetched[n]) {
            this.fetchManyColumnsInfo(n);
        }
        if (this._is_fetched[n]) {
            return;
        }
        this._isNullable[n] = 2;
        this._isAutoincrement[n] = false;
    }

    private final void fetchManyColumnsInfo(int n) throws SQLException {
        int n2 = n;
        if (n2 > 1 && n2 + 80 >= this.nextUpperbound) {
            n2 = this.nextUpperbound - 80;
            if (n2 < 1) {
                n2 = 1;
            } else if (n2 > n) {
                n2 = n;
            }
            this.nextUpperbound = n2;
        }
        StringBuilder stringBuilder = new StringBuilder(410 + Math.min(80, this.colCount) * 150);
        stringBuilder.append("SELECT s.\"name\" AS schnm, t.\"name\" AS tblnm, c.\"name\" AS colnm, cast(CASE c.\"null\" WHEN true THEN 1 WHEN false THEN 0 ELSE 2 END AS int) AS nullable, cast(CASE WHEN c.\"default\" IS NOT NULL AND c.\"default\" LIKE 'next value for %' THEN true ELSE false END AS boolean) AS isautoincrement FROM \"sys\".\"columns\" c JOIN \"sys\".\"tables\" t ON c.\"table_id\" = t.\"id\" JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" WHERE ");
        String string = null;
        String string2 = null;
        String string3 = null;
        int n3 = 0;
        for (int i = n2; i < this.array_size && n3 < 80; ++i) {
            if (this._is_fetched[i] || this._is_queried[i]) continue;
            this._isNullable[i] = 2;
            this._isAutoincrement[i] = false;
            string = this.getSchemaName(i);
            if (!(string == null || string.isEmpty() || (string2 = this.getTableName(i)) == null || string2.isEmpty() || (string3 = this.getColumnName(i)) == null || string3.isEmpty())) {
                if (n3 > 0) {
                    stringBuilder.append(" OR ");
                }
                stringBuilder.append("(s.\"name\" = ").append(MonetWrapper.sq(string));
                stringBuilder.append(" AND t.\"name\" = ").append(MonetWrapper.sq(string2));
                stringBuilder.append(" AND c.\"name\" = ").append(MonetWrapper.sq(string3));
                stringBuilder.append(")");
                this._is_queried[i] = true;
                ++n3;
            }
            if (this._is_queried[i]) continue;
            this._is_fetched[i] = true;
        }
        if (n3 == 0) {
            return;
        }
        Statement statement = this.conn.createStatement();
        if (statement != null) {
            ResultSet resultSet = statement.executeQuery(stringBuilder.toString());
            if (resultSet != null) {
                String string4 = null;
                String string5 = null;
                String string6 = null;
                while (resultSet.next()) {
                    string4 = resultSet.getString(1);
                    string5 = resultSet.getString(2);
                    string6 = resultSet.getString(3);
                    for (int i = 1; i < this.array_size; ++i) {
                        if (this._is_fetched[i] || !this._is_queried[i] || (string3 = this.getColumnName(i)) == null || !string3.equals(string6) || (string2 = this.getTableName(i)) == null || !string2.equals(string5) || (string = this.getSchemaName(i)) == null || !string.equals(string4)) continue;
                        this._isNullable[i] = resultSet.getInt(4);
                        this._isAutoincrement[i] = resultSet.getBoolean(5);
                        this._is_fetched[i] = true;
                        --n3;
                        i = this.array_size;
                    }
                }
                resultSet.close();
            }
            statement.close();
        }
        if (n3 != 0) {
            for (int i = n2; i < this.array_size; ++i) {
                if (this._is_fetched[i] || !this._is_queried[i]) continue;
                this._is_fetched[i] = true;
            }
        }
    }
}

