/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import org.monetdb.jdbc.MonetConnection;
import org.monetdb.jdbc.MonetDriver;
import org.monetdb.jdbc.MonetVersion;
import org.monetdb.jdbc.MonetWrapper;
import org.monetdb.mcl.net.ClientInfo;

public final class MonetDatabaseMetaData
extends MonetWrapper
implements DatabaseMetaData {
    private final MonetConnection con;
    private static final String FunctionsSelect = "SELECT DISTINCT CASE WHEN f.\"language\" > 0 THEN s.\"name\"||'.'||f.\"name\" ELSE f.\"name\" END FROM \"sys\".\"functions\" f JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" WHERE ";
    private static final String FunctionsWhere = "(f.\"id\" IN (SELECT \"func_id\" FROM \"sys\".\"args\" WHERE \"number\" = 1 AND \"name\" = 'arg_1' AND \"type\" IN ";
    private static final String OrFunctionsMaxMin = " OR f.\"name\" IN ('sql_max','sql_min','least','greatest')";
    private static final String FunctionsOrderBy1 = " ORDER BY 1";
    private static final String keyQuery = "SELECT cast(null AS char(1)) AS \"PKTABLE_CAT\", pkschema.\"name\" AS \"PKTABLE_SCHEM\", pktable.\"name\" AS \"PKTABLE_NAME\", pkkeycol.\"name\" AS \"PKCOLUMN_NAME\", cast(null AS char(1)) AS \"FKTABLE_CAT\", fkschema.\"name\" AS \"FKTABLE_SCHEM\", fktable.\"name\" AS \"FKTABLE_NAME\", fkkeycol.\"name\" AS \"FKCOLUMN_NAME\", cast(1 + \"pkkeycol\".\"nr\" AS smallint) AS \"KEY_SEQ\", cast(CASE ((fkkey.\"action\" >> 8) & 255) WHEN 0 THEN 3 WHEN 1 THEN 0 WHEN 2 THEN 1 WHEN 3 THEN 2 WHEN 4 THEN 4 ELSE 3 END AS smallint) AS \"UPDATE_RULE\", cast(CASE (fkkey.\"action\" & 255) WHEN 0 THEN 3 WHEN 1 THEN 0 WHEN 2 THEN 1 WHEN 3 THEN 2 WHEN 4 THEN 4 ELSE 3 END AS smallint) AS \"DELETE_RULE\", fkkey.\"name\" AS \"FK_NAME\", pkkey.\"name\" AS \"PK_NAME\", cast(7 AS smallint) AS \"DEFERRABILITY\" FROM \"sys\".\"keys\" pkkey JOIN \"sys\".\"objects\" pkkeycol ON pkkey.\"id\" = pkkeycol.\"id\" JOIN \"sys\".\"tables\" pktable ON pktable.\"id\" = pkkey.\"table_id\" JOIN \"sys\".\"schemas\" pkschema ON pkschema.\"id\" = pktable.\"schema_id\" JOIN \"sys\".\"keys\" fkkey ON fkkey.\"rkey\" = pkkey.\"id\" JOIN \"sys\".\"objects\" fkkeycol ON (fkkey.\"id\" = fkkeycol.\"id\" AND fkkeycol.\"nr\" = pkkeycol.\"nr\") JOIN \"sys\".\"tables\" fktable ON fktable.\"id\" = fkkey.\"table_id\" JOIN \"sys\".\"schemas\" fkschema ON fkschema.\"id\" = fktable.\"schema_id\" WHERE fkkey.\"rkey\" > 0";

    public MonetDatabaseMetaData(MonetConnection monetConnection) {
        this.con = monetConnection;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return false;
    }

    @Override
    public String getURL() throws SQLException {
        return this.con.getJDBCURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.con.getUserName();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public String getDatabaseProductName() {
        return "MonetDB";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.con.getDatabaseProductVersion();
    }

    @Override
    public String getDriverName() {
        return "MonetDB Native Driver";
    }

    @Override
    public String getDriverVersion() {
        return MonetVersion.driverVersion;
    }

    @Override
    public int getDriverMajorVersion() {
        return MonetVersion.majorVersion;
    }

    @Override
    public int getDriverMinorVersion() {
        return MonetVersion.minorVersion;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String getSQLKeywords() {
        return this.getConcatenatedStringFromQuery("SELECT \"keyword\" FROM \"sys\".\"keywords\" WHERE \"keyword\" NOT IN ('ABS','ALL','ALLOCATE','ALTER','AND','ANY','ARE','ARRAY','AS','ASENSITIVE','ASYMMETRIC','AT','ATOMIC','AUTHORIZATION','AVG','BEGIN','BETWEEN','BIGINT','BINARY','BLOB','BOOLEAN','BOTH','BY','CALL','CALLED','CARDINALITY','CASCADED','CASE','CAST','CEIL','CEILING','CHAR','CHARACTER','CHARACTER_LENGTH','CHAR_LENGTH','CHECK','CLOB','CLOSE','COALESCE','COLLATE','COLLECT','COLUMN','COMMIT','CONDITION','CONNECT','CONSTRAINT','CONVERT','CORR','CORRESPONDING','COUNT','COVAR_POP','COVAR_SAMP','CREATE','CROSS','CUBE','CUME_DIST','CURRENT','CURRENT_DATE','CURRENT_DEFAULT_TRANSFORM_GROUP','CURRENT_PATH','CURRENT_ROLE','CURRENT_TIME','CURRENT_TIMESTAMP','CURRENT_TRANSFORM_GROUP_FOR_TYPE','CURRENT_USER','CURSOR','CYCLE','DATE','DAY','DEALLOCATE','DEC','DECIMAL','DECLARE','DEFAULT','DELETE','DENSE_RANK','DEREF','DESCRIBE','DETERMINISTIC','DISCONNECT','DISTINCT','DOUBLE','DROP','DYNAMIC','EACH','ELEMENT','ELSE','END','END-EXEC','ESCAPE','EVERY','EXCEPT','EXEC','EXECUTE','EXISTS','EXP','EXTERNAL','EXTRACT','FALSE','FETCH','FILTER','FLOAT','FLOOR','FOR','FOREIGN','FREE','FROM','FULL','FUNCTION','FUSION','GET','GLOBAL','GRANT','GROUP','GROUPING','HAVING','HOLD','HOUR','IDENTITY','IN','INDICATOR','INNER','INOUT','INSENSITIVE','INSERT','INT','INTEGER','INTERSECT','INTERSECTION','INTERVAL','INTO','IS','JOIN','LANGUAGE','LARGE','LATERAL','LEADING','LEFT','LIKE','LN','LOCAL','LOCALTIME','LOCALTIMESTAMP','LOWER','MATCH','MAX','MEMBER','MERGE','METHOD','MIN','MINUTE','MOD','MODIFIES','MODULE','MONTH','MULTISET','NATIONAL','NATURAL','NCHAR','NCLOB','NEW','NO','NONE','NORMALIZE','NOT','NULL','NULLIF','NUMERIC','OCTET_LENGTH','OF','OLD','ON','ONLY','OPEN','OR','ORDER','OUT','OUTER','OVER','OVERLAPS','OVERLAY','PARAMETER','PARTITION','PERCENTILE_CONT','PERCENTILE_DISC','PERCENT_RANK','POSITION','POWER','PRECISION','PREPARE','PRIMARY','PROCEDURE','RANGE','RANK','READS','REAL','RECURSIVE','REF','REFERENCES','REFERENCING','REGR_AVGX','REGR_AVGY','REGR_COUNT','REGR_INTERCEPT','REGR_R2','REGR_SLOPE','REGR_SXX','REGR_SXY','REGR_SYY','RELEASE','RESULT','RETURN','RETURNS','REVOKE','RIGHT','ROLLBACK','ROLLUP','ROW','ROWS','ROW_NUMBER','SAVEPOINT','SCOPE','SCROLL','SEARCH','SECOND','SELECT','SENSITIVE','SESSION_USER','SET','SIMILAR','SMALLINT','SOME','SPECIFIC','SPECIFICTYPE','SQL','SQLEXCEPTION','SQLSTATE','SQLWARNING','SQRT','START','STATIC','STDDEV_POP','STDDEV_SAMP','SUBMULTISET','SUBSTRING','SUM','SYMMETRIC','SYSTEM','SYSTEM_USER','TABLE','TABLESAMPLE','THEN','TIME','TIMESTAMP','TIMEZONE_HOUR','TIMEZONE_MINUTE','TO','TRAILING','TRANSLATE','TRANSLATION','TREAT','TRIGGER','TRIM','TRUE','UESCAPE','UNION','UNIQUE','UNKNOWN','UNNEST','UPDATE','UPPER','USER','USING','VALUE','VALUES','VARCHAR','VARYING','VAR_POP','VAR_SAMP','WHEN','WHENEVER','WHERE','WIDTH_BUCKET','WINDOW','WITH','WITHIN','WITHOUT','YEAR') ORDER BY 1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getConcatenatedStringFromQuery(String string) {
        StringBuilder stringBuilder = new StringBuilder(1200);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.con.createStatement();
            resultSet = statement.executeQuery(string);
            boolean bl = true;
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                if (string2 == null) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string2);
            }
        }
        catch (SQLException sQLException) {
            MonetConnection.closeResultsetStatement(resultSet, statement);
            catch (Throwable throwable) {
                MonetConnection.closeResultsetStatement(resultSet, statement);
                throw throwable;
            }
        }
        MonetConnection.closeResultsetStatement(resultSet, statement);
        return stringBuilder.toString();
    }

    @Override
    public String getNumericFunctions() {
        return this.getConcatenatedStringFromQuery("SELECT DISTINCT CASE WHEN f.\"language\" > 0 THEN s.\"name\"||'.'||f.\"name\" ELSE f.\"name\" END FROM \"sys\".\"functions\" f JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" WHERE (f.\"id\" IN (SELECT \"func_id\" FROM \"sys\".\"args\" WHERE \"number\" = 1 AND \"name\" = 'arg_1' AND \"type\" IN ('tinyint','smallint','int','bigint','hugeint','decimal','double','real')) AND \"type\" = 1 AND f.\"name\" NOT IN ('code','not_uniques','rotate_xor_hash','space')) OR f.\"name\" IN ('alpha','degrees','fuse','ms_round','ms_str','ms_trunc','pi','radians') OR f.\"name\" IN ('sql_max','sql_min','least','greatest') ORDER BY 1");
    }

    @Override
    public String getStringFunctions() {
        return this.getConcatenatedStringFromQuery("SELECT DISTINCT CASE WHEN f.\"language\" > 0 THEN s.\"name\"||'.'||f.\"name\" ELSE f.\"name\" END FROM \"sys\".\"functions\" f JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" WHERE (f.\"id\" IN (SELECT \"func_id\" FROM \"sys\".\"args\" WHERE \"number\" = 1 AND \"name\" = 'arg_1' AND \"type\" IN ('char','varchar','clob','json','url')) AND \"type\" = 1 AND \"mod\" <> 'sql') OR (\"mod\" IN ('str','txtsim') AND \"type\" = 1) OR f.\"name\" IN ('isarray','isobject','isvalid','md5','ms_stuff','reverse') OR f.\"name\" IN ('sql_max','sql_min','least','greatest') UNION SELECT 'position' ORDER BY 1");
    }

    @Override
    public String getSystemFunctions() {
        String string = " UNION SELECT * FROM (VALUES('cast'),('coalesce'),('convert'),('ifnull'),('nullif')) as sf";
        if (!this.con.checkMinimumDBVersion(11, 47)) {
            string = string.replace(",('ifnull')", "");
        }
        return this.getConcatenatedStringFromQuery("SELECT DISTINCT CASE WHEN f.\"language\" > 0 THEN s.\"name\"||'.'||f.\"name\" ELSE f.\"name\" END FROM \"sys\".\"functions\" f JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" WHERE f.\"name\" IN ('columnsize','current_sessionid','database','debug','get_value_for','greatest','hash','hashsize','heapsize','ifthenelse','imprintsize','isaurl','isauuid','isnull','least','masterclock','mastertick','newurl','next_value_for','password_hash','replicaclock','replicatick','sql_max','sql_min','uuid')" + string + FunctionsOrderBy1);
    }

    @Override
    public String getTimeDateFunctions() {
        return this.getConcatenatedStringFromQuery("SELECT DISTINCT CASE WHEN f.\"language\" > 0 THEN s.\"name\"||'.'||f.\"name\" ELSE f.\"name\" END FROM \"sys\".\"functions\" f JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" WHERE \"mod\" IN ('mtime','timestamp') OR f.\"name\" IN ('localtime','localtimestamp','date_trunc','dayname','monthname') OR f.\"name\" IN ('sql_max','sql_min','least','greatest') UNION SELECT 'extract' UNION SELECT 'now' ORDER BY 1");
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return true;
    }

    @Override
    public boolean supportsConvert(int n, int n2) {
        switch (n) {
            case 16: {
                switch (n2) {
                    case -6: 
                    case -5: 
                    case 1: 
                    case 4: 
                    case 5: 
                    case 12: 
                    case 16: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 2004: {
                switch (n2) {
                    case 12: 
                    case 2004: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                switch (n2) {
                    case -6: 
                    case -5: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 2005: {
                        return true;
                    }
                }
                return false;
            }
            case 1: 
            case 12: 
            case 2005: {
                switch (n2) {
                    case -6: 
                    case -5: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2004: 
                    case 2005: 
                    case 2013: 
                    case 2014: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (n2) {
                    case 1: 
                    case 12: 
                    case 91: 
                    case 93: 
                    case 2005: 
                    case 2014: {
                        return true;
                    }
                }
                return false;
            }
            case 92: 
            case 2013: {
                switch (n2) {
                    case 1: 
                    case 12: 
                    case 92: 
                    case 2005: 
                    case 2013: {
                        return true;
                    }
                }
                return false;
            }
            case 93: 
            case 2014: {
                switch (n2) {
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2005: 
                    case 2013: 
                    case 2014: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return this.con.checkMinimumDBVersion(11, 51);
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return false;
    }

    @Override
    public String getSchemaTerm() {
        return "schema";
    }

    @Override
    public String getProcedureTerm() {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() {
        return "cat";
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public String getCatalogSeparator() {
        return null;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 1024;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 100000;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return this.con.getMaxConnections();
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 1024;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 256;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    @Override
    public int getMaxStatementLength() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 1024;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 1024;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 8;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) {
        return n != 0;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        boolean bl = this.con.commentsTableExists();
        StringBuilder stringBuilder = new StringBuilder(980);
        stringBuilder.append("SELECT cast(null as char(1)) AS \"PROCEDURE_CAT\", s.\"name\" AS \"PROCEDURE_SCHEM\", f.\"name\" AS \"PROCEDURE_NAME\", cast(null as char(1)) AS \"Field4\", cast(null as char(1)) AS \"Field5\", cast(null as char(1)) AS \"Field6\", ").append(bl ? "COALESCE(cm.\"remark\", cast(f.\"func\" as varchar(9999)))" : "cast(f.\"func\" as varchar(9999))").append(" AS \"REMARKS\", cast(1 AS smallint) AS \"PROCEDURE_TYPE\", cast(f.\"id\" as varchar(10)) AS \"SPECIFIC_NAME\" FROM \"sys\".\"functions\" f JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" ");
        if (bl) {
            stringBuilder.append("LEFT OUTER JOIN \"sys\".\"comments\" cm ON f.\"id\" = cm.\"id\" ");
        }
        stringBuilder.append("WHERE f.\"type\" = 2");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1=0");
        } else {
            if (string2 != null && !string2.equals("%")) {
                stringBuilder.append(" AND s.\"name\" ").append(this.composeMatchPart(string2));
            }
            if (string3 != null && !string3.equals("%")) {
                stringBuilder.append(" AND f.\"name\" ").append(this.composeMatchPart(string3));
            }
        }
        stringBuilder.append(" ORDER BY \"PROCEDURE_SCHEM\", \"PROCEDURE_NAME\", \"SPECIFIC_NAME\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(2900);
        stringBuilder.append("SELECT cast(null as char(1)) AS \"PROCEDURE_CAT\", s.\"name\" AS \"PROCEDURE_SCHEM\", f.\"name\" AS \"PROCEDURE_NAME\", a.\"name\" AS \"COLUMN_NAME\", cast(CASE a.\"inout\" WHEN 0 THEN (CASE a.\"number\" WHEN 0 THEN 5 ELSE 4 END) WHEN 1 THEN 1 ELSE 0 END AS smallint) AS \"COLUMN_TYPE\", cast(").append(MonetDriver.getSQLTypeMap("a.\"type\"")).append(" AS int) AS \"DATA_TYPE\", a.\"type\" AS \"TYPE_NAME\", CASE a.\"type\" WHEN 'tinyint' THEN 3 WHEN 'smallint' THEN 5 WHEN 'int' THEN 10 WHEN 'bigint' THEN 19 WHEN 'hugeint' THEN 38 WHEN 'oid' THEN 19 WHEN 'wrd' THEN 19 ELSE a.\"type_digits\" END AS \"PRECISION\", CASE a.\"type\" WHEN 'tinyint' THEN 1 WHEN 'smallint' THEN 2 WHEN 'int' THEN 4 WHEN 'bigint' THEN 8 WHEN 'hugeint' THEN 16 WHEN 'oid' THEN 8 WHEN 'wrd' THEN 8 ELSE a.\"type_digits\" END AS \"LENGTH\", cast(CASE WHEN a.\"type\" IN ('tinyint','smallint','int','bigint','hugeint','oid','wrd','decimal','numeric','time','timetz','timestamp','timestamptz','day_interval','month_interval','sec_interval') THEN a.\"type_scale\" ELSE NULL END AS smallint) AS \"SCALE\", cast(CASE WHEN a.\"type\" IN ('tinyint','smallint','int','bigint','hugeint','oid','wrd','decimal','numeric','day_interval','month_interval','sec_interval') THEN 10 WHEN a.\"type\" IN ('real','float','double') THEN 2 ELSE NULL END AS smallint) AS \"RADIX\", cast(").append(2).append(" AS smallint) AS \"NULLABLE\", cast(null as char(1)) AS \"REMARKS\", cast(null as char(1)) AS \"COLUMN_DEF\", cast(0 as int) AS \"SQL_DATA_TYPE\", cast(0 as int) AS \"SQL_DATETIME_SUB\", cast(CASE WHEN a.\"type\" IN ('varchar','clob','char','json','url','xml') THEN 4 * cast(a.\"type_digits\" as bigint) WHEN a.\"type\" = 'blob' THEN a.\"type_digits\" ELSE NULL END as bigint) AS \"CHAR_OCTET_LENGTH\", cast(a.\"number\" + 1 as int) AS \"ORDINAL_POSITION\", cast('' as varchar(3)) AS \"IS_NULLABLE\", cast(f.\"id\" as varchar(10)) AS \"SPECIFIC_NAME\" FROM \"sys\".\"args\" a JOIN \"sys\".\"functions\" f ON a.\"func_id\" = f.\"id\" JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" WHERE f.\"type\" = 2");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1=0");
        } else {
            if (string2 != null && !string2.equals("%")) {
                stringBuilder.append(" AND s.\"name\" ").append(this.composeMatchPart(string2));
            }
            if (string3 != null && !string3.equals("%")) {
                stringBuilder.append(" AND f.\"name\" ").append(this.composeMatchPart(string3));
            }
            if (string4 != null && !string4.equals("%")) {
                stringBuilder.append(" AND a.\"name\" ").append(this.composeMatchPart(string4));
            }
        }
        stringBuilder.append(" ORDER BY \"PROCEDURE_SCHEM\", \"PROCEDURE_NAME\", \"SPECIFIC_NAME\", \"ORDINAL_POSITION\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        boolean bl = this.con.commentsTableExists();
        StringBuilder stringBuilder = new StringBuilder(1600);
        stringBuilder.append("SELECT cast(null as char(1)) AS \"TABLE_CAT\", s.\"name\" AS \"TABLE_SCHEM\", t.\"name\" AS \"TABLE_NAME\", tt.\"table_type_name\" AS \"TABLE_TYPE\", ").append(bl ? "COALESCE(cm.\"remark\", t.\"query\")" : "t.\"query\"").append(" AS \"REMARKS\", cast(null as char(1)) AS \"TYPE_CAT\", cast(null as char(1)) AS \"TYPE_SCHEM\", cast(null as char(1)) AS \"TYPE_NAME\", cast(null as char(1)) AS \"SELF_REFERENCING_COL_NAME\", cast(null as char(1)) AS \"REF_GENERATION\" FROM \"sys\".\"tables\" t JOIN \"sys\".\"table_types\" tt ON t.\"type\" = tt.\"table_type_id\" JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" ");
        if (bl) {
            stringBuilder.append("LEFT OUTER JOIN \"sys\".\"comments\" cm ON t.\"id\" = cm.\"id\" ");
        }
        boolean bl2 = true;
        if (string != null && !string.isEmpty()) {
            stringBuilder.append("WHERE 1=0");
            bl2 = false;
        } else {
            if (string2 != null && !string2.equals("%")) {
                stringBuilder.append("WHERE s.\"name\" ").append(this.composeMatchPart(string2));
                bl2 = false;
            }
            if (string3 != null && !string3.equals("%")) {
                stringBuilder.append(bl2 ? "WHERE" : " AND").append(" t.\"name\" ").append(this.composeMatchPart(string3));
                bl2 = false;
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            boolean bl3 = false;
            stringBuilder.append(bl2 ? "WHERE" : " AND").append(" tt.\"table_type_name\" IN (");
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                if (string4 == null || string4.isEmpty()) continue;
                if ("BASE TABLE".equals(string4)) {
                    string4 = "TABLE";
                } else if ("GLOBAL TEMPORARY".equals(string4)) {
                    string4 = "GLOBAL TEMPORARY TABLE";
                } else if ("LOCAL TEMPORARY".equals(string4)) {
                    string4 = "LOCAL TEMPORARY TABLE";
                }
                if (bl3) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(MonetWrapper.sq(string4));
                bl3 = true;
            }
            if (!bl3) {
                stringBuilder.append("''");
            }
            stringBuilder.append(')');
        }
        stringBuilder.append(" ORDER BY \"TABLE_TYPE\", \"TABLE_SCHEM\", \"TABLE_NAME\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(170);
        stringBuilder.append("SELECT \"name\" AS \"TABLE_SCHEM\", cast(null as char(1)) AS \"TABLE_CATALOG\" FROM \"sys\".\"schemas\" ");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append("WHERE 1=0");
        } else if (string2 != null && !string2.equals("%")) {
            stringBuilder.append("WHERE \"name\" ").append(this.composeMatchPart(string2));
        }
        stringBuilder.append(" ORDER BY \"TABLE_SCHEM\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.executeMetaDataQuery("SELECT cast(null as char(1)) AS \"TABLE_CAT\" WHERE 1=0");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return this.executeMetaDataQuery("SELECT \"table_type_name\" AS \"TABLE_TYPE\" FROM \"sys\".\"table_types\" ORDER BY 1");
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        boolean bl = this.con.commentsTableExists();
        StringBuilder stringBuilder = new StringBuilder(2450);
        stringBuilder.append("SELECT cast(null as char(1)) AS \"TABLE_CAT\", s.\"name\" AS \"TABLE_SCHEM\", t.\"name\" AS \"TABLE_NAME\", c.\"name\" AS \"COLUMN_NAME\", cast(").append(MonetDriver.getSQLTypeMap("c.\"type\"")).append(" AS int) AS \"DATA_TYPE\", c.\"type\" AS \"TYPE_NAME\", c.\"type_digits\" AS \"COLUMN_SIZE\", cast(0 as int) AS \"BUFFER_LENGTH\", c.\"type_scale\" AS \"DECIMAL_DIGITS\", cast(CASE WHEN c.\"type\" IN ('decimal','numeric','day_interval','month_interval','sec_interval') THEN 10 WHEN c.\"type\" IN ('int','smallint','tinyint','bigint','hugeint','float','real','double','oid','wrd') THEN 2 ELSE 0 END AS int) AS \"NUM_PREC_RADIX\", cast(CASE c.\"null\" WHEN true THEN 1 WHEN false THEN 0 ELSE 2 END AS int) AS \"NULLABLE\", ").append(bl ? "cm.\"remark\"" : "cast(null AS varchar(9999))").append(" AS \"REMARKS\", c.\"default\" AS \"COLUMN_DEF\", cast(0 as int) AS \"SQL_DATA_TYPE\", cast(0 as int) AS \"SQL_DATETIME_SUB\", cast(CASE WHEN c.\"type\" IN ('varchar','clob','char','json','url','xml') THEN 4 * cast(c.\"type_digits\" as bigint) ELSE NULL END as bigint) AS \"CHAR_OCTET_LENGTH\", cast(c.\"number\" + 1 as int) AS \"ORDINAL_POSITION\", cast(CASE c.\"null\" WHEN true THEN 'YES' WHEN false THEN 'NO' ELSE '' END AS varchar(3)) AS \"IS_NULLABLE\", cast(null AS char(1)) AS \"SCOPE_CATALOG\", cast(null AS char(1)) AS \"SCOPE_SCHEMA\", cast(null AS char(1)) AS \"SCOPE_TABLE\", cast(null AS smallint) AS \"SOURCE_DATA_TYPE\", cast(CASE WHEN c.\"default\" IS NOT NULL AND c.\"default\" LIKE 'next value for %' THEN 'YES' ELSE 'NO' END AS varchar(3)) AS \"IS_AUTOINCREMENT\", cast('NO' AS varchar(3)) AS \"IS_GENERATEDCOLUMN\" FROM \"sys\".\"columns\" c JOIN \"sys\".\"tables\" t ON c.\"table_id\" = t.\"id\" JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" ");
        if (bl) {
            stringBuilder.append("LEFT OUTER JOIN \"sys\".\"comments\" cm ON c.\"id\" = cm.\"id\" ");
        }
        if (string != null && !string.isEmpty()) {
            stringBuilder.append("WHERE 1=0");
        } else {
            boolean bl2 = true;
            if (string2 != null && !string2.equals("%")) {
                stringBuilder.append("WHERE s.\"name\" ").append(this.composeMatchPart(string2));
                bl2 = false;
            }
            if (string3 != null && !string3.equals("%")) {
                stringBuilder.append(bl2 ? "WHERE" : " AND").append(" t.\"name\" ").append(this.composeMatchPart(string3));
                bl2 = false;
            }
            if (string4 != null && !string4.equals("%")) {
                stringBuilder.append(bl2 ? "WHERE" : " AND").append(" c.\"name\" ").append(this.composeMatchPart(string4));
            }
        }
        stringBuilder.append(" ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"ORDINAL_POSITION\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        boolean bl = this.con.privilege_codesTableExists();
        StringBuilder stringBuilder = new StringBuilder(1100);
        stringBuilder.append("SELECT cast(null as char(1)) AS \"TABLE_CAT\", s.\"name\" AS \"TABLE_SCHEM\", t.\"name\" AS \"TABLE_NAME\", c.\"name\" AS \"COLUMN_NAME\", grantors.\"name\" AS \"GRANTOR\", grantees.\"name\" AS \"GRANTEE\", ").append(bl ? "pc.\"privilege_code_name\"" : "cast(CASE p.\"privileges\" WHEN 1 THEN 'SELECT' WHEN 2 THEN 'UPDATE' WHEN 4 THEN 'INSERT' WHEN 8 THEN 'DELETE' WHEN 16 THEN 'EXECUTE' WHEN 32 THEN 'GRANT' ELSE NULL END AS varchar(7))").append(" AS \"PRIVILEGE\", cast(CASE p.\"grantable\" WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END AS varchar(3)) AS \"IS_GRANTABLE\" FROM \"sys\".\"privileges\" p JOIN \"sys\".\"columns\" c ON p.\"obj_id\" = c.\"id\" JOIN \"sys\".\"tables\" t ON c.\"table_id\" = t.\"id\" JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" JOIN \"sys\".\"auths\" grantors ON p.\"grantor\" = grantors.\"id\" JOIN \"sys\".\"auths\" grantees ON p.\"auth_id\" = grantees.\"id\" ");
        if (bl) {
            stringBuilder.append("JOIN \"sys\".\"privilege_codes\" pc ON p.\"privileges\" = pc.\"privilege_code_id\" ");
        }
        if (string != null && !string.isEmpty()) {
            stringBuilder.append("WHERE 1=0");
        } else {
            boolean bl2 = true;
            if (string2 != null && !string2.equals("%")) {
                stringBuilder.append("WHERE s.\"name\" ").append(this.composeMatchPart(string2));
                bl2 = false;
            }
            if (string3 != null && !string3.equals("%")) {
                stringBuilder.append(bl2 ? "WHERE" : " AND").append(" t.\"name\" ").append(this.composeMatchPart(string3));
                bl2 = false;
            }
            if (string4 != null && !string4.equals("%")) {
                stringBuilder.append(bl2 ? "WHERE" : " AND").append(" c.\"name\" ").append(this.composeMatchPart(string4));
            }
        }
        stringBuilder.append(" ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"COLUMN_NAME\", \"PRIVILEGE\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        boolean bl = this.con.privilege_codesTableExists();
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append("SELECT cast(null as char(1)) AS \"TABLE_CAT\", s.\"name\" AS \"TABLE_SCHEM\", t.\"name\" AS \"TABLE_NAME\", grantors.\"name\" AS \"GRANTOR\", grantees.\"name\" AS \"GRANTEE\", ").append(bl ? "pc.\"privilege_code_name\"" : "cast(CASE p.\"privileges\" WHEN 1 THEN 'SELECT' WHEN 2 THEN 'UPDATE' WHEN 4 THEN 'INSERT' WHEN 8 THEN 'DELETE' WHEN 16 THEN 'EXECUTE' WHEN 32 THEN 'GRANT' ELSE NULL END AS varchar(7))").append(" AS \"PRIVILEGE\", cast(CASE p.\"grantable\" WHEN 0 THEN 'NO' WHEN 1 THEN 'YES' ELSE NULL END AS varchar(3)) AS \"IS_GRANTABLE\" FROM \"sys\".\"privileges\" p JOIN \"sys\".\"tables\" t ON p.\"obj_id\" = t.\"id\" JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" JOIN \"sys\".\"auths\" grantors ON p.\"grantor\" = grantors.\"id\" JOIN \"sys\".\"auths\" grantees ON p.\"auth_id\" = grantees.\"id\" ");
        if (bl) {
            stringBuilder.append("JOIN \"sys\".\"privilege_codes\" pc ON p.\"privileges\" = pc.\"privilege_code_id\" ");
        }
        if (string != null && !string.isEmpty()) {
            stringBuilder.append("WHERE 1=0");
        } else {
            boolean bl2 = true;
            if (string2 != null && !string2.equals("%")) {
                stringBuilder.append("WHERE s.\"name\" ").append(this.composeMatchPart(string2));
                bl2 = false;
            }
            if (string3 != null && !string3.equals("%")) {
                stringBuilder.append(bl2 ? "WHERE" : " AND").append(" t.\"name\" ").append(this.composeMatchPart(string3));
            }
        }
        stringBuilder.append(" ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"PRIVILEGE\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        boolean bl2 = string2 == null || string2 != null && ("tmp".equals(string2) || string2.contains("%") || string2.contains("_"));
        StringBuilder stringBuilder = new StringBuilder(3000);
        stringBuilder.append("with syskeys as (SELECT \"id\", \"table_id\" FROM \"sys\".\"keys\" WHERE \"type\" = 0 UNION ALL SELECT \"id\", \"table_id\" FROM \"sys\".\"keys\" WHERE \"type\" IN (1, 3) AND \"table_id\" NOT IN (select \"table_id\" from \"sys\".\"keys\" where \"type\" = 0) AND (\"table_id\", \"id\") IN (select \"table_id\", min(\"id\") from \"sys\".\"keys\" where \"type\" IN (1, 3) group by \"table_id\"))");
        if (bl2) {
            stringBuilder.append(", tmpkeys as (SELECT \"id\", \"table_id\" FROM \"tmp\".\"keys\" WHERE \"type\" = 0 UNION ALL SELECT \"id\", \"table_id\" FROM \"tmp\".\"keys\" WHERE \"type\" IN (1, 3) AND \"table_id\" NOT IN (select \"table_id\" from \"tmp\".\"keys\" where \"type\" = 0) AND (\"table_id\", \"id\") IN (select \"table_id\", min(\"id\") from \"tmp\".\"keys\" where \"type\" IN (1, 3) group by \"table_id\"))");
        }
        stringBuilder.append(", tableids as (SELECT t.\"id\" FROM \"sys\".\"tables\" t JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" WHERE t.\"type\" NOT IN (1, 11)");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1=0");
        } else if (n == 2 || n == 1 || n == 0) {
            if (string2 != null) {
                stringBuilder.append(" AND s.\"name\" = ").append(MonetWrapper.sq(string2));
            }
            if (string3 != null) {
                stringBuilder.append(" AND t.\"name\" = ").append(MonetWrapper.sq(string3));
            }
        } else {
            stringBuilder.append(" AND 1=0");
        }
        stringBuilder.append("), cols as (SELECT c.\"name\", c.\"type\", c.\"type_digits\", c.\"type_scale\", o.\"nr\" FROM syskeys k JOIN tableids t ON k.\"table_id\" = t.\"id\" JOIN \"sys\".\"objects\" o ON k.\"id\" = o.\"id\" JOIN \"sys\".\"_columns\" c ON (k.\"table_id\" = c.\"table_id\" AND o.\"name\" = c.\"name\")");
        if (!bl) {
            stringBuilder.append(" WHERE c.\"null\" = false");
        }
        if (bl2) {
            stringBuilder.append(" UNION ALL SELECT c.\"name\", c.\"type\", c.\"type_digits\", c.\"type_scale\", o.\"nr\" FROM tmpkeys k JOIN tableids t ON k.\"table_id\" = t.\"id\" JOIN \"tmp\".\"objects\" o ON k.\"id\" = o.\"id\" JOIN \"tmp\".\"_columns\" c ON (k.\"table_id\" = c.\"table_id\" AND o.\"name\" = c.\"name\")");
            if (!bl) {
                stringBuilder.append(" WHERE c.\"null\" = false");
            }
        }
        stringBuilder.append(" UNION ALL SELECT c.\"name\", c.\"type\", c.\"type_digits\", c.\"type_scale\", c.\"number\" FROM tableids t JOIN \"sys\".\"_columns\" c ON t.\"id\" = c.\"table_id\" WHERE t.\"id\" NOT IN (SELECT \"table_id\" FROM \"sys\".\"keys\" WHERE \"type\" in (0, 1, 3))");
        if (!bl) {
            stringBuilder.append(" AND c.\"null\" = false");
        }
        if (bl2) {
            stringBuilder.append(" UNION ALL SELECT c.\"name\", c.\"type\", c.\"type_digits\", c.\"type_scale\", c.\"number\" FROM tableids t JOIN \"tmp\".\"_columns\" c ON t.\"id\" = c.\"table_id\" WHERE t.\"id\" NOT IN (SELECT \"table_id\" FROM \"tmp\".\"keys\" WHERE \"type\" in (0, 1, 3))");
            if (!bl) {
                stringBuilder.append(" AND c.\"null\" = false");
            }
        }
        stringBuilder.append(") SELECT cast(2 AS smallint) AS \"SCOPE\", c.\"name\" AS \"COLUMN_NAME\", cast(").append(MonetDriver.getSQLTypeMap("c.\"type\"")).append(" AS int) AS \"DATA_TYPE\", c.\"type\" AS \"TYPE_NAME\", c.\"type_digits\" AS \"COLUMN_SIZE\", cast(0 as int) AS \"BUFFER_LENGTH\", cast(c.\"type_scale\" AS smallint) AS \"DECIMAL_DIGITS\", cast(1 AS smallint) AS \"PSEUDO_COLUMN\" FROM cols c ORDER BY \"SCOPE\", c.\"nr\", \"COLUMN_NAME\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        return this.executeMetaDataQuery("SELECT cast(0 as smallint) AS \"SCOPE\", cast(null as char(1)) AS \"COLUMN_NAME\", cast(0 as int) AS \"DATA_TYPE\", cast(null as char(1)) AS \"TYPE_NAME\", cast(0 as int) AS \"COLUMN_SIZE\", cast(0 as int) AS \"BUFFER_LENGTH\", cast(0 as smallint) AS \"DECIMAL_DIGITS\", cast(0 as smallint) AS \"PSEUDO_COLUMN\" WHERE 1=0");
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder(1200);
        stringBuilder.append("SELECT cast(null AS char(1)) AS \"TABLE_CAT\", s.\"name\" AS \"TABLE_SCHEM\", t.\"name\" AS \"TABLE_NAME\", o.\"name\" AS \"COLUMN_NAME\", cast(1 + o.\"nr\" AS smallint) AS \"KEY_SEQ\", k.\"name\" AS \"PK_NAME\" FROM \"sys\".\"keys\" k JOIN \"sys\".\"objects\" o ON k.\"id\" = o.\"id\" JOIN \"sys\".\"_tables\" t ON k.\"table_id\" = t.\"id\" JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" WHERE k.\"type\" = 0");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1=0");
        } else {
            if (string2 != null && !string2.equals("%")) {
                stringBuilder.append(" AND s.\"name\" ").append(this.composeMatchPart(string2));
            }
            if (string3 != null && !string3.equals("%")) {
                stringBuilder.append(" AND t.\"name\" ").append(this.composeMatchPart(string3));
            }
        }
        boolean bl2 = bl = string2 == null || string2 != null && ("tmp".equals(string2) || string2.contains("%") || string2.contains("_"));
        if (bl) {
            stringBuilder.append(" UNION ALL ");
            stringBuilder.append("SELECT cast(null AS char(1)) AS \"TABLE_CAT\", s.\"name\" AS \"TABLE_SCHEM\", t.\"name\" AS \"TABLE_NAME\", o.\"name\" AS \"COLUMN_NAME\", cast(1 + o.\"nr\" AS smallint) AS \"KEY_SEQ\", k.\"name\" AS \"PK_NAME\" FROM \"tmp\".\"keys\" k JOIN \"tmp\".\"objects\" o ON k.\"id\" = o.\"id\" JOIN \"tmp\".\"_tables\" t ON k.\"table_id\" = t.\"id\" JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" WHERE k.\"type\" = 0");
            if (string != null && !string.isEmpty()) {
                stringBuilder.append(" AND 1=0");
            } else {
                if (string2 != null && !string2.equals("%")) {
                    stringBuilder.append(" AND s.\"name\" ").append(this.composeMatchPart(string2));
                }
                if (string3 != null && !string3.equals("%")) {
                    stringBuilder.append(" AND t.\"name\" ").append(this.composeMatchPart(string3));
                }
            }
        }
        stringBuilder.append(" ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"COLUMN_NAME\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(keyQuery.length() + 250);
        stringBuilder.append(keyQuery);
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1=0");
        } else {
            if (string2 != null && !string2.equals("%")) {
                stringBuilder.append(" AND fkschema.\"name\" ").append(this.composeMatchPart(string2));
            }
            if (string3 != null && !string3.equals("%")) {
                stringBuilder.append(" AND fktable.\"name\" ").append(this.composeMatchPart(string3));
            }
        }
        stringBuilder.append(" ORDER BY \"PKTABLE_SCHEM\", \"PKTABLE_NAME\", \"PK_NAME\", \"FKTABLE_SCHEM\", \"FKTABLE_NAME\", \"FK_NAME\", \"KEY_SEQ\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(keyQuery.length() + 250);
        stringBuilder.append(keyQuery);
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1=0");
        } else {
            if (string2 != null && !string2.equals("%")) {
                stringBuilder.append(" AND pkschema.\"name\" ").append(this.composeMatchPart(string2));
            }
            if (string3 != null && !string3.equals("%")) {
                stringBuilder.append(" AND pktable.\"name\" ").append(this.composeMatchPart(string3));
            }
        }
        stringBuilder.append(" ORDER BY \"FKTABLE_SCHEM\", \"FKTABLE_NAME\", \"FK_NAME\", \"PKTABLE_SCHEM\", \"PKTABLE_NAME\", \"PK_NAME\", \"KEY_SEQ\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(keyQuery.length() + 350);
        stringBuilder.append(keyQuery);
        if (string != null && !string.isEmpty() || string4 != null && !string4.isEmpty()) {
            stringBuilder.append(" AND 1=0");
        } else {
            if (string2 != null && !string2.equals("%")) {
                stringBuilder.append(" AND pkschema.\"name\" ").append(this.composeMatchPart(string2));
            }
            if (string3 != null && !string3.equals("%")) {
                stringBuilder.append(" AND pktable.\"name\" ").append(this.composeMatchPart(string3));
            }
            if (string5 != null && !string5.equals("%")) {
                stringBuilder.append(" AND fkschema.\"name\" ").append(this.composeMatchPart(string5));
            }
            if (string6 != null && !string6.equals("%")) {
                stringBuilder.append(" AND fktable.\"name\" ").append(this.composeMatchPart(string6));
            }
        }
        stringBuilder.append(" ORDER BY \"FKTABLE_SCHEM\", \"FKTABLE_NAME\", \"FK_NAME\", \"PKTABLE_SCHEM\", \"PKTABLE_NAME\", \"PK_NAME\", \"KEY_SEQ\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(4816);
        stringBuilder.append("SELECT \"sqlname\" AS \"TYPE_NAME\", cast(").append(MonetDriver.getSQLTypeMap("\"sqlname\"")).append(" AS int) AS \"DATA_TYPE\", cast(CASE WHEN \"sqlname\" IN ('time','timetz','timestamp','timestamptz') THEN \"digits\" -1 ELSE \"digits\" END AS int) AS \"PRECISION\", cast(CASE WHEN \"sqlname\" IN ('char','varchar') THEN '''' WHEN \"sqlname\" IN ('clob','inet','inet4','inet6','json','url','uuid','date','time','timetz','timestamp','timestamptz','blob','sqlblob','xml') THEN \"sqlname\"||' ''' ELSE NULL END AS varchar(16)) AS \"LITERAL_PREFIX\", cast(CASE WHEN \"sqlname\" IN ('char','varchar','clob','inet','inet4','inet6','json','url','uuid','date','time','timetz','timestamp','timestamptz','blob','sqlblob','xml') THEN '''' ELSE NULL END AS varchar(2)) AS \"LITERAL_SUFFIX\", CASE WHEN \"sqlname\" IN ('char','varchar') THEN 'max length' WHEN \"sqlname\" = 'decimal' THEN 'precision, scale' WHEN \"sqlname\" IN ('time','timetz','timestamp','timestamptz') THEN 'scale' ELSE NULL END AS \"CREATE_PARAMS\", cast(CASE WHEN \"systemname\" = 'oid' THEN 0 ELSE 1 END AS smallint) AS \"NULLABLE\", CASE WHEN \"systemname\" IN ('str','json','url','xml') THEN true ELSE false END AS \"CASE_SENSITIVE\", cast(3 AS smallint) AS \"SEARCHABLE\", CASE WHEN \"sqlname\" IN ('tinyint','smallint','int','bigint','hugeint','decimal','real','double') THEN false ELSE true END AS \"UNSIGNED_ATTRIBUTE\", CASE \"sqlname\" WHEN 'decimal' THEN true ELSE false END AS \"FIXED_PREC_SCALE\", false AS \"AUTO_INCREMENT\", \"systemname\" AS \"LOCAL_TYPE_NAME\", cast(0 AS smallint) AS \"MINIMUM_SCALE\", cast(CASE WHEN \"sqlname\" = 'decimal' THEN (CASE \"systemname\" WHEN 'int' THEN 9 WHEN 'lng' THEN 18 WHEN 'sht' THEN 4 WHEN 'hge' THEN 38 WHEN 'bte' THEN 2 ELSE 0 END) WHEN \"sqlname\" IN ('time','timetz','timestamp','timestamptz') THEN 6 ELSE 0 END AS smallint) AS \"MAXIMUM_SCALE\", cast(0 AS int) AS \"SQL_DATA_TYPE\", cast(0 AS int) AS \"SQL_DATETIME_SUB\", cast(CASE WHEN \"sqlname\" IN ('time','timetz','timestamp','timestamptz') THEN 10 ELSE \"radix\" END AS int) AS \"NUM_PREC_RADIX\" FROM \"sys\".\"types\" WHERE \"sqlname\" NOT IN ('sec_interval','day_interval','month_interval') UNION ALL SELECT \"TYPE_NAME\", 1111 AS \"DATA_TYPE\", PRECISION, 'interval ''' AS LITERAL_PREFIX, LITERAL_SUFFIX, CREATE_PARAMS, 1 AS NULLABLE, false AS CASE_SENSITIVE, 2 AS SEARCHABLE, false AS UNSIGNED_ATTRIBUTE, false AS FIXED_PREC_SCALE, false AS \"AUTO_INCREMENT\", LOCAL_TYPE_NAME, 0 AS MINIMUM_SCALE, MAXIMUM_SCALE, 0 AS SQL_DATA_TYPE, 0 AS SQL_DATETIME_SUB, 10 AS NUM_PREC_RADIX FROM (VALUES ('interval year', 6, ''' year', CAST(NULL AS VARCHAR(5)), 'month_interval', 0),('interval month', 8, ''' month', NULL, 'month_interval', 0),('interval day', 10, ''' day', NULL, 'day_interval', 0),('interval hour', 12, ''' hour', NULL, 'sec_interval', 0),('interval minute', 12, ''' minute', NULL, 'sec_interval', 0),('interval second', 15, ''' second', 'scale', 'sec_interval', 3),('interval year to month', 8, ''' year to month', NULL, 'month_interval', 0),('interval day to hour', 12, ''' day to hour', NULL, 'sec_interval', 0),('interval day to minute', 12, ''' day to minute', NULL, 'sec_interval', 0),('interval day to second', 15, ''' day to second', 'scale', 'sec_interval', 3),('interval hour to minute', 12, ''' hour to minute', NULL, 'sec_interval', 0),('interval hour to second', 15, ''' hour to second', 'scale', 'sec_interval', 3),('interval minute to second', 15, ''' minute to second', 'scale', 'sec_interval', 3)) AS interval_types(\"TYPE_NAME\", PRECISION, LITERAL_SUFFIX, CREATE_PARAMS, LOCAL_TYPE_NAME, MAXIMUM_SCALE) UNION ALL SELECT \"TYPE_NAME\", \"DATA_TYPE\", PRECISION, NULL AS LITERAL_PREFIX, NULL AS LITERAL_SUFFIX, NULL AS CREATE_PARAMS, 0 AS NULLABLE, false AS CASE_SENSITIVE, 3 AS SEARCHABLE, false AS UNSIGNED_ATTRIBUTE, false AS FIXED_PREC_SCALE, true AS \"AUTO_INCREMENT\", LOCAL_TYPE_NAME, 0 AS MINIMUM_SCALE, 0 AS MAXIMUM_SCALE, 0 AS SQL_DATA_TYPE, 0 AS SQL_DATETIME_SUB, 2 AS NUM_PREC_RADIX FROM (VALUES ('bigserial', -5, 63, 'bigint'),('serial', 4, 31, 'int')) AS serial_types(\"TYPE_NAME\", \"DATA_TYPE\", PRECISION, LOCAL_TYPE_NAME) ORDER BY \"DATA_TYPE\", \"TYPE_NAME\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        boolean bl3;
        Object object;
        String string4 = "0";
        if (!(bl2 || string2 == null || string2.isEmpty() || string2.contains("%") || string3 == null || string3.isEmpty() || string3.contains("%"))) {
            object = null;
            try {
                String string5;
                object = this.executeMetaDataQuery("SELECT COUNT(*) FROM \"" + string2 + "\".\"" + string3 + "\"");
                if (object != null && object.next() && (string5 = object.getString(1)) != null && !string5.isEmpty()) {
                    string4 = string5;
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                MonetConnection.closeResultsetStatement((ResultSet)object, null);
            }
        }
        object = new StringBuilder(2500);
        ((StringBuilder)object).append("SELECT cast(null AS char(1)) AS \"TABLE_CAT\", s.\"name\" AS \"TABLE_SCHEM\", t.\"name\" AS \"TABLE_NAME\", CASE WHEN k.\"name\" IS NULL THEN true ELSE false END AS \"NON_UNIQUE\", cast(null AS char(1)) AS \"INDEX_QUALIFIER\", i.\"name\" AS \"INDEX_NAME\", CASE i.\"type\" WHEN 0 THEN 2 ELSE 3 END AS \"TYPE\", cast(o.\"nr\" +1 AS smallint) AS \"ORDINAL_POSITION\", c.\"name\" AS \"COLUMN_NAME\", cast(null AS char(1)) AS \"ASC_OR_DESC\", cast(").append(string4).append(" AS int) AS \"CARDINALITY\", cast(0 AS int) AS \"PAGES\", cast(null AS char(1)) AS \"FILTER_CONDITION\" FROM \"sys\".\"idxs\" i JOIN \"sys\".\"_tables\" t ON i.\"table_id\" = t.\"id\" JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" JOIN \"sys\".\"objects\" o ON i.\"id\" = o.\"id\" JOIN \"sys\".\"_columns\" c ON (t.\"id\" = c.\"table_id\" AND o.\"name\" = c.\"name\") LEFT OUTER JOIN \"sys\".\"keys\" k ON (i.\"name\" = k.\"name\" AND i.\"table_id\" = k.\"table_id\" AND k.\"type\" IN (0, 1, 3)) ");
        if (string != null && !string.isEmpty()) {
            ((StringBuilder)object).append("WHERE 1=0");
        } else {
            boolean bl4 = true;
            if (string2 != null && !string2.equals("%")) {
                ((StringBuilder)object).append("WHERE s.\"name\" ").append(this.composeMatchPart(string2));
                bl4 = false;
            }
            if (string3 != null && !string3.equals("%")) {
                ((StringBuilder)object).append(bl4 ? "WHERE" : " AND").append(" t.\"name\" ").append(this.composeMatchPart(string3));
                bl4 = false;
            }
            if (bl) {
                ((StringBuilder)object).append(bl4 ? "WHERE" : " AND").append(" k.\"name\" IS NOT NULL");
            }
        }
        boolean bl5 = bl3 = string2 == null || string2 != null && ("tmp".equals(string2) || string2.contains("%") || string2.contains("_"));
        if (bl3) {
            ((StringBuilder)object).append(" UNION ALL ");
            ((StringBuilder)object).append("SELECT cast(null AS char(1)) AS \"TABLE_CAT\", s.\"name\" AS \"TABLE_SCHEM\", t.\"name\" AS \"TABLE_NAME\", CASE WHEN k.\"name\" IS NULL THEN true ELSE false END AS \"NON_UNIQUE\", cast(null AS char(1)) AS \"INDEX_QUALIFIER\", i.\"name\" AS \"INDEX_NAME\", CASE i.\"type\" WHEN 0 THEN 2 ELSE 3 END AS \"TYPE\", cast(o.\"nr\" +1 AS smallint) AS \"ORDINAL_POSITION\", c.\"name\" AS \"COLUMN_NAME\", cast(null AS char(1)) AS \"ASC_OR_DESC\", cast(").append(string4).append(" AS int) AS \"CARDINALITY\", cast(0 AS int) AS \"PAGES\", cast(null AS char(1)) AS \"FILTER_CONDITION\" FROM \"tmp\".\"idxs\" i JOIN \"tmp\".\"_tables\" t ON i.\"table_id\" = t.\"id\" JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" JOIN \"tmp\".\"objects\" o ON i.\"id\" = o.\"id\" JOIN \"tmp\".\"_columns\" c ON (t.\"id\" = c.\"table_id\" AND o.\"name\" = c.\"name\") LEFT OUTER JOIN \"tmp\".\"keys\" k ON (i.\"name\" = k.\"name\" AND i.\"table_id\" = k.\"table_id\" AND k.\"type\" IN (0, 1, 3)) ");
            if (string != null && !string.isEmpty()) {
                ((StringBuilder)object).append("WHERE 1=0");
            } else {
                boolean bl6 = true;
                if (string2 != null && !string2.equals("%")) {
                    ((StringBuilder)object).append("WHERE s.\"name\" ").append(this.composeMatchPart(string2));
                    bl6 = false;
                }
                if (string3 != null && !string3.equals("%")) {
                    ((StringBuilder)object).append(bl6 ? "WHERE" : " AND").append(" t.\"name\" ").append(this.composeMatchPart(string3));
                    bl6 = false;
                }
                if (bl) {
                    ((StringBuilder)object).append(bl6 ? "WHERE" : " AND").append(" k.\"name\" IS NOT NULL");
                }
            }
        }
        ((StringBuilder)object).append(" ORDER BY \"NON_UNIQUE\", \"TYPE\", \"INDEX_NAME\", \"ORDINAL_POSITION\"");
        return this.executeMetaDataQuery(((StringBuilder)object).toString());
    }

    @Override
    public boolean supportsResultSetType(int n) throws SQLException {
        return n != 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        if (n == 1005) {
            return false;
        }
        return n2 == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int n) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int n) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int n) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int n) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int n) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int n) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int n) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(990);
        if (nArray != null && nArray.length > 0) {
            stringBuilder.append("SELECT * FROM (");
        }
        stringBuilder.append("SELECT cast(null as char(1)) AS \"TYPE_CAT\", s.\"name\" AS \"TYPE_SCHEM\", t.\"sqlname\" AS \"TYPE_NAME\", CASE t.\"sqlname\" WHEN 'xml' THEN 'java.lang.String' ELSE 'java.lang.Object' END AS \"CLASS_NAME\", cast(CASE WHEN t.\"sqlname\" = 'xml' THEN 2000 ELSE 2002 END AS int) AS \"DATA_TYPE\", t.\"systemname\" AS \"REMARKS\", cast(null as smallint) AS \"BASE_TYPE\" FROM \"sys\".\"types\" t JOIN \"sys\".\"schemas\" s ON t.\"schema_id\" = s.\"id\" WHERE t.\"id\" > 99 AND t.\"eclass\" >= 18 AND t.\"sqlname\" NOT IN ('inet','json','url','uuid','inet4','inet6')");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1=0");
        } else {
            if (string2 != null && !string2.equals("%")) {
                stringBuilder.append(" AND s.\"name\" ").append(this.composeMatchPart(string2));
            }
            if (string3 != null && !string3.equals("%")) {
                stringBuilder.append(" AND t.\"sqlname\" ").append(this.composeMatchPart(string3));
            }
        }
        if (nArray != null && nArray.length > 0) {
            stringBuilder.append(") AS getUDTs WHERE \"DATA_TYPE\" IN (");
            for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(nArray[i]);
            }
            stringBuilder.append(')');
        }
        stringBuilder.append(" ORDER BY \"DATA_TYPE\", \"TYPE_SCHEM\", \"TYPE_NAME\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public Connection getConnection() {
        return this.con;
    }

    @Override
    public boolean supportsSavepoints() {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        return this.executeMetaDataQuery("SELECT cast(null as char(1)) AS \"TYPE_CAT\", '' AS \"TYPE_SCHEM\", '' AS \"TYPE_NAME\", cast(null as char(1)) AS \"SUPERTYPE_CAT\", '' AS \"SUPERTYPE_SCHEM\", '' AS \"SUPERTYPE_NAME\" WHERE 1=0");
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        return this.executeMetaDataQuery("SELECT cast(null as char(1)) AS \"TABLE_CAT\", '' AS \"TABLE_SCHEM\", '' AS \"TABLE_NAME\", '' AS \"SUPERTABLE_NAME\" WHERE 1=0");
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        return this.executeMetaDataQuery("SELECT cast(null as char(1)) AS \"TYPE_CAT\", '' AS \"TYPE_SCHEM\", '' AS \"TYPE_NAME\", '' AS \"ATTR_NAME\", cast(0 as int) AS \"DATA_TYPE\", '' AS \"ATTR_TYPE_NAME\", cast(0 as int) AS \"ATTR_SIZE\", cast(0 as int) AS \"DECIMAL_DIGITS\", cast(0 as int) AS \"NUM_PREC_RADIX\", cast(0 as int) AS \"NULLABLE\", '' AS \"REMARKS\", '' AS \"ATTR_DEF\", cast(0 as int) AS \"SQL_DATA_TYPE\", cast(0 as int) AS \"SQL_DATETIME_SUB\", cast(0 as int) AS \"CHAR_OCTET_LENGTH\", cast(0 as int) AS \"ORDINAL_POSITION\", 'YES' AS \"IS_NULLABLE\", '' AS \"SCOPE_CATALOG\", '' AS \"SCOPE_SCHEMA\", '' AS \"SCOPE_TABLE\", cast(0 as smallint) AS \"SOURCE_DATA_TYPE\" WHERE 1=0");
    }

    @Override
    public boolean supportsResultSetHoldability(int n) {
        return n == 1;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.con.getDatabaseMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.con.getDatabaseMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 2;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return this.con.supportsEscapeSequenceSyntax();
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        String string = "SELECT cast('' as varchar(40)) AS \"NAME\", cast(0 as int) AS \"MAX_LEN\", cast('' as varchar(128)) AS \"DEFAULT_VALUE\", cast('' as varchar(256)) AS \"DESCRIPTION\" WHERE 1=0";
        if (this.con.checkMinimumDBVersion(11, 51)) {
            string = "SELECT prop AS \"NAME\", cast(maxlen as int) AS \"MAX_LEN\", defval AS \"DEFAULT_VALUE\", descr AS \"DESCRIPTION\" FROM sys.clientinfo_properties LEFT OUTER JOIN (VALUES ('ApplicationName',128," + MonetDatabaseMetaData.stringEscape(ClientInfo.defaultApplicationName) + ",'Name of the application'),('ClientHostname',128," + MonetDatabaseMetaData.stringEscape(ClientInfo.defaultHostname) + ",'Host the application is running on'),('ClientLibrary',128," + MonetDatabaseMetaData.stringEscape(ClientInfo.defaultClientLibrary) + ",'Name and version of the driver'),('ClientPid',19," + MonetDatabaseMetaData.stringEscape(ClientInfo.defaultPid) + ",'Process id of the application'),('ClientRemark',256,NULL,'Additional information')) AS t(nm, maxlen, defval, descr) ON prop = nm ORDER BY 1";
        }
        return this.executeMetaDataQuery(string);
    }

    private static String stringEscape(String string) {
        return "R'" + string.replaceAll("'", "''") + "'";
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        boolean bl = this.con.commentsTableExists();
        StringBuilder stringBuilder = new StringBuilder(800);
        stringBuilder.append("SELECT cast(null as char(1)) AS \"FUNCTION_CAT\", s.\"name\" AS \"FUNCTION_SCHEM\", f.\"name\" AS \"FUNCTION_NAME\", ").append(bl ? "COALESCE(cm.\"remark\", cast(f.\"func\" as varchar(9999)))" : "cast(f.\"func\" as varchar(9999))").append(" AS \"REMARKS\", CASE WHEN f.\"type\" IN (1,2,3,4,6) THEN 1 WHEN f.\"type\" IN (5,7) THEN 2 ELSE 0 END AS \"FUNCTION_TYPE\", cast(f.\"id\" as varchar(10)) AS \"SPECIFIC_NAME\" FROM \"sys\".\"functions\" f JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" ");
        if (bl) {
            stringBuilder.append("LEFT OUTER JOIN \"sys\".\"comments\" cm ON f.\"id\" = cm.\"id\" ");
        }
        stringBuilder.append("WHERE f.\"type\" <> 2");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1=0");
        } else {
            if (string2 != null && !string2.equals("%")) {
                stringBuilder.append(" AND s.\"name\" ").append(this.composeMatchPart(string2));
            }
            if (string3 != null && !string3.equals("%")) {
                stringBuilder.append(" AND f.\"name\" ").append(this.composeMatchPart(string3));
            }
        }
        stringBuilder.append(" ORDER BY \"FUNCTION_SCHEM\", \"FUNCTION_NAME\", \"SPECIFIC_NAME\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(2600);
        stringBuilder.append("SELECT cast(null as char(1)) AS \"FUNCTION_CAT\", s.\"name\" AS \"FUNCTION_SCHEM\", f.\"name\" AS \"FUNCTION_NAME\", a.\"name\" AS \"COLUMN_NAME\", cast(CASE a.\"inout\" WHEN 0 THEN (CASE a.\"number\" WHEN 0 THEN 4 ELSE 3 END) WHEN 1 THEN 1 ELSE 0 END AS smallint) AS \"COLUMN_TYPE\", cast(").append(MonetDriver.getSQLTypeMap("a.\"type\"")).append(" AS int) AS \"DATA_TYPE\", a.\"type\" AS \"TYPE_NAME\", CASE a.\"type\" WHEN 'tinyint' THEN 3 WHEN 'smallint' THEN 5 WHEN 'int' THEN 10 WHEN 'bigint' THEN 19 WHEN 'hugeint' THEN 38 WHEN 'oid' THEN 19 WHEN 'wrd' THEN 19 ELSE a.\"type_digits\" END AS \"PRECISION\", CASE a.\"type\" WHEN 'tinyint' THEN 1 WHEN 'smallint' THEN 2 WHEN 'int' THEN 4 WHEN 'bigint' THEN 8 WHEN 'hugeint' THEN 16 WHEN 'oid' THEN 8 WHEN 'wrd' THEN 8 ELSE a.\"type_digits\" END AS \"LENGTH\", cast(CASE WHEN a.\"type\" IN ('tinyint','smallint','int','bigint','hugeint','oid','wrd','decimal','numeric','time','timetz','timestamp','timestamptz','day_interval','month_interval','sec_interval') THEN a.\"type_scale\" ELSE NULL END AS smallint) AS \"SCALE\", cast(CASE WHEN a.\"type\" IN ('tinyint','smallint','int','bigint','hugeint','oid','wrd','decimal','numeric','day_interval','month_interval','sec_interval') THEN 10 WHEN a.\"type\" IN ('real','float','double') THEN 2 ELSE NULL END AS smallint) AS \"RADIX\", cast(").append(2).append(" AS smallint) AS \"NULLABLE\", cast(null as char(1)) AS \"REMARKS\", cast(CASE WHEN a.\"type\" IN ('varchar','clob','char','json','url','xml') THEN 4 * cast(a.\"type_digits\" as bigint) WHEN a.\"type\" = 'blob' THEN a.\"type_digits\" ELSE NULL END as bigint) AS \"CHAR_OCTET_LENGTH\", cast(a.\"number\" as int) AS \"ORDINAL_POSITION\", cast('' as varchar(3)) AS \"IS_NULLABLE\", cast(f.\"id\" as varchar(10)) AS \"SPECIFIC_NAME\" FROM \"sys\".\"args\" a JOIN \"sys\".\"functions\" f ON a.\"func_id\" = f.\"id\" JOIN \"sys\".\"schemas\" s ON f.\"schema_id\" = s.\"id\" WHERE f.\"type\" <> 2");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" AND 1=0");
        } else {
            if (string2 != null && !string2.equals("%")) {
                stringBuilder.append(" AND s.\"name\" ").append(this.composeMatchPart(string2));
            }
            if (string3 != null && !string3.equals("%")) {
                stringBuilder.append(" AND f.\"name\" ").append(this.composeMatchPart(string3));
            }
            if (string4 != null && !string4.equals("%")) {
                stringBuilder.append(" AND a.\"name\" ").append(this.composeMatchPart(string4));
            }
        }
        stringBuilder.append(" ORDER BY \"FUNCTION_SCHEM\", \"FUNCTION_NAME\", \"SPECIFIC_NAME\", \"ORDINAL_POSITION\"");
        return this.executeMetaDataQuery(stringBuilder.toString());
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        return this.executeMetaDataQuery("SELECT cast(null as char(1)) AS \"TABLE_CAT\", '' AS \"TABLE_SCHEM\", '' AS \"TABLE_NAME\", '' AS \"COLUMN_NAME\", cast(0 as int) AS \"DATA_TYPE\", cast(0 as int) AS \"COLUMN_SIZE\", cast(0 as int) AS \"DECIMAL_DIGITS\", cast(0 as int) AS \"NUM_PREC_RADIX\", '' AS \"COLUMN_USAGE\", '' AS \"REMARKS\", cast(0 as int) AS \"CHAR_OCTET_LENGTH\", '' AS \"IS_NULLABLE\" WHERE 1=0");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return true;
    }

    @Override
    public long getMaxLogicalLobSize() {
        return 0L;
    }

    @Override
    public boolean supportsRefCursors() {
        return false;
    }

    private final ResultSet executeMetaDataQuery(String string) throws SQLException {
        Statement statement = this.con.createStatement(1004, 1007);
        ResultSet resultSet = null;
        if (statement != null) {
            resultSet = statement.executeQuery(string);
            if (resultSet != null) {
                statement.closeOnCompletion();
            } else {
                statement.close();
            }
        }
        return resultSet;
    }

    private final String composeMatchPart(String string) {
        if (string == null) {
            return "IS NULL";
        }
        int n = string.length();
        if (n == 0) {
            return "= ''";
        }
        if (string.equals("%") || string.equals("%%")) {
            return "LIKE '%'";
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            block6: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\\': {
                        if (bl3) {
                            stringBuilder.append(c).append(c);
                            bl3 = false;
                            continue block6;
                        }
                        bl3 = true;
                        continue block6;
                    }
                    case '%': 
                    case '_': {
                        if (bl3) {
                            bl = true;
                            bl3 = false;
                        } else {
                            bl2 = true;
                            i = n;
                        }
                        stringBuilder.append(c);
                        continue block6;
                    }
                    default: {
                        if (bl3) {
                            stringBuilder.append('\\');
                            bl3 = false;
                        }
                        stringBuilder.append(c);
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (bl2) {
            return "LIKE " + MonetWrapper.sq(string);
        }
        if (bl) {
            return "= " + MonetWrapper.sq(stringBuilder.toString());
        }
        return "= " + MonetWrapper.sq(string);
    }
}

