/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.jdbc.types;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;

public final class Inet4
implements SQLData {
    private String inet4;

    @Override
    public String getSQLTypeName() {
        return "inet4";
    }

    @Override
    public void readSQL(SQLInput sQLInput, String string) throws SQLException {
        if (!"inet4".equals(string)) {
            throw new SQLException("can only use this class with 'inet4' type", "M1M05");
        }
        this.fromString(sQLInput.readString());
    }

    @Override
    public void writeSQL(SQLOutput sQLOutput) throws SQLException {
        sQLOutput.writeString(this.inet4);
    }

    public String toString() {
        return this.inet4;
    }

    public void fromString(String string) throws SQLException {
        InetAddress inetAddress;
        if (string == null) {
            this.inet4 = null;
            return;
        }
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new SQLDataException("could not resolve IP address", "22M29");
        }
        if (!(inetAddress instanceof Inet4Address)) {
            throw new SQLDataException("IPv4 address expected", "22M29");
        }
        this.inet4 = inetAddress.toString();
    }

    public String getAddress() {
        return this.inet4;
    }

    public void setAddress(String string) throws SQLException {
        this.fromString(string);
    }

    public InetAddress getInetAddress() throws SQLException {
        if (this.inet4 == null) {
            return null;
        }
        try {
            return InetAddress.getByName(this.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            throw new SQLDataException("could not resolve IP address", "22M29");
        }
    }

    public void setInetAddress(InetAddress inetAddress) throws SQLException {
        if (!(inetAddress instanceof Inet4Address)) {
            throw new SQLDataException("IPv4 address expected", "22M29");
        }
        this.fromString(inetAddress.getHostAddress());
    }
}

