/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.jdbc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLException;
import org.monetdb.jdbc.MonetBlob;
import org.monetdb.jdbc.MonetCallableStatement;
import org.monetdb.jdbc.MonetClob;
import org.monetdb.jdbc.MonetDatabaseMetaData;
import org.monetdb.jdbc.MonetPreparedStatement;
import org.monetdb.jdbc.MonetSavepoint;
import org.monetdb.jdbc.MonetStatement;
import org.monetdb.jdbc.MonetWrapper;
import org.monetdb.jdbc.types.INET;
import org.monetdb.jdbc.types.Inet4;
import org.monetdb.jdbc.types.Inet6;
import org.monetdb.jdbc.types.URL;
import org.monetdb.mcl.MCLException;
import org.monetdb.mcl.io.BufferedMCLReader;
import org.monetdb.mcl.io.BufferedMCLWriter;
import org.monetdb.mcl.io.LineType;
import org.monetdb.mcl.net.ClientInfo;
import org.monetdb.mcl.net.MapiSocket;
import org.monetdb.mcl.net.Target;
import org.monetdb.mcl.net.ValidationError;
import org.monetdb.mcl.parser.HeaderLineParser;
import org.monetdb.mcl.parser.MCLParseException;
import org.monetdb.mcl.parser.StartOfHeaderParser;

public class MonetConnection
extends MonetWrapper
implements Connection,
AutoCloseable {
    private final Target target;
    private final MapiSocket server;
    private final BufferedMCLReader in;
    private final BufferedMCLWriter out;
    private final StartOfHeaderParser sohp = new StartOfHeaderParser();
    private boolean closed;
    private boolean autoCommit = true;
    private SQLWarning warnings;
    private Map<String, Class<?>> typeMap = new HashMap<String, Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("inet", INET.class);
            this.put("inet4", Inet4.class);
            this.put("inet6", Inet6.class);
            this.put("url", URL.class);
        }
    };
    private final WeakHashMap<Statement, ?> statements = new WeakHashMap();
    private int curReplySize = 100;
    final String[] queryTempl = new String[3];
    private final String[] commandTempl = new String[2];
    private HashMap<String, String> clientInfoAttributeNames = null;
    private static final int LANG_SQL = 0;
    private static final int LANG_MAL = 3;
    private static final int LANG_UNKNOWN = -1;
    private final int lang;
    protected int lastSetQueryTimeout = 0;
    private DatabaseMetaData dbmd;
    private UploadHandler uploadHandler;
    private DownloadHandler downloadHandler;
    private String env_current_user;
    private String env_monet_version;
    private String env_raw_strings;
    private int maxConnections;
    private int databaseMajorVersion;
    private int databaseMinorVersion;
    private int databaseMicroVersion = 0;
    private boolean queriedPrivilege_codesTable = false;
    private boolean hasPrivilege_codesTable = false;
    private boolean queriedCommentsTable = false;
    private boolean hasCommentsTable = false;
    private static final int DEF_FETCHSIZE = 250;
    private int defaultFetchSize = 250;
    private static int seqCounter = 0;

    MonetConnection(Target target) throws SQLException, IllegalArgumentException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Target.Validated validated;
        this.target = target;
        try {
            validated = target.validate();
        }
        catch (ValidationError validationError) {
            throw new SQLNonTransientConnectionException(validationError.getMessage());
        }
        this.server = new MapiSocket();
        if (validated.isDebug()) {
            try {
                object4 = validated.getLogfile();
                if (object4 == null) {
                    object4 = "monet_" + System.currentTimeMillis() + ".log";
                }
                object3 = new File((String)object4);
                int n = ((String)object4).lastIndexOf(46);
                if (n < 0) {
                    n = ((String)object4).length();
                }
                object2 = ((String)object4).substring(0, n);
                String string = ((String)object4).substring(n);
                int n2 = 1;
                while (!((File)object3).createNewFile()) {
                    object3 = new File((String)object2 + "-" + n2 + string);
                    ++n2;
                }
                this.server.debug(((File)object3).getAbsolutePath());
            }
            catch (IOException iOException) {
                throw new SQLNonTransientConnectionException("Opening logfile failed: " + iOException.getMessage(), "08M01");
            }
        }
        object4 = null;
        switch (validated.getLanguage()) {
            case "sql": {
                this.lang = 0;
                this.queryTempl[0] = "s";
                this.queryTempl[1] = "\n;";
                this.queryTempl[2] = "\n;\n";
                this.commandTempl[0] = "X";
                this.commandTempl[1] = "";
                object4 = new SqlOptionsCallback(validated);
                break;
            }
            case "mal": {
                this.lang = 3;
                this.queryTempl[0] = "";
                this.queryTempl[1] = ";\n";
                this.queryTempl[2] = ";\n";
                this.commandTempl[0] = "";
                this.commandTempl[1] = "";
                break;
            }
            default: {
                this.lang = -1;
            }
        }
        try {
            object3 = this.server.connect(target, (MapiSocket.OptionsCallback)object4);
            object = object3.iterator();
            while (object.hasNext()) {
                object2 = object.next();
                this.addWarning((String)object2, "01M02");
            }
            this.in = this.server.getReader();
            this.out = this.server.getWriter();
            object = this.in.discardRemainder();
            if (object != null) {
                throw new SQLNonTransientConnectionException((String)(((String)object).length() > 6 ? ((String)object).substring(6) : object), "08001");
            }
        }
        catch (SSLException sSLException) {
            throw new SQLNonTransientConnectionException("Cannot establish secure connection: " + sSLException.getMessage(), sSLException);
        }
        catch (IOException iOException) {
            throw new SQLNonTransientConnectionException("Cannot connect: " + iOException.getMessage(), "08006", iOException);
        }
        catch (MCLParseException mCLParseException) {
            throw new SQLNonTransientConnectionException(mCLParseException.getMessage(), "08001");
        }
        catch (MCLException mCLException) {
            String[] stringArray = mCLException.getMessage().split("\n");
            object2 = new SQLNonTransientConnectionException(stringArray[0], "08001", mCLException);
            for (int i = 1; i < stringArray.length; ++i) {
                ((SQLException)object2).setNextException(new SQLNonTransientConnectionException(stringArray[1], "08001"));
            }
            throw object2;
        }
        if (this.server.canClientInfo() && validated.sendClientInfo()) {
            object3 = new ClientInfo();
            ((ClientInfo)object3).setDefaults();
            object = validated.getClientApplication();
            object2 = validated.getClientRemark();
            if (!((String)object).isEmpty()) {
                ((ClientInfo)object3).set("ApplicationName", (String)object);
            }
            if (!((String)object2).isEmpty()) {
                ((ClientInfo)object3).set("ClientRemark", (String)object2);
            }
            this.sendClientInfo((ClientInfo)object3);
        }
        this.curReplySize = this.defaultFetchSize;
        if (this.lang == 0) {
            if (this.autoCommit != validated.isAutocommit()) {
                this.setAutoCommit(validated.isAutocommit());
            }
            if (!((SqlOptionsCallback)object4).sizeHeaderEnabled) {
                this.sendControlCommand("sizeheader 1");
            }
            if (!((SqlOptionsCallback)object4).timeZoneSet) {
                this.setTimezone(60 * validated.getTimezone());
            }
        }
        this.closed = false;
        if (!validated.getSchema().isEmpty()) {
            object3 = this.createStatement();
            try {
                object = validated.getSchema().replaceAll("\"", "\"\"");
                object3.execute("SET SCHEMA \"" + (String)object + "\"");
            }
            finally {
                if (object3 != null) {
                    object3.close();
                }
            }
        }
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.clearWarnings();
        this.clientInfoAttributeNames = null;
        this.dbmd = null;
        MapiSocket mapiSocket = this.server;
        synchronized (mapiSocket) {
            for (Statement statement : this.statements.keySet()) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            this.server.close();
            this.closed = true;
        }
    }

    @Override
    public void commit() throws SQLException {
        this.sendTransactionCommand("COMMIT");
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 1);
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, 1);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        try {
            MonetStatement monetStatement = new MonetStatement(this, n, n2, n3);
            this.statements.put(monetStatement, null);
            return monetStatement;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException.toString(), "M0M03");
        }
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public int getHoldability() {
        return 1;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.lang != 0) {
            throw new SQLException("This method is only supported in SQL mode", "M0M04");
        }
        if (this.dbmd == null) {
            this.dbmd = new MonetDatabaseMetaData(this);
        }
        return this.dbmd;
    }

    @Override
    public int getTransactionIsolation() {
        return 8;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return this.typeMap;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return this.warnings;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String nativeSQL(String string) {
        return string;
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007, 1);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string, n, n2, 1);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkNotClosed();
        if (string == null || string.isEmpty()) {
            throw new SQLException("Missing SQL statement", "M1M05");
        }
        try {
            MonetCallableStatement monetCallableStatement = new MonetCallableStatement(this, n, n2, n3, string);
            this.statements.put(monetCallableStatement, null);
            return monetCallableStatement;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException.toString(), "M0M03");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string, n, n2, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkNotClosed();
        if (string == null || string.isEmpty()) {
            throw new SQLException("Missing SQL statement", "M1M05");
        }
        try {
            MonetPreparedStatement monetPreparedStatement = new MonetPreparedStatement(this, n, n2, n3, string);
            this.statements.put(monetPreparedStatement, null);
            return monetPreparedStatement;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException.toString(), "M0M03");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (n != 1 && n != 2) {
            throw new SQLException("Invalid argument, expected RETURN_GENERATED_KEYS or NO_GENERATED_KEYS", "M1M05");
        }
        return this.prepareStatement(string, 1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("prepareStatement(String sql, int[] columnIndexes)");
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("prepareStatement(String sql, String[] columnNames)");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkNotClosed();
        if (!(savepoint instanceof MonetSavepoint)) {
            throw new SQLException("This driver can only handle savepoints it created itself", "M0M06");
        }
        MonetSavepoint monetSavepoint = (MonetSavepoint)savepoint;
        this.sendTransactionCommand("RELEASE SAVEPOINT " + monetSavepoint.getName());
    }

    @Override
    public void rollback() throws SQLException {
        this.checkNotClosed();
        this.sendTransactionCommand("ROLLBACK");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkNotClosed();
        if (!(savepoint instanceof MonetSavepoint)) {
            throw new SQLException("This driver can only handle savepoints it created itself", "M0M06");
        }
        MonetSavepoint monetSavepoint = (MonetSavepoint)savepoint;
        this.sendTransactionCommand("ROLLBACK TO SAVEPOINT " + monetSavepoint.getName());
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkNotClosed();
        if (this.autoCommit != bl) {
            this.sendControlCommand(bl ? "auto_commit 1" : "auto_commit 0");
            this.autoCommit = bl;
        }
    }

    @Override
    public void setCatalog(String string) {
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        if (n != 1) {
            throw MonetConnection.newSQLFeatureNotSupportedException("setHoldability(CLOSE_CURSORS_AT_COMMIT)");
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        if (bl) {
            this.addWarning("cannot setReadOnly(true): read-only Connection mode not supported", "01M08");
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint(null);
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        MonetSavepoint monetSavepoint;
        this.checkNotClosed();
        try {
            monetSavepoint = string != null ? new MonetSavepoint(string) : new MonetSavepoint();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException.getMessage(), "M0M03");
        }
        this.sendTransactionCommand("SAVEPOINT " + monetSavepoint.getName());
        return monetSavepoint;
    }

    @Override
    public void setTransactionIsolation(int n) {
        if (n != 8) {
            this.addWarning("MonetDB only supports fully serializable transactions, continuing with transaction level raised to TRANSACTION_SERIALIZABLE", "01M09");
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) {
        this.typeMap = map;
    }

    public String toString() {
        return "MonetDB Connection (" + this.getJDBCURL() + (this.closed ? ") disconnected" : ") connected");
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("createArrayOf");
    }

    @Override
    public Clob createClob() throws SQLException {
        return new MonetClob("");
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new MonetBlob(new byte[1]);
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("createNClob");
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("createStruct");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw MonetConnection.newSQLFeatureNotSupportedException("createSQLXML");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int n) throws SQLException {
        int n2;
        boolean bl;
        ResultSet resultSet;
        Statement statement;
        block16: {
            if (n < 0) {
                throw new SQLException("timeout is less than 0", "M1M05");
            }
            if (this.closed) {
                return false;
            }
            statement = null;
            resultSet = null;
            bl = false;
            n2 = this.lastSetQueryTimeout;
            try {
                statement = this.createStatement();
                if (statement == null) break block16;
                if (n > 0 && n2 != n) {
                    statement.setQueryTimeout(n);
                }
                if ((resultSet = statement.executeQuery("SELECT 1")) == null || !resultSet.next()) break block16;
                bl = true;
            }
            catch (SQLException sQLException) {
                block17: {
                    try {
                        String string = sQLException.getMessage();
                        if (string == null || !string.equalsIgnoreCase("Current transaction is aborted (please ROLLBACK)")) break block17;
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        MonetConnection.closeResultsetStatement(resultSet, statement);
                        if (n > 0 && n2 != this.lastSetQueryTimeout) {
                            this.lastSetQueryTimeout = n2;
                            try {
                                this.setQueryTimeout(n2);
                            }
                            catch (SQLException sQLException2) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                MonetConnection.closeResultsetStatement(resultSet, statement);
                if (n > 0 && n2 != this.lastSetQueryTimeout) {
                    this.lastSetQueryTimeout = n2;
                    try {
                        this.setQueryTimeout(n2);
                    }
                    catch (SQLException sQLException3) {}
                }
            }
        }
        MonetConnection.closeResultsetStatement(resultSet, statement);
        if (n > 0 && n2 != this.lastSetQueryTimeout) {
            this.lastSetQueryTimeout = n2;
            try {
                this.setQueryTimeout(n2);
            }
            catch (SQLException sQLException) {}
        }
        return bl;
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        String string2 = this.getClientInfoAttributeNames().get(string);
        if (string2 == null) {
            return null;
        }
        String string3 = "SELECT " + string2 + " FROM sys.sessions WHERE sessionid = current_sessionid()";
        try (Statement statement = this.createStatement();){
            String string4;
            block17: {
                ResultSet resultSet;
                block15: {
                    String string5;
                    block16: {
                        resultSet = statement.executeQuery(string3);
                        try {
                            if (resultSet == null || !resultSet.next()) break block15;
                            string5 = resultSet.getString(1);
                            if (resultSet == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return string5;
                }
                string4 = null;
                if (resultSet == null) break block17;
                resultSet.close();
            }
            return string4;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        Properties properties = new Properties();
        if (this.server.canClientInfo()) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder("SELECT ");
            String string = "";
            for (Map.Entry<String, String> object2 : this.getClientInfoAttributeNames().entrySet()) {
                object = object2.getKey();
                String i = object2.getValue();
                stringBuilder.append(string);
                string = ", ";
                stringBuilder.append(i);
                stringBuilder.append(" AS \"");
                stringBuilder.append((String)object);
                stringBuilder.append("\"");
            }
            stringBuilder.append(" FROM sys.sessions WHERE sessionid = current_sessionid()");
            try (Statement statement = this.createStatement();
                 ResultSet resultSet = statement.executeQuery(stringBuilder.toString());){
                if (resultSet != null && resultSet.next()) {
                    object = resultSet.getMetaData();
                    for (int i = 1; i <= object.getColumnCount(); ++i) {
                        String string2 = object.getColumnName(i);
                        String string3 = resultSet.getString(i);
                        properties.setProperty(string2, string3 != null ? string3 : "");
                    }
                }
            }
        }
        return properties;
    }

    private HashMap<String, String> getClientInfoAttributeNames() throws SQLException {
        if (this.clientInfoAttributeNames == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (this.server.canClientInfo()) {
                try (Statement statement = this.createStatement();
                     ResultSet resultSet = statement.executeQuery("SELECT prop, session_attr FROM sys.clientinfo_properties");){
                    while (resultSet != null && resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        hashMap.put(string, string2);
                    }
                }
            }
            this.clientInfoAttributeNames = hashMap;
        }
        return this.clientInfoAttributeNames;
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        ClientInfo clientInfo = new ClientInfo();
        try {
            clientInfo.set(string, string2, this.getClientInfoAttributeNames().keySet());
            this.sendClientInfo(clientInfo);
            SQLWarning sQLWarning = clientInfo.warnings();
            if (sQLWarning != null) {
                this.addWarning(sQLWarning);
            }
        }
        catch (SQLException sQLException) {
            throw clientInfo.wrapException(sQLException);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        ClientInfo clientInfo = new ClientInfo();
        try {
            for (String string : properties.stringPropertyNames()) {
                String string2 = properties.getProperty(string);
                clientInfo.set(string, string2, this.getClientInfoAttributeNames().keySet());
            }
            this.sendClientInfo(clientInfo);
            SQLWarning sQLWarning = clientInfo.warnings();
            if (sQLWarning != null) {
                this.addWarning(sQLWarning);
            }
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            throw sQLClientInfoException;
        }
        catch (SQLException sQLException) {
            throw clientInfo.wrapException(sQLException);
        }
    }

    private void sendClientInfo(ClientInfo clientInfo) throws SQLException {
        String string = clientInfo.format();
        if (!string.isEmpty()) {
            this.sendControlCommand("clientinfo " + string);
        }
    }

    @Override
    public void setSchema(String string) throws SQLException {
        this.checkNotClosed();
        if (string == null || string.isEmpty()) {
            throw new SQLException("Missing schema name", "M1M05");
        }
        Statement statement = null;
        try {
            statement = this.createStatement();
            if (statement != null) {
                statement.execute("SET SCHEMA \"" + string + "\"");
            }
        }
        finally {
            MonetConnection.closeResultsetStatement(null, statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        this.checkNotClosed();
        String string = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.createStatement();
            if (statement != null && (resultSet = statement.executeQuery("SELECT CURRENT_SCHEMA")) != null && resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        finally {
            MonetConnection.closeResultsetStatement(resultSet, statement);
        }
        if (string == null) {
            throw new SQLException("Failed to fetch schema name", "02000");
        }
        return string;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.closed) {
            return;
        }
        if (executor == null) {
            throw new SQLException("executor is null", "M1M05");
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                MonetConnection.this.close();
            }
        });
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        this.checkNotClosed();
        if (n < 0) {
            throw new SQLException("milliseconds is less than zero", "M1M05");
        }
        try {
            this.server.setSoTimeout(n);
        }
        catch (SocketException socketException) {
            throw new SQLNonTransientConnectionException(socketException.getMessage(), "08000");
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkNotClosed();
        try {
            return this.server.getSoTimeout();
        }
        catch (SocketException socketException) {
            throw new SQLNonTransientConnectionException(socketException.getMessage(), "08000");
        }
    }

    public Properties getConnectionProperties() {
        return this.target.getProperties();
    }

    public void setUploadHandler(UploadHandler uploadHandler) {
        this.uploadHandler = uploadHandler;
    }

    public UploadHandler getUploadHandler() {
        return this.uploadHandler;
    }

    public void setDownloadHandler(DownloadHandler downloadHandler) {
        this.downloadHandler = downloadHandler;
    }

    public DownloadHandler getDownloadHandler() {
        return this.downloadHandler;
    }

    private void setTimezone(int n) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("SET TIME ZONE INTERVAL '");
        int n2 = n / 60;
        if (n2 < 0) {
            stringBuilder.append('-');
            n2 = -n2;
        } else {
            stringBuilder.append('+');
        }
        int n3 = n2 / 60;
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3).append(':');
        if ((n2 -= n3 * 60) < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2).append("' HOUR TO MINUTE");
        this.sendIndependentCommand(stringBuilder.toString());
    }

    private void checkNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection is closed", "M1M20");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setQueryTimeout(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("query timeout seconds is less than zero", "M1M05");
        }
        this.checkNotClosed();
        Statement statement = null;
        try {
            String string = this.checkMinimumDBVersion(11, 37) ? "CALL sys.\"setquerytimeout\"(" + n + ")" : "CALL sys.\"settimeout\"(" + n + ")";
            statement = this.createStatement();
            statement.execute(string);
            this.lastSetQueryTimeout = n;
        }
        catch (Throwable throwable) {
            MonetConnection.closeResultsetStatement(null, statement);
            throw throwable;
        }
        MonetConnection.closeResultsetStatement(null, statement);
    }

    boolean mapBlobAsVarBinary() {
        return this.target.isTreatBlobAsBinary();
    }

    boolean mapClobAsVarChar() {
        return this.target.isTreatClobAsVarchar();
    }

    String getJDBCURL() {
        return this.target.buildUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void getEnvValues() throws SQLException {
        block9: {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = this.createStatement();
                if (statement == null || (resultSet = statement.executeQuery("SELECT \"name\", \"value\" FROM \"sys\".\"env\"() WHERE \"name\" IN ('monet_version', 'max_clients', 'raw_strings') UNION SELECT 'current_user' as \"name\", current_user as \"value\"")) == null) break block9;
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    if ("current_user".equals(string)) {
                        this.env_current_user = string2;
                        continue;
                    }
                    if ("monet_version".equals(string)) {
                        this.env_monet_version = string2;
                        continue;
                    }
                    if ("raw_strings".equals(string)) {
                        this.env_raw_strings = string2;
                        continue;
                    }
                    if (!"max_clients".equals(string) || string2 == null) continue;
                    try {
                        this.maxConnections = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (this.maxConnections > 0) continue;
                    this.maxConnections = 1;
                }
            }
            finally {
                MonetConnection.closeResultsetStatement(resultSet, statement);
            }
        }
    }

    String getUserName() throws SQLException {
        if (this.env_current_user == null) {
            this.getEnvValues();
        }
        return this.env_current_user;
    }

    int getMaxConnections() throws SQLException {
        if (this.maxConnections == 0) {
            this.getEnvValues();
        }
        return this.maxConnections;
    }

    boolean inRawStringsMode() throws SQLException {
        if (this.env_raw_strings == null) {
            this.getEnvValues();
            if (this.env_raw_strings == null) {
                this.env_raw_strings = "false";
            }
        }
        return "true".equals(this.env_raw_strings);
    }

    String getDatabaseProductVersion() throws SQLException {
        if (this.env_monet_version == null) {
            this.getEnvValues();
        }
        if (this.env_monet_version != null) {
            return this.env_monet_version;
        }
        return "";
    }

    int getDatabaseMajorVersion() throws SQLException {
        if (this.databaseMajorVersion == 0) {
            if (this.env_monet_version == null) {
                this.getEnvValues();
            }
            if (this.env_monet_version != null) {
                try {
                    int n = this.env_monet_version.indexOf(46);
                    this.databaseMajorVersion = Integer.parseInt(n >= 0 ? this.env_monet_version.substring(0, n) : this.env_monet_version);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return this.databaseMajorVersion;
    }

    int getDatabaseMinorVersion() throws SQLException {
        if (this.databaseMinorVersion == 0) {
            if (this.env_monet_version == null) {
                this.getEnvValues();
            }
            if (this.env_monet_version != null) {
                try {
                    int n = this.env_monet_version.indexOf(46);
                    if (n >= 0) {
                        int n2;
                        this.databaseMinorVersion = Integer.parseInt((n2 = this.env_monet_version.indexOf(46, ++n)) > 0 ? this.env_monet_version.substring(n, n2) : this.env_monet_version.substring(n));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return this.databaseMinorVersion;
    }

    int getDatabaseMicroVersion() throws SQLException {
        if (this.databaseMicroVersion == 0) {
            if (this.env_monet_version == null) {
                this.getEnvValues();
            }
            if (this.env_monet_version != null) {
                try {
                    int n = this.env_monet_version.lastIndexOf(46);
                    this.databaseMicroVersion = Integer.parseInt(this.env_monet_version.substring(++n));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return this.databaseMicroVersion;
    }

    boolean checkMinimumDBVersion(int n, int n2, int n3) {
        try {
            int n4 = this.getDatabaseMajorVersion();
            if (n4 > n) {
                return true;
            }
            if (n4 < n) {
                return false;
            }
            int n5 = this.getDatabaseMinorVersion();
            if (n5 > n2) {
                return true;
            }
            if (n5 < n2) {
                return false;
            }
            int n6 = this.getDatabaseMicroVersion();
            return n6 >= n3;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    boolean checkMinimumDBVersion(int n, int n2) {
        return this.checkMinimumDBVersion(n, n2, 0);
    }

    boolean supportsEscapeSequenceSyntax() {
        return this.checkMinimumDBVersion(11, 47);
    }

    boolean supportsLargePrepares() {
        if (this.checkMinimumDBVersion(11, 53, 4)) {
            return true;
        }
        if (this.checkMinimumDBVersion(11, 53, 0)) {
            return false;
        }
        return this.checkMinimumDBVersion(11, 51, 9);
    }

    boolean privilege_codesTableExists() {
        if (!this.queriedPrivilege_codesTable) {
            this.querySysTable();
            this.queriedPrivilege_codesTable = true;
        }
        return this.hasPrivilege_codesTable;
    }

    boolean commentsTableExists() {
        if (!this.queriedCommentsTable) {
            this.querySysTable();
            this.queriedCommentsTable = true;
        }
        return this.hasCommentsTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void querySysTable() {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.createStatement();
            if (statement != null && (resultSet = statement.executeQuery("SELECT name FROM sys._tables WHERE name in ('privilege_codes', 'comments') AND schema_id IN (SELECT id FROM sys.schemas WHERE name = 'sys')")) != null) {
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    if ("comments".equals(string)) {
                        this.hasCommentsTable = true;
                        this.queriedCommentsTable = true;
                        continue;
                    }
                    if (!"privilege_codes".equals(string)) continue;
                    this.hasPrivilege_codesTable = true;
                    this.queriedPrivilege_codesTable = true;
                }
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            MonetConnection.closeResultsetStatement(resultSet, statement);
        }
    }

    static final void closeResultsetStatement(ResultSet resultSet, Statement statement) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void sendTransactionCommand(String string) throws SQLException {
        try (ResponseList responseList = new ResponseList(0, 0L, 1000, 1007);){
            responseList.processQuery(string);
        }
    }

    private void sendIndependentCommand(String string) throws SQLException {
        this.sendCommand(string, true);
    }

    void sendControlCommand(String string) throws SQLException {
        this.sendCommand(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(String string, boolean bl) throws SQLException {
        MapiSocket mapiSocket = this.server;
        synchronized (mapiSocket) {
            try {
                if (bl) {
                    this.out.writeLine(this.queryTempl[0] + string + this.queryTempl[1]);
                } else {
                    this.out.writeLine(this.commandTempl[0] + string + this.commandTempl[1]);
                }
                String string2 = this.in.discardRemainder();
                if (string2 != null) {
                    throw new SQLException(string2.substring(6), string2.substring(0, 5));
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.close();
                throw new SQLNonTransientConnectionException("connection timed out", "08M33");
            }
            catch (IOException iOException) {
                throw new SQLNonTransientConnectionException(iOException.getMessage(), "08000");
            }
        }
    }

    private final void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    private final void addWarning(String string, String string2) {
        SQLWarning sQLWarning = new SQLWarning(string, string2);
        this.addWarning(sQLWarning);
    }

    protected int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    private String handleTransfer(String string) throws IOException {
        if (string.startsWith("r ")) {
            String[] stringArray = string.split(" ", 3);
            if (stringArray.length == 3) {
                long l;
                try {
                    l = Long.parseLong(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    return numberFormatException.toString();
                }
                return this.handleUpload(stringArray[2], true, l);
            }
        } else {
            if (string.startsWith("rb ")) {
                return this.handleUpload(string.substring(3), false, 0L);
            }
            if (string.startsWith("w ")) {
                return this.handleDownload(string.substring(2), true);
            }
            if (string.startsWith("wb ")) {
                return this.handleDownload(string.substring(3), false);
            }
        }
        return "JDBC does not support this file transfer yet: " + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleUpload(String string, boolean bl, long l) throws IOException {
        if (this.uploadHandler == null) {
            return "No file upload handler has been registered with the JDBC driver";
        }
        long l2 = l >= 1L ? l - 1L : 0L;
        Upload upload = new Upload(this.server, this.uploadHandler::uploadCancelled, bl);
        boolean bl2 = this.server.setInsertFakePrompts(false);
        try {
            this.uploadHandler.handleUpload(upload, string, bl, l2);
            if (!upload.hasBeenUsed()) {
                throw new IOException("Call to " + this.uploadHandler.getClass().getCanonicalName() + ".handleUpload for path '" + string + "' sent neither data nor an error message");
            }
        }
        finally {
            upload.close();
            this.server.setInsertFakePrompts(bl2);
        }
        return upload.getError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleDownload(String string, boolean bl) throws IOException {
        if (this.downloadHandler == null) {
            return "No file download handler has been registered with the JDBC driver";
        }
        try (Download download = new Download(this.server, bl);){
            this.downloadHandler.handleDownload(download, string, true);
            if (!download.hasBeenUsed()) {
                download.sendError("Call to " + this.downloadHandler.getClass().getSimpleName() + ".handleDownload sent neither data nor error");
            }
        }
        return download.getError();
    }

    private class SqlOptionsCallback
    extends MapiSocket.OptionsCallback {
        private final Target.Validated validated;
        private int level;
        boolean sizeHeaderEnabled = false;
        boolean timeZoneSet = false;

        public SqlOptionsCallback(Target.Validated validated) {
            this.validated = validated;
        }

        @Override
        public void addOptions(String string, int n) {
            if (!string.equals("sql")) {
                return;
            }
            this.level = n;
            if (this.contribute(SqlOption.Autocommit, this.validated.isAutocommit() ? 1 : 0)) {
                MonetConnection.this.autoCommit = MonetConnection.this.target.isAutocommit();
            }
            if (this.contribute(SqlOption.ReplySize, this.validated.getReplySize())) {
                MonetConnection.this.defaultFetchSize = this.validated.getReplySize();
            }
            if (this.contribute(SqlOption.SizeHeader, 1)) {
                this.sizeHeaderEnabled = true;
            }
            if (this.contribute(SqlOption.TimeZone, 60 * MonetConnection.this.target.getTimezone())) {
                this.timeZoneSet = true;
            }
        }

        private boolean contribute(SqlOption sqlOption, int n) {
            if (sqlOption.level >= this.level) {
                return false;
            }
            this.contribute(sqlOption.field, n);
            return true;
        }
    }

    public static interface UploadHandler {
        public void handleUpload(Upload var1, String var2, boolean var3, long var4) throws IOException;

        default public void uploadCancelled() {
        }
    }

    public static interface DownloadHandler {
        public void handleDownload(Download var1, String var2, boolean var3) throws IOException;
    }

    final class ResponseList {
        private final int cachesize;
        private final long maxrows;
        private final int rstype;
        private final int rsconcur;
        private final int seqnr;
        private final ArrayList<Response> responses;
        private HashMap<Integer, ResultSetResponse> rsresponses;
        private int curResponse;

        ResponseList(int n, long l, int n2, int n3) {
            this.cachesize = n;
            this.maxrows = l;
            this.rstype = n2;
            this.rsconcur = n3;
            this.responses = new ArrayList();
            this.curResponse = -1;
            this.seqnr = seqCounter++;
        }

        Response getNextResponse() {
            if (this.rstype == 1003 && this.curResponse >= 0 && this.curResponse < this.responses.size()) {
                Response response = this.responses.get(this.curResponse);
                if (response != null) {
                    response.close();
                }
                this.responses.set(this.curResponse, null);
            }
            ++this.curResponse;
            if (this.curResponse >= this.responses.size()) {
                return null;
            }
            return this.responses.get(this.curResponse);
        }

        void closeResponse(int n) {
            if (n < 0 || n >= this.responses.size()) {
                return;
            }
            Response response = this.responses.set(n, null);
            if (response != null) {
                response.close();
            }
        }

        void closeCurrentResponse() {
            this.closeResponse(this.curResponse);
        }

        void closeCurOldResponses() {
            for (int i = this.curResponse; i >= 0; --i) {
                this.closeResponse(i);
            }
        }

        void close() {
            for (int i = 0; i < this.responses.size(); ++i) {
                this.closeResponse(i);
            }
        }

        boolean hasUnclosedResponses() {
            for (Response response : this.responses) {
                if (response == null) continue;
                return true;
            }
            return false;
        }

        void processQuery(String string) throws SQLException {
            this.executeQuery(MonetConnection.this.queryTempl, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void executeQuery(String[] stringArray, String string) throws SQLException {
            String string2 = null;
            try {
                Object object = MonetConnection.this.server;
                synchronized (object) {
                    MonetConnection.this.in.discardRemainder();
                    int n = this.cachesize;
                    if (n == 0) {
                        n = MonetConnection.this.defaultFetchSize;
                    }
                    if (this.maxrows > 0L && this.maxrows < (long)n) {
                        n = (int)this.maxrows;
                    }
                    if (MonetConnection.this.lang == 0 && n != MonetConnection.this.curReplySize && stringArray != MonetConnection.this.commandTempl) {
                        MonetConnection.this.sendControlCommand("reply_size " + n);
                        MonetConnection.this.curReplySize = n;
                    }
                    MonetConnection.this.out.writeLine(stringArray[0] + string + stringArray[1]);
                    MonetConnection.this.in.advance();
                    Response response = null;
                    block22: while (MonetConnection.this.in.getLineType() != LineType.PROMPT) {
                        switch (MonetConnection.this.in.getLineType()) {
                            case SOHEADER: {
                                try {
                                    switch (MonetConnection.this.sohp.parse(MonetConnection.this.in.getLine())) {
                                        case 48: {
                                            throw new MCLParseException("Q_PARSE header not allowed here", 1);
                                        }
                                        case 49: 
                                        case 53: {
                                            int n2 = MonetConnection.this.sohp.getNextAsInt();
                                            long l = MonetConnection.this.sohp.getNextAsLong();
                                            int n3 = MonetConnection.this.sohp.getNextAsInt();
                                            int n4 = MonetConnection.this.sohp.getNextAsInt();
                                            long l2 = this.maxrows == 0L || l <= this.maxrows ? l : this.maxrows;
                                            response = new ResultSetResponse(n2, l, l2, n3, n4, this, this.seqnr);
                                            if ((long)n4 < l2) {
                                                if (this.rsresponses == null) {
                                                    this.rsresponses = new HashMap();
                                                }
                                                this.rsresponses.put(n2, (ResultSetResponse)response);
                                            }
                                            break;
                                        }
                                        case 50: {
                                            response = new UpdateResponse(MonetConnection.this.sohp.getNextAsLong(), MonetConnection.this.sohp.getNextAsString());
                                            break;
                                        }
                                        case 51: {
                                            response = new SchemaResponse();
                                            break;
                                        }
                                        case 52: {
                                            boolean bl = MonetConnection.this.sohp.getNextAsString().equals("t");
                                            if (MonetConnection.this.autoCommit && bl) {
                                                MonetConnection.this.addWarning("Server enabled auto commit mode while local state already was auto commit.", "01M11");
                                            }
                                            MonetConnection.this.autoCommit = bl;
                                            response = new AutoCommitResponse(bl);
                                            break;
                                        }
                                        case 54: {
                                            int n5 = MonetConnection.this.sohp.getNextAsInt();
                                            MonetConnection.this.sohp.getNextAsInt();
                                            int n6 = MonetConnection.this.sohp.getNextAsInt();
                                            int n3 = MonetConnection.this.sohp.getNextAsInt();
                                            ResultSetResponse resultSetResponse = this.rsresponses != null ? this.rsresponses.get(n5) : null;
                                            if (resultSetResponse == null) {
                                                string2 = "M0M12!no ResultSetResponse with id " + n5 + " found";
                                                break;
                                            }
                                            DataBlockResponse dataBlockResponse = new DataBlockResponse(n6, resultSetResponse.getRSType() == 1003);
                                            resultSetResponse.addDataBlockResponse(n3, dataBlockResponse);
                                            response = dataBlockResponse;
                                        }
                                    }
                                }
                                catch (MCLParseException mCLParseException) {
                                    int n7 = mCLParseException.getErrorOffset();
                                    string2 = "M0M10!error while parsing start of header:\n" + mCLParseException.getMessage() + " found: '" + MonetConnection.this.in.getLine().charAt(n7) + "' in: \"" + MonetConnection.this.in.getLine() + "\" at pos: " + n7;
                                    MonetConnection.this.in.discardRemainder();
                                    continue block22;
                                }
                                if (string2 != null) {
                                    MonetConnection.this.in.discardRemainder();
                                    continue block22;
                                }
                                MonetConnection.this.in.advance();
                                while (string2 == null && MonetConnection.this.in.getLineType() == LineType.HEADER) {
                                    string2 = response.addLine(MonetConnection.this.in.getLine(), MonetConnection.this.in.getLineType());
                                    MonetConnection.this.in.advance();
                                }
                                while (string2 == null && response.wantsMore()) {
                                    string2 = response.addLine(MonetConnection.this.in.getLine(), MonetConnection.this.in.getLineType());
                                    MonetConnection.this.in.advance();
                                }
                                if (string2 != null) {
                                    string2 = "M0M10!" + string2;
                                    MonetConnection.this.in.discardRemainder(string2);
                                    continue block22;
                                }
                                if (response instanceof DataBlockResponse) continue block22;
                                this.responses.add(response);
                                continue block22;
                            }
                            case INFO: {
                                MonetConnection.this.addWarning(MonetConnection.this.in.getLine().substring(1), "01000");
                                MonetConnection.this.in.advance();
                                continue block22;
                            }
                            case FILETRANSFER: {
                                MonetConnection.this.in.advance();
                                String string3 = MonetConnection.this.in.getLine();
                                MonetConnection.this.in.advance();
                                string2 = string3 != null ? MonetConnection.this.handleTransfer(string3) : "Protocol violation, expected transfer command, got nothing";
                                if (string2 != null) {
                                    MonetConnection.this.out.writeLine(string2 + "\n");
                                    string2 = MonetConnection.this.in.discardRemainder();
                                    continue block22;
                                }
                                MonetConnection.this.in.resetLineType();
                                MonetConnection.this.in.advance();
                                continue block22;
                            }
                            default: {
                                String string4 = "M0M10!protocol violation, unexpected " + (Object)((Object)MonetConnection.this.in.getLineType()) + " line: " + MonetConnection.this.in.getLine();
                                string2 = MonetConnection.this.in.discardRemainder(string4);
                                continue block22;
                            }
                            case ERROR: 
                        }
                        string2 = MonetConnection.this.in.discardRemainder(MonetConnection.this.in.getLine().substring(1));
                    }
                }
                if (string2 != null) {
                    object = null;
                    String[] stringArray2 = string2.split("\n");
                    for (int i = 0; i < stringArray2.length; ++i) {
                        SQLException sQLException = stringArray2[i].length() >= 6 ? new SQLException(stringArray2[i].substring(6), stringArray2[i].substring(0, 5)) : new SQLNonTransientConnectionException(stringArray2[i], "08000");
                        if (object == null) {
                            object = sQLException;
                            continue;
                        }
                        ((SQLException)object).setNextException(sQLException);
                    }
                    throw object;
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.close();
                throw new SQLNonTransientConnectionException("connection timed out", "08M33");
            }
            catch (IOException iOException) {
                MonetConnection.this.closed = true;
                throw new SQLNonTransientConnectionException(iOException.getMessage() + " (mserver5 still alive?)", "08006");
            }
        }
    }

    public static class Upload {
        private final MapiSocket server;
        private final Runnable cancellationCallback;
        private final boolean textMode;
        private PrintStream print = null;
        private String error = null;
        private int customChunkSize = -1;

        Upload(MapiSocket mapiSocket, Runnable runnable, boolean bl) {
            this.server = mapiSocket;
            this.cancellationCallback = runnable;
            this.textMode = bl;
        }

        public void sendError(String string) throws IOException {
            if (this.error != null) {
                throw new IOException("another error has already been sent: " + this.error);
            }
            this.error = string;
        }

        public void setChunkSize(int n) {
            this.customChunkSize = n;
        }

        public PrintStream getStream() throws IOException {
            if (this.error != null) {
                throw new IOException("Cannot send data after an error has been sent");
            }
            if (this.print == null) {
                try {
                    MapiSocket.UploadStream uploadStream = this.customChunkSize >= 0 ? this.server.uploadStream(this.customChunkSize) : this.server.uploadStream();
                    uploadStream.setCancellationCallback(this.cancellationCallback);
                    this.print = new PrintStream((OutputStream)(this.textMode ? new StripCrLfStream(uploadStream) : uploadStream), false, "UTF-8");
                    uploadStream.write(10);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException("The system is guaranteed to support the UTF-8 encoding but apparently it doesn't", unsupportedEncodingException);
                }
            }
            return this.print;
        }

        public boolean hasBeenUsed() {
            return this.print != null || this.error != null;
        }

        public String getError() {
            return this.error;
        }

        public void uploadFrom(InputStream inputStream) throws IOException {
            int n;
            PrintStream printStream = this.getStream();
            byte[] byArray = new byte[65536];
            while ((n = inputStream.read(byArray)) >= 0) {
                ((OutputStream)printStream).write(byArray, 0, n);
            }
        }

        public void uploadFrom(BufferedReader bufferedReader, long l) throws IOException {
            int n = 0;
            while ((long)n < l) {
                String string = bufferedReader.readLine();
                if (string == null) {
                    return;
                }
                ++n;
            }
            this.uploadFrom(bufferedReader);
        }

        public void uploadFrom(Reader reader) throws IOException {
            int n;
            PrintStream printStream = this.getStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)printStream, StandardCharsets.UTF_8);
            char[] cArray = new char[65536];
            while ((n = reader.read(cArray, 0, cArray.length)) >= 0) {
                outputStreamWriter.write(cArray, 0, n);
            }
            outputStreamWriter.close();
        }

        public void close() {
            if (this.print != null) {
                this.print.close();
                this.print = null;
            }
        }
    }

    public static class Download {
        private final MapiSocket server;
        private boolean prependCr;
        private MapiSocket.DownloadStream stream = null;
        private String error = null;

        Download(MapiSocket mapiSocket, boolean bl) {
            this.server = mapiSocket;
            this.prependCr = false;
            if (bl) {
                this.setLineSeparator(System.lineSeparator());
            }
        }

        public void sendError(String string) throws IOException {
            if (this.error != null) {
                throw new IOException("another error has already been sent: " + this.error);
            }
            this.error = string;
        }

        public InputStream getStream() throws IOException {
            if (this.error != null) {
                throw new IOException("cannot receive data after error has been sent");
            }
            if (this.stream == null) {
                this.stream = this.server.downloadStream(this.prependCr);
                this.server.getOutputStream().flush();
            }
            return this.stream;
        }

        public void downloadTo(OutputStream outputStream) throws IOException {
            int n;
            InputStream inputStream = this.getStream();
            byte[] byArray = new byte[65536];
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
        }

        public void downloadTo(Writer writer) throws IOException {
            int n;
            InputStream inputStream = this.getStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            char[] cArray = new char[65536];
            while ((n = inputStreamReader.read(cArray)) >= 0) {
                writer.write(cArray, 0, n);
            }
        }

        public boolean hasBeenUsed() {
            return this.stream != null || this.error != null;
        }

        public String getError() {
            return this.error;
        }

        public void close() {
            if (this.stream != null) {
                try {
                    this.stream.close();
                    this.stream = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void setLineSeparator(String string) {
            if ("\n".equals(string)) {
                this.prependCr = false;
            } else if ("\r\n".equals(string)) {
                this.prependCr = true;
            } else {
                throw new IllegalArgumentException("sep must be \\n or \\r\\n");
            }
        }
    }

    static enum SqlOption {
        Autocommit(1, "auto_commit"),
        ReplySize(2, "reply_size"),
        SizeHeader(3, "size_header"),
        TimeZone(5, "time_zone");

        final int level;
        final String field;

        private SqlOption(int n2, String string2) {
            this.level = n2;
            this.field = string2;
        }
    }

    public static class StripCrLfStream
    extends FilterOutputStream {
        private boolean crPending = false;

        public StripCrLfStream(OutputStream outputStream) {
            super(outputStream);
        }

        public boolean pending() {
            return this.crPending;
        }

        @Override
        public void write(int n) throws IOException {
            if (this.crPending && n != 10) {
                this.out.write(13);
            }
            if (n != 13) {
                this.out.write(n);
                this.crPending = false;
            } else {
                this.crPending = true;
            }
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (n2 == 0) {
                return;
            }
            if (this.crPending && byArray[0] != 10) {
                this.out.write(13);
            }
            if (byArray[n2 - 1] == 13) {
                this.crPending = true;
                --n2;
            } else {
                this.crPending = false;
            }
            for (int i = n; i < n + n2 - 1; ++i) {
                if (byArray[i] != 13 || byArray[i + 1] != 10) continue;
                int n3 = i - n;
                this.out.write(byArray, n, n3);
                n2 -= n3 + 1;
                n += n3 + 1;
                ++i;
            }
            this.out.write(byArray, n, n2);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.crPending) {
                this.out.write(13);
            }
            this.crPending = false;
            super.close();
        }
    }

    private final class AutoCommitResponse
    extends SchemaResponse {
        public final boolean autocommit;

        public AutoCommitResponse(boolean bl) {
            this.autocommit = bl;
        }
    }

    class SchemaResponse
    implements Response {
        SchemaResponse() {
        }

        @Override
        public String addLine(String string, LineType lineType) {
            return "Header lines are not supported for a SchemaResponse";
        }

        @Override
        public boolean wantsMore() {
            return false;
        }

        @Override
        public void close() {
        }
    }

    static final class UpdateResponse
    implements Response {
        public final long count;
        public final String lastid;

        public UpdateResponse(long l, String string) {
            this.count = l;
            this.lastid = string;
        }

        @Override
        public String addLine(String string, LineType lineType) {
            return "Header lines are not supported for an UpdateResponse";
        }

        @Override
        public boolean wantsMore() {
            return false;
        }

        @Override
        public void close() {
        }
    }

    private static final class DataBlockResponse
    implements Response {
        private final String[] data;
        private int pos = -1;
        private final boolean forwardOnly;

        DataBlockResponse(int n, boolean bl) {
            this.data = new String[n];
            this.forwardOnly = bl;
        }

        @Override
        public String addLine(String string, LineType lineType) {
            if (lineType != LineType.RESULT) {
                return "protocol violation: unexpected " + (Object)((Object)lineType) + " line in data block: " + string;
            }
            this.data[++this.pos] = string;
            return null;
        }

        @Override
        public boolean wantsMore() {
            return this.pos + 1 < this.data.length;
        }

        @Override
        public void close() {
            Arrays.fill(this.data, null);
        }

        String getRow(int n) {
            if (this.forwardOnly) {
                String string = this.data[n];
                this.data[n] = null;
                return string;
            }
            return this.data[n];
        }
    }

    final class ResultSetResponse
    implements Response {
        public final int columncount;
        public final long tuplecount;
        private int cacheSize;
        public final int id;
        private String[] name;
        private String[] type;
        private int[] columnLengths;
        private int[] colPrecisions;
        private int[] colScales;
        private String[] tableNames;
        private String[] schemaNames;
        private final int seqnr;
        private DataBlockResponse[] resultBlocks;
        private boolean closed;
        private final ResponseList parent;
        private final boolean cacheSizeSetExplicitly;
        private boolean destroyOnClose;
        private int blockOffset;
        private final HeaderLineParser hlp;
        private final boolean[] isSet = new boolean[5];
        private static final int NAMES = 0;
        private static final int TYPES = 1;
        private static final int TABLES = 2;
        private static final int LENS = 3;
        private static final int TYPESIZES = 4;

        ResultSetResponse(int n, long l, long l2, int n2, int n3, ResponseList responseList, int n4) {
            this.parent = responseList;
            if (responseList.cachesize == 0) {
                this.cacheSize = MonetConnection.this.defaultFetchSize;
                this.cacheSizeSetExplicitly = false;
            } else {
                this.cacheSize = responseList.cachesize;
                this.cacheSizeSetExplicitly = true;
            }
            if (n3 > this.cacheSize) {
                this.cacheSize = n3;
            }
            this.seqnr = n4;
            this.closed = false;
            this.destroyOnClose = l > (long)n3;
            this.id = n;
            this.tuplecount = l2;
            this.columncount = n2;
            this.resultBlocks = new DataBlockResponse[(int)(l2 / (long)this.cacheSize) + 1];
            this.hlp = new HeaderLineParser(n2);
            this.resultBlocks[0] = new DataBlockResponse(n3, responseList.rstype == 1003);
        }

        @Override
        public String addLine(String string, LineType lineType) {
            if (lineType == LineType.RESULT || this.isSet[3] && this.isSet[1] && this.isSet[2] && this.isSet[0] && this.isSet[4]) {
                if (!this.isSet[4]) {
                    this.isSet[4] = true;
                }
                return this.resultBlocks[0].addLine(string, lineType);
            }
            if (lineType != LineType.HEADER) {
                if (!this.isSet[4]) {
                    this.isSet[4] = true;
                }
                return "Header expected, got " + (Object)((Object)lineType) + " line: " + string;
            }
            try {
                switch (this.hlp.parse(string)) {
                    case 1: {
                        this.name = (String[])this.hlp.values.clone();
                        this.isSet[0] = true;
                        break;
                    }
                    case 2: {
                        this.columnLengths = (int[])this.hlp.intValues.clone();
                        this.isSet[3] = true;
                        break;
                    }
                    case 4: {
                        this.type = (String[])this.hlp.values.clone();
                        this.isSet[1] = true;
                        break;
                    }
                    case 3: {
                        this.tableNames = (String[])this.hlp.values.clone();
                        int n = this.tableNames.length;
                        this.schemaNames = new String[n];
                        for (int i = 0; i < n; ++i) {
                            String string2 = this.tableNames[i];
                            if (string2 != null) {
                                int n2 = string2.indexOf(46);
                                if (n2 >= 0) {
                                    this.schemaNames[i] = string2.substring(0, n2);
                                    this.tableNames[i] = string2.substring(n2 + 1);
                                    continue;
                                }
                                this.schemaNames[i] = "";
                                continue;
                            }
                            this.schemaNames[i] = "";
                            this.tableNames[i] = "";
                        }
                        this.isSet[2] = true;
                        break;
                    }
                    case 5: {
                        int n = this.hlp.values.length;
                        this.colPrecisions = new int[n];
                        this.colScales = new int[n];
                        for (int i = 0; i < n; ++i) {
                            String string3 = this.hlp.values[i];
                            if (string3 != null) {
                                try {
                                    int n3 = string3.indexOf(32);
                                    if (n3 > 0) {
                                        this.colPrecisions[i] = Integer.parseInt(string3.substring(0, n3));
                                        this.colScales[i] = Integer.parseInt(string3.substring(n3 + 1));
                                        continue;
                                    }
                                    this.colPrecisions[i] = Integer.parseInt(string3);
                                    this.colScales[i] = 0;
                                    continue;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    return numberFormatException.getMessage();
                                }
                            }
                            this.colPrecisions[i] = 1;
                            this.colScales[i] = 0;
                        }
                        this.isSet[4] = true;
                        break;
                    }
                }
            }
            catch (MCLParseException mCLParseException) {
                return mCLParseException.getMessage();
            }
            return null;
        }

        @Override
        public boolean wantsMore() {
            return this.resultBlocks[0].wantsMore();
        }

        private final String[] getValues(char[] cArray, int n, int n2) {
            int n3 = 0;
            String[] stringArray = new String[this.columncount];
            for (int i = n; i < n2; ++i) {
                if (cArray[i] != '\t' || cArray[i - 1] != ',') continue;
                stringArray[n3++] = new String(cArray, n, i - 1 - n);
                n = i + 1;
            }
            stringArray[n3++] = new String(cArray, n, n2 - n);
            return stringArray;
        }

        void addDataBlockResponse(int n, DataBlockResponse dataBlockResponse) {
            int n2 = (n - this.blockOffset) / this.cacheSize;
            this.resultBlocks[n2] = dataBlockResponse;
        }

        String[] getNames() {
            return this.name;
        }

        String[] getTypes() {
            return this.type;
        }

        String[] getTableNames() {
            return this.tableNames;
        }

        String[] getSchemaNames() {
            return this.schemaNames;
        }

        int[] getColumnLengths() {
            return this.columnLengths;
        }

        int[] getColumnPrecisions() {
            return this.colPrecisions;
        }

        int[] getColumnScales() {
            return this.colScales;
        }

        int getCacheSize() {
            return this.cacheSize;
        }

        int getBlockOffset() {
            return this.blockOffset;
        }

        int getRSType() {
            return this.parent.rstype;
        }

        int getRSConcur() {
            return this.parent.rsconcur;
        }

        String getLine(int n) throws SQLException {
            if ((long)n >= this.tuplecount || n < 0) {
                return null;
            }
            int n2 = (n - this.blockOffset) / this.cacheSize;
            int n3 = (n - this.blockOffset) % this.cacheSize;
            DataBlockResponse dataBlockResponse = this.resultBlocks[n2];
            if (dataBlockResponse == null) {
                if (this.parent.rstype == 1003) {
                    for (int i = 0; i < n2; ++i) {
                        this.resultBlocks[i] = null;
                    }
                    if (seqCounter - 1 == this.seqnr && !this.cacheSizeSetExplicitly && this.tuplecount - (long)n > (long)this.cacheSize && this.cacheSize < 2500) {
                        this.blockOffset += this.cacheSize;
                        this.cacheSize *= 10;
                        n2 = (n - this.blockOffset) / this.cacheSize;
                        n3 = (n - this.blockOffset) % this.cacheSize;
                    }
                }
                this.parent.executeQuery(MonetConnection.this.commandTempl, "export " + this.id + " " + (n2 * this.cacheSize + this.blockOffset) + " " + this.cacheSize);
                dataBlockResponse = this.resultBlocks[n2];
                if (dataBlockResponse == null) {
                    throw new SQLException("resultBlocks[" + n2 + "] should have been fetched by now", "M0M10");
                }
            }
            return dataBlockResponse.getRow(n3);
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            try {
                if (this.destroyOnClose) {
                    MonetConnection.this.sendControlCommand("close " + this.id);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            for (int i = 1; i < this.resultBlocks.length; ++i) {
                DataBlockResponse dataBlockResponse = this.resultBlocks[i];
                if (dataBlockResponse == null) continue;
                dataBlockResponse.close();
            }
            this.name = null;
            this.type = null;
            this.columnLengths = null;
            this.colPrecisions = null;
            this.colScales = null;
            this.tableNames = null;
            this.schemaNames = null;
            this.resultBlocks = null;
            this.closed = true;
        }

        boolean isClosed() {
            return this.closed;
        }
    }

    static interface Response {
        public String addLine(String var1, LineType var2);

        public boolean wantsMore();

        public void close();
    }
}

