/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import org.monetdb.client.QueryPart;
import org.monetdb.client.SQLStack;
import org.monetdb.client.Table;
import org.monetdb.jdbc.MonetConnection;
import org.monetdb.jdbc.MonetDriver;
import org.monetdb.util.CmdLineOpts;
import org.monetdb.util.Exporter;
import org.monetdb.util.FileTransferHandler;
import org.monetdb.util.MDBvalidator;
import org.monetdb.util.OptionsException;
import org.monetdb.util.SQLExporter;
import org.monetdb.util.XMLExporter;

public final class JdbcClient {
    private static Connection con;
    private static DatabaseMetaData dbmd;
    private static Statement stmt;
    private static BufferedReader in;
    private static PrintWriter out;
    private static Exporter exporter;

    /*
     * WARNING - void declaration
     */
    public static final void main(String[] stringArray) throws Exception {
        Object object;
        String[] stringArray2;
        String string;
        Object object2;
        Object object3;
        Properties properties = new Properties();
        CmdLineOpts cmdLineOpts = new CmdLineOpts();
        cmdLineOpts.addOption("h", "host", 1, "localhost", "The hostname of the host that runs the MonetDB database.  A port number can be supplied by use of a colon, i.e. -h somehost:12345.");
        cmdLineOpts.addOption("p", "port", 1, "50000", "The port number to connect to.");
        cmdLineOpts.addOption("f", "file", 1, null, "A file name to use either for reading or writing.  The file will be used for writing when dump mode is used (-D --dump).  In read mode, the file can also be an URL pointing to a plain text file that is optionally gzip compressed.");
        cmdLineOpts.addOption("u", "user", 1, System.getProperty("user.name"), "The username to use when connecting to the database.");
        cmdLineOpts.addOption(null, "password", 1, null, null);
        cmdLineOpts.addOption("d", "database", 1, "", "Try to connect to the given database (only makes sense if connecting to monetdbd).");
        cmdLineOpts.addOption("l", "language", 1, "sql", "Use the given language, defaults to 'sql'.");
        cmdLineOpts.addOption(null, "csvdir", 1, null, "The directory path where csv data files are read or written when using ON CLIENT clause of COPY command.");
        cmdLineOpts.addOption(null, "help", 0, null, "This help screen.");
        cmdLineOpts.addOption(null, "version", 0, null, "Display driver version and exit.");
        cmdLineOpts.addOption("e", "echo", 0, null, "Also outputs the contents of the input file, if any.");
        cmdLineOpts.addOption("q", "quiet", 0, null, "Suppress printing the welcome header.");
        cmdLineOpts.addOption("D", "dump", 3, null, "Dumps the given table(s), or the complete database if none given.");
        cmdLineOpts.addOption(null, "Xoutput", 1, null, "The output mode when dumping.  Default is sql, xml may be used for an experimental XML output.");
        cmdLineOpts.addOption(null, "Xhash", 1, null, "Use the given hash algorithm during challenge response. Supported algorithm names: SHA512, SHA384, SHA256 and SHA1.");
        cmdLineOpts.addOption(null, "Xdebug", 2, null, "Writes a transmission log to disk for debugging purposes. If a file name is given, it is used, otherwise a file called monet<timestamp>.log is created.  A given file never be overwritten; instead a unique variation of the file is used.");
        cmdLineOpts.addOption(null, "Xbatching", 2, null, "Indicates that a batch should be used instead of direct communication with the server for each statement.  If a number is given, it is used as batch size.  i.e. 8000 would execute the contents on the batch after each 8000 statements read.  Batching can greatly speedup the process of restoring a database dump.");
        cmdLineOpts.addIgnored("save_history");
        cmdLineOpts.addIgnored("format");
        cmdLineOpts.addIgnored("width");
        String string2 = null;
        String string3 = null;
        File file = new File(".monetdb");
        if (!file.exists()) {
            file = new File(System.getProperty("user.home"), ".monetdb");
        }
        if (file.exists()) {
            try {
                cmdLineOpts.processFile(file);
            }
            catch (OptionsException optionsException) {
                System.err.println("Error in " + file.getAbsolutePath() + ": " + optionsException.getMessage());
                System.exit(1);
            }
            string3 = cmdLineOpts.getOption("user").getArgument();
            string2 = cmdLineOpts.getOption("password").getArgument();
        }
        cmdLineOpts.removeOption("password");
        try {
            cmdLineOpts.processArgs(stringArray);
        }
        catch (OptionsException optionsException) {
            System.err.println("Error: " + optionsException.getMessage());
            System.exit(1);
        }
        if (string3 != cmdLineOpts.getOption("user").getArgument()) {
            string2 = null;
        }
        if (cmdLineOpts.getOption("help").isPresent()) {
            System.out.print("Usage java -jar jdbcclient.jre8.jar\n\t\t[-h host[:port]] [-p port] [-f file] [-u user]\n\t\t[-l language] [-d database] [-e] [-D [table]]\n\t\t[--csvdir /path/to/csvfiles]] [-X<opt>]\n\t\t| [--help] | [--version]\nor using long option equivalents --host --port --file --user --language\n--dump --echo --database.\nArguments may be written directly after the option like -p50000.\n\nIf no host and port are given, localhost and 50000 are assumed.\nAn .monetdb file may exist in the user's home directory.  This file can contain\npreferences to use each time JdbcClient is started.  Options given on the\ncommand line override the preferences file.  The .monetdb file syntax is\n<option>=<value> where option is one of the options host, port, file, mode\ndebug, or password.  Note that the last one is perilous and therefore not\navailable as command line option.\nIf no input file is given using the -f flag, an interactive session is\nstarted on the terminal.\n\nOPTIONS\n" + cmdLineOpts.produceHelpMessage());
            System.exit(0);
        }
        if (cmdLineOpts.getOption("version").isPresent()) {
            System.out.println("JDBC Driver: v" + MonetDriver.getDriverVersion());
            System.exit(0);
        }
        boolean bl = "xml".equals(cmdLineOpts.getOption("Xoutput").getArgument());
        if (string2 == null) {
            object3 = System.console();
            object2 = null;
            if (object3 != null) {
                object2 = ((Console)object3).readPassword("password: ", new Object[0]);
            }
            if (object2 == null) {
                System.err.println("Invalid password!");
                System.exit(1);
            }
            string2 = String.valueOf(object2);
        }
        string3 = cmdLineOpts.getOption("user").getArgument();
        object3 = cmdLineOpts.getOption("host").getArgument();
        object2 = cmdLineOpts.getOption("port").getArgument();
        int n = ((String)object3).indexOf(58);
        if (n > 0) {
            object2 = ((String)object3).substring(n + 1);
            object3 = ((String)object3).substring(0, n);
        }
        properties.setProperty("host", (String)object3);
        properties.setProperty("port", (String)object2);
        properties.setProperty("fetchsize", "10000");
        CmdLineOpts.OptionContainer optionContainer = cmdLineOpts.getOption("language");
        String string4 = optionContainer.getArgument();
        if (optionContainer.isPresent()) {
            properties.setProperty("language", string4);
        }
        if ((optionContainer = cmdLineOpts.getOption("Xdebug")).isPresent()) {
            properties.setProperty("debug", "true");
            if (optionContainer.getArgumentCount() == 1) {
                properties.setProperty("logfile", "logfile=" + optionContainer.getArgument());
            }
        }
        if ((optionContainer = cmdLineOpts.getOption("Xhash")).isPresent()) {
            properties.setProperty("hash", optionContainer.getArgument());
        }
        con = null;
        String string5 = cmdLineOpts.getOption("database").getArgument();
        try {
            Class.forName("org.monetdb.jdbc.MonetDriver");
            if (string5.startsWith("jdbc:")) {
                string = string5;
            } else {
                string = "jdbc:monetdb:";
                properties.setProperty("database", string5);
            }
            properties.setProperty("user", string3);
            properties.setProperty("password", string2);
            con = DriverManager.getConnection(string, properties);
            for (stringArray2 = con.getWarnings(); stringArray2 != null; stringArray2 = stringArray2.getNextWarning()) {
                System.err.println("Connection warning: " + stringArray2.getMessage());
            }
            con.clearWarnings();
        }
        catch (SQLException sQLException) {
            System.err.println("Database connect failed: " + sQLException.getMessage());
            System.exit(1);
        }
        try {
            dbmd = con.getMetaData();
        }
        catch (SQLException sQLException) {
            dbmd = null;
        }
        optionContainer = cmdLineOpts.getOption("csvdir");
        if (optionContainer.isPresent() && (string = optionContainer.getArgument()) != null) {
            if (Files.isDirectory(Paths.get(string, new String[0]), new LinkOption[0])) {
                stringArray2 = new FileTransferHandler(string, Charset.defaultCharset());
                ((MonetConnection)con).setUploadHandler((MonetConnection.UploadHandler)stringArray2);
                ((MonetConnection)con).setDownloadHandler((MonetConnection.DownloadHandler)stringArray2);
            } else {
                System.err.println("Warning: provided csvdir \"" + string + "\" does not exist. Ignoring csvdir setting.");
            }
        }
        stmt = con.createStatement();
        in = new BufferedReader(new InputStreamReader(System.in));
        out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
        if ("sql".equals(string4) && cmdLineOpts.getOption("dump").isPresent() && dbmd != null) {
            int n2 = cmdLineOpts.getOption("dump").getArgumentCount();
            optionContainer = cmdLineOpts.getOption("file");
            if (optionContainer.isPresent()) {
                out = new PrintWriter(new BufferedWriter(new FileWriter(optionContainer.getArgument())));
            }
            stringArray2 = new String[]{"TABLE", "VIEW", "MERGE TABLE", "REMOTE TABLE", "REPLICA TABLE", "STREAM TABLE"};
            object = dbmd.getTables(null, con.getSchema(), null, (String[])(n2 == 0 ? stringArray2 : null));
            LinkedList<Table> linkedList = new LinkedList<Table>();
            while (object.next()) {
                linkedList.add(new Table(object.getString(2), object.getString(3), object.getString(4)));
            }
            object.close();
            object = null;
            if (bl) {
                exporter = new XMLExporter(out);
                exporter.setProperty(1, 1);
            } else {
                exporter = new SQLExporter(out);
                exporter.setProperty(1, 0);
            }
            exporter.useSchemas(true);
            if (!bl) {
                out.println("START TRANSACTION;\n");
            }
            if (n2 > 0) {
                void list2;
                String[] stringArray3 = cmdLineOpts.getOption("dump").getArguments();
                boolean i = false;
                while (list2 < linkedList.size()) {
                    Table table = (Table)linkedList.get((int)list2);
                    for (int j = 0; j < stringArray3.length; ++j) {
                        String string6 = stringArray3[j].toString();
                        if (!table.getName().equalsIgnoreCase(string6) && !table.getFqname().equalsIgnoreCase(string6)) continue;
                        JdbcClient.doDump(out, table);
                    }
                    ++list2;
                }
            } else {
                object = dbmd.getImportedKeys(null, null, null);
                while (object.next()) {
                    Table table = Table.findTable(object.getString(6), object.getString(7), linkedList);
                    Table table2 = Table.findTable(object.getString(2), object.getString(3), linkedList);
                    if (table == null || table2 == null) continue;
                    table.addDependency(table2);
                }
                object.close();
                object = null;
                for (Table table : linkedList) {
                    Table.checkForLoop(table, new ArrayList<Table>());
                }
                for (int i = 0; i < linkedList.size(); ++i) {
                    List<Table> list = linkedList.get(i).requires(linkedList.subList(0, i + 1));
                    if (list.size() <= 0) continue;
                    linkedList.removeAll(list);
                    linkedList.addAll(i, list);
                    --i;
                }
                for (Table table : linkedList) {
                    JdbcClient.doDump(out, table);
                }
            }
            if (!bl) {
                out.println("COMMIT;");
            }
            out.flush();
            stmt.close();
            con.close();
            System.exit(0);
        }
        if (bl) {
            exporter = new XMLExporter(out);
            exporter.setProperty(1, 1);
        } else {
            exporter = new SQLExporter(out);
            exporter.setProperty(1, 2);
        }
        exporter.useSchemas(false);
        try {
            boolean bl2;
            boolean bl3 = cmdLineOpts.getOption("file").isPresent();
            boolean bl4 = bl2 = bl3 && cmdLineOpts.getOption("echo").isPresent();
            if (bl3) {
                object = cmdLineOpts.getOption("file").getArgument();
                try {
                    in = JdbcClient.getReader((String)object);
                }
                catch (Exception exception) {
                    System.err.println("Error: " + exception.getMessage());
                    System.exit(1);
                }
                int n3 = 0;
                optionContainer = cmdLineOpts.getOption("Xbatching");
                if (optionContainer.isPresent()) {
                    if (optionContainer.getArgumentCount() == 1) {
                        try {
                            n3 = Integer.parseInt(optionContainer.getArgument());
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException("Illegal argument for Xbatching: " + optionContainer.getArgument() + " is not a parseable number!");
                        }
                    }
                    JdbcClient.processBatch(n3);
                } else {
                    JdbcClient.processInteractive(true, bl2, true, string3);
                }
            } else {
                if (!cmdLineOpts.getOption("quiet").isPresent()) {
                    out.println("Welcome to the MonetDB interactive JDBC terminal!");
                    if (dbmd != null) {
                        out.println("JDBC Driver: " + dbmd.getDriverName() + " v" + dbmd.getDriverVersion());
                        out.println("Database Server: " + dbmd.getDatabaseProductName() + " v" + dbmd.getDatabaseProductVersion());
                    }
                    out.println("Current Schema: " + con.getSchema());
                    out.println("Type \\q to quit (you can also use: quit or exit), \\? or \\h for a list of available commands");
                    out.flush();
                }
                JdbcClient.processInteractive(false, bl2, true, string3);
            }
            stmt.close();
            con.close();
            in.close();
        }
        catch (Exception exception) {
            System.err.println("A fatal exception occurred: " + exception.toString());
            exception.printStackTrace(System.err);
            try {
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            System.exit(1);
        }
    }

    static BufferedReader getReader(String string) throws Exception {
        BufferedReader bufferedReader;
        block7: {
            bufferedReader = null;
            URI uRI = null;
            try {
                uRI = new URI(string);
                if (uRI != null && uRI.isAbsolute()) {
                    URL uRL = uRI.toURL();
                    HttpURLConnection.setFollowRedirects(true);
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setRequestMethod("GET");
                    String string2 = httpURLConnection.getContentType();
                    bufferedReader = "application/x-gzip".equals(string2) ? new BufferedReader(new InputStreamReader(new GZIPInputStream(httpURLConnection.getInputStream()))) : new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                }
            }
            catch (IOException iOException) {
                throw new Exception("Failed to open/read http URL: " + iOException.getMessage());
            }
            catch (Exception exception) {
                if (uRI == null) break block7;
                throw new Exception("Invalid http URL: " + string + "\n" + exception.getMessage());
            }
        }
        if (bufferedReader == null) {
            try {
                bufferedReader = new BufferedReader(new FileReader(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Exception(fileNotFoundException.getMessage());
            }
        }
        return bufferedReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processInteractive(boolean bl, boolean bl2, boolean bl3, String string) throws IOException, SQLException {
        SQLStack sQLStack = new SQLStack();
        boolean bl4 = false;
        if (!bl) {
            bl4 = con.getAutoCommit();
            out.println("auto commit mode: " + (bl4 ? "on" : "off"));
            out.print(JdbcClient.getPrompt(sQLStack, true));
            out.flush();
        }
        String string2 = "";
        boolean bl5 = true;
        long l = 1L;
        while (true) {
            String string3;
            if ((string3 = in.readLine()) == null) {
                out.println("");
                if (string2.isEmpty()) break;
                try {
                    JdbcClient.executeQuery(string2, stmt, out, !bl);
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2;
                    out.flush();
                    do {
                        if (bl) {
                            System.err.println("Error on line " + l + ": [" + sQLException2.getSQLState() + "] " + sQLException2.getMessage());
                            continue;
                        }
                        System.err.println("Error [" + sQLException2.getSQLState() + "]: " + sQLException2.getMessage());
                    } while ((sQLException2 = sQLException2.getNextException()) != null);
                }
                string2 = "";
                bl5 = true;
                if (!bl) {
                    boolean bl6 = con.getAutoCommit();
                    if (bl6 != bl4) {
                        out.println("auto commit mode: " + (bl6 ? "on" : "off"));
                        bl4 = bl6;
                    }
                    out.print(JdbcClient.getPrompt(sQLStack, bl5));
                }
                out.flush();
            } else {
                QueryPart queryPart;
                if (bl2) {
                    out.println(string3);
                    out.flush();
                }
                if (!(queryPart = JdbcClient.scanQuery(string3, sQLStack, bl3)).isEmpty()) {
                    Object object;
                    Object object2;
                    String string4 = queryPart.getQuery();
                    boolean bl7 = true;
                    if (bl5) {
                        bl7 = false;
                        if (string4.equals("\\q") || string4.equals("quit") || string4.equals("exit")) break;
                        if (dbmd != null && string4.startsWith("\\d")) {
                            JdbcClient.processDescribeCmd(string4, bl3);
                        } else if (string4.startsWith("\\v")) {
                            if (string4.equals("\\vsci")) {
                                MDBvalidator.validateSqlCatalogIntegrity(con, true);
                            } else if (string4.equals("\\vsci_noheader")) {
                                MDBvalidator.validateSqlCatalogIntegrity(con, false);
                            } else if (string4.equals("\\vsni")) {
                                MDBvalidator.validateSqlNetcdfTablesIntegrity(con, true);
                            } else if (string4.equals("\\vsni_noheader")) {
                                MDBvalidator.validateSqlNetcdfTablesIntegrity(con, false);
                            } else if (string4.equals("\\vsgi")) {
                                MDBvalidator.validateSqlGeomTablesIntegrity(con, true);
                            } else if (string4.equals("\\vsgi_noheader")) {
                                MDBvalidator.validateSqlGeomTablesIntegrity(con, false);
                            } else if (string4.startsWith("\\vsi ")) {
                                object2 = string4.substring(5).trim();
                                if (((String)object2).endsWith(";")) {
                                    object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                                }
                                MDBvalidator.validateSchemaIntegrity(con, (String)object2, true);
                            } else if (string4.startsWith("\\vsi_noheader ")) {
                                object2 = string4.substring(14);
                                MDBvalidator.validateSchemaIntegrity(con, (String)object2, false);
                            } else if (string4.equals("\\vdbi")) {
                                MDBvalidator.validateDBIntegrity(con, true);
                            } else if (string4.equals("\\vdbi_noheader")) {
                                MDBvalidator.validateDBIntegrity(con, false);
                            } else {
                                JdbcClient.showCommands();
                            }
                        } else if (string4.startsWith("\\l") || string4.startsWith("\\i")) {
                            object2 = string4.substring(2).trim();
                            if (bl3 && ((String)object2).endsWith(";")) {
                                object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                            }
                            if (((String)object2).isEmpty()) {
                                System.err.println("Usage: '" + string4.substring(0, 2) + "<uri>' where <uri> is a file or URL");
                            } else {
                                object = in;
                                try {
                                    in = JdbcClient.getReader((String)object2);
                                    if (string4.startsWith("\\l")) {
                                        JdbcClient.processInteractive(true, bl2, bl3, string);
                                    }
                                    JdbcClient.processBatch(0);
                                }
                                catch (Exception exception) {
                                    out.flush();
                                    System.err.println("Error: " + exception.getMessage());
                                }
                                finally {
                                    in = object;
                                }
                            }
                        } else if (string4.equals("\\?") || string4.equals("\\h") || string4.startsWith("\\")) {
                            JdbcClient.showCommands();
                        } else {
                            bl7 = true;
                        }
                    }
                    if (bl7) {
                        string2 = string2 + string4 + (queryPart.hasOpenQuote() ? "\\n" : " ");
                        if (queryPart.isComplete()) {
                            string2 = string2.substring(0, string2.length() - 2);
                            try {
                                JdbcClient.executeQuery(string2, stmt, out, !bl);
                            }
                            catch (SQLException sQLException) {
                                out.flush();
                                object = bl ? "Error on line " + l + ": [" : "Error [";
                                do {
                                    System.err.println((String)object + ((SQLException)object2).getSQLState() + "] " + ((Throwable)object2).getMessage());
                                } while ((object2 = ((SQLException)object2).getNextException()) != null);
                            }
                            string2 = "";
                            bl5 = true;
                        } else {
                            bl5 = false;
                        }
                    }
                }
                if (!bl) {
                    boolean bl8 = con.getAutoCommit();
                    if (bl8 != bl4) {
                        out.println("auto commit mode: " + (bl8 ? "on" : "off"));
                        bl4 = bl8;
                    }
                    out.print(JdbcClient.getPrompt(sQLStack, bl5));
                }
                out.flush();
            }
            ++l;
        }
    }

    private static void showCommands() {
        out.println("Available commands:");
        out.println("\\q       quits this program (you can also use: quit or exit)");
        if (dbmd != null) {
            out.println("\\d       list available user tables and views in current schema");
            out.println("\\dt      list available user tables in current schema");
            out.println("\\dv      list available user views in current schema");
            out.println("\\df      list available user functions in current schema");
            out.println("\\dp      list available user procedures in current schema");
            out.println("\\ds      list available user sequences in current schema");
            out.println("\\dn      list available user schemas");
            out.println("\\dS      list available system tables and views in sys/tmp/information_schema schema");
            out.println("\\dSt     list available system tables in sys/tmp schema");
            out.println("\\dSv     list available system views in sys/information_schema/logging schema");
            out.println("\\dSf     list available system functions in current schema");
            out.println("\\dSp     list available system procedures in current schema");
            out.println("\\dSn     list available system schemas");
            out.println("\\d <obj> describes the given table or view");
        }
        out.println("\\l<uri>  executes the contents of the given file or URL");
        out.println("\\i<uri>  batch executes the inserts from the given file or URL");
        out.println("\\vsci    validate sql system catalog integrity");
        out.println("\\vsi <schema>  validate integrity of data in the given schema");
        out.println("\\vdbi    validate integrity of data in all user schemas in the database");
        out.println("\\? or \\h this help screen");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processDescribeCmd(String string, boolean bl) {
        String string2 = string.substring(1);
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            if (string2.equals("d") || string2.equals("dt") || string2.equals("dv")) {
                boolean bl2 = string2.equals("dt");
                boolean bl3 = string2.equals("dv");
                resultSet = dbmd.getTables(null, con.getSchema(), null, null);
                while (resultSet.next()) {
                    boolean bl4;
                    String string3 = resultSet.getString(4);
                    boolean bl5 = bl4 = string3 != null && !string3.startsWith("SYSTEM ");
                    if (bl4 && bl2 && !string3.contains("TABLE")) {
                        bl4 = false;
                    }
                    if (bl4 && bl3 && !string3.contains("VIEW")) {
                        bl4 = false;
                    }
                    if (!bl4) continue;
                    out.println(string3 + "\t" + JdbcClient.optAddDqs(resultSet.getString(2)) + "." + JdbcClient.optAddDqs(resultSet.getString(3)));
                }
            } else if (string2.equals("dS") || string2.equals("dSt") || string2.equals("dSv") || string2.equals("dtS") || string2.equals("dvS")) {
                boolean bl6 = string2.contains("t");
                boolean bl7 = string2.contains("v");
                String string4 = con.getSchema();
                if (!("sys".equals(string4) || "tmp".equals(string4) || "information_schema".equals(string4) || "logging".equals(string4))) {
                    string4 = "sys";
                }
                resultSet = dbmd.getTables(null, string4, null, null);
                while (resultSet.next()) {
                    boolean bl8;
                    String string5 = resultSet.getString(4);
                    boolean bl9 = bl8 = string5 != null && string5.startsWith("SYSTEM ");
                    if (bl8 && bl6 && !string5.contains("TABLE")) {
                        bl8 = false;
                    }
                    if (bl8 && bl7 && !string5.contains("VIEW")) {
                        bl8 = false;
                    }
                    if (!bl8) continue;
                    out.println(string5 + "\t" + JdbcClient.optAddDqs(resultSet.getString(2)) + "." + JdbcClient.optAddDqs(resultSet.getString(3)));
                }
            } else if (string2.equals("df") || string2.equals("dp") || string2.equals("dSf") || string2.equals("dSp") || string2.equals("dfS") || string2.equals("dpS")) {
                boolean bl10 = string2.contains("p");
                boolean bl11 = string2.contains("S");
                String string6 = "SELECT DISTINCT " + (bl11 ? "'SYSTEM ' || " : "") + "\"function_type_keyword\" as func_type, \"schemas\".\"name\" as schem_name, \"functions\".\"name\" as func_name FROM sys.\"functions\" JOIN sys.\"function_types\" ON \"functions\".\"type\" = \"function_types\".\"function_type_id\" JOIN sys.\"schemas\" ON \"functions\".\"schema_id\" = \"schemas\".\"id\" WHERE \"functions\".\"system\" = " + (bl11 ? "true" : "false") + " AND \"functions\".\"type\" " + (bl10 ? "= 2" : "<> 2") + " AND \"schemas\".\"name\" = current_schema ORDER BY 2, 3";
                statement = con.createStatement();
                resultSet = statement.executeQuery(string6);
                while (resultSet.next()) {
                    out.println(resultSet.getString(1) + "    \t" + JdbcClient.optAddDqs(resultSet.getString(2)) + "." + JdbcClient.optAddDqs(resultSet.getString(3)));
                }
            } else if (string2.equals("ds")) {
                String string7 = "SELECT \"schemas\".\"name\", \"sequences\".\"name\" FROM sys.\"sequences\" JOIN sys.\"schemas\" ON \"sequences\".\"schema_id\" = \"schemas\".\"id\" WHERE \"schemas\".\"name\" = current_schema ORDER BY 1, 2";
                statement = con.createStatement();
                resultSet = statement.executeQuery(string7);
                while (resultSet.next()) {
                    out.println("SEQUENCE  " + JdbcClient.optAddDqs(resultSet.getString(1)) + "." + JdbcClient.optAddDqs(resultSet.getString(2)));
                }
            } else if (string2.equals("dn") || string2.equals("dSn") || string2.equals("dnS")) {
                boolean bl12 = string2.contains("S");
                String string8 = "SELECT \"name\" FROM sys.\"schemas\" WHERE \"system\" = " + (bl12 ? "true" : "false") + " ORDER BY 1";
                String string9 = bl12 ? "SYSTEM SCHEMA\t" : "SCHEMA\t";
                statement = con.createStatement();
                resultSet = statement.executeQuery(string8);
                while (resultSet.next()) {
                    out.println(string9 + JdbcClient.optAddDqs(resultSet.getString(1)));
                }
            } else if (string2.startsWith("d ")) {
                String string10 = string2.substring(2).trim();
                if (bl && string10.endsWith(";")) {
                    string10 = string10.substring(0, string10.length() - 1);
                }
                if (string10.isEmpty()) {
                    System.err.println("Missing name of object to describe");
                } else {
                    int n;
                    String string11;
                    String string12 = string10;
                    boolean bl13 = false;
                    int n2 = string10.indexOf(46);
                    if (n2 > 0) {
                        string11 = string10.substring(0, n2);
                        string12 = string10.substring(n2 + 1);
                        n = string11.length();
                        if (n > 2 && string11.charAt(0) == '\"' && string11.charAt(n - 1) == '\"') {
                            string11 = string11.substring(1, n - 1);
                        }
                    } else {
                        string11 = con.getSchema();
                    }
                    if ((n = string12.length()) > 2 && string12.charAt(0) == '\"' && string12.charAt(n - 1) == '\"') {
                        string12 = string12.substring(1, n - 1);
                    }
                    resultSet = dbmd.getTables(null, string11, string12, null);
                    while (resultSet.next() && !bl13) {
                        String string13 = resultSet.getString(2);
                        String string14 = resultSet.getString(3);
                        if (!string12.equals(string14) || !string11.equals(string13)) continue;
                        String string15 = resultSet.getString(4);
                        if (string15.startsWith("SYSTEM ")) {
                            string15 = string15.substring(7);
                        }
                        exporter.dumpSchema(dbmd, string15, string13, string14);
                        bl13 = true;
                        break;
                    }
                    if (!bl13) {
                        System.err.println("table or view: " + string11 + "." + string12 + " does not exist");
                    }
                }
            } else if (string2.startsWith("d")) {
                System.err.println("unknown sub-command for \\d: " + string2.substring(1));
            } else {
                JdbcClient.showCommands();
            }
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            out.flush();
            do {
                System.err.println("Error [" + sQLException2.getSQLState() + "]: " + sQLException2.getMessage());
            } while ((sQLException2 = sQLException2.getNextException()) != null);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private static String optAddDqs(String string) {
        if (string.contains(" ") || string.contains("\t") || string.contains("\n")) {
            return Exporter.dq(string);
        }
        return string;
    }

    private static void executeQuery(String string, Statement statement, PrintWriter printWriter, boolean bl) throws SQLException {
        SQLWarning sQLWarning;
        long l = bl ? System.currentTimeMillis() : 0L;
        long l2 = 0L;
        long l3 = -1L;
        boolean bl2 = statement.execute(string, 1);
        if (!bl2) {
            l3 = statement.getLargeUpdateCount();
        }
        do {
            Object object;
            if (bl2) {
                object = statement.getResultSet();
                exporter.dumpResultSet((ResultSet)object);
                if (bl) {
                    l2 = System.currentTimeMillis();
                    printWriter.println("Elapsed Time: " + (l2 - l) + " ms");
                    l = l2;
                }
                if ((sQLWarning = object.getWarnings()) != null) {
                    printWriter.flush();
                    do {
                        System.err.println("ResultSet warning: " + sQLWarning.getMessage());
                    } while ((sQLWarning = sQLWarning.getNextWarning()) != null);
                    object.clearWarnings();
                }
                object.close();
            } else {
                object = "";
                if (bl) {
                    l2 = System.currentTimeMillis();
                    object = ". Elapsed Time: " + (l2 - l) + " ms";
                    l = l2;
                }
                if (l3 == -1L) {
                    printWriter.println("Operation successful" + (String)object);
                } else {
                    ResultSet resultSet = statement.getGeneratedKeys();
                    boolean bl3 = resultSet != null && resultSet.next();
                    printWriter.println(l3 + " affected row" + (l3 != 1L ? "s" : "") + (bl3 ? ", last generated key: " + resultSet.getString(1) : "") + (String)object);
                    resultSet.close();
                }
            }
            printWriter.flush();
        } while ((bl2 = statement.getMoreResults()) || (l3 = statement.getLargeUpdateCount()) != -1L);
        for (sQLWarning = statement.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
            System.err.println("Statement warning: " + sQLWarning.getMessage());
        }
        statement.clearWarnings();
        for (sQLWarning = con.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
            System.err.println("Connection warning: " + sQLWarning.getMessage());
        }
        con.clearWarnings();
    }

    private static void processBatch(int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(2048);
        int n2 = 0;
        try {
            String string;
            n2 = 1;
            while ((string = in.readLine()) != null) {
                stringBuilder.append(string);
                if (string.endsWith(";")) {
                    stmt.addBatch(stringBuilder.toString());
                    stringBuilder.setLength(0);
                } else {
                    stringBuilder.append('\n');
                }
                if (n > 0 && n2 % n == 0) {
                    stmt.executeBatch();
                }
                ++n2;
            }
            stmt.addBatch(stringBuilder.toString());
            stmt.executeBatch();
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            do {
                System.err.println("Error at line " + n2 + ": [" + sQLException2.getSQLState() + "] " + sQLException2.getMessage());
            } while ((sQLException2 = sQLException2.getNextException()) != null);
        }
    }

    private static void doDump(PrintWriter printWriter, Table table) throws SQLException {
        ResultSet resultSet;
        String string = table.getType();
        exporter.dumpSchema(dbmd, string, table.getSchem(), table.getName());
        printWriter.println();
        if (!(!string.contains("TABLE") || string.equals("MERGE TABLE") || string.equals("REMOTE TABLE") || string.equals("REPLICA TABLE") || string.equals("STREAM TABLE") || (resultSet = stmt.executeQuery("SELECT * FROM " + table.getFqnameQ())) == null)) {
            exporter.dumpResultSet(resultSet);
            resultSet.close();
            printWriter.println();
        }
    }

    private static String getPrompt(SQLStack sQLStack, boolean bl) {
        return (bl ? "sql" : "more") + (sQLStack.empty() ? ">" : Character.valueOf(sQLStack.peek())) + " ";
    }

    private static QueryPart scanQuery(String string, SQLStack sQLStack, boolean bl) {
        int n;
        int n2;
        boolean bl2 = sQLStack.peek() == '\'';
        boolean bl3 = sQLStack.peek() == '\"';
        boolean bl4 = false;
        int n3 = string.length();
        block8: for (n2 = 0; n2 < n3; ++n2) {
            switch (string.charAt(n2)) {
                case '\\': {
                    bl4 = !bl4;
                    continue block8;
                }
                default: {
                    bl4 = false;
                    continue block8;
                }
                case '\'': {
                    if (!bl4 && sQLStack.peek() != '\"') {
                        if (sQLStack.peek() != '\'') {
                            sQLStack.push('\'');
                        } else {
                            sQLStack.pop();
                        }
                    }
                    bl4 = false;
                    continue block8;
                }
                case '\"': {
                    if (!bl4 && sQLStack.peek() != '\'') {
                        if (sQLStack.peek() != '\"') {
                            sQLStack.push('\"');
                        } else {
                            sQLStack.pop();
                        }
                    }
                    bl4 = false;
                    continue block8;
                }
                case '-': {
                    if (!bl4 && sQLStack.peek() != '\'' && sQLStack.peek() != '\"' && n2 + 1 < n3 && string.charAt(n2 + 1) == '-') {
                        n3 = n2;
                    }
                    bl4 = false;
                    continue block8;
                }
                case '(': {
                    if (!bl4 && sQLStack.peek() != '\'' && sQLStack.peek() != '\"') {
                        sQLStack.push('(');
                    }
                    bl4 = false;
                    continue block8;
                }
                case ')': {
                    if (!bl4 && sQLStack.peek() == '(') {
                        sQLStack.pop();
                    }
                    bl4 = false;
                }
            }
        }
        if (!bl2 && !bl3 && n3 > 0) {
            for (n2 = 0; n2 < n3 && Character.isWhitespace(string.charAt(n2)); ++n2) {
            }
        }
        if (sQLStack.peek() != '\'' && !bl3 && n > n2) {
            for (n = n3 - 1; n >= n2 && Character.isWhitespace(string.charAt(n)); --n) {
            }
        }
        if (n2 == ++n) {
            return new QueryPart(false, null, sQLStack.peek() == '\'' || sQLStack.peek() == '\"');
        }
        if (sQLStack.peek() == '\'' || sQLStack.peek() == '\"') {
            return new QueryPart(false, string.substring(n2, n), true);
        }
        if (bl && string.charAt(n - 1) == ';') {
            return new QueryPart(true, string.substring(n2, n), false);
        }
        return new QueryPart(false, string.substring(n2, n), false);
    }
}

