# {{name}}

A blog site, generated by [modular](https://github.com/juxt/modular).

## Requirements

This site uses a Less compiler in JavaScript that requires Nashorn, so it's only possible to use if you've got JDK 8 or later.

## Usage

To run the blog-site, install [Leiningen](http://leiningen.org/) and type

```
lein run
```

## Development

For rapid development, use the REPL from the command line or via your
favorite code editor.

```
lein repl
user> (dev)
dev> (go)
```

After making code changes, reset your application's state (causing all
your modifications to be reloaded too).

```
dev> (reset)
```

Rinse and repeat.

## Understanding how routes are matched

Unless you change it, the blog index is at `/myblog/index.html`.

You can test what it matches to from the REPL like this:

```
dev> (pprint (match-route "/myblog/index.html"))
{:handler ...
 :id :clean-blog-example.pages/index}
```

Here we see the `id` of the Ring handler. It is defined in [{{name}}/pages](src/{{sanitized}}/pages.clj).

Near the bottom of this namespace is a record named `Pages`. It satisfies bidi's `RouteProvider` protocol and returns a route structure. The leaves of this route structure and wrapped in bidi's `handler` wrapper, allowing the handlers to be associated with keywords.

You can also find out where these handlers are accessible from the REPL.

```
dev> (path-for :clean-blog-example.pages/index)
"/myblog/index.html"
```

There is a special keywords such as `:web-resources`,
`:bootstrap-resources` and `:jquery-resources` that are relate to
collections of static resources. The first corresponds to resources
under `resources/public`, the others extract resources from
[webjars](http://www.webjars.org/) that the project depends on.

```
dev> (path-for :web-resources)
"/static"
dev> (path-for :bootstrap-resources)
"/bootstrap"
dev> (path-for :jquery-resources)
"/jquery"
```

## Generating a static site

You can generate this site to a set of static files with

```
lein gen
```

You can then deploy these files to your website. Note, it's [possible to use github to serve static files](https://help.github.com/articles/setting-up-a-custom-domain-with-github-pages/) too.

## Credits

The blog-site style has been taken from Start Bootstrap: http://startbootstrap.com/template-overviews/clean-blog/

## Copyright and License

The MIT License (MIT)

Copyright © {{year}} {{author}}

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
the Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
