(ns modelizer.build
  #?(:clj
     (:require
       [clojure.edn :as edn]
       [clojure.java.io :as io])
     :cljs
     (:require-macros
       [modelizer.build :refer [read-info]])))

#?(:clj
   (defn safe-slurp [path]
     (let [f (io/file (io/resource path))]
       (try
         (edn/read-string (slurp f))
         (catch Exception _)))))


#?(:clj
   (defmacro read-info
     ([]
      `(read-info "modelizer/build.edn"))

     ([path]
      (safe-slurp path))))


(def info (read-info))
