(ns leiningen.new.misaki-compiler
  (:use [leiningen.new.templates :only [renderer year project-name
                                        ->files sanitize-ns name-to-path]]))

(def render (renderer "misaki-compiler"))

(defn misaki-compiler
  "FIXME: write documentation"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)
              }]
    (->files data
             ;["src/{{sanitized}}/foo.clj" (render "foo.clj" data)]
             ["project.clj"  (render "project.clj" data)]
             ["README.md"    (render "README.md" data)]
             ["doc/intro.md" (render "intro.md" data)]
             [".gitignore"   (render "gitignore" data)]
             ["src/misaki/compiler/{{sanitized}}/core.clj" (render "core.clj" data)]
             ["test/misaki/compiler/{{name}}/core_test.clj" (render "test.clj" data)]
             ["test/_config.clj" (render "_config.clj" data)]
             )))




(comment


(defn app
  "An application project template."
  [name]
  (let [render (renderer "app")
        data {:raw-name name
              :name (project-name name)
              :namespace (sanitize-ns name)
              :nested-dirs (name-to-path name)
              :year (year)}]
    (println "Generating a project called" name "based on the 'app' template.")
    (->files data
             ["project.clj" (render "project.clj" data)]
             ["README.md" (render "README.md" data)]
             ["doc/intro.md" (render "intro.md" data)]
             [".gitignore" (render "gitignore" data)]
             ["src/{{nested-dirs}}/core.clj" (render "core.clj" data)]
             ["test/{{nested-dirs}}/core_test.clj" (render "test.clj" data)]
  
  )))




  )
