(in-ns 'miraj.polymer.paper)

;; (alter-meta! *ns* (fn [m] (assoc m :miraj/miraj {:miraj/elements true
;;                                                  :miraj/nss '[]
;;                                                  :miraj/codom ""
;;                                                  :miraj/assets
;;                                                  {:miraj/bower
;;                                                   [
;; "PolymerElements/paper-elements" "PolymerElements/paper-dropdown-menu" 
;;                                                    ]
;;                                                    :miraj/base "/miraj/polymer/assets/"}})))

;;;;;;;; COMPONENT: miraj.polymer.paper/badge ;;;;;;;;;;;;;;;;
(defn badge
  "<paper-badge> is a circular text badge that is displayed on the top right corner of an element, representing a status or a notification. It will badge the anchor element specified in the `for` attribute, or, if that doesn't exist, centered to the parent node containing it.

  https://www.webcomponents.org/element/PolymerElements/paper-badge"
  [& args]
  (apply codom/element :paper-badge args))
(alter-meta! (find-var (symbol (str *ns*) "badge"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-badge
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-badge/paper-badge.html"
                                           :miraj/bower "PolymerElements/paper-badge"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-badge"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/button ;;;;;;;;;;;;;;;;
(defn button
  "Material design button

  https://www.webcomponents.org/element/PolymerElements/paper-button"
  [& args]
  (apply codom/element :paper-button args))
(alter-meta! (find-var (symbol (str *ns*) "button"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-button
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-button/paper-button.html"
                                           :miraj/bower "PolymerElements/paper-button"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-button"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/card ;;;;;;;;;;;;;;;;
(defn card
  "Material design piece of paper with unique related data

  https://www.webcomponents.org/element/PolymerElements/paper-card"
  [& args]
  (apply codom/element :paper-card args))
(alter-meta! (find-var (symbol (str *ns*) "card"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-card
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-card/paper-card.html"
                                           :miraj/bower "PolymerElements/paper-card"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-card"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/checkbox ;;;;;;;;;;;;;;;;
(defn checkbox
  "A material design checkbox

  https://www.webcomponents.org/element/PolymerElements/paper-checkbox"
  [& args]
  (apply codom/element :paper-checkbox args))
(alter-meta! (find-var (symbol (str *ns*) "checkbox"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-checkbox
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-checkbox/paper-checkbox.html"
                                           :miraj/bower "PolymerElements/paper-checkbox"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-checkbox"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/dialog ;;;;;;;;;;;;;;;;
(defn dialog
  "A Material Design dialog

  https://www.webcomponents.org/element/PolymerElements/paper-dialog"
  [& args]
  (apply codom/element :paper-dialog args))
(alter-meta! (find-var (symbol (str *ns*) "dialog"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-dialog
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-dialog/paper-dialog.html"
                                           :miraj/bower "PolymerElements/paper-dialog"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-dialog"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/dialog-scrollable ;;;;;;;;;;;;;;;;
(defn dialog-scrollable
  "A scrollable area used inside the material design dialog

  https://www.webcomponents.org/element/PolymerElements/paper-dialog-scrollable"
  [& args]
  (apply codom/element :paper-dialog-scrollable args))
(alter-meta! (find-var (symbol (str *ns*) "dialog-scrollable"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-dialog-scrollable
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-dialog-scrollable/paper-dialog-scrollable.html"
                                           :miraj/bower "PolymerElements/paper-dialog-scrollable"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-dialog-scrollable"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/drawer-panel ;;;;;;;;;;;;;;;;
(defn drawer-panel
  "A responsive drawer panel

  https://www.webcomponents.org/element/PolymerElements/paper-drawer-panel"
  [& args]
  (apply codom/element :paper-drawer-panel args))
(alter-meta! (find-var (symbol (str *ns*) "drawer-panel"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-drawer-panel
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-drawer-panel/paper-drawer-panel.html"
                                           :miraj/bower "PolymerElements/paper-drawer-panel"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-drawer-panel"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/dropdown-menu ;;;;;;;;;;;;;;;;
(defn dropdown-menu
  "An element that works similarly to a native browser select

  https://www.webcomponents.org/element/PolymerElements/paper-dropdown-menu"
  [& args]
  (apply codom/element :paper-dropdown-menu args))
(alter-meta! (find-var (symbol (str *ns*) "dropdown-menu"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-dropdown-menu
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-dropdown-menu/paper-dropdown-menu.html"
                                           :miraj/bower "PolymerElements/paper-dropdown-menu"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-dropdown-menu"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/dropdown-menu-light ;;;;;;;;;;;;;;;;
(defn dropdown-menu-light
  "This is a faster, lighter
version of `paper-dropdown-menu`, that does not use a `<paper-input>`
internally. Use this element if you're concerned about the performance
of this element, i.e., if you plan on using many dropdowns on the same
page. Note that this element has a slightly different styling API than
`paper-dropdown-menu`

  https://www.webcomponents.org/element/PolymerElements/paper-dropdown-menu"
  [& args]
  (apply codom/element :paper-dropdown-menu-light args))
(alter-meta! (find-var (symbol (str *ns*) "dropdown-menu-light"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-dropdown-menu-light
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-dropdown-menu/paper-dropdown-menu-light.html"
                                           :miraj/bower "PolymerElements/paper-dropdown-menu"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-dropdown-menu"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/fab ;;;;;;;;;;;;;;;;
(defn fab
  "A material design floating action button.

  https://www.webcomponents.org/element/PolymerElements/paper-fab"
  [& args]
  (apply codom/element :paper-fab args))
(alter-meta! (find-var (symbol (str *ns*) "fab"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-fab
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-fab/paper-fab.html"
                                           :miraj/bower "PolymerElements/paper-fab"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-fab"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/header-panel ;;;;;;;;;;;;;;;;
(defn header-panel
  "<paper-header-panel> a header and content wrapper for layout with headers.

  https://www.webcomponents.org/element/PolymerElements/paper-header-panel"
  [& args]
  (apply codom/element :paper-header-panel args))
(alter-meta! (find-var (symbol (str *ns*) "header-panel"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-header-panel
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-header-panel/paper-header-panel.html"
                                           :miraj/bower "PolymerElements/paper-header-panel"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-header-panel"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/icon-button ;;;;;;;;;;;;;;;;
(defn icon-button
  "<paper-icon-button> A material design icon button.

  https://www.webcomponents.org/element/PolymerElements/paper-icon-button"
  [& args]
  (apply codom/element :paper-icon-button args))
(alter-meta! (find-var (symbol (str *ns*) "icon-button"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-icon-button
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-icon-button/paper-icon-button.html"
                                           :miraj/bower "PolymerElements/paper-icon-button"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-icon-button"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/icon-button-light ;;;;;;;;;;;;;;;;
(defn icon-button-light
  "<paper-icon-button-light> a lightweight version of paper/icon-button.

  https://www.webcomponents.org/element/PolymerElements/paper-icon-button-light"
  [& args]
  (apply codom/element :paper-icon-button-light args))
(alter-meta! (find-var (symbol (str *ns*) "icon-button-light"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-icon-button-light
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-icon-button/paper-icon-button-light.html"
                                           :miraj/bower "PolymerElements/paper-icon-button"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-icon-button-light"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/input ;;;;;;;;;;;;;;;;
(defn input
  "<paper-input> is a single-line text field with Material Design styling.

  https://www.webcomponents.org/element/PolymerElements/paper-input"
  [& args]
  (apply codom/element :paper-input args))
(alter-meta! (find-var (symbol (str *ns*) "input"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-input
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-input/paper-input.html"
                                           :miraj/bower "PolymerElements/paper-input"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-input"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/textarea ;;;;;;;;;;;;;;;;
(defn textarea
  "<paper-textarea> is a multi-line text field with Material Design styling.

  https://www.webcomponents.org/element/PolymerElements/paper-textarea"
  [& args]
  (apply codom/element :paper-textarea args))
(alter-meta! (find-var (symbol (str *ns*) "textarea"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-textarea
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-input/paper-textarea.html"
                                           :miraj/bower "PolymerElements/paper-input"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-textarea"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/item ;;;;;;;;;;;;;;;;
(defn item
  "<paper-item> is an interactive list item. By default, it is a horizontal flexbox.

  https://www.webcomponents.org/element/PolymerElements/paper-item"
  [& args]
  (apply codom/element :paper-item args))
(alter-meta! (find-var (symbol (str *ns*) "item"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-item
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-item/paper-item.html"
                                           :miraj/bower "PolymerElements/paper-item"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-item"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/icon-item ;;;;;;;;;;;;;;;;
(defn icon-item
  "<paper-icon-item>
is a convenience element to make an item with icon. It is an
interactive list item with a fixed-width icon area, according to
Material Design.

  https://www.webcomponents.org/element/PolymerElements/paper-item/paper-icon-item"
  [& args]
  (apply codom/element :paper-icon-item args))
(alter-meta! (find-var (symbol (str *ns*) "icon-item"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-icon-item
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-item/paper-icon-item.html"
                                           :miraj/bower "PolymerElements/paper-item"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-item/paper-icon-item"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/item-body ;;;;;;;;;;;;;;;;
(defn item-body
  "Use <paper-item-body> in a
<paper-item> or <paper-icon-item> to make two- or three-line
items. It is a flex item that is a vertical flexbox.

  https://www.webcomponents.org/element/PolymerElements/paper-item/paper-item-body"
  [& args]
  (apply codom/element :paper-item-body args))
(alter-meta! (find-var (symbol (str *ns*) "item-body"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-item-body
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-item/paper-item-body.html"
                                           :miraj/bower "PolymerElements/paper-item"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-item/paper-item-body"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/listbox ;;;;;;;;;;;;;;;;
(defn listbox
  "<paper-listbox>
implements an accessible listbox control with Material Design
styling. The focused item is highlighted, and the selected item has
bolded text.

  https://www.webcomponents.org/element/PolymerElements/paper-listbox"
  [& args]
  (apply codom/element :paper-listbox args))
(alter-meta! (find-var (symbol (str *ns*) "listbox"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-listbox
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-listbox/paper-listbox.html"
                                           :miraj/bower "PolymerElements/paper-listbox"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-listbox"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/material ;;;;;;;;;;;;;;;;
(defn material
  "<paper-material> is
a container that renders two shadows on top of each other to create
the effect of a lifted piece of paper.

  https://www.webcomponents.org/element/PolymerElements/paper-material"
  [& args]
  (apply codom/element :paper-material args))
(alter-meta! (find-var (symbol (str *ns*) "material"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-material
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-material/paper-material.html"
                                           :miraj/bower "PolymerElements/paper-material"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-material"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/menu ;;;;;;;;;;;;;;;;
(defn menu
  "<paper-menu> implements an accessible menu control with Material Design styling. The focused item
is highlighted, and the selected item has bolded text.

  https://www.webcomponents.org/element/PolymerElements/paper-menu"
  [& args]
  (apply codom/element :paper-menu args))
(alter-meta! (find-var (symbol (str *ns*) "menu"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-menu
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-menu/paper-menu.html"
                                           :miraj/bower "PolymerElements/paper-menu"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-menu"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/submenu ;;;;;;;;;;;;;;;;
(defn submenu
  "<paper-submenu> is a nested menu inside of a parent <paper-menu>. It
consists of a trigger that expands or collapses another <paper-menu>.

  https://www.webcomponents.org/element/PolymerElements/paper-submenu"
  [& args]
  (apply codom/element :paper-submenu args))
(alter-meta! (find-var (symbol (str *ns*) "submenu"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-submenu
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-menu/paper-submenu.html"
                                           :miraj/bower "PolymerElements/paper-menu"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-submenu"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/menu-button ;;;;;;;;;;;;;;;;
(defn menu-button
  "<paper-menu-button> allows one to compose a designated 'trigger' element with another element that represents 'content', to create a dropdown menu that displays the 'content' when the 'trigger' is clicked.

The child element with the class <dropdown-trigger> will be used as
the 'trigger' element. The child element with the class
<dropdown-content> will be used as the 'content' element.

  https://www.webcomponents.org/element/PolymerElements/paper-menu-button"
  [& args]
  (apply codom/element :paper-menu-button args))
(alter-meta! (find-var (symbol (str *ns*) "menu-button"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-menu-button
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-menu-button/paper-menu-button.html"
                                           :miraj/bower "PolymerElements/paper-menu-button"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-menu-button"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/menu-grow-height-animation ;;;;;;;;;;;;;;;;
(defn menu-grow-height-animation
  "paper-menu animation

  https://www.webcomponents.org/element/PolymerElements/paper-menu-grow-height-animation"
  [& args]
  (apply codom/element :paper-menu-grow-height-animation args))
(alter-meta! (find-var (symbol (str *ns*) "menu-grow-height-animation"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-menu-grow-height-animation
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-menu-button/paper-menu-button-animations.html"
                                           :miraj/bower "PolymerElements/paper-menu-button"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-menu-grow-height-animation"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/menu-grow-width-animation ;;;;;;;;;;;;;;;;
(defn menu-grow-width-animation
  "paper-menu animation

  https://www.webcomponents.org/element/PolymerElements/paper-menu-grow-width-animation"
  [& args]
  (apply codom/element :paper-menu-grow-width-animation args))
(alter-meta! (find-var (symbol (str *ns*) "menu-grow-width-animation"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-menu-grow-width-animation
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-menu-button/paper-menu-button-animations.html"
                                           :miraj/bower "PolymerElements/paper-menu-button"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-menu-grow-width-animation"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/menu-shrink-height-animation ;;;;;;;;;;;;;;;;
(defn menu-shrink-height-animation
  "paper-menu animation

  https://www.webcomponents.org/element/PolymerElements/paper-menu-shrink-height-animation"
  [& args]
  (apply codom/element :paper-menu-shrink-height-animation args))
(alter-meta! (find-var (symbol (str *ns*) "menu-shrink-height-animation"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-menu-shrink-height-animation
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-menu-button/paper-menu-button-animations.html"
                                           :miraj/bower "PolymerElements/paper-menu-button"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-menu-shrink-height-animation"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/menu-shrink-width-animation ;;;;;;;;;;;;;;;;
(defn menu-shrink-width-animation
  "paper-menu animation

  https://www.webcomponents.org/element/PolymerElements/paper-menu-shrink-width-animation"
  [& args]
  (apply codom/element :paper-menu-shrink-width-animation args))
(alter-meta! (find-var (symbol (str *ns*) "menu-shrink-width-animation"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-menu-shrink-width-animation
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-menu-button/paper-menu-button-animations.html"
                                           :miraj/bower "PolymerElements/paper-menu-button"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-menu-shrink-width-animation"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/progress ;;;;;;;;;;;;;;;;
(defn progress
  "<paper-progress> is
a material design progress bar, for situations where the percentage
completed can be determined. They give users a quick sense of how much
longer an operation will take.

  https://www.webcomponents.org/element/PolymerElements/paper-progress"
  [& args]
  (apply codom/element :paper-progress args))
(alter-meta! (find-var (symbol (str *ns*) "progress"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-progress
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-progress/paper-progress.html"
                                           :miraj/bower "PolymerElements/paper-progress"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-progress"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/radio-button ;;;;;;;;;;;;;;;;
(defn radio-button
  "<paper-radio-button> is
                              a button that can be either checked or
                              unchecked. User can tap the radio button
                              to check or uncheck it.

  https://www.webcomponents.org/element/PolymerElements/paper-radio-button"
  [& args]
  (apply codom/element :paper-radio-button args))
(alter-meta! (find-var (symbol (str *ns*) "radio-button"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-radio-button
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-radio-button/paper-radio-button.html"
                                           :miraj/bower "PolymerElements/paper-radio-button"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-radio-button"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/radio-group ;;;;;;;;;;;;;;;;
(defn radio-group
  "<paper-radio-group> allows user to select at most one radio button from a set. Checking one radio button that belongs to a radio group unchecks any previously checked radio button within the same group. Use `selected` to get or set the selected radio button.

  https://www.webcomponents.org/element/PolymerElements/paper-radio-group"
  [& args]
  (apply codom/element :paper-radio-group args))
(alter-meta! (find-var (symbol (str *ns*) "radio-group"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-radio-group
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-radio-group/paper-radio-group.html"
                                           :miraj/bower "PolymerElements/paper-radio-group"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-radio-group"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/ripple ;;;;;;;;;;;;;;;;
(defn ripple
  "<paper-ripple>
                              provides a visual effect that other
                              paper elements can use to simulate a
                              rippling effect emanating from the point
                              of contact.  The effect can be
                              visualized as a concentric circle with
                              motion.

  https://www.webcomponents.org/element/PolymerElements/paper-ripple"
  [& args]
  (apply codom/element :paper-ripple args))
(alter-meta! (find-var (symbol (str *ns*) "ripple"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-ripple
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-ripple/paper-ripple.html"
                                           :miraj/bower "PolymerElements/paper-ripple"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-ripple"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/scroll-header-panel ;;;;;;;;;;;;;;;;
(defn scroll-header-panel
  "<paper-scroll-header-panel>
contains a header section and a content section.  The header is
initially on the top part of the view but it scrolls away with the
rest of the scrollable content.  Upon scrolling slightly up at any
point, the header scrolls back into view.  This saves screen space and
allows users to access important controls by easily moving them back
to the view.

  https://www.webcomponents.org/element/PolymerElements/paper-scroll-header-panel"
  [& args]
  (apply codom/element :paper-scroll-header-panel args))
(alter-meta! (find-var (symbol (str *ns*) "scroll-header-panel"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-scroll-header-panel
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-scroll-header-panel/paper-scroll-header-panel.html"
                                           :miraj/bower "PolymerElements/paper-scroll-header-panel"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-scroll-header-panel"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/slider ;;;;;;;;;;;;;;;;
(defn slider
  "<paper-slider> allows user to select a value from a range of values by
moving the slider thumb.  The interactive nature of the slider makes it a
great choice for settings that reflect intensity levels, such as volume,
brightness, or color saturation.

  https://www.webcomponents.org/element/PolymerElements/paper-slider"
  [& args]
  (apply codom/element :paper-slider args))
(alter-meta! (find-var (symbol (str *ns*) "slider"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-slider
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-slider/paper-slider.html"
                                           :miraj/bower "PolymerElements/paper-slider"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-slider"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/spinner ;;;;;;;;;;;;;;;;
(defn spinner
  "<paper-spinner>
                              provides a multiple color material
                              design circular spinner.

  https://www.webcomponents.org/element/PolymerElements/paper-spinner"
  [& args]
  (apply codom/element :paper-spinner args))
(alter-meta! (find-var (symbol (str *ns*) "spinner"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-spinner
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-spinner/paper-spinner.html"
                                           :miraj/bower "PolymerElements/paper-spinner"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-spinner"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/spinner-lite ;;;;;;;;;;;;;;;;
(defn spinner-lite
  "Lightweight version of <paper-spinner>

  https://www.webcomponents.org/element/PolymerElements/paper-spinner-lite"
  [& args]
  (apply codom/element :paper-spinner-lite args))
(alter-meta! (find-var (symbol (str *ns*) "spinner-lite"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-spinner-lite
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-spinner/paper-spinner-lite.html"
                                           :miraj/bower "PolymerElements/paper-spinner"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-spinner-lite"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/tab ;;;;;;;;;;;;;;;;
(defn tab
  "<paper-tab> is styled to look like a tab.  It should be used in conjunction with <paper-tabs>.

  https://www.webcomponents.org/element/PolymerElements/paper-tab"
  [& args]
  (apply codom/element :paper-tab args))
(alter-meta! (find-var (symbol (str *ns*) "tab"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-tab
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-tabs/paper-tab.html"
                                           :miraj/bower "PolymerElements/paper-tabs"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-tab"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/tabs ;;;;;;;;;;;;;;;;
(defn tabs
  "<paper-tabs> makes it easy to explore and switch between different views or functional aspects of an app, or to browse categorized data sets.

  https://www.webcomponents.org/element/PolymerElements/paper-tabs"
  [& args]
  (apply codom/element :paper-tabs args))
(alter-meta! (find-var (symbol (str *ns*) "tabs"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-tabs
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-tabs/paper-tabs.html"
                                           :miraj/bower "PolymerElements/paper-tabs"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-tabs"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/toast ;;;;;;;;;;;;;;;;
(defn toast
  "<paper-toast> provides a subtle notification toast. Only one <paper-toast> will be visible on screen.

  https://www.webcomponents.org/element/PolymerElements/paper-toast"
  [& args]
  (apply codom/element :paper-toast args))
(alter-meta! (find-var (symbol (str *ns*) "toast"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-toast
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-toast/paper-toast.html"
                                           :miraj/bower "PolymerElements/paper-toast"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-toast"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/toggle-button ;;;;;;;;;;;;;;;;
(defn toggle-button
  "<paper-toggle-button> provides a ON/OFF switch that user can toggle the state by tapping or by dragging the switch.

  https://www.webcomponents.org/element/PolymerElements/paper-toggle-button"
  [& args]
  (apply codom/element :paper-toggle-button args))
(alter-meta! (find-var (symbol (str *ns*) "toggle-button"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-toggle-button
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-toggle-button/paper-toggle-button.html"
                                           :miraj/bower "PolymerElements/paper-toggle-button"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-toggle-button"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/toolbar ;;;;;;;;;;;;;;;;
(defn toolbar
  "<paper-toolbar> is a horizontal bar containing items that can be used for
label, navigation, search and actions.  The items placed inside the
<paper-toolbar> are projected into a `class='horizontal center layout'` container inside of
<paper-toolbar>'s Shadow DOM.  You can use flex attributes to control the items'
sizing.

  https://www.webcomponents.org/element/PolymerElements/paper-toolbar"
  [& args]
  (apply codom/element :paper-toolbar args))
(alter-meta! (find-var (symbol (str *ns*) "toolbar"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-toolbar
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-toolbar/paper-toolbar.html"
                                           :miraj/bower "PolymerElements/paper-toolbar"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-toolbar"}})

;;;;;;;; COMPONENT: miraj.polymer.paper/tooltip ;;;;;;;;;;;;;;;;
(defn tooltip
  "<paper-tooltip> is a label that appears on hover and focus when the user
hovers over an element with the cursor or with the keyboard. It will be centered
to an anchor element specified in the `for` attribute, or, if that doesn't exist,
centered to the parent node containing it.

  https://www.webcomponents.org/element/PolymerElements/paper-tooltip"
  [& args]
  (apply codom/element :paper-tooltip args))
(alter-meta! (find-var (symbol (str *ns*) "tooltip"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :paper-tooltip
                            :miraj/lib :miraj.polymer.paper
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-tooltip/paper-tooltip.html"
                                           :miraj/bower "PolymerElements/paper-tooltip"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-tooltip"}})



