(ns miraj.polymer.paper.styles
  "Miraj Polymer Paper Style components

  https://www.webcomponents.org/element/PolymerElements/"
  )

(alter-meta! *ns* (fn [m] (assoc m :miraj/miraj {:miraj/styles true
                                                 :miraj/nss '[]
                                                 :miraj/assets
                                                 {:miraj/bower
                                                  [
"PolymerElements/paper-styles" 
                                                   ]
                                                                :miraj/href "/miraj/polymer/assets/"}})))
(def pfx "/miraj/polymer/assets/")

;;;;;;;; STYLE: miraj.polymer.paper.styles/styles ;;;;;;;;;;;;;;;;
(def styles
  "The <paper-styles> component provides simple ways to use Material Design CSS styles in your application. The following imports are available:

1. color.html: a complete list of the colors defined in the Material Design palette

2. default-theme.html: text, background and accent colors that match the default Material Design theme

3. shadow.html: Material Design elevation and shadow styles

4. typography.html: Material Design font styles and sizes

5. demo-pages.html: generic styles used in the PolymerElements demo pages

We recommend importing each of these individual files, and using the style mixins available in each ones, rather than the aggregated paper-styles.html as a whole.

  https://www.webcomponents.org/element/PolymerElements/paper-styles"
  {:miraj/href "/miraj/polymer/assets/paper-styles/paper-styles.html"})

(alter-meta! (find-var (symbol (str *ns*) "styles"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :polymer
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-styles/paper-styles.html"
                                           :miraj/bower "PolymerElements/paper-styles"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-styles"}})

;;;;;;;; STYLE: miraj.polymer.paper.styles/color ;;;;;;;;;;;;;;;;
(def color
  "A complete list of the colors defined in the Material Design palette.

  https://www.webcomponents.org/element/PolymerElements/paper-styles"
  {:miraj/href "/miraj/polymer/assets/paper-styles/color.html"})

(alter-meta! (find-var (symbol (str *ns*) "color"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :polymer
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-styles/color.html"
                                           :miraj/bower "PolymerElements/paper-styles"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-styles"}})

;;;;;;;; STYLE: miraj.polymer.paper.styles/dialog ;;;;;;;;;;;;;;;;
(def dialog
  "A complete list of the colors defined in the Material Design palette.

  https://www.webcomponents.org/element/PolymerElements/paper-styles"
  {:miraj/href "/miraj/polymer/assets/paper-dialog-behavior/paper-dialog-shared-styles.html"
   :miraj/module 'paper-dialog-shared-styles})

(alter-meta! (find-var (symbol (str *ns*) "dialog"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :polymer
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-dialog-behavior/paper-dialog-shared-styles.html"
                                           :miraj/bower "PolymerElements/paper-dialog-behavior"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-styles"}})

;;;;;;;; STYLE: miraj.polymer.paper.styles/default-theme ;;;;;;;;;;;;;;;;
(def default-theme
  "Text, background and accent colors that match the default Material Design theme.

  https://www.webcomponents.org/element/PolymerElements/paper-styles"
  {:miraj/href "/miraj/polymer/assets/paper-styles/default-theme.html"})

(alter-meta! (find-var (symbol (str *ns*) "default-theme"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :polymer
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-styles/default-theme.html"
                                           :miraj/bower "PolymerElements/paper-styles"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-styles"}})

;;;;;;;; STYLE: miraj.polymer.paper.styles/demo-pages ;;;;;;;;;;;;;;;;
(def demo-pages
  "Generic styles used in the PolymerElements demo pages

  https://www.webcomponents.org/element/PolymerElements/paper-styles"
  {:miraj/href "/miraj/polymer/assets/paper-styles/demo-pages.html"})

(alter-meta! (find-var (symbol (str *ns*) "demo-pages"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :polymer
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-styles/demo-pages.html"
                                           :miraj/bower "PolymerElements/paper-styles"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-styles"}})

;;;;;;;; STYLE: miraj.polymer.paper.styles/dropdown-menu ;;;;;;;;;;;;;;;;
(def dropdown-menu
  "

  https://www.webcomponents.org/element/PolymerElements/paper-dropdown-menu"
  {:miraj/href "/miraj/polymer/assets/paper-dropdown-menu/paper-dropdown-menu-shared-styles.html"
   :miraj/module 'paper-dropdown-menu-shared-styles})

(alter-meta! (find-var (symbol (str *ns*) "dropdown-menu"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :polymer
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-dropdown-menu/paper-dropdown-menu-shared-styles.html"
                                           :miraj/bower "PolymerElements/paper-dropdown-menu"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-dropdown-menu"}})

;;;;;;;; STYLE: miraj.polymer.paper.styles/item ;;;;;;;;;;;;;;;;
(def item
  "docstring

  https://www.webcomponents.org/element/PolymerElements/paper-item"
  {:miraj/href "/miraj/polymer/assets/paper-item/paper-item-shared-styles.html"
   :miraj/module 'paper-item-shared-styles})

(alter-meta! (find-var (symbol (str *ns*) "item"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :polymer
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-item/paper-item-shared-styles.html"
                                           :miraj/bower "PolymerElements/paper-item"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-item"}})

;;;;;;;; STYLE: miraj.polymer.paper.styles/material ;;;;;;;;;;;;;;;;
(def material
  "docstring

  https://www.webcomponents.org/element/PolymerElements/paper-material"
  {:miraj/href "/miraj/polymer/assets/paper-material/paper-material-shared-styles.html"
   :miraj/module 'paper-material-shared-styles})

(alter-meta! (find-var (symbol (str *ns*) "material"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :polymer
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-material/paper-material-shared-styles.html"
                                           :miraj/bower "PolymerElements/paper-material"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-material"}})

;;;;;;;; STYLE: miraj.polymer.paper.styles/menu ;;;;;;;;;;;;;;;;
(def menu
  "docstring

  https://www.webcomponents.org/element/PolymerElements/paper-menu"
  {:miraj/href "/miraj/polymer/assets/paper-menu/paper-menu-shared-styles.html"
   :miraj/module 'paper-menu-shared-styles})

(alter-meta! (find-var (symbol (str *ns*) "menu"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :polymer
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-menu/paper-menu-shared-styles.html"
                                           :miraj/bower "PolymerElements/paper-menu"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-menu"}})

;;;;;;;; STYLE: miraj.polymer.paper.styles/shadow ;;;;;;;;;;;;;;;;
(def shadow
  "Material Design elevation and shadow styles.

  https://www.webcomponents.org/element/PolymerElements/paper-styles"
  {:miraj/href "/miraj/polymer/assets/paper-styles/shadow.html"})

(alter-meta! (find-var (symbol (str *ns*) "shadow"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :polymer
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-styles/shadow.html"
                                           :miraj/bower "PolymerElements/paper-styles"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-styles"}})

;;;;;;;; STYLE: miraj.polymer.paper.styles/spinner ;;;;;;;;;;;;;;;;
(def spinner
  "docstring

  https://www.webcomponents.org/element/PolymerElements/paper-spinner"
  {:miraj/href "/miraj/polymer/assets/paper-spinner/paper-spinner-styles.html"})

(alter-meta! (find-var (symbol (str *ns*) "spinner"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :polymer
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-spinner/paper-spinner-styles.html"
                                           :miraj/bower "PolymerElements/paper-spinner"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-spinner"}})

;;;;;;;; STYLE: miraj.polymer.paper.styles/typography ;;;;;;;;;;;;;;;;
(def typography
  "Material Design font styles and sizes.

  https://www.webcomponents.org/element/PolymerElements/paper-styles"
  {:miraj/href "/miraj/polymer/assets/paper-styles/typography.html"})

(alter-meta! (find-var (symbol (str *ns*) "typography"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :polymer
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/paper-styles/typography.html"
                                           :miraj/bower "PolymerElements/paper-styles"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/paper-styles"}})


