(ns miraj.polymer.layout.extensions
  "Miraj Polymer App Layout Effects

  https://www.webcomponents.org/element/PolymerElements/"
  )

(alter-meta! *ns* (fn [m] (assoc m :miraj/miraj {:miraj/styles true
                                                 :miraj/nss '[]
                                                 :miraj/assets
                                                 {:miraj/bower
                                                  [
"PolymerElements/app-layout" 
                                                   ]
                                                                :miraj/href "/miraj/polymer/assets/"}})))
(def pfx "/miraj/polymer/assets/")

;;;;;;;; STYLE: miraj.polymer.layout.extensions/scroll-effects ;;;;;;;;;;;;;;;;
(def scroll-effects
  "

  https://www.webcomponents.org/element/PolymerElements/Polymer.AppScrollEffectsBehavior"
  {:miraj/href "/miraj/polymer/assets/app-layout/app-scroll-effects/app-scroll-effects.html"})

(alter-meta! (find-var (symbol (str *ns*) "scroll-effects"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :miraj.polymer/layout
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/app-layout/app-scroll-effects/app-scroll-effects.html"
                                           :miraj/bower "PolymerElements/app-layout"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/Polymer.AppScrollEffectsBehavior"}})

;;;;;;;; STYLE: miraj.polymer.layout.extensions/blend ;;;;;;;;;;;;;;;;
(def blend
  "While scrolling down, fade in the rear background layer and fade out the front background layer (opacity interpolated based on scroll position).

  https://www.webcomponents.org/element/PolymerElements/Polymer.AppScrollEffectsBehavior"
  {:miraj/href "/miraj/polymer/assets/app-layout/app-scroll-effects/effects/blend-background.html"})

(alter-meta! (find-var (symbol (str *ns*) "blend"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :miraj.polymer/layout
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/app-layout/app-scroll-effects/effects/blend-background.html"
                                           :miraj/bower "PolymerElements/app-layout"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/Polymer.AppScrollEffectsBehavior"}})

;;;;;;;; STYLE: miraj.polymer.layout.extensions/fade ;;;;;;;;;;;;;;;;
(def fade
  "Upon scrolling past a threshold, fade in the rear background layer and fade out the front background layer (opacity CSS transitioned over time).

  https://www.webcomponents.org/element/PolymerElements/Polymer.AppScrollEffectsBehavior"
  {:miraj/href "/miraj/polymer/assets/app-layout/app-scroll-effects/effects/fade-background.html"})

(alter-meta! (find-var (symbol (str *ns*) "fade"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :miraj.polymer/layout
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/app-layout/app-scroll-effects/effects/fade-background.html"
                                           :miraj/bower "PolymerElements/app-layout"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/Polymer.AppScrollEffectsBehavior"}})

;;;;;;;; STYLE: miraj.polymer.layout.extensions/material ;;;;;;;;;;;;;;;;
(def material
  "Shorthand for the waterfall, resize-title, blend-background, and parallax-background effects.

  https://www.webcomponents.org/element/PolymerElements/Polymer.AppScrollEffectsBehavior"
  {:miraj/href "/miraj/polymer/assets/app-layout/app-scroll-effects/effects/material.html"})

(alter-meta! (find-var (symbol (str *ns*) "material"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :miraj.polymer/layout
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/app-layout/app-scroll-effects/effects/material.html"
                                           :miraj/bower "PolymerElements/app-layout"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/Polymer.AppScrollEffectsBehavior"}})

;;;;;;;; STYLE: miraj.polymer.layout.extensions/parallax ;;;;;;;;;;;;;;;;
(def parallax
  "Vertically translate the background based on a factor of the scroll position.

  https://www.webcomponents.org/element/PolymerElements/Polymer.AppScrollEffectsBehavior"
  {:miraj/href "/miraj/polymer/assets/app-layout/app-scroll-effects/effects/parallax-background.html"})

(alter-meta! (find-var (symbol (str *ns*) "parallax"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :miraj.polymer/layout
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/app-layout/app-scroll-effects/effects/parallax-background.html"
                                           :miraj/bower "PolymerElements/app-layout"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/Polymer.AppScrollEffectsBehavior"}})

;;;;;;;; STYLE: miraj.polymer.layout.extensions/resize-snapped-title ;;;;;;;;;;;;;;;;
(def resize-snapped-title
  "Upon scrolling past a threshold, CSS transition the font size of a designated title element between two values.

  https://www.webcomponents.org/element/PolymerElements/Polymer.AppScrollEffectsBehavior"
  {:miraj/href "/miraj/polymer/assets/app-layout/app-scroll-effects/effects/resize-snapped-title.html"})

(alter-meta! (find-var (symbol (str *ns*) "resize-snapped-title"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :miraj.polymer/layout
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/app-layout/app-scroll-effects/effects/resize-snapped-title.html"
                                           :miraj/bower "PolymerElements/app-layout"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/Polymer.AppScrollEffectsBehavior"}})

;;;;;;;; STYLE: miraj.polymer.layout.extensions/resize-title ;;;;;;;;;;;;;;;;
(def resize-title
  "Transform the font size of a designated title element between two values based on the scroll position.

  https://www.webcomponents.org/element/PolymerElements/Polymer.AppScrollEffectsBehavior"
  {:miraj/href "/miraj/polymer/assets/app-layout/app-scroll-effects/effects/resize-title.html"})

(alter-meta! (find-var (symbol (str *ns*) "resize-title"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :miraj.polymer/layout
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/app-layout/app-scroll-effects/effects/resize-title.html"
                                           :miraj/bower "PolymerElements/app-layout"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/Polymer.AppScrollEffectsBehavior"}})

;;;;;;;; STYLE: miraj.polymer.layout.extensions/waterfall ;;;;;;;;;;;;;;;;
(def waterfall
  "Toggles the shadow property in app-header when content is scrolled to create a sense of depth between the element and the content underneath.

  https://www.webcomponents.org/element/PolymerElements/Polymer.AppScrollEffectsBehavior"
  {:miraj/href "/miraj/polymer/assets/app-layout/app-scroll-effects/effects/waterfall.html"})

(alter-meta! (find-var (symbol (str *ns*) "waterfall"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/style true
                            :miraj/lib :miraj.polymer/layout
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/app-layout/app-scroll-effects/effects/waterfall.html"
                                           :miraj/bower "PolymerElements/app-layout"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/Polymer.AppScrollEffectsBehavior"}})


