(in-ns 'miraj.html)

;; (alter-meta! *ns* (fn [m] (assoc m :miraj/miraj {:miraj/elements true
;;                                                  :miraj/nss '[]
;;                                                  :miraj/codom ""
;;                                                  :miraj/assets
;;                                                  {:miraj/bower
;;                                                   [
;; 
;;                                                    ]
;;                                                    :miraj/base ""}})))

;;;;;;;; COMPONENT: miraj.html/a ;;;;;;;;;;;;;;;;
(defn a
  "Hyperlink.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-a-element"
  [& args]
  (apply codom/element :a args))
(alter-meta! (find-var (symbol (str *ns*) "a"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :a
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-a-element"}})

;;;;;;;; COMPONENT: miraj.html/abbr ;;;;;;;;;;;;;;;;
(defn abbr
  "Abbreviation.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-abbr-element"
  [& args]
  (apply codom/element :abbr args))
(alter-meta! (find-var (symbol (str *ns*) "abbr"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :abbr
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-abbr-element"}})

;;;;;;;; COMPONENT: miraj.html/address ;;;;;;;;;;;;;;;;
(defn address
  "Contact information for a page or article element.

  https://www.w3.org/TR/html5/sections.html#the-address-element"
  [& args]
  (apply codom/element :address args))
(alter-meta! (find-var (symbol (str *ns*) "address"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :address
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/sections.html#the-address-element"}})

;;;;;;;; COMPONENT: miraj.html/area ;;;;;;;;;;;;;;;;
(defn area
  "Hyperlink or dead area on an image map.

  https://www.w3.org/TR/html5/embedded-content-0.html#the-area-element"
  [& args]
  (apply codom/element :area args))
(alter-meta! (find-var (symbol (str *ns*) "area"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :area
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/embedded-content-0.html#the-area-element"}})

;;;;;;;; COMPONENT: miraj.html/article ;;;;;;;;;;;;;;;;
(defn article
  "Article. Self-contained syndicatable or reusable composition.

  https://www.w3.org/TR/html5/sections.html#the-article-element"
  [& args]
  (apply codom/element :article args))
(alter-meta! (find-var (symbol (str *ns*) "article"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :article
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/sections.html#the-article-element"}})

;;;;;;;; COMPONENT: miraj.html/aside ;;;;;;;;;;;;;;;;
(defn aside
  "Sidebar for tangentially related content

  https://www.w3.org/TR/html5/sections.html#the-aside-element"
  [& args]
  (apply codom/element :aside args))
(alter-meta! (find-var (symbol (str *ns*) "aside"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :aside
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/sections.html#the-aside-element"}})

;;;;;;;; COMPONENT: miraj.html/audio ;;;;;;;;;;;;;;;;
(defn audio
  "Audio player

  https://www.w3.org/TR/html5/embedded-content-0.html#the-audio-element"
  [& args]
  (apply codom/element :audio args))
(alter-meta! (find-var (symbol (str *ns*) "audio"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :audio
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/embedded-content-0.html#the-audio-element"}})

;;;;;;;; COMPONENT: miraj.html/b ;;;;;;;;;;;;;;;;
(defn b
  "Keywords. The b element represents a span of text to which attention is being drawn for utilitarian purposes without conveying any extra importance and with no implication of an alternate voice or mood, such as key words in a document abstract, product names in a review, actionable words in interactive text-driven software, or an article lede.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-b-element"
  [& args]
  (apply codom/element :b args))
(alter-meta! (find-var (symbol (str *ns*) "b"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :b
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-b-element"}})

;;;;;;;; COMPONENT: miraj.html/base ;;;;;;;;;;;;;;;;
(defn base
  "Base URL and default target browsing context for hyperlinks and forms

  https://www.w3.org/TR/html5/document-metadata.html#the-base-element"
  [& args]
  (apply codom/element :base args))
(alter-meta! (find-var (symbol (str *ns*) "base"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :base
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/document-metadata.html#the-base-element"}})

;;;;;;;; COMPONENT: miraj.html/bdi ;;;;;;;;;;;;;;;;
(defn bdi
  "Text directionality isolation. The bdi element represents a span of text that is to be isolated from its surroundings for the purposes of bidirectional text formatting. 

  https://www.w3.org/TR/html5/text-level-semantics.html#the-bdi-element"
  [& args]
  (apply codom/element :bdi args))
(alter-meta! (find-var (symbol (str *ns*) "bdi"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :bdi
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-bdi-element"}})

;;;;;;;; COMPONENT: miraj.html/bdo ;;;;;;;;;;;;;;;;
(defn bdo
  "BiDi Override: text directionality formatting. The bdo element represents explicit text directionality formatting control for its children. It allows authors to override the Unicode bidirectional algorithm by explicitly specifying a direction override.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-bdo-element"
  [& args]
  (apply codom/element :bdo args))
(alter-meta! (find-var (symbol (str *ns*) "bdo"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :bdo
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-bdo-element"}})

;;;;;;;; COMPONENT: miraj.html/blockquote ;;;;;;;;;;;;;;;;
(defn blockquote
  "A section quoted from another source. The blockquote element represents content that is quoted from another source, optionally with a citation which must be within a footer or cite element, and optionally with in-line changes such as annotations and abbreviations. Content inside a blockquote other than citations and in-line changes must be quoted from another source, whose address, if it has one, may be cited in the cite attribute.

  https://www.w3.org/TR/html5/grouping-content.html#the-blockquote-element"
  [& args]
  (apply codom/element :blockquote args))
(alter-meta! (find-var (symbol (str *ns*) "blockquote"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :blockquote
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/grouping-content.html#the-blockquote-element"}})

;;;;;;;; COMPONENT: miraj.html/body ;;;;;;;;;;;;;;;;
(defn body
  "Document body.

  https://www.w3.org/TR/html5/sections.html#the-body-element"
  [& args]
  (apply codom/element :body args))
(alter-meta! (find-var (symbol (str *ns*) "body"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :body
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/sections.html#the-body-element"}})

;;;;;;;; COMPONENT: miraj.html/br ;;;;;;;;;;;;;;;;
(defn br
  "Line break, e.g. in poem or postal address.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-br-element"
  [& args]
  (apply codom/element :br args))
(alter-meta! (find-var (symbol (str *ns*) "br"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :br
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-br-element"}})

;;;;;;;; COMPONENT: miraj.html/button ;;;;;;;;;;;;;;;;
(defn button
  "Button control.

  https://www.w3.org/TR/html5/forms.html#the-button-element"
  [& args]
  (apply codom/element :button args))
(alter-meta! (find-var (symbol (str *ns*) "button"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :button
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/forms.html#the-button-element"}})

;;;;;;;; COMPONENT: miraj.html/canvas ;;;;;;;;;;;;;;;;
(defn canvas
  "Scriptable bitmap canvas.

  https://www.w3.org/TR/html5/scripting-1.html#the-canvas-element"
  [& args]
  (apply codom/element :canvas args))
(alter-meta! (find-var (symbol (str *ns*) "canvas"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :canvas
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/scripting-1.html#the-canvas-element"}})

;;;;;;;; COMPONENT: miraj.html/caption ;;;;;;;;;;;;;;;;
(defn caption
  "Table caption.

  https://www.w3.org/TR/html5/tabular-data.html#the-caption-element"
  [& args]
  (apply codom/element :caption args))
(alter-meta! (find-var (symbol (str *ns*) "caption"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :caption
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/tabular-data.html#the-caption-element"}})

;;;;;;;; COMPONENT: miraj.html/cite ;;;;;;;;;;;;;;;;
(defn cite
  "Title of a work.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-cite-element"
  [& args]
  (apply codom/element :cite args))
(alter-meta! (find-var (symbol (str *ns*) "cite"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :cite
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-cite-element"}})

;;;;;;;; COMPONENT: miraj.html/code ;;;;;;;;;;;;;;;;
(defn code
  "Computer code.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-code-element"
  [& args]
  (apply codom/element :code args))
(alter-meta! (find-var (symbol (str *ns*) "code"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :code
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-code-element"}})

;;;;;;;; COMPONENT: miraj.html/col ;;;;;;;;;;;;;;;;
(defn col
  "Table column.

  https://www.w3.org/TR/html5/tabular-data.html#the-col-element"
  [& args]
  (apply codom/element :col args))
(alter-meta! (find-var (symbol (str *ns*) "col"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :col
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/tabular-data.html#the-col-element"}})

;;;;;;;; COMPONENT: miraj.html/colgroup ;;;;;;;;;;;;;;;;
(defn colgroup
  "Group of columns in a table.

  https://www.w3.org/TR/html5/tabular-data.html#the-colgroup-element"
  [& args]
  (apply codom/element :colgroup args))
(alter-meta! (find-var (symbol (str *ns*) "colgroup"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :colgroup
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/tabular-data.html#the-colgroup-element"}})

;;;;;;;; COMPONENT: miraj.html/data ;;;;;;;;;;;;;;;;
(defn data
  "Machine-readable equivalent. The data element represents its contents, along with a machine-readable form of those contents in the value attribute. The value attribute must be present. Its value must be a representation of the element's contents in a machine-readable format.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-data-element"
  [& args]
  (apply codom/element :data args))
(alter-meta! (find-var (symbol (str *ns*) "data"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :data
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-data-element"}})

;;;;;;;; COMPONENT: miraj.html/datalist ;;;;;;;;;;;;;;;;
(defn datalist
  "Container for options for combo box control.

  https://www.w3.org/TR/html5/forms.html#the-datalist-element"
  [& args]
  (apply codom/element :datalist args))
(alter-meta! (find-var (symbol (str *ns*) "datalist"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :datalist
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/forms.html#the-datalist-element"}})

;;;;;;;; COMPONENT: miraj.html/dd ;;;;;;;;;;;;;;;;
(defn dd
  "Content for corresponding dt element(s). The dd element represents the description, definition, or value, part of a term-description group in a description list (dl element).

  https://www.w3.org/TR/html5/grouping-content.html#the-dd-element"
  [& args]
  (apply codom/element :dd args))
(alter-meta! (find-var (symbol (str *ns*) "dd"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :dd
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/grouping-content.html#the-dd-element"}})

;;;;;;;; COMPONENT: miraj.html/del ;;;;;;;;;;;;;;;;
(defn del
  "A removal from the document

  https://www.w3.org/TR/html5/edits.html#the-del-element"
  [& args]
  (apply codom/element :del args))
(alter-meta! (find-var (symbol (str *ns*) "del"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :del
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/edits.html#the-del-element"}})

;;;;;;;; COMPONENT: miraj.html/dfn ;;;;;;;;;;;;;;;;
(defn dfn
  "Defining instance.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-dfn-element"
  [& args]
  (apply codom/element :dfn args))
(alter-meta! (find-var (symbol (str *ns*) "dfn"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :dfn
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-dfn-element"}})

;;;;;;;; COMPONENT: miraj.html/div ;;;;;;;;;;;;;;;;
(defn div
  "Generic flow container.

  https://www.w3.org/TR/html5/grouping-content.html#the-div-element"
  [& args]
  (apply codom/element :div args))
(alter-meta! (find-var (symbol (str *ns*) "div"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :div
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/grouping-content.html#the-div-element"}})

;;;;;;;; COMPONENT: miraj.html/dl ;;;;;;;;;;;;;;;;
(defn dl
  "Association list consisting of zero or more name-value groups.

  https://www.w3.org/TR/html5/grouping-content.html#the-dl-element"
  [& args]
  (apply codom/element :dl args))
(alter-meta! (find-var (symbol (str *ns*) "dl"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :dl
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/grouping-content.html#the-dl-element"}})

;;;;;;;; COMPONENT: miraj.html/dt ;;;;;;;;;;;;;;;;
(defn dt
  "Legend for corresponding dd element(s).

  https://www.w3.org/TR/html5/grouping-content.html#the-dt-element"
  [& args]
  (apply codom/element :dt args))
(alter-meta! (find-var (symbol (str *ns*) "dt"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :dt
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/grouping-content.html#the-dt-element"}})

;;;;;;;; COMPONENT: miraj.html/em ;;;;;;;;;;;;;;;;
(defn em
  "Stress emphasis.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-em-element"
  [& args]
  (apply codom/element :em args))
(alter-meta! (find-var (symbol (str *ns*) "em"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :em
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-em-element"}})

;;;;;;;; COMPONENT: miraj.html/embed ;;;;;;;;;;;;;;;;
(defn embed
  "Plugin. The embed element provides an integration point for an external (typically non-HTML) application or interactive content. The src attribute gives the address of the resource being embedded. The attribute, if present, must contain a valid non-empty URL potentially surrounded by spaces.

  https://www.w3.org/TR/html5/embedded-content-0.html#the-embed-element"
  [& args]
  (apply codom/element :embed args))
(alter-meta! (find-var (symbol (str *ns*) "embed"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :embed
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/embedded-content-0.html#the-embed-element"}})

;;;;;;;; COMPONENT: miraj.html/fieldset ;;;;;;;;;;;;;;;;
(defn fieldset
  "Group of form controls.

  https://www.w3.org/TR/html5/forms.html#the-fieldset-element"
  [& args]
  (apply codom/element :fieldset args))
(alter-meta! (find-var (symbol (str *ns*) "fieldset"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :fieldset
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/forms.html#the-fieldset-element"}})

;;;;;;;; COMPONENT: miraj.html/figcaption ;;;;;;;;;;;;;;;;
(defn figcaption
  "Caption for figure.

  https://www.w3.org/TR/html5/grouping-content.html#the-figcaption-element"
  [& args]
  (apply codom/element :figcaption args))
(alter-meta! (find-var (symbol (str *ns*) "figcaption"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :figcaption
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/grouping-content.html#the-figcaption-element"}})

;;;;;;;; COMPONENT: miraj.html/figure ;;;;;;;;;;;;;;;;
(defn figure
  "Figure with optional caption.

  https://www.w3.org/TR/html5/grouping-content.html#the-figure-element"
  [& args]
  (apply codom/element :figure args))
(alter-meta! (find-var (symbol (str *ns*) "figure"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :figure
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/grouping-content.html#the-figure-element"}})

;;;;;;;; COMPONENT: miraj.html/footer ;;;;;;;;;;;;;;;;
(defn footer
  "Footer for a page or section.

  https://www.w3.org/TR/html5/sections.html#the-footer-element"
  [& args]
  (apply codom/element :footer args))
(alter-meta! (find-var (symbol (str *ns*) "footer"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :footer
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/sections.html#the-footer-element"}})

;;;;;;;; COMPONENT: miraj.html/form ;;;;;;;;;;;;;;;;
(defn form
  "User-submittable form

  https://www.w3.org/TR/html5/forms.html#the-form-element"
  [& args]
  (apply codom/element :form args))
(alter-meta! (find-var (symbol (str *ns*) "form"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :form
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/forms.html#the-form-element"}})

;;;;;;;; COMPONENT: miraj.html/h1 ;;;;;;;;;;;;;;;;
(defn h1
  "Section heading.

  https://www.w3.org/TR/html5/sections.html#the-h1,-h2,-h3,-h4,-h5,-and-h6-elements"
  [& args]
  (apply codom/element :h1 args))
(alter-meta! (find-var (symbol (str *ns*) "h1"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :h1
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/sections.html#the-h1,-h2,-h3,-h4,-h5,-and-h6-elements"}})

;;;;;;;; COMPONENT: miraj.html/h2 ;;;;;;;;;;;;;;;;
(defn h2
  "Section heading.

  https://www.w3.org/TR/html5/sections.html#the-h1,-h2,-h3,-h4,-h5,-and-h6-elements"
  [& args]
  (apply codom/element :h2 args))
(alter-meta! (find-var (symbol (str *ns*) "h2"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :h2
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/sections.html#the-h1,-h2,-h3,-h4,-h5,-and-h6-elements"}})

;;;;;;;; COMPONENT: miraj.html/h3 ;;;;;;;;;;;;;;;;
(defn h3
  "Section heading.

  https://www.w3.org/TR/html5/sections.html#the-h1,-h2,-h3,-h4,-h5,-and-h6-elements"
  [& args]
  (apply codom/element :h3 args))
(alter-meta! (find-var (symbol (str *ns*) "h3"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :h3
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/sections.html#the-h1,-h2,-h3,-h4,-h5,-and-h6-elements"}})

;;;;;;;; COMPONENT: miraj.html/h4 ;;;;;;;;;;;;;;;;
(defn h4
  "Section heading.

  https://www.w3.org/TR/html5/sections.html#the-h1,-h2,-h3,-h4,-h5,-and-h6-elements"
  [& args]
  (apply codom/element :h4 args))
(alter-meta! (find-var (symbol (str *ns*) "h4"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :h4
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/sections.html#the-h1,-h2,-h3,-h4,-h5,-and-h6-elements"}})

;;;;;;;; COMPONENT: miraj.html/h5 ;;;;;;;;;;;;;;;;
(defn h5
  "Section heading.

  https://www.w3.org/TR/html5/sections.html#the-h1,-h2,-h3,-h4,-h5,-and-h6-elements"
  [& args]
  (apply codom/element :h5 args))
(alter-meta! (find-var (symbol (str *ns*) "h5"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :h5
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/sections.html#the-h1,-h2,-h3,-h4,-h5,-and-h6-elements"}})

;;;;;;;; COMPONENT: miraj.html/h6 ;;;;;;;;;;;;;;;;
(defn h6
  "Section heading.

  https://www.w3.org/TR/html5/sections.html#the-h1,-h2,-h3,-h4,-h5,-and-h6-elements"
  [& args]
  (apply codom/element :h6 args))
(alter-meta! (find-var (symbol (str *ns*) "h6"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :h6
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/sections.html#the-h1,-h2,-h3,-h4,-h5,-and-h6-elements"}})

;;;;;;;; COMPONENT: miraj.html/head ;;;;;;;;;;;;;;;;
(defn head
  "Container for document metadata.

  https://www.w3.org/TR/html5/document-metadata.html#the-head-element"
  [& args]
  (apply codom/element :head args))
(alter-meta! (find-var (symbol (str *ns*) "head"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :head
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/document-metadata.html#the-head-element"}})

;;;;;;;; COMPONENT: miraj.html/header ;;;;;;;;;;;;;;;;
(defn header
  "Introductory or navigational aids for a page or section.

  https://www.w3.org/TR/html5/sections.html#the-header-element"
  [& args]
  (apply codom/element :header args))
(alter-meta! (find-var (symbol (str *ns*) "header"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :header
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/sections.html#the-header-element"}})

;;;;;;;; COMPONENT: miraj.html/hr ;;;;;;;;;;;;;;;;
(defn hr
  "Thematic break. The hr element represents a paragraph-level thematic break, e.g. a scene change in a story, or a transition to another topic within a section of a reference book.

  https://www.w3.org/TR/html5/grouping-content.html#the-hr-element"
  [& args]
  (apply codom/element :hr args))
(alter-meta! (find-var (symbol (str *ns*) "hr"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :hr
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/grouping-content.html#the-hr-element"}})

;;;;;;;; COMPONENT: miraj.html/html ;;;;;;;;;;;;;;;;
(defn html
  "Root element.

  https://www.w3.org/TR/html5/semantics.html#the-html-element"
  [& args]
  (apply codom/element :html args))
(alter-meta! (find-var (symbol (str *ns*) "html"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :html
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/semantics.html#the-html-element"}})

;;;;;;;; COMPONENT: miraj.html/i ;;;;;;;;;;;;;;;;
(defn i
  "Alternate voice. The i element represents a span of text in an alternate voice or mood, or otherwise offset from the normal prose in a manner indicating a different quality of text, such as a taxonomic designation, a technical term, an idiomatic phrase from another language, transliteration, a thought, or a ship name in Western texts.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-i-element"
  [& args]
  (apply codom/element :i args))
(alter-meta! (find-var (symbol (str *ns*) "i"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :i
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-i-element"}})

;;;;;;;; COMPONENT: miraj.html/iframe ;;;;;;;;;;;;;;;;
(defn iframe
  "Nested browsing context.

  https://www.w3.org/TR/html5/embedded-content-0.html#the-iframe-element"
  [& args]
  (apply codom/element :iframe args))
(alter-meta! (find-var (symbol (str *ns*) "iframe"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :iframe
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/embedded-content-0.html#the-iframe-element"}})

;;;;;;;; COMPONENT: miraj.html/img ;;;;;;;;;;;;;;;;
(defn img
  "Image.

  https://www.w3.org/TR/html5/embedded-content-0.html#the-img-element"
  [& args]
  (apply codom/element :img args))
(alter-meta! (find-var (symbol (str *ns*) "img"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :img
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/embedded-content-0.html#the-img-element"}})

;;;;;;;; COMPONENT: miraj.html/input ;;;;;;;;;;;;;;;;
(defn input
  "Form control.

  https://www.w3.org/TR/html5/forms.html#the-input-element"
  [& args]
  (apply codom/element :input args))
(alter-meta! (find-var (symbol (str *ns*) "input"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :input
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/forms.html#the-input-element"}})

;;;;;;;; COMPONENT: miraj.html/ins ;;;;;;;;;;;;;;;;
(defn ins
  "An addition to the document.

  https://www.w3.org/TR/html5/edits.html#the-ins-element"
  [& args]
  (apply codom/element :ins args))
(alter-meta! (find-var (symbol (str *ns*) "ins"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :ins
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/edits.html#the-ins-element"}})

;;;;;;;; COMPONENT: miraj.html/kbd ;;;;;;;;;;;;;;;;
(defn kbd
  "User input

  https://www.w3.org/TR/html5/text-level-semantics.html#the-kbd-element"
  [& args]
  (apply codom/element :kbd args))
(alter-meta! (find-var (symbol (str *ns*) "kbd"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :kbd
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-kbd-element"}})

;;;;;;;; COMPONENT: miraj.html/keygen ;;;;;;;;;;;;;;;;
(defn keygen
  "Cryptographic key-pair generator form control. The keygen element represents a key pair generator control. When the control's form is submitted, the private key is stored in the local keystore, and the public key is packaged and sent to the server.

  https://www.w3.org/TR/html5/forms.html#the-keygen-element"
  [& args]
  (apply codom/element :keygen args))
(alter-meta! (find-var (symbol (str *ns*) "keygen"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :keygen
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/forms.html#the-keygen-element"}})

;;;;;;;; COMPONENT: miraj.html/label ;;;;;;;;;;;;;;;;
(defn label
  "Caption for a form control.

  https://www.w3.org/TR/html5/forms.html#the-label-element"
  [& args]
  (apply codom/element :label args))
(alter-meta! (find-var (symbol (str *ns*) "label"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :label
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/forms.html#the-label-element"}})

;;;;;;;; COMPONENT: miraj.html/legend ;;;;;;;;;;;;;;;;
(defn legend
  "Caption for a fieldset.

  https://www.w3.org/TR/html5/forms.html#the-legend-element"
  [& args]
  (apply codom/element :legend args))
(alter-meta! (find-var (symbol (str *ns*) "legend"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :legend
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/forms.html#the-legend-element"}})

;;;;;;;; COMPONENT: miraj.html/li ;;;;;;;;;;;;;;;;
(defn li
  "List item.

  https://www.w3.org/TR/html5/grouping-content.html#the-li-element"
  [& args]
  (apply codom/element :li args))
(alter-meta! (find-var (symbol (str *ns*) "li"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :li
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/grouping-content.html#the-li-element"}})

;;;;;;;; COMPONENT: miraj.html/link ;;;;;;;;;;;;;;;;
(defn link
  "Link metadata.

  https://www.w3.org/TR/html5/document-metadata.html#the-link-element"
  [& args]
  (apply codom/element :link args))
(alter-meta! (find-var (symbol (str *ns*) "link"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :link
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/document-metadata.html#the-link-element"}})

;;;;;;;; COMPONENT: miraj.html/main ;;;;;;;;;;;;;;;;
(defn main
  "Main content of a document.

  https://www.w3.org/TR/html5/grouping-content.html#the-main-element"
  [& args]
  (apply codom/element :main args))
(alter-meta! (find-var (symbol (str *ns*) "main"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :main
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/grouping-content.html#the-main-element"}})

;;;;;;;; COMPONENT: miraj.html/map ;;;;;;;;;;;;;;;;
(defn map
  "Image map

  https://www.w3.org/TR/html5/embedded-content-0.html#the-map-element"
  [& args]
  (apply codom/element :map args))
(alter-meta! (find-var (symbol (str *ns*) "map"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :map
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/embedded-content-0.html#the-map-element"}})

;;;;;;;; COMPONENT: miraj.html/mark ;;;;;;;;;;;;;;;;
(defn mark
  "Highlight. The mark element represents a run of text in one document marked or highlighted for reference purposes, due to its relevance in another context. When used in a quotation or other block of text referred to from the prose, it indicates a highlight that was not originally present but which has been added to bring the reader's attention to a part of the text that might not have been considered important by the original author when the block was originally written, but which is now under previously unexpected scrutiny. When used in the main prose of a document, it indicates a part of the document that has been highlighted due to its likely relevance to the user's current activity

  https://www.w3.org/TR/html5/text-level-semantics.html#the-mark-element"
  [& args]
  (apply codom/element :mark args))
(alter-meta! (find-var (symbol (str *ns*) "mark"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :mark
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-mark-element"}})

;;;;;;;; COMPONENT: miraj.html/meta ;;;;;;;;;;;;;;;;
(defn meta
  "Text metadata.

  https://www.w3.org/TR/html5/document-metadata.html#the-meta-element"
  [& args]
  (apply codom/element :meta args))
(alter-meta! (find-var (symbol (str *ns*) "meta"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :meta
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/document-metadata.html#the-meta-element"}})

;;;;;;;; COMPONENT: miraj.html/meter ;;;;;;;;;;;;;;;;
(defn meter
  "Gauge. The meter element represents a scalar measurement within a known range, or a fractional value; for example disk usage, the relevance of a query result, or the fraction of a voting population to have selected a particular candidate.

  https://www.w3.org/TR/html5/forms.html#the-meter-element"
  [& args]
  (apply codom/element :meter args))
(alter-meta! (find-var (symbol (str *ns*) "meter"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :meter
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/forms.html#the-meter-element"}})

;;;;;;;; COMPONENT: miraj.html/nav ;;;;;;;;;;;;;;;;
(defn nav
  "Section with navigational links.

  https://www.w3.org/TR/html5/sections.html#the-nav-element"
  [& args]
  (apply codom/element :nav args))
(alter-meta! (find-var (symbol (str *ns*) "nav"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :nav
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/sections.html#the-nav-element"}})

;;;;;;;; COMPONENT: miraj.html/noscript ;;;;;;;;;;;;;;;;
(defn noscript
  "Fallback content for script.

  https://www.w3.org/TR/html5/scripting-1.html#the-noscript-element"
  [& args]
  (apply codom/element :noscript args))
(alter-meta! (find-var (symbol (str *ns*) "noscript"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :noscript
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/scripting-1.html#the-noscript-element"}})

;;;;;;;; COMPONENT: miraj.html/object ;;;;;;;;;;;;;;;;
(defn object
  "Image, nested browsing context, or plugin.

  https://www.w3.org/TR/html5/embedded-content-0.html#the-object-element"
  [& args]
  (apply codom/element :object args))
(alter-meta! (find-var (symbol (str *ns*) "object"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :object
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/embedded-content-0.html#the-object-element"}})

;;;;;;;; COMPONENT: miraj.html/ol ;;;;;;;;;;;;;;;;
(defn ol
  "Ordered list. The ol element represents a list of items, where the items have been intentionally ordered, such that changing the order would change the meaning of the document.

  https://www.w3.org/TR/html5/grouping-content.html#the-ol-element"
  [& args]
  (apply codom/element :ol args))
(alter-meta! (find-var (symbol (str *ns*) "ol"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :ol
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/grouping-content.html#the-ol-element"}})

;;;;;;;; COMPONENT: miraj.html/optgroup ;;;;;;;;;;;;;;;;
(defn optgroup
  "Group of options in a list box.

  https://www.w3.org/TR/html5/forms.html#the-optgroup-element"
  [& args]
  (apply codom/element :optgroup args))
(alter-meta! (find-var (symbol (str *ns*) "optgroup"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :optgroup
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/forms.html#the-optgroup-element"}})

;;;;;;;; COMPONENT: miraj.html/option ;;;;;;;;;;;;;;;;
(defn option
  "Option in a list box or combo box control.

  https://www.w3.org/TR/html5/forms.html#the-option-element"
  [& args]
  (apply codom/element :option args))
(alter-meta! (find-var (symbol (str *ns*) "option"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :option
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/forms.html#the-option-element"}})

;;;;;;;; COMPONENT: miraj.html/output ;;;;;;;;;;;;;;;;
(defn output
  "Calculated output value. The output element represents the result of a calculation or user action.

  https://www.w3.org/TR/html5/forms.html#the-output-element"
  [& args]
  (apply codom/element :output args))
(alter-meta! (find-var (symbol (str *ns*) "output"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :output
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/forms.html#the-output-element"}})

;;;;;;;; COMPONENT: miraj.html/p ;;;;;;;;;;;;;;;;
(defn p
  "Paragraph.

  https://www.w3.org/TR/html5/grouping-content.html#the-p-element"
  [& args]
  (apply codom/element :p args))
(alter-meta! (find-var (symbol (str *ns*) "p"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :p
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/grouping-content.html#the-p-element"}})

;;;;;;;; COMPONENT: miraj.html/param ;;;;;;;;;;;;;;;;
(defn param
  "Parameter for object.

  https://www.w3.org/TR/html5/embedded-content-0.html#the-param-element"
  [& args]
  (apply codom/element :param args))
(alter-meta! (find-var (symbol (str *ns*) "param"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :param
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/embedded-content-0.html#the-param-element"}})

;;;;;;;; COMPONENT: miraj.html/pre ;;;;;;;;;;;;;;;;
(defn pre
  "Block of preformatted text.

  https://www.w3.org/TR/html5/grouping-content.html#the-pre-element"
  [& args]
  (apply codom/element :pre args))
(alter-meta! (find-var (symbol (str *ns*) "pre"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :pre
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/grouping-content.html#the-pre-element"}})

;;;;;;;; COMPONENT: miraj.html/progress ;;;;;;;;;;;;;;;;
(defn progress
  "Progress bar.

  https://www.w3.org/TR/html5/forms.html#the-progress-element"
  [& args]
  (apply codom/element :progress args))
(alter-meta! (find-var (symbol (str *ns*) "progress"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :progress
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/forms.html#the-progress-element"}})

;;;;;;;; COMPONENT: miraj.html/q ;;;;;;;;;;;;;;;;
(defn q
  "Quotation.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-q-element"
  [& args]
  (apply codom/element :q args))
(alter-meta! (find-var (symbol (str *ns*) "q"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :q
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-q-element"}})

;;;;;;;; COMPONENT: miraj.html/rb ;;;;;;;;;;;;;;;;
(defn rb
  "Ruby base.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-rb-element"
  [& args]
  (apply codom/element :rb args))
(alter-meta! (find-var (symbol (str *ns*) "rb"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :rb
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-rb-element"}})

;;;;;;;; COMPONENT: miraj.html/rp ;;;;;;;;;;;;;;;;
(defn rp
  "Parenthesis for ruby annotation text.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-rp-element"
  [& args]
  (apply codom/element :rp args))
(alter-meta! (find-var (symbol (str *ns*) "rp"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :rp
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-rp-element"}})

;;;;;;;; COMPONENT: miraj.html/rt ;;;;;;;;;;;;;;;;
(defn rt
  "Ruby annotation text.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-rt-element"
  [& args]
  (apply codom/element :rt args))
(alter-meta! (find-var (symbol (str *ns*) "rt"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :rt
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-rt-element"}})

;;;;;;;; COMPONENT: miraj.html/rtc ;;;;;;;;;;;;;;;;
(defn rtc
  "Ruby annotation text container.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-rtc-element"
  [& args]
  (apply codom/element :rtc args))
(alter-meta! (find-var (symbol (str *ns*) "rtc"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :rtc
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-rtc-element"}})

;;;;;;;; COMPONENT: miraj.html/ruby ;;;;;;;;;;;;;;;;
(defn ruby
  "Ruby annotation(s).

  https://www.w3.org/TR/html5/text-level-semantics.html#the-ruby-element"
  [& args]
  (apply codom/element :ruby args))
(alter-meta! (find-var (symbol (str *ns*) "ruby"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :ruby
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-ruby-element"}})

;;;;;;;; COMPONENT: miraj.html/s ;;;;;;;;;;;;;;;;
(defn s
  "Inaccurate text. The s element represents contents that are no longer accurate or no longer relevant.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-s-element"
  [& args]
  (apply codom/element :s args))
(alter-meta! (find-var (symbol (str *ns*) "s"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :s
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-s-element"}})

;;;;;;;; COMPONENT: miraj.html/samp ;;;;;;;;;;;;;;;;
(defn samp
  "Computer output. The samp element represents (sample) output from a program or computing system.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-samp-element"
  [& args]
  (apply codom/element :samp args))
(alter-meta! (find-var (symbol (str *ns*) "samp"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :samp
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-samp-element"}})

;;;;;;;; COMPONENT: miraj.html/section ;;;;;;;;;;;;;;;;
(defn section
  "Generic document or application section.

  https://www.w3.org/TR/html5/sections.html#the-section-element"
  [& args]
  (apply codom/element :section args))
(alter-meta! (find-var (symbol (str *ns*) "section"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :section
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/sections.html#the-section-element"}})

;;;;;;;; COMPONENT: miraj.html/select ;;;;;;;;;;;;;;;;
(defn select
  "List box control. The select element represents a control for selecting amongst a set of options.

  https://www.w3.org/TR/html5/forms.html#the-select-element"
  [& args]
  (apply codom/element :select args))
(alter-meta! (find-var (symbol (str *ns*) "select"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :select
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/forms.html#the-select-element"}})

;;;;;;;; COMPONENT: miraj.html/small ;;;;;;;;;;;;;;;;
(defn small
  "Side comment. The small element represents side comments such as small print.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-small-element"
  [& args]
  (apply codom/element :small args))
(alter-meta! (find-var (symbol (str *ns*) "small"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :small
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-small-element"}})

;;;;;;;; COMPONENT: miraj.html/source ;;;;;;;;;;;;;;;;
(defn source
  "Media source for video or audio.

  https://www.w3.org/TR/html5/embedded-content-0.html#the-source-element"
  [& args]
  (apply codom/element :source args))
(alter-meta! (find-var (symbol (str *ns*) "source"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :source
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/embedded-content-0.html#the-source-element"}})

;;;;;;;; COMPONENT: miraj.html/span ;;;;;;;;;;;;;;;;
(defn span
  "Generic phrasing container.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-span-element"
  [& args]
  (apply codom/element :span args))
(alter-meta! (find-var (symbol (str *ns*) "span"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :span
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-span-element"}})

;;;;;;;; COMPONENT: miraj.html/strong ;;;;;;;;;;;;;;;;
(defn strong
  "Importance.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-strong-element"
  [& args]
  (apply codom/element :strong args))
(alter-meta! (find-var (symbol (str *ns*) "strong"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :strong
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-strong-element"}})

;;;;;;;; COMPONENT: miraj.html/style ;;;;;;;;;;;;;;;;
(defn style
  "Embedded styling information

  https://www.w3.org/TR/html5/document-metadata.html#the-style-element"
  [& args]
  (apply codom/element :style args))
(alter-meta! (find-var (symbol (str *ns*) "style"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :style
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/document-metadata.html#the-style-element"}})

;;;;;;;; COMPONENT: miraj.html/sub ;;;;;;;;;;;;;;;;
(defn sub
  "Subscript.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-sub-and-sup-elements"
  [& args]
  (apply codom/element :sub args))
(alter-meta! (find-var (symbol (str *ns*) "sub"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :sub
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-sub-and-sup-elements"}})

;;;;;;;; COMPONENT: miraj.html/sup ;;;;;;;;;;;;;;;;
(defn sup
  "Superscript.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-sub-and-sup-elements"
  [& args]
  (apply codom/element :sup args))
(alter-meta! (find-var (symbol (str *ns*) "sup"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :sup
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-sub-and-sup-elements"}})

;;;;;;;; COMPONENT: miraj.html/table ;;;;;;;;;;;;;;;;
(defn table
  "Table.

  https://www.w3.org/TR/html5/tabular-data.html#the-table-element"
  [& args]
  (apply codom/element :table args))
(alter-meta! (find-var (symbol (str *ns*) "table"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :table
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/tabular-data.html#the-table-element"}})

;;;;;;;; COMPONENT: miraj.html/tbody ;;;;;;;;;;;;;;;;
(defn tbody
  "Group of rows in a table.

  https://www.w3.org/TR/html5/tabular-data.html#the-tbody-element"
  [& args]
  (apply codom/element :tbody args))
(alter-meta! (find-var (symbol (str *ns*) "tbody"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :tbody
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/tabular-data.html#the-tbody-element"}})

;;;;;;;; COMPONENT: miraj.html/td ;;;;;;;;;;;;;;;;
(defn td
  "Table cell.

  https://www.w3.org/TR/html5/tabular-data.html#the-td-element"
  [& args]
  (apply codom/element :td args))
(alter-meta! (find-var (symbol (str *ns*) "td"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :td
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/tabular-data.html#the-td-element"}})

;;;;;;;; COMPONENT: miraj.html/template ;;;;;;;;;;;;;;;;
(defn template
  "Template. The template element is used to declare fragments of HTML that can be cloned and inserted in the document by script.

  https://www.w3.org/TR/html5/scripting-1.html#the-template-element"
  [& args]
  (apply codom/element :template args))
(alter-meta! (find-var (symbol (str *ns*) "template"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :template
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/scripting-1.html#the-template-element"}})

;;;;;;;; COMPONENT: miraj.html/textarea ;;;;;;;;;;;;;;;;
(defn textarea
  "Multiline text field.

  https://www.w3.org/TR/html5/forms.html#the-textarea-element"
  [& args]
  (apply codom/element :textarea args))
(alter-meta! (find-var (symbol (str *ns*) "textarea"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :textarea
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/forms.html#the-textarea-element"}})

;;;;;;;; COMPONENT: miraj.html/tfoot ;;;;;;;;;;;;;;;;
(defn tfoot
  "Group of footer rows in a table.

  https://www.w3.org/TR/html5/tabular-data.html#the-tfoot-element"
  [& args]
  (apply codom/element :tfoot args))
(alter-meta! (find-var (symbol (str *ns*) "tfoot"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :tfoot
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/tabular-data.html#the-tfoot-element"}})

;;;;;;;; COMPONENT: miraj.html/th ;;;;;;;;;;;;;;;;
(defn th
  "Table header cell

  https://www.w3.org/TR/html5/tabular-data.html#the-th-element"
  [& args]
  (apply codom/element :th args))
(alter-meta! (find-var (symbol (str *ns*) "th"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :th
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/tabular-data.html#the-th-element"}})

;;;;;;;; COMPONENT: miraj.html/thead ;;;;;;;;;;;;;;;;
(defn thead
  "Group of heading rows in a table.

  https://www.w3.org/TR/html5/tabular-data.html#the-thead-element"
  [& args]
  (apply codom/element :thead args))
(alter-meta! (find-var (symbol (str *ns*) "thead"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :thead
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/tabular-data.html#the-thead-element"}})

;;;;;;;; COMPONENT: miraj.html/time ;;;;;;;;;;;;;;;;
(defn time
  "Machine-readable equivalent of date- or time-related data.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-time-element"
  [& args]
  (apply codom/element :time args))
(alter-meta! (find-var (symbol (str *ns*) "time"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :time
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-time-element"}})

;;;;;;;; COMPONENT: miraj.html/title ;;;;;;;;;;;;;;;;
(defn title
  "Document title.

  https://www.w3.org/TR/html5/document-metadata.html#the-title-element"
  [& args]
  (apply codom/element :title args))
(alter-meta! (find-var (symbol (str *ns*) "title"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :title
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/document-metadata.html#the-title-element"}})

;;;;;;;; COMPONENT: miraj.html/tr ;;;;;;;;;;;;;;;;
(defn tr
  "Table row.

  https://www.w3.org/TR/html5/tabular-data.html#the-tr-element"
  [& args]
  (apply codom/element :tr args))
(alter-meta! (find-var (symbol (str *ns*) "tr"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :tr
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/tabular-data.html#the-tr-element"}})

;;;;;;;; COMPONENT: miraj.html/track ;;;;;;;;;;;;;;;;
(defn track
  "Timed text track.

  https://www.w3.org/TR/html5/embedded-content-0.html#the-track-element"
  [& args]
  (apply codom/element :track args))
(alter-meta! (find-var (symbol (str *ns*) "track"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :track
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/embedded-content-0.html#the-track-element"}})

;;;;;;;; COMPONENT: miraj.html/u ;;;;;;;;;;;;;;;;
(defn u
  "Keywords. The u element represents a span of text with an unarticulated, though explicitly rendered, non-textual annotation, such as labeling the text as being a proper name in Chinese text (a Chinese proper name mark), or labeling the text as being misspelt.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-u-element"
  [& args]
  (apply codom/element :u args))
(alter-meta! (find-var (symbol (str *ns*) "u"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :u
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-u-element"}})

;;;;;;;; COMPONENT: miraj.html/ul ;;;;;;;;;;;;;;;;
(defn ul
  "List. The ul element represents a list of items, where the order of the items is not important — that is, where changing the order would not materially change the meaning of the document.

  https://www.w3.org/TR/html5/grouping-content.html#the-ul-element"
  [& args]
  (apply codom/element :ul args))
(alter-meta! (find-var (symbol (str *ns*) "ul"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :ul
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/grouping-content.html#the-ul-element"}})

;;;;;;;; COMPONENT: miraj.html/var ;;;;;;;;;;;;;;;;
(defn var
  "Variable. The var element represents a variable. This could be an actual variable in a mathematical expression or programming context, an identifier representing a constant, a symbol identifying a physical quantity, a function parameter, or just be a term used as a placeholder in prose.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-var-element"
  [& args]
  (apply codom/element :var args))
(alter-meta! (find-var (symbol (str *ns*) "var"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :var
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-var-element"}})

;;;;;;;; COMPONENT: miraj.html/video ;;;;;;;;;;;;;;;;
(defn video
  "Video player.

  https://www.w3.org/TR/html5/embedded-content-0.html#the-video-element"
  [& args]
  (apply codom/element :video args))
(alter-meta! (find-var (symbol (str *ns*) "video"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :video
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/embedded-content-0.html#the-video-element"}})

;;;;;;;; COMPONENT: miraj.html/wbr ;;;;;;;;;;;;;;;;
(defn wbr
  "Line-breaking opportunity.

  https://www.w3.org/TR/html5/text-level-semantics.html#the-wbr-element"
  [& args]
  (apply codom/element :wbr args))
(alter-meta! (find-var (symbol (str *ns*) "wbr"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :wbr
                            :miraj/lib :html
                            :miraj/assets {:miraj/href ""
                                           :miraj/bower ""}
                            :miraj/help "https://www.w3.org/TR/html5/text-level-semantics.html#the-wbr-element"}})



(load "html_spec")
