(ns milesian.sequence-diagram
  (:require
   [clojure.walk :refer (postwalk)]
   [org.httpkit.client :refer (request) :rename {request http-request}]
   [cheshire.core :refer (encode decode)]
   [clojure.pprint :refer (pprint)]
   [camel-snake-kebab :refer (->kebab-case-keyword ->camelCaseString)]
   [milesian.aop.utils  :refer (extract-data)]
            ))



(defn process-maps [fm t]
  (postwalk (fn [fm]
              (cond
               (map? fm) (reduce-kv (fn [acc k v] (assoc acc (t k) v)) {} fm)
               :otherwise fm)) fm))

(defn ->clj
  "Convert JSON keys into Clojure keywords. This is because we receive
  JSON but want to process it as Clojure."
  [fm]
  (process-maps fm ->kebab-case-keyword))

(defn ->js
  "Convert Clojure keywords into JSON keys. This is because we respond
  with JSON."
  [fm]
  (process-maps fm ->camelCaseString))

(defn request [method uri & {:keys [data]}]
  @(http-request
          (merge
           {:method method
            :url uri
            :headers
            (merge
             {"Content-Type" "application/json"
              "Accept" "application/json"})}

           (when data {:body (str (encode (->js data)))}))
          identity))

(defn replace- [s]
  (clojure.string/replace s #"-" "_"))


(defn function-invocation
  [*fn* this args]
  (let [{:keys [id who fn-name fn-args]} (extract-data *fn* this args)]
    (format "%s->%s: %s %s" (replace- who) (replace- id) fn-name fn-args)))

(defn function-return
  [*fn* this args]
  (let [{:keys [id who fn-name fn-args]} (extract-data *fn* this args)]
    (format "%s->%s:" (replace- id) (replace- who))))


(def store (atom []))

(defn store-message [m k]
  (swap! store conj [m k]))

(defn publish-message [m]
  (request :post (format "http://localhost:%s/publish" 8011) :data {:sequence m}))

(defn try-to-publish [s]
  (let [closed (filter (fn[[_ k]] (= k :closed)) @s)]
    (when (= (count closed) (count (filter (fn[[_ k]] (= k :opened)) @s)))
      (let [m (reduce (fn [s [m _]] (str s m "\n")) "" @s)]
        (println m)
        (publish-message m)
        )
      (reset! s []))))

(defn sequence-diagram-invocation
  [*fn* this & args]
  (store-message (function-invocation *fn* this args) :opened)
  (let [res (apply *fn* (conj args this))]
    (store-message (function-return *fn* this args) :closed)
    (try-to-publish store)
    res))
