# milesian/format-system-diagrams
Utility functions to format a stuartsierra/component system to visualise using 
[tangrammer/webclient-system-diagram](https://github.com/tangrammer/webclient-system-diagram)

Also includes http-kit to make http calls


#### Releases and Dependency Information


```clojure
[milesian/format-system-diagrams "0.1.3"]
```

```clojure 
  :dependencies [[cheshire          "5.3.1"]
                 [camel-snake-kebab "0.1.4"]
                 [http-kit         "2.1.19"]
                 [milesian/aop      "0.1.4"]]
```

## How to use it

My preferred way to use it is :

**Update your project deps**

```clojure
;; Update your dev dependencies 
:profiles {:dev {:dependencies [ ...
                                  [milesian/format-system-diagrams "0.1.3" :exclusions [http-kit]]
                                  [milesian/bigbang "0.1.1"]
                                  [milesian/aop "0.1.4"]
                                  [milesian/identity "0.1.3"]
                                  ...
                                  ]
                                  ...
          }}
```
**Update your dev.clj**

```clojure

(ns dev
	(:require 
		 ...
   [milesian.bigbang :as bigbang]
   [milesian.identity :as identity]
   [milesian.aop :as aop]
   [milesian.aop.utils  :refer (extract-data)]
   [milesian.sequence-diagram :refer (store-message try-to-publish store)]

		 ...))

...

(defn diagram
  "to get sequence diagram we need the ->start-fn-call and
  the <-return-fn-call times of the fn invocation call.
  The sequence will be published if all fns are finished (:closed)"
  [*fn* this & args]
  (let [invocation-data (extract-data *fn* this args)]
    (store-message invocation-data :opened)
    (let [res (apply *fn* (conj args this))]
      (store-message invocation-data :closed)
      (try-to-publish system)
      res)))
      
; replace your current start fn by this one      
(defn start
  "Starts the current development system."
  []
  (alter-var-root #'system #(bigbang/expand % {:before-start [[identity/add-meta-key %]
                                                              [identity/assoc-meta-who-to-deps]]
                                               :after-start [[aop/wrap diagram]]}))) 
      
```


**Start [tangrammer/webclient-system-diagram](https://github.com/tangrammer/webclient-system-diagram) with** `$ lein run`

**Invoke your component-app and check your browsers:** [[sequence diagram]](http://localhost:8011/sequence) - [[graph diagram]](http://localhost:8011/graph)

[<img src="https://dl.dropboxusercontent.com/u/8688858/real-system-visualisations/graph.png" alt="Drawing" style="width: 40%;"/>](https://dl.dropboxusercontent.com/u/8688858/real-system-visualisations/graph.png)
[<img src="https://dl.dropboxusercontent.com/u/8688858/real-system-visualisations/sequence.png" alt="Drawing" style="width: 40%;"/>](https://dl.dropboxusercontent.com/u/8688858/real-system-visualisations/sequence.png)


## License

Copyright © 2014 Juan Antonio Ruz 

Distributed under the [MIT License](http://opensource.org/licenses/MIT). This means that pieces of this library may be copied into other libraries if they don't wish to have this as an explicit dependency, as long as it is credited within the code.

