(ns spec-tools.type
  (:require #?(:clj [clojure.future :refer :all])
            [spec-tools.impl :as impl]))

(defn- dispatch [x]
  (cond

    ;; symbol
    (symbol? x)
    (impl/clojure-core-symbol-or-any x)

    ;; a from
    (seq? x)
    (impl/clojure-core-symbol-or-any (first x))

    ;; default
    :else x))

(defmulti resolve-type dispatch :default ::default)

(defmethod resolve-type ::default [_] nil)

(defn types []
  #{:long
    :double
    :boolean
    :string
    :keyword
    :symbol
    :uuid
    :uri
    :bigdec
    :date
    :ratio
    :map
    :set
    :vector})

(defn type-symbols []
  (-> resolve-type
      methods
      keys
      (->> (filter symbol?))
      set))

(defmethod resolve-type `any? [_] nil)
(defmethod resolve-type `some? [_] nil)
(defmethod resolve-type `number? [_] :double)
(defmethod resolve-type `integer? [_] :long)
(defmethod resolve-type `int? [_] :long)
(defmethod resolve-type `pos-int? [_] :long)
(defmethod resolve-type `neg-int? [_] :long)
(defmethod resolve-type `nat-int? [_] :long)
(defmethod resolve-type `float? [_] :double)
(defmethod resolve-type `double? [_] :double)
(defmethod resolve-type `boolean? [_] :boolean)
(defmethod resolve-type `string? [_] :string)
(defmethod resolve-type `ident? [_] :keyword)
(defmethod resolve-type `simple-ident? [_] :keyword)
(defmethod resolve-type `qualified-ident? [_] :keyword)
(defmethod resolve-type `keyword? [_] :keyword)
(defmethod resolve-type `simple-keyword? [_] :keyword)
(defmethod resolve-type `qualified-keyword? [_] :keyword)
(defmethod resolve-type `symbol? [_] :symbol)
(defmethod resolve-type `simple-symbol? [_] :symbol)
(defmethod resolve-type `qualified-symbol? [_] :symbol)
(defmethod resolve-type `uuid? [_] :uuid)
#?(:clj (defmethod resolve-type `uri? [_] :uri))
#?(:clj (defmethod resolve-type `bigdec? [_] :bigdec))
(defmethod resolve-type `inst? [_] :date)
(defmethod resolve-type `seqable? [_] nil)
(defmethod resolve-type `indexed? [_] nil)
(defmethod resolve-type `map? [_] nil)
(defmethod resolve-type `vector? [_] nil)
(defmethod resolve-type `list? [_] nil)
(defmethod resolve-type `seq? [_] nil)
(defmethod resolve-type `char? [_] nil)
(defmethod resolve-type `set? [_] nil)
(defmethod resolve-type `nil? [_] :nil)
(defmethod resolve-type `false? [_] :boolean)
(defmethod resolve-type `true? [_] :boolean)
(defmethod resolve-type `zero? [_] :long)
#?(:clj (defmethod resolve-type `rational? [_] :long))
(defmethod resolve-type `coll? [_] nil)
(defmethod resolve-type `empty? [_] nil)
(defmethod resolve-type `associative? [_] nil)
(defmethod resolve-type `sequential? [_] nil)
#?(:clj (defmethod resolve-type `ratio? [_] :ratio))
#?(:clj (defmethod resolve-type `bytes? [_] nil))

(defmethod resolve-type :clojure.spec.alpha/unknown [_] nil)

(defmethod resolve-type 'clojure.spec.alpha/keys [_] :map)

(defmethod resolve-type 'clojure.spec.alpha/or [x] nil)

(defmethod resolve-type 'clojure.spec.alpha/and [x]
  (let [[_ predicate & _] x]
    (resolve-type predicate)))

; merge

(defmethod resolve-type 'clojure.spec.alpha/every [x]
  (let [{:keys [into]} (apply hash-map (drop 2 x))]
    (cond
      (map? into) :map
      (set? into) :set
      :else :vector)))

; every-ks

(defmethod resolve-type 'clojure.spec.alpha/coll-of [x]
  (let [{:keys [into]} (apply hash-map (drop 2 x))]
    (cond
      (map? into) :map
      (set? into) :set
      :else :vector)))

(defmethod resolve-type 'clojure.spec.alpha/map-of [_] :map)

; *
; +
; ?
; alt
; cat
; &
; tuple
; keys*
; nilable
