(ns spec-tools.spec
  (:refer-clojure :exclude [any? some? number? pos? neg? integer? int? pos-int? neg-int? nat-int?
                            float? double? boolean? string? ident? simple-ident? qualified-ident?
                            keyword? simple-keyword? qualified-keyword? symbol? simple-symbol?
                            qualified-symbol? uuid? uri? bigdec? inst? seqable? indexed?
                            map? vector? list? seq? char? set? nil? false? true? zero?
                            rational? coll? empty? associative? sequential? ratio? bytes?
                            #?@(:cljs [Inst Keyword UUID])])
  (:require [spec-tools.core :as st]
            #?(:clj [clojure.future :as future]
               :cljs [clojure.core :as future])))

(def any? (st/spec future/any?))
(def some? (st/spec clojure.core/some?))
(def number? (st/spec clojure.core/number?))
(def pos? (st/spec clojure.core/pos?))
(def neg? (st/spec clojure.core/neg?))
(def integer? (st/spec clojure.core/integer?))
(def int? (st/spec future/int?))
(def pos-int? (st/spec future/pos-int?))
(def neg-int? (st/spec future/neg-int?))
(def nat-int? (st/spec future/nat-int?))
(def float? (st/spec clojure.core/float?))
(def double? (st/spec future/double?))
(def boolean? (st/spec future/boolean?))
(def string? (st/spec clojure.core/string?))
(def ident? (st/spec future/ident?))
(def simple-ident? (st/spec future/simple-ident?))
(def qualified-ident? (st/spec future/qualified-ident?))
(def keyword? (st/spec clojure.core/keyword?))
(def simple-keyword? (st/spec future/simple-keyword?))
(def qualified-keyword? (st/spec future/qualified-keyword?))
(def symbol? (st/spec clojure.core/symbol?))
(def simple-symbol? (st/spec future/simple-symbol?))
(def qualified-symbol? (st/spec future/qualified-symbol?))
(def uuid? (st/spec future/uuid?))
#?(:clj (def uri? (st/spec future/uri?)))
#?(:clj (def bigdec? (st/spec future/bigdec?)))
(def inst? (st/spec future/inst?))
(def seqable? (st/spec future/seqable?))
(def indexed? (st/spec future/indexed?))
(def map? (st/spec clojure.core/map?))
(def vector? (st/spec clojure.core/vector?))
(def list? (st/spec clojure.core/list?))
(def seq? (st/spec clojure.core/seq?))
(def char? (st/spec clojure.core/char?))
(def set? (st/spec clojure.core/set?))
(def nil? (st/spec clojure.core/nil?))
(def false? (st/spec clojure.core/false?))
(def true? (st/spec clojure.core/true?))
(def zero? (st/spec clojure.core/zero?))
#?(:clj (def rational? (st/spec clojure.core/rational?)))
(def coll? (st/spec clojure.core/coll?))
(def empty? (st/spec clojure.core/empty?))
(def associative? (st/spec clojure.core/associative?))
(def sequential? (st/spec clojure.core/sequential?))
#?(:clj (def ratio? (st/spec clojure.core/ratio?)))
#?(:clj (def bytes? (st/spec future/bytes?)))
