(ns middlesphere.log
  (:require [io.pedestal.log :as log]))

(defmacro trace
  "Logs value at TRACE level, returns nil.
  `keyvals` - should be a pair values (e.g. \"abcd\" 123, 567 {:a 1})
  "
  [& keyvals]
  (#'io.pedestal.log/log-expr &form :trace keyvals))

(defmacro debug
  "Logs value at DEBUG level, returns nil.
  `keyvals` - should be a pair values (e.g. \"abcd\" 123, 567 {:a 1})
  "
  [& keyvals]
  (#'io.pedestal.log/log-expr &form :debug keyvals))

(defmacro info
  "Logs value at INFO level, returns nil.
  `keyvals` - should be a pair values (e.g. \"abcd\" 123, 567 {:a 1})
  "
  [& keyvals]
  (#'io.pedestal.log/log-expr &form :info keyvals))

(defmacro warn
  "Logs value at WARN level, returns nil.
  `keyvals` - should be a pair values (e.g. \"abcd\" 123, 567 {:a 1})
  "
  [& keyvals]
  (#'io.pedestal.log/log-expr &form :warn keyvals))

(defmacro error
  "Logs value at ERROR level, returns nil.
  `keyvals` - should be a pair values (e.g. \"abcd\" 123, 567 {:a 1})
  "
  [& keyvals]
  (#'io.pedestal.log/log-expr &form :error keyvals))

(defmacro spy
  "Logs expr and its value at DEBUG level, returns value."
  [expr]
  (let [value' (gensym "value")]
    `(let [~value' ~expr]
       ~(#'io.pedestal.log/log-expr &form :debug (vector :spy (list 'quote expr)
                                       :value value'))
       ~value')))
