# util

Collection of useful functions: util, logging, metrics, monitoring.

## Usage

For Leiningen add to project.clj: ```[middlesphere/util "0.3.0"]```  
For Deps CLI add to deps.edn:  ```{:deps {middlesphere/util {:mvn/version "0.3.0}}```

Import necessary namespaces:

```clojure
    (require '[middlesphere.log :as log])
    (require '[middlesphere.metrics :as metrics])
    (require '[middlesphere.util :as util])
 ```
 
### Logging

First, choose logging library. It is recommended to use log4j2 or logback.
Add necessary dependecies to your project.

#### Log4j2 (preferred)

Add to your project.clj following dependencies:
 
```clojure
    [org.apache.logging.log4j/log4j-core "2.11.2"]
    [org.apache.logging.log4j/log4j-slf4j-impl "2.11.2"]
    [com.lmax/disruptor "3.4.2"]
``` 
Example config in env/dev/resources/log4j2.xml.  
To make all appenders asynchronous set system  
property -Dlog4j2.contextSelector=org.apache.logging.log4j.core.async.AsyncLoggerContextSelector and add 
disruptor library as dependency. 
```clojure
    [com.lmax/disruptor "3.4.2"]
``` 

#### Logback

Add to your project.clj following dependencies:

```clojure
    [ch.qos.logback/logback-classic "1.2.3"]
``` 
Example config in env/dev/resources/logback.xml.  

#### Example of logging
To log messages on different levels:

```clojure
    (log/trace :msg "log message at TRACE level")
    (log/debug :msg "log message at DEBUG level")
    (log/info :msg "log message at INFO level")
    (log/warn :msg "log message at WARN level")
    (log/error :msg "log message at ERROR level")   
``` 

Also, we can spy values: ```(log/spy (+ 2 3))```
=> 23:47:29.469 DEBUG - {:spy (+ 2 3), :value 5, :line nil} user 

### Metrics

Here is example of using metrics:

```clojure
  (import java.util.concurrent.TimeUnit)
  
  (def r (metrics/metric-registry))                                 ;; create metrics registry

  (metrics/console-reporter r 10 TimeUnit/SECONDS)                  ;;report to console every 10 sec
  (metrics/slf4j-reporter r 15 TimeUnit/SECONDS)                    ;;report to logger every 15 sec
  (metrics/jmx-reporter r)                                          ;;expose current metrics via JMX
  (def s (metrics/statsd-reporter r 10 TimeUnit/SECONDS "127.0.0.1" 8125)) ;; report to StatsD server via UDP every 10 sec

  (metrics/counter r "counter1" 5)
  (metrics/gauge r "gauge1" metrics/used-jvm-mem)
  (metrics/histogram r "hist1" 1177)
  (metrics/meter r "meter1" 43)
```

## License

Copyright © 2019 Mike Ananev

This program and the accompanying materials are made available under the
terms of the Eclipse Public License 2.0 which is available at
http://www.eclipse.org/legal/epl-2.0.
