(ns middlesphere.log
  (:require [io.pedestal.log :as log]))

(defmacro trace
  "Logs value at TRACE level, returns nil.
  `keyvals` - should be a pair values (e.g. \"abcd\" 123, 567 {:a 1})
  "
  [& keyvals]
  `(io.pedestal.log/trace ~@keyvals))

(defmacro debug
  "Logs value at DEBUG level, returns nil.
  `keyvals` - should be a pair values (e.g. \"abcd\" 123, 567 {:a 1})
  "
  [& keyvals]
  `(io.pedestal.log/debug ~@keyvals))

(defmacro info
  "Logs value at INFO level, returns nil.
  `keyvals` - should be a pair values (e.g. \"abcd\" 123, 567 {:a 1})
  "
  [& keyvals]
  `(io.pedestal.log/info ~@keyvals))

(defmacro warn
  "Logs value at WARN level, returns nil.
  `keyvals` - should be a pair values (e.g. \"abcd\" 123, 567 {:a 1})
  "
  [& keyvals]
  `(io.pedestal.log/warn ~@keyvals))

(defmacro error
  "Logs value at ERROR level, returns nil.
  `keyvals` - should be a pair values (e.g. \"abcd\" 123, 567 {:a 1})
  "
  [& keyvals]
  `(io.pedestal.log/error ~@keyvals))

(defmacro spy
  "Logs expr and its value at DEBUG level, returns value."
  [expr]
  `(io.pedestal.log/spy ~expr))
