(ns om-stuff.translations
  (:require [taoensso.tower :as tower :include-macros true]
            [goog.string :as gstring]
            [goog.string.format :as gformat]))

(def ^:private tconfig
  {:fallback-locale :en
   :dev-mode? true
   :compiled-dictionary (tower/dict-compile "translations/dict.clj")})

(def t* (partial (tower/make-t tconfig) :en))

(defn t [format & args]
  (if-let [s (t* format)]
    (apply gstring/format s args)
    (str format)))
